/*
 * Decompiled with CFR 0.152.
 */
package alma.acs.component.dynwrapper;

import alma.acs.component.dynwrapper.ComponentInvocationHandler;
import alma.acs.component.dynwrapper.DynWrapperException;
import alma.acs.component.dynwrapper.TypeMapper;
import java.lang.reflect.Field;
import java.util.logging.Logger;

public class HolderMapper
extends TypeMapper {
    public HolderMapper(Object delegate, Logger logger) {
        super(delegate, logger);
    }

    @Override
    public boolean canTranslate(Class<?> oldObjClass, Class<?> newObjClass, ComponentInvocationHandler invHandler) {
        boolean canTranslate = false;
        try {
            if (oldObjClass.getName().endsWith("Holder") && newObjClass.getName().endsWith("Holder")) {
                Field oldValue = oldObjClass.getDeclaredField("value");
                Field newValue = newObjClass.getDeclaredField("value");
                canTranslate = invHandler.canTranslate(oldValue.getType(), newValue.getType());
            }
        }
        catch (NoSuchFieldException e) {
            this.m_logger.fine("Holder class without field 'value' encountered.");
        }
        if (this.m_verbose) {
            String msg = "can " + (canTranslate ? "" : "not ") + "translate from class '" + oldObjClass.getName() + "' to class '" + newObjClass.getName() + "'.";
            this.m_logger.finer(msg);
        }
        return canTranslate;
    }

    public Object translate(Object oldHolder, Object newHolderTemplate, Class newObjectClass, ComponentInvocationHandler invHandler) throws DynWrapperException {
        if (newHolderTemplate == null) {
            try {
                newHolderTemplate = newObjectClass.newInstance();
            }
            catch (Exception e) {
                throw new DynWrapperException("failed to create holder class " + newObjectClass.getName());
            }
        }
        try {
            Field oldValueField = oldHolder.getClass().getDeclaredField("value");
            Field newValueField = newObjectClass.getDeclaredField("value");
            Object oldValue = oldValueField.get(oldHolder);
            Object newValue = invHandler.translate(oldValue, null, newValueField.getType());
            newValueField.set(newHolderTemplate, newValue);
            return newHolderTemplate;
        }
        catch (Exception e) {
            throw new DynWrapperException(e);
        }
    }
}

