/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.cea;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import uk.ac.starlink.util.XmlWriter;

public class ElementDeclaration {
    private final String elName_;
    private final String attList_;
    private Collection attNames_;

    public ElementDeclaration(String elName) {
        this(elName, "");
    }

    public ElementDeclaration(String elName, String attList) {
        this.elName_ = elName;
        this.attList_ = attList;
    }

    public void setAttributeNames(String[] attNames) {
        this.attNames_ = Collections.unmodifiableCollection(new HashSet<String>(Arrays.asList(attNames)));
    }

    public boolean hasAttribute(String attName) {
        return this.attNames_.contains(attName);
    }

    public String getElementName() {
        return this.elName_;
    }

    public String getElementAttributes() {
        return this.attList_;
    }

    public static ElementDeclaration createNamespaceElement(String elName, String ns) {
        String atts = XmlWriter.formatAttribute((String)"xmlns", (String)ns);
        return new ElementDeclaration(elName, atts);
    }
}

