/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.lint;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.zip.GZIPInputStream;
import org.xml.sax.Locator;
import uk.ac.starlink.ttools.lint.ElementHandler;
import uk.ac.starlink.ttools.lint.StreamingHandler;
import uk.ac.starlink.util.Base64InputStream;
import uk.ac.starlink.util.Compression;
import uk.ac.starlink.util.PipeReaderThread;
import uk.ac.starlink.util.URLUtils;

public class StreamHandler
extends ElementHandler {
    private PipeReaderThread pipeReader_;
    private OutputStream dataSink_;
    static final /* synthetic */ boolean $assertionsDisabled;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startElement() {
        ElementHandler parent;
        String href = this.getAttribute("href");
        String encoding = this.getAttribute("encoding");
        if (!(href != null && href.trim().length() != 0 || "base64".equals(encoding))) {
            this.warning(this + " has no href but encoding is not base64");
        }
        if ((parent = this.getAncestry().getParent()) instanceof StreamingHandler) {
            final StreamingHandler streamer = (StreamingHandler)parent;
            if (href != null) {
                Locator locator = this.getContext().getLocator();
                String systemId = locator == null ? null : locator.getSystemId();
                URL url = URLUtils.makeURL((String)systemId, (String)href);
                if (url != null) {
                    InputStream in = null;
                    try {
                        in = url.openStream();
                        in = new BufferedInputStream(in);
                        in = this.decodeStream(in);
                        streamer.feed(in);
                    }
                    catch (IOException e) {
                        this.warning("Read error for external stream " + e);
                    }
                    finally {
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (IOException e) {}
                        }
                    }
                } else {
                    this.error("Can't make sense of href '" + href + "'");
                }
            } else {
                try {
                    this.pipeReader_ = new PipeReaderThread(){

                        protected void doReading(InputStream in) throws IOException {
                            in = new BufferedInputStream(in);
                            in = StreamHandler.this.decodeStream(in);
                            streamer.feed(in);
                        }
                    };
                    this.pipeReader_.start();
                    this.dataSink_ = new BufferedOutputStream(this.pipeReader_.getOutputStream());
                }
                catch (IOException e) {
                    this.error("Trouble with STREAM content - can't validate");
                    this.pipeReader_ = null;
                    this.dataSink_ = null;
                }
            }
        } else {
            this.error("Illegal parent of STREAM " + parent);
        }
    }

    public void characters(char[] ch, int start, int leng) {
        if (this.dataSink_ != null) {
            try {
                for (int i = 0; i < leng; ++i) {
                    this.dataSink_.write(ch[start++]);
                }
            }
            catch (IOException e) {}
        } else {
            this.error("Unexpected content of STREAM (stream with href should be empty)");
        }
    }

    public void endElement() {
        if (this.dataSink_ != null) {
            if (!$assertionsDisabled && this.pipeReader_ == null) {
                throw new AssertionError();
            }
            try {
                this.dataSink_.close();
                this.pipeReader_.finishReading();
            }
            catch (IOException e) {
                this.error("Streaming error " + e);
            }
            this.dataSink_ = null;
            this.pipeReader_ = null;
        }
    }

    private InputStream decodeStream(InputStream in) throws IOException {
        String encoding = this.getAttribute("encoding");
        if (encoding == null || encoding.equals("none") || encoding.trim().length() == 0) {
            return in;
        }
        if (encoding.equals("base64")) {
            return new Base64InputStream(in);
        }
        if (encoding.equals("gzip")) {
            return new GZIPInputStream(in);
        }
        if (encoding.equals("dynamic")) {
            this.warning("Parser can't interpret dynamic stream encodings properly - sorry");
            return Compression.decompressStatic((InputStream)in);
        }
        this.error("Unknown encoding type '" + encoding + "' (assume none)");
        return in;
    }

    static {
        $assertionsDisabled = !StreamHandler.class.desiredAssertionStatus();
    }
}

