/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.mode;

import java.io.BufferedOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import nom.tam.fits.Header;
import nom.tam.fits.HeaderCardException;
import uk.ac.starlink.fits.FitsConstants;
import uk.ac.starlink.table.ColumnData;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.ColumnPermutedStarTable;
import uk.ac.starlink.table.ColumnStarTable;
import uk.ac.starlink.table.DefaultValueInfo;
import uk.ac.starlink.table.JoinStarTable;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.ttools.Stilts;
import uk.ac.starlink.ttools.TableConsumer;
import uk.ac.starlink.ttools.func.Times;
import uk.ac.starlink.ttools.jel.ColumnIdentifier;
import uk.ac.starlink.util.Destination;

public class CubeWriter
implements TableConsumer {
    private final double[] loBounds_;
    private final double[] hiBounds_;
    private final String[] colIds_;
    private final String scaleId_;
    private final Class outType_;
    private final Destination dest_;
    private int[] nbins_;
    private double[] binSizes_;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$java$lang$Number;

    public CubeWriter(double[] loBounds, double[] hiBounds, int[] nbins, double[] binSizes, String[] colIds, String scaleId, Destination dest, Class outType) {
        this.loBounds_ = loBounds;
        this.hiBounds_ = hiBounds;
        this.nbins_ = nbins;
        this.binSizes_ = binSizes;
        this.colIds_ = colIds;
        this.scaleId_ = scaleId;
        this.dest_ = dest;
        this.outType_ = outType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void consume(final StarTable inTable) throws IOException {
        StarTable asTable;
        int ndim = this.colIds_.length;
        StarTable aTable = CubeWriter.getPermutedTable(inTable, this.colIds_);
        if (this.scaleId_ != null) {
            String[] ids = new String[ndim + 1];
            System.arraycopy(this.colIds_, 0, ids, 0, ndim);
            ids[ndim] = this.scaleId_;
            asTable = CubeWriter.getPermutedTable(inTable, ids);
        } else {
            ColumnStarTable unitTable = new ColumnStarTable(inTable){

                public long getRowCount() {
                    return inTable.getRowCount();
                }
            };
            unitTable.addColumn((ColumnData)new UnitColumnData());
            asTable = new JoinStarTable(new StarTable[]{aTable, unitTable});
        }
        CubeWriter.fixBounds(aTable, this.loBounds_, this.hiBounds_);
        if (this.binSizes_ == null) {
            if (!$assertionsDisabled && this.nbins_ == null) {
                throw new AssertionError();
            }
            this.binSizes_ = new double[ndim];
            for (int i = 0; i < ndim; ++i) {
                this.binSizes_[i] = (this.hiBounds_[i] - this.loBounds_[i]) / (double)this.nbins_[i];
            }
        } else if (this.nbins_ == null) {
            if (!$assertionsDisabled && this.binSizes_ == null) {
                throw new AssertionError();
            }
            this.nbins_ = new int[ndim];
            for (int i = 0; i < ndim; ++i) {
                this.nbins_[i] = (int)Math.ceil((this.hiBounds_[i] - this.loBounds_[i]) / this.binSizes_[i]);
            }
        }
        double[] cube = CubeWriter.calculateCube(asTable, this.loBounds_, this.nbins_, this.binSizes_);
        DataOutputStream out = new DataOutputStream(new BufferedOutputStream(this.dest_.createStream()));
        try {
            this.writeFits((ValueInfo[])Tables.getColumnInfos((StarTable)aTable), (ValueInfo)asTable.getColumnInfo(ndim), cube, this.outType_, out);
        }
        finally {
            out.close();
        }
    }

    private static StarTable getPermutedTable(StarTable baseTable, String[] colIds) throws IOException {
        ColumnIdentifier ident = new ColumnIdentifier(baseTable);
        int ndim = colIds.length;
        int[] colMap = new int[ndim];
        for (int idim = 0; idim < ndim; ++idim) {
            colMap[idim] = ident.getColumnIndex(colIds[idim]);
        }
        ColumnPermutedStarTable dimTable = new ColumnPermutedStarTable(baseTable, colMap);
        for (int idim = 0; idim < ndim; ++idim) {
            ColumnInfo info;
            if ((class$java$lang$Number == null ? CubeWriter.class$("java.lang.Number") : class$java$lang$Number).isAssignableFrom((info = dimTable.getColumnInfo(idim)).getContentClass())) continue;
            throw new IOException("Column " + info + " not numeric");
        }
        return dimTable;
    }

    private static void fixBounds(StarTable table, double[] loBounds, double[] hiBounds) throws IOException {
        int ndim = table.getColumnCount();
        boolean autobound = false;
        for (int idim = 0; idim < ndim; ++idim) {
            autobound = autobound || Double.isNaN(loBounds[idim]) || Double.isNaN(hiBounds[idim]);
        }
        if (autobound) {
            double[][] dataBounds = CubeWriter.getDataBounds(table);
            for (int idim = 0; idim < ndim; ++idim) {
                if (Double.isNaN(loBounds[idim])) {
                    loBounds[idim] = dataBounds[idim][0];
                }
                if (Double.isNaN(hiBounds[idim])) {
                    hiBounds[idim] = dataBounds[idim][1];
                }
                if (!Double.isNaN(loBounds[idim]) && !Double.isNaN(hiBounds[idim])) continue;
                throw new IOException("Can't get bounds for " + table.getColumnInfo(idim).getName() + " - no data?");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static double[][] getDataBounds(StarTable table) throws IOException {
        int ndim = table.getColumnCount();
        double[][] bounds = new double[ndim][2];
        for (int idim = 0; idim < ndim; ++idim) {
            bounds[idim] = new double[]{Double.NaN, Double.NaN};
        }
        RowSequence rseq = table.getRowSequence();
        try {
            while (rseq.next()) {
                Object[] row = rseq.getRow();
                for (int idim = 0; idim < ndim; ++idim) {
                    double dval;
                    Object cell = row[idim];
                    if (!(cell instanceof Number) || Double.isInfinite(dval = ((Number)cell).doubleValue()) || Double.isNaN(dval)) continue;
                    if (!(dval >= bounds[idim][0])) {
                        bounds[idim][0] = dval;
                    }
                    if (dval <= bounds[idim][1]) continue;
                    bounds[idim][1] = dval;
                }
            }
        }
        finally {
            rseq.close();
        }
        return bounds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static double[] calculateCube(StarTable table, double[] loBounds, int[] nbins, double[] binSizes) throws IOException {
        int ndim = table.getColumnCount() - 1;
        double[] hiBounds = new double[ndim];
        for (int idim = 0; idim < ndim; ++idim) {
            hiBounds[idim] = loBounds[idim] + (double)nbins[idim] * binSizes[idim];
        }
        long np = 1L;
        for (int idim = 0; idim < ndim; ++idim) {
            np *= (long)nbins[idim];
        }
        int npix = Tables.checkedLongToInt((long)np);
        double[] cube = new double[npix];
        RowSequence rseq = table.getRowSequence();
        try {
            int[] coords = new int[ndim];
            while (rseq.next()) {
                Object[] row = rseq.getRow();
                Object scaleObj = row[ndim];
                double scale = scaleObj instanceof Number ? ((Number)scaleObj).doubleValue() : Double.NaN;
                boolean okRow = scale != 0.0 && !Double.isNaN(scale);
                for (int idim = 0; okRow && idim < ndim; ++idim) {
                    double dval;
                    boolean okCell = false;
                    Object cell = row[idim];
                    if (cell instanceof Number && (dval = ((Number)cell).doubleValue()) >= loBounds[idim] && dval <= hiBounds[idim]) {
                        int ibin = (int)((dval - loBounds[idim]) / binSizes[idim]);
                        if (ibin == nbins[idim]) {
                            --ibin;
                        }
                        if (!($assertionsDisabled || ibin >= 0 && ibin <= nbins[idim])) {
                            throw new AssertionError();
                        }
                        coords[idim] = ibin;
                        okCell = true;
                    }
                    okRow = okRow && okCell;
                }
                if (!okRow) continue;
                int ipix = 0;
                int step = 1;
                for (int idim = 0; idim < ndim; ++idim) {
                    ipix += step * coords[idim];
                    step *= nbins[idim];
                }
                int n = ipix;
                cube[n] = cube[n] + scale;
            }
        }
        finally {
            rseq.close();
        }
        return cube;
    }

    private void writeFits(ValueInfo[] axInfos, ValueInfo binInfo, double[] cube, Class outType, DataOutputStream out) throws IOException {
        int npix = cube.length;
        int ndim = this.nbins_.length;
        double min = Double.NaN;
        double max = Double.NaN;
        if (npix > 0) {
            for (int i = 0; i < npix; ++i) {
                double datum = cube[i];
                if (!(datum >= min)) {
                    min = datum;
                }
                if (datum <= max) continue;
                max = datum;
            }
        }
        if (min == Double.NaN && !$assertionsDisabled && max != Double.NaN) {
            throw new AssertionError();
        }
        Class<Number> clazz = outType;
        if (clazz == null) {
            if (min == Double.NaN) {
                clazz = Byte.TYPE;
            } else {
                Class binType = binInfo.getContentClass();
                if (binType == Byte.class || binType == Short.class || binType == Integer.class || binType == Long.class) {
                    if (min >= -128.0 && max <= 127.0) {
                        clazz = Byte.TYPE;
                    } else if (min >= -32768.0 && max <= 32767.0) {
                        clazz = Short.TYPE;
                    } else if (min >= -2.147483648E9 && max <= 2.147483647E9) {
                        clazz = Integer.TYPE;
                    }
                }
            }
            if (clazz == null) {
                clazz = Double.TYPE;
            }
        }
        NumberWriter writer = CubeWriter.createNumberWriter(out, clazz);
        Header hdr = new Header();
        try {
            int id;
            hdr.addValue("SIMPLE", true, "");
            hdr.addValue("BITPIX", (long)writer.getBitpix(), "Data type");
            hdr.addValue("NAXIS", (long)this.nbins_.length, "Number of axes");
            for (id = 0; id < ndim; ++id) {
                hdr.addValue("NAXIS" + (id + 1), (long)this.nbins_[id], "Dimension " + (id + 1));
            }
            hdr.addValue("DATE", Times.mjdToIso(Times.unixMillisToMjd(System.currentTimeMillis())), "HDU creation date");
            hdr.addValue("BUNIT", "COUNTS", "Number of points per pixel (bin)");
            hdr.addValue("DATAMIN", min, "Minimum value");
            hdr.addValue("DATAMAX", max, "Maximum value");
            for (id = 0; id < ndim; ++id) {
                ValueInfo info = axInfos[id];
                String units = info.getUnitString();
                String desc = info.getDescription();
                hdr.addValue("CTYPE" + (id + 1), info.getName(), desc != null ? desc : "");
                if (units != null) {
                    hdr.addValue("CUNIT" + (id + 1), info.getUnitString(), "Units");
                }
                hdr.addValue("CRVAL" + (id + 1), 0.0, "Reference pixel position (" + (id + 1) + ")");
                hdr.addValue("CDELT" + (id + 1), this.binSizes_[id], "Reference pixel extent (" + (id + 1) + ")");
                hdr.addValue("CRPIX" + (id + 1), -this.loBounds_[id] / this.binSizes_[id], "Reference pixel index (" + (id + 1) + ")");
            }
            hdr.addValue("ORIGIN", "STILTS version " + Stilts.getVersion() + " (" + this.getClass().getName() + ")", null);
            FitsConstants.writeHeader((DataOutput)out, (Header)hdr);
        }
        catch (HeaderCardException e) {
            throw (IOException)new IOException("Trouble with FITS headers: " + e.getMessage()).initCause(e);
        }
        for (int ip = 0; ip < npix; ++ip) {
            writer.writeNumber(cube[ip]);
        }
        long nbyte = (long)(Math.abs(writer.getBitpix()) / 8) * (long)npix;
        int over = (int)(nbyte % 2880L);
        if (over > 0) {
            out.write(new byte[2880 - over]);
        }
        out.flush();
    }

    public static NumberWriter createNumberWriter(final DataOutput out, Class clazz) {
        if (clazz == Byte.TYPE) {
            return new NumberWriter(8){

                public void writeNumber(double value) throws IOException {
                    out.writeByte((byte)value);
                }
            };
        }
        if (clazz == Short.TYPE) {
            return new NumberWriter(16){

                public void writeNumber(double value) throws IOException {
                    out.writeShort((short)value);
                }
            };
        }
        if (clazz == Integer.TYPE) {
            return new NumberWriter(32){

                public void writeNumber(double value) throws IOException {
                    out.writeInt((int)value);
                }
            };
        }
        if (clazz == Long.TYPE) {
            return new NumberWriter(64){

                public void writeNumber(double value) throws IOException {
                    out.writeLong((long)value);
                }
            };
        }
        if (clazz == Float.TYPE) {
            return new NumberWriter(-32){

                public void writeNumber(double value) throws IOException {
                    out.writeFloat((float)value);
                }
            };
        }
        if (clazz == Double.TYPE) {
            return new NumberWriter(-64){

                public void writeNumber(double value) throws IOException {
                    out.writeDouble(value);
                }
            };
        }
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
        return new NumberWriter(64){

            public void writeNumber(double value) throws IOException {
                out.writeDouble(value);
            }
        };
    }

    static {
        $assertionsDisabled = !CubeWriter.class.desiredAssertionStatus();
    }

    private static class UnitColumnData
    extends ColumnData {
        private final Integer unit_ = new Integer(1);

        UnitColumnData() {
            super((ValueInfo)new DefaultValueInfo("Counts", class$java$lang$Integer == null ? (class$java$lang$Integer = CubeWriter.class$("java.lang.Integer")) : class$java$lang$Integer));
        }

        public Object readValue(long irow) {
            return this.unit_;
        }
    }

    private static abstract class NumberWriter {
        private final int bitpix_;

        protected NumberWriter(int bitpix) {
            this.bitpix_ = bitpix;
        }

        public abstract void writeNumber(double var1) throws IOException;

        public int getBitpix() {
            return this.bitpix_;
        }
    }
}

