/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot;

import java.awt.Color;
import uk.ac.starlink.ttools.plot.DataColorTweaker;
import uk.ac.starlink.ttools.plot.PlotState;
import uk.ac.starlink.ttools.plot.Shader;

public class ShaderTweaker
implements DataColorTweaker {
    private final int ioff_;
    private final int ndim_;
    private final Shader[] shaders_;
    private final Scaler[] scalers_;
    private final double[] knobs_;
    private boolean hasEffect_;
    static final /* synthetic */ boolean $assertionsDisabled;

    public ShaderTweaker(int ioff, Shader[] shaders, double[][] ranges, boolean[] logFlags, boolean[] flipFlags) {
        this.ioff_ = ioff;
        this.shaders_ = shaders;
        int ndim = this.shaders_.length;
        this.knobs_ = new double[ndim];
        this.scalers_ = new Scaler[ndim];
        int nd = 0;
        for (int idim = 0; idim < ndim; ++idim) {
            this.knobs_[idim] = Double.NaN;
            if (this.shaders_[idim] == null) continue;
            int jdim = ioff + idim;
            this.scalers_[idim] = ShaderTweaker.createScaler(ranges[jdim][0], ranges[jdim][1], logFlags[jdim], flipFlags[jdim]);
            nd = idim + 1;
        }
        this.ndim_ = nd;
    }

    public int getNcoord() {
        return this.ioff_ + this.ndim_;
    }

    public boolean setCoords(double[] coords) {
        boolean hasEffect = false;
        for (int idim = 0; idim < this.ndim_; ++idim) {
            if (this.shaders_[idim] == null) continue;
            int jdim = this.ioff_ + idim;
            double value = coords[jdim];
            if (Double.isNaN(value)) {
                this.knobs_[idim] = Double.NaN;
                continue;
            }
            hasEffect = true;
            Scaler scaler = this.scalers_[idim];
            double sval = scaler.scale(value);
            if (scaler.inRange(value)) {
                this.knobs_[idim] = sval;
                if (!($assertionsDisabled || sval >= 0.0 && sval <= 1.0)) {
                    throw new AssertionError();
                }
                continue;
            }
            if (Double.isNaN(sval)) {
                return false;
            }
            this.knobs_[idim] = sval > 1.0 ? 1.0 : 0.0;
        }
        this.hasEffect_ = hasEffect;
        return true;
    }

    public void tweakColor(float[] rgba) {
        if (this.hasEffect_) {
            for (int idim = 0; idim < this.ndim_; ++idim) {
                double knob;
                Shader shader = this.shaders_[idim];
                if (shader == null || Double.isNaN(knob = this.knobs_[idim])) continue;
                shader.adjustRgba(rgba, (float)knob);
            }
        }
    }

    public Color tweakColor(Color orig) {
        if (this.hasEffect_) {
            float[] rgba = orig.getRGBComponents(null);
            this.tweakColor(rgba);
            return new Color(rgba[0], rgba[1], rgba[2], rgba[3]);
        }
        return orig;
    }

    public static ShaderTweaker createTweaker(int ioff, PlotState state) {
        Object ranges;
        Shader[] shaders = state.getShaders();
        int naux = shaders.length;
        if (naux == 0) {
            return null;
        }
        int nd = state.getMainNdim();
        if (ioff == nd) {
            ranges = state.getRanges();
        } else {
            ranges = new double[ioff + naux][];
            System.arraycopy(state.getRanges(), nd, ranges, ioff, naux);
        }
        return new ShaderTweaker(ioff, shaders, (double[][])ranges, state.getLogFlags(), state.getFlipFlags());
    }

    private static Scaler createScaler(double lo, double hi, boolean logFlag, boolean flipFlag) {
        if (logFlag) {
            final double base1 = 1.0 / (flipFlag ? hi : lo);
            final double scale1 = 1.0 / Math.log(flipFlag ? lo / hi : hi / lo);
            return new Scaler(lo, hi){

                public double scale(double value) {
                    return Math.log(value * base1) * scale1;
                }
            };
        }
        final double base = flipFlag ? hi : lo;
        final double scale1 = 1.0 / (flipFlag ? lo - hi : hi - lo);
        return new Scaler(lo, hi){

            public double scale(double value) {
                return (value - base) * scale1;
            }
        };
    }

    static {
        $assertionsDisabled = !ShaderTweaker.class.desiredAssertionStatus();
    }

    private static abstract class Scaler {
        private final double lo_;
        private final double hi_;

        public Scaler(double lo, double hi) {
            this.lo_ = lo;
            this.hi_ = hi;
        }

        public boolean inRange(double value) {
            return value >= this.lo_ && value <= this.hi_;
        }

        public abstract double scale(double var1);
    }
}

