/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.task;

import uk.ac.starlink.table.JoinFixAction;
import uk.ac.starlink.task.ChoiceParameter;
import uk.ac.starlink.task.Environment;
import uk.ac.starlink.task.Parameter;
import uk.ac.starlink.task.TaskException;

public class JoinFixActionParameter
extends ChoiceParameter {
    public JoinFixActionParameter(String name) {
        super(name);
        this.setPrompt("Whether and how to rename input columns");
        this.addOption(new Fixer("none", "columns are not renamed"){

            public JoinFixAction createAction(Environment env, Parameter suffixParam) throws TaskException {
                return JoinFixAction.NO_ACTION;
            }
        });
        String dflt = "dups";
        this.addOption(new Fixer("dups", "columns which would otherwise have duplicate names in the output will be renamed to indicate which table they came from"){

            public JoinFixAction createAction(Environment env, Parameter suffixParam) throws TaskException {
                String suffix = suffixParam.stringValue(env);
                return suffix == null || suffix.trim().length() == 0 ? JoinFixAction.NO_ACTION : JoinFixAction.makeRenameDuplicatesAction((String)suffix);
            }
        });
        this.addOption(new Fixer("all", "all columns will be renamed to indicate which table they came from"){

            public JoinFixAction createAction(Environment env, Parameter suffixParam) throws TaskException {
                String suffix = suffixParam.stringValue(env);
                return suffix == null || suffix.trim().length() == 0 ? JoinFixAction.NO_ACTION : JoinFixAction.makeRenameAllAction((String)suffix);
            }
        });
        this.setDefault(dflt);
        StringBuffer dbuf = new StringBuffer().append("<p>Determines how input columns are renamed before\n").append("use in the output table.  The choices are:\n").append("<ul>\n");
        Object[] options = this.getOptions();
        for (int i = 0; i < options.length; ++i) {
            Fixer opt = (Fixer)options[i];
            dbuf.append("<li>").append("<code>").append(opt.toString()).append("</code>").append(": ").append(opt.getDescription()).append("</li>").append("\n");
        }
        dbuf.append("</ul>\n").append("If columns are renamed, the new ones are determined\n").append("by <code>").append(this.createSuffixParameter("*").getName()).append("</code> ").append("parameters.\n").append("</p>");
        this.setDescription(dbuf.toString());
    }

    public JoinFixAction getJoinFixAction(Environment env, Parameter suffixParam) throws TaskException {
        Fixer fixer = (Fixer)this.objectValue(env);
        return fixer.createAction(env, suffixParam);
    }

    public JoinFixAction[] getJoinFixActions(Environment env, int nin) throws TaskException {
        JoinFixAction[] fixActs = new JoinFixAction[nin];
        for (int i = 0; i < nin; ++i) {
            Parameter suffixParam = this.createSuffixParameter(Integer.toString(i + 1));
            fixActs[i] = this.getJoinFixAction(env, suffixParam);
        }
        return fixActs;
    }

    public Parameter createSuffixParameter(String numLabel) {
        return this.createSuffixParameter("suffix" + numLabel, "table " + numLabel, "_" + numLabel);
    }

    public Parameter createSuffixParameter(String name, String descrip, String dflt) {
        Parameter param = new Parameter(name);
        param.setDefault(dflt);
        param.setNullPermitted(true);
        param.setUsage("<label>");
        param.setPrompt("Deduplicating suffix for columns in " + descrip);
        param.setDescription(new String[]{"<p>If the <code>" + this.getName() + "</code> parameter", "is set so that input columns are renamed for insertion into", "the output table, this parameter determines how the", "renaming is done.", "It gives a suffix which is appended to all renamed columns", "from " + descrip + ".", "</p>"});
        return param;
    }

    private abstract class Fixer {
        private final String name_;
        private final String description_;

        public Fixer(String name, String description) {
            this.name_ = name;
            this.description_ = description;
        }

        public abstract JoinFixAction createAction(Environment var1, Parameter var2) throws TaskException;

        public String getDescription() {
            return this.description_;
        }

        public String toString() {
            return this.name_;
        }
    }
}

