-- An AppleScript script to create an alias on the desktop and set its icon to the ALMA icon

use framework "Foundation"
use scripting additions

on run argList
	
	-- Ensure that the caller has specified the user_install_dir and the product name on the command line 
	
	try
		set userInstallDir to item 1 of argList
		set productName to item 2 of argList
	on error
		tell me to error "Usage: setIcon <USER_INSTALLDIR> <PRODUCT_NAME>"
	end try
	
	
	set home to (system attribute "HOME")
	
	set sourceFile to userInstallDir & "/_" & productName & "_installation/ALMA-OT.app"
	
	set desktopShortCut to home & "/Desktop/" & productName
	
	-- Delete any existing desktop alias of that name 
	
	try
		do shell script "rm " & quoted form of desktopShortCut
	end try
	
	-- Get the Finder application to create a new desktop alias on the desktop 
	
	tell application "Finder"
		set myapp to POSIX file sourceFile as alias
		set newAlias to (make new alias file at desktop to myapp) as alias
		my setIcon(result)
		set name of newAlias to productName
	end tell
	
	
end run

-- Now set the icon of the new desktop alias  

to setIcon(fileRef)
	set iconImage to current application's NSImage's alloc's initWithContentsOfFile:"alma.icns"
	current application's NSWorkspace's sharedWorkspace's setIcon:iconImage forFile:(POSIX path of fileRef) options:0
end setIcon



