/*
 * Decompiled with CFR 0.152.
 */
package alma.correlatorSrc.CorrConfigValidator;

import alma.ACS.stringSeqHolder;
import alma.AccumModeMod.AccumMode;
import alma.AtmPhaseCorrectionMod.AtmPhaseCorrection;
import alma.BasebandNameMod.BasebandName;
import alma.CorrConfigModeErr.wrappers.AcsJConstructorFailureEx;
import alma.CorrConfigModeErr.wrappers.AcsJInvalidKeyEx;
import alma.CorrConfigModeErr.wrappers.AcsJInvalidModeEx;
import alma.CorrConfigModeErr.wrappers.AcsJModeInconsistencyEx;
import alma.CorrConfigModeErr.wrappers.AcsJReadTypeEx;
import alma.CorrelationBitMod.CorrelationBit;
import alma.CorrelationModeMod.CorrelationMode;
import alma.Correlator.BaseBandConfig;
import alma.Correlator.ChannelAverageRegion;
import alma.Correlator.ConfigMode;
import alma.Correlator.CorrConfigModeClass.CorrConfigModeClass;
import alma.Correlator.CorrelatorConfiguration;
import alma.Correlator.DataRatesBL;
import alma.Correlator.DataRatesPerBasebandBL;
import alma.Correlator.SpectralWindow;
import alma.Correlator.eFilterMode;
import alma.Correlator.eFraction;
import alma.NetSidebandMod.NetSideband;
import alma.ReceiverSidebandMod.ReceiverSideband;
import alma.SidebandProcessingModeMod.SidebandProcessingMode;
import alma.StokesParameterMod.StokesParameter;
import alma.SwitchingModeMod.SwitchingMode;
import alma.correlatorSrc.CorrConfigValidator.BL_XMLParser;
import alma.correlatorSrc.CorrConfigValidator.CorrConfigValidatorBLDataRateCalcImpl;
import alma.correlatorSrc.CorrConfigValidator.CorrConfigValidatorBase;
import alma.correlatorSrc.CorrConfigValidator.SBConversionException;
import alma.hla.datamodel.enumeration.JBasebandName;
import alma.hla.datamodel.enumeration.JSidebandProcessingMode;
import alma.hla.datamodel.enumeration.JStokesParameter;
import com.cosylab.CDB.DAL;
import com.cosylab.CDB.DAO;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CorrConfigValidator
extends CorrConfigValidatorBLDataRateCalcImpl {
    private Logger m_logger;
    private CorrConfigModeClass m_modesTable;
    Vector m_errorVector;
    private long m_integrationDuration;
    private long m_dumpDuration;
    private ReceiverSideband m_receiverType;
    private int m_totalChanAverRegionsPerBaseband;
    private String m_correlatorType;
    private int m_maxNumSpectralWindowsPerBaseband;
    private int m_maxNumAntennas;
    private int m_maxNumBasebands;
    private int m_maxNumChanAverRegions;
    private int m_maxNumAPCDatasets;
    private Vector m_sideBandProcessingModesAllowed;

    public CorrConfigValidator() throws AcsJConstructorFailureEx {
        this.m_correlatorType = new String("CORRELATOR_12m_1QUADRANT");
        this.m_logger = Logger.getLogger("alma.correlator.CorrConfigValidator");
        try {
            this.m_modesTable = new CorrConfigModeClass(this.m_correlatorType);
            this.setCorrelatorLimits();
        }
        catch (AcsJConstructorFailureEx ex) {
            this.m_logger.log(Level.SEVERE, "failed to instantiate modes table for correlator type: " + this.m_correlatorType, ex);
            throw ex;
        }
    }

    public CorrConfigValidator(String correlatorType) throws AcsJConstructorFailureEx {
        this.m_correlatorType = correlatorType.length() == 0 ? new String("CORRELATOR_12m_1QUADRANT") : correlatorType;
        this.m_logger = Logger.getLogger("alma.correlator.CorrConfigValidator");
        try {
            this.m_modesTable = new CorrConfigModeClass(this.m_correlatorType);
            this.setCorrelatorLimits();
        }
        catch (AcsJConstructorFailureEx ex) {
            this.m_logger.log(Level.SEVERE, "failed to instantiate modes table for correlator type: " + this.m_correlatorType, ex);
            throw ex;
        }
    }

    public CorrConfigValidator(DAL dal) throws AcsJConstructorFailureEx, AcsJReadTypeEx {
        this.m_logger = Logger.getLogger("alma.correlator.CorrConfigValidator");
        try {
            this.m_modesTable = new CorrConfigModeClass(dal);
            this.m_correlatorType = this.m_modesTable.getType();
            this.setCorrelatorLimits();
        }
        catch (AcsJConstructorFailureEx ex) {
            this.m_logger.log(Level.SEVERE, "failed to instantiate modes table.", ex);
            throw ex;
        }
        try {
            DAO ex = dal.get_DAO_Servant("alma/CORR/CONFIGURATION_VALIDATOR");
        }
        catch (Throwable thr) {
            throw new AcsJReadTypeEx("access to cdb atribute thrown unknown exception");
        }
    }

    public CorrelatorConfiguration translateSpectralSpecXml2CorrConfigIdl(String spectralSpecXML) {
        BL_XMLParser blXMLParser = new BL_XMLParser();
        this.m_errorVector = new Vector();
        try {
            CorrelatorConfiguration corrConfigIDL = blXMLParser.translateSpectralSpecXml2CorrConfigIdl(spectralSpecXML);
            return corrConfigIDL;
        }
        catch (SBConversionException sbcex) {
            this.m_errorVector.addElement(sbcex.getMessage());
            return null;
        }
        catch (Exception ex) {
            this.m_errorVector.addElement("Invalid spectral Spec: " + ex.toString());
            return null;
        }
    }

    @Override
    public boolean validateSpectralSpec(String spectralSpec, int numOfAntennas, stringSeqHolder errorStringSeq) {
        this.m_errorVector = new Vector();
        CorrelatorConfiguration corrConfig = this.translateSpectralSpecXml2CorrConfigIdl(spectralSpec);
        if (corrConfig == null) {
            this.m_errorVector.addElement("Failed to translate SpectralSpec Xml to CorrConfigIdl ");
            this.copyErrorStrings(errorStringSeq);
            return false;
        }
        return this.validateConfiguration(corrConfig, numOfAntennas, errorStringSeq);
    }

    public boolean validateSpectralSpecBL(String spectralSpec, int[] cais, DataRatesBL dataRates, stringSeqHolder errorStringSeq) {
        dataRates.master = 0.0f;
        dataRates.basebands = new DataRatesPerBasebandBL[4];
        for (int i = 0; i < 4; ++i) {
            dataRates.basebands[i] = new DataRatesPerBasebandBL();
            dataRates.basebands[i].dpi = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
            dataRates.basebands[i].cluster = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
        }
        this.m_errorVector = new Vector();
        CorrelatorConfiguration corrConfig = this.translateSpectralSpecXml2CorrConfigIdl(spectralSpec);
        if (corrConfig == null) {
            this.m_errorVector.addElement("Failed to translate SpectralSpec Xml to CorrConfigIdl ");
            this.copyErrorStrings(errorStringSeq);
            return false;
        }
        if (!this.validateConfiguration(corrConfig, cais.length, errorStringSeq)) {
            return false;
        }
        try {
            int[] intersections = new int[4];
            this.calculateDetailedDataRate(this.m_modesTable, corrConfig, cais, intersections, dataRates);
        }
        catch (Exception ex) {
            this.m_errorVector.addElement("Failed to compute detailed data rates: " + ex.toString());
            this.copyErrorStrings(errorStringSeq);
            return false;
        }
        return true;
    }

    public boolean validateConfiguration(CorrelatorConfiguration corrConfig, int numOfAntennas, stringSeqHolder errorStringSeq) {
        int i;
        AtmPhaseCorrection atm1;
        AtmPhaseCorrection atm0;
        this.m_logger.info("CorrConfigValidator: Validate the Configuration IDL struct");
        this.m_errorVector = new Vector();
        boolean isValidConfig = true;
        this.m_integrationDuration = corrConfig.integrationDuration;
        this.m_receiverType = corrConfig.receiverType;
        this.m_dumpDuration = corrConfig.dumpDuration;
        isValidConfig = this.validateDurations(corrConfig);
        if (corrConfig.APCDataSets.length < 1 || corrConfig.APCDataSets.length > this.m_maxNumAPCDatasets) {
            this.m_errorVector.addElement("CorrConfig : Invalid number of APCDataSets: " + corrConfig.APCDataSets.length + " valid range: 1 - " + this.m_maxNumAPCDatasets);
            isValidConfig = false;
        } else if (corrConfig.APCDataSets.length == 2 && (atm0 = corrConfig.APCDataSets[0]) == (atm1 = corrConfig.APCDataSets[1])) {
            this.m_errorVector.addElement("CorrConfig : Duplicate APC Data type: " + atm0.toString());
            isValidConfig = false;
        }
        if (corrConfig.baseBands.length < 1 || corrConfig.baseBands.length > this.m_maxNumBasebands) {
            this.m_errorVector.addElement("CorrConfig Baseband count " + corrConfig.baseBands.length + " is invalid. Valid range: 1 - " + this.m_maxNumBasebands);
            this.copyErrorStrings(errorStringSeq);
            return false;
        }
        for (i = 0; i < corrConfig.baseBands.length; ++i) {
            for (int j = i + 1; j < corrConfig.baseBands.length; ++j) {
                if (corrConfig.baseBands[i].basebandName != corrConfig.baseBands[j].basebandName) continue;
                this.m_errorVector.addElement("CorrConfig baseband " + corrConfig.baseBands[i].basebandName.toString() + " appers more than once");
                this.copyErrorStrings(errorStringSeq);
                return false;
            }
        }
        for (i = 0; i < corrConfig.baseBands.length; ++i) {
            for (int j = i + 1; j < corrConfig.baseBands.length; ++j) {
                if (corrConfig.baseBands[i].dataProducts == corrConfig.baseBands[j].dataProducts) continue;
                this.m_errorVector.addElement("CorrConfig baseband " + corrConfig.baseBands[i].basebandName.toString() + " and " + corrConfig.baseBands[j].basebandName.toString() + " have different data products ");
                this.copyErrorStrings(errorStringSeq);
                return false;
            }
        }
        for (BaseBandConfig bb : corrConfig.baseBands) {
            if (this.validateBaseband(bb, numOfAntennas)) continue;
            isValidConfig = false;
        }
        if (numOfAntennas < 1 || numOfAntennas > this.m_maxNumAntennas) {
            this.m_errorVector.addElement("CorrConfig Number of antennas invalid: " + numOfAntennas + " Valid range: 1 - " + this.m_maxNumAntennas);
            this.copyErrorStrings(errorStringSeq);
            return false;
        }
        if (!this.checkBaseBandDataRate(corrConfig, numOfAntennas)) {
            isValidConfig = false;
        }
        if (!this.checkConfigDataRate(corrConfig, numOfAntennas)) {
            isValidConfig = false;
        }
        this.copyErrorStrings(errorStringSeq);
        if (this.m_errorVector.size() != 0) {
            isValidConfig = false;
        }
        return isValidConfig;
    }

    private boolean validateDurations(CorrelatorConfiguration corrConfig) {
        boolean bValidDurations = true;
        long channelAverageDuration = corrConfig.channelAverageDuration;
        if (this.m_dumpDuration < 10000L) {
            this.m_errorVector.addElement("Dump duration is too short: " + this.m_dumpDuration);
            bValidDurations = false;
        }
        if (this.m_integrationDuration < 10000L) {
            this.m_errorVector.addElement("Integration Duration is too short: " + this.m_integrationDuration);
            bValidDurations = false;
        } else if (this.m_dumpDuration != 0L && this.m_integrationDuration % this.m_dumpDuration != 0L) {
            this.m_errorVector.addElement("Integration Duration " + this.m_integrationDuration + " is not an integer multiple of the dump duration: " + this.m_dumpDuration);
            bValidDurations = false;
        }
        if (channelAverageDuration > 0L) {
            if (channelAverageDuration > this.m_integrationDuration) {
                this.m_errorVector.addElement("Channel average duration " + channelAverageDuration + " is greater than the integration duration " + this.m_integrationDuration);
                bValidDurations = false;
            }
            if (this.m_dumpDuration != 0L && channelAverageDuration % this.m_dumpDuration != 0L) {
                this.m_errorVector.addElement("Channel average duration " + channelAverageDuration + " is not an integral multiple of the dump duration: " + this.m_dumpDuration);
                bValidDurations = false;
            }
            if (this.m_integrationDuration % channelAverageDuration != 0L) {
                this.m_errorVector.addElement("Integration duration " + this.m_integrationDuration + " is not a multiple of the sub-integration durations: " + channelAverageDuration);
                bValidDurations = false;
            }
        }
        return bValidDurations;
    }

    private SpectralWindow getSpectralWindow(SpectralWindow spw) {
        SpectralWindow spectWindow = new SpectralWindow();
        spectWindow.centerFrequencyMHz = spw.centerFrequencyMHz;
        spectWindow.effectiveBandwidthMHz = spw.effectiveBandwidthMHz;
        spectWindow.effectiveNumberOfChannels = spw.effectiveNumberOfChannels;
        spectWindow.spectralAveragingFactor = spw.spectralAveragingFactor;
        spectWindow.sideBand = spw.sideBand;
        spectWindow.associatedSpectralWindowNumberInPair = spw.associatedSpectralWindowNumberInPair;
        spectWindow.useThisSpectralWindow = spw.useThisSpectralWindow;
        spectWindow.windowFunction = spw.windowFunction;
        spectWindow.channelAverageRegions = this.getChannelAverageRegions(spw);
        spectWindow.frqChProfReproduction = spw.frqChProfReproduction;
        spectWindow.correlationBits = spw.correlationBits;
        spectWindow.correlationNyquistOversampling = spw.correlationNyquistOversampling;
        spectWindow.polnProductsSeq = this.getPolnProductsSeq(spw);
        spectWindow.quantizationCorrection = spw.quantizationCorrection;
        return spectWindow;
    }

    private StokesParameter[] getPolnProductsSeq(SpectralWindow spw) {
        StokesParameter[] pps = new StokesParameter[spw.polnProductsSeq.length];
        for (int l = 0; l < spw.polnProductsSeq.length; ++l) {
            pps[l] = spw.polnProductsSeq[l];
            this.m_logger.info(">>> alma.StokesParameterMod.StokesParameter " + pps[l].toString());
        }
        return pps;
    }

    private ChannelAverageRegion[] getChannelAverageRegions(SpectralWindow spw) {
        ChannelAverageRegion[] cars = new ChannelAverageRegion[spw.channelAverageRegions.length];
        for (int carl = 0; carl < spw.channelAverageRegions.length; ++carl) {
            cars[carl] = this.getChannelAverageRegion(spw.channelAverageRegions[carl]);
        }
        return cars;
    }

    private ChannelAverageRegion getChannelAverageRegion(ChannelAverageRegion car) {
        ChannelAverageRegion chanAverRegion = new ChannelAverageRegion();
        chanAverRegion.startChannel = car.startChannel;
        chanAverRegion.numberChannels = car.numberChannels;
        return chanAverRegion;
    }

    private boolean validateBaseband(BaseBandConfig baseBand, int numOfAntennas) {
        boolean isValidBaseBand;
        block15: {
            block17: {
                block16: {
                    block13: {
                        block14: {
                            isValidBaseBand = true;
                            this.m_totalChanAverRegionsPerBaseband = 0;
                            if (this.m_correlatorType.equals("CORRELATOR_12m_2ANTS") && baseBand.basebandName != BasebandName.BB_1 && baseBand.basebandName != BasebandName.BB_2) {
                                this.m_errorVector.addElement("BaseBand " + baseBand.basebandName.toString() + " for correlator CORRELATOR_12m_2ANTS is invalid, only BB_1 & BB_2 valid");
                                isValidBaseBand = false;
                            } else if (baseBand.basebandName != BasebandName.BB_1 && baseBand.basebandName != BasebandName.BB_2 && baseBand.basebandName != BasebandName.BB_3 && baseBand.basebandName != BasebandName.BB_4) {
                                this.m_errorVector.addElement("BaseBand " + baseBand.basebandName.toString() + " is invalid, only BB_1...BB_4 valid");
                                isValidBaseBand = false;
                            }
                            if (!this.validateCamAndDataProduct(baseBand, numOfAntennas == 1)) {
                                isValidBaseBand = false;
                            }
                            if (!this.validateSpectralWindows(baseBand)) {
                                isValidBaseBand = false;
                            }
                            if (baseBand.binSwitchingMode.SwitchingType != SwitchingMode.NO_SWITCHING) break block13;
                            if (baseBand.binSwitchingMode.numberOfPositions == 1) break block14;
                            this.m_errorVector.addElement("BaseBand " + baseBand.basebandName.toString() + ": Bin Switching mode: " + baseBand.binSwitchingMode.SwitchingType.toString() + ": # Bin switching positions " + baseBand.binSwitchingMode.numberOfPositions);
                            isValidBaseBand = false;
                            break block15;
                        }
                        if (baseBand.binSwitchingMode.dwellTime.length == 1 && baseBand.binSwitchingMode.deadTime.length <= 1) break block15;
                        this.m_errorVector.addElement("BaseBand " + baseBand.basebandName.toString() + ": Bin Switching mode: " + baseBand.binSwitchingMode.SwitchingType.toString() + " [# Bin switching positions " + baseBand.binSwitchingMode.numberOfPositions + " Array lengths: Dwell time: " + baseBand.binSwitchingMode.dwellTime.length + " Dead time: " + baseBand.binSwitchingMode.deadTime.length + "] must all be equal");
                        isValidBaseBand = false;
                        break block15;
                    }
                    if (baseBand.binSwitchingMode.SwitchingType == SwitchingMode.LOAD_SWITCHING) break block15;
                    if (baseBand.binSwitchingMode.numberOfPositions < 2 || baseBand.binSwitchingMode.numberOfPositions > 4) {
                        this.m_errorVector.addElement("BaseBand " + baseBand.basebandName.toString() + ": Bin Switching mode: " + baseBand.binSwitchingMode.SwitchingType.toString() + ": # Bin switching positions " + baseBand.binSwitchingMode.numberOfPositions + " unsupported");
                        isValidBaseBand = false;
                    }
                    if (baseBand.binSwitchingMode.dwellTime.length == baseBand.binSwitchingMode.numberOfPositions) break block16;
                    this.m_errorVector.addElement("BaseBand " + baseBand.basebandName.toString() + ": Bin Switching mode: " + baseBand.binSwitchingMode.SwitchingType.toString() + ": # Bin switching positions " + baseBand.binSwitchingMode.numberOfPositions + " not equal to # of dwell time postions " + baseBand.binSwitchingMode.dwellTime.length);
                    isValidBaseBand = false;
                    break block15;
                }
                if (baseBand.binSwitchingMode.SwitchingType != SwitchingMode.NUTATOR_SWITCHING) break block17;
                if (baseBand.binSwitchingMode.deadTime.length != baseBand.binSwitchingMode.dwellTime.length) {
                    this.m_errorVector.addElement("BaseBand " + baseBand.basebandName.toString() + ": Bin Switching mode: " + baseBand.binSwitchingMode.SwitchingType.toString() + " must have equal numbers of dwell time entries: " + baseBand.binSwitchingMode.dwellTime.length + " dead time entries: " + baseBand.binSwitchingMode.deadTime.length);
                    isValidBaseBand = false;
                }
                if (baseBand.binSwitchingMode.deadTime.length == 0 || baseBand.binSwitchingMode.dwellTime.length == 0) break block15;
                for (int i = 0; i < baseBand.binSwitchingMode.deadTime.length; ++i) {
                    long deadDwellTime;
                    if (baseBand.binSwitchingMode.deadTime[i] == 0L || baseBand.binSwitchingMode.dwellTime[i] == 0L) {
                        this.m_errorVector.addElement("BaseBand " + baseBand.basebandName.toString() + ": Bin Switching mode: " + baseBand.binSwitchingMode.SwitchingType.toString() + ": must have non-zero dwell (" + Long.toString(baseBand.binSwitchingMode.dwellTime[i]) + ") and dead (" + Long.toString(baseBand.binSwitchingMode.deadTime[i]) + ") times");
                        isValidBaseBand = false;
                    }
                    if ((deadDwellTime = baseBand.binSwitchingMode.deadTime[i] + baseBand.binSwitchingMode.dwellTime[i]) == 0L) {
                        this.m_errorVector.addElement("BaseBand " + baseBand.basebandName.toString() + ": Bin Switching mode: " + baseBand.binSwitchingMode.SwitchingType.toString() + ": Bin Switching dwell + dead time set [" + Integer.toString(i) + "] is " + Long.toString(deadDwellTime) + " is 0");
                        isValidBaseBand = false;
                        continue;
                    }
                    if (deadDwellTime % 480000L == 0L) continue;
                    this.m_errorVector.addElement("BaseBand " + baseBand.basebandName.toString() + ": Bin Switching mode: " + baseBand.binSwitchingMode.SwitchingType.toString() + ": Bin Switching dwell + dead time set [" + Integer.toString(i) + "] is " + Long.toString(deadDwellTime) + " must be a multiple of 480000 100ns.");
                    isValidBaseBand = false;
                }
                break block15;
            }
            if (baseBand.binSwitchingMode.SwitchingType == SwitchingMode.FREQUENCY_SWITCHING) {
                int i;
                for (i = 0; i < baseBand.binSwitchingMode.deadTime.length; ++i) {
                    if (baseBand.binSwitchingMode.deadTime[i] == 0L) continue;
                    this.m_errorVector.addElement("BaseBand " + baseBand.basebandName.toString() + ": Bin Switching mode: " + baseBand.binSwitchingMode.SwitchingType.toString() + ": can't have dead times: [" + Integer.toString(i) + "]: " + Long.toString(baseBand.binSwitchingMode.deadTime[i]));
                    isValidBaseBand = false;
                }
                for (i = 0; i < baseBand.binSwitchingMode.dwellTime.length; ++i) {
                    if (baseBand.binSwitchingMode.dwellTime[i] % 480000L == 0L) continue;
                    this.m_errorVector.addElement("BaseBand " + baseBand.basebandName.toString() + ": Bin Switching mode: " + baseBand.binSwitchingMode.SwitchingType.toString() + ": Dwell time[" + Integer.toString(i) + "] is " + Long.toString(baseBand.binSwitchingMode.dwellTime[i]) + " must be a multiple of 48 ms.");
                    isValidBaseBand = false;
                }
            }
        }
        return isValidBaseBand;
    }

    private boolean validateSpectralWindows(BaseBandConfig baseBand) {
        int si;
        boolean bValidSpectralWindow = true;
        String bbn = JBasebandName.name((BasebandName)baseBand.basebandName);
        int modeNumber = 0;
        ConfigMode m = null;
        long quotient = 0L;
        double resolution = 0.0;
        if (baseBand.spectralWindows.length < 1 || baseBand.spectralWindows.length > this.m_maxNumSpectralWindowsPerBaseband) {
            this.m_errorVector.addElement("BaseBand " + bbn + ": Spectral window count " + baseBand.spectralWindows.length + " is invalid. Valid range: 1 - " + this.m_maxNumSpectralWindowsPerBaseband);
            bValidSpectralWindow = false;
        }
        if (baseBand.sideBandSeparationMode == SidebandProcessingMode.PHASE_SWITCH_SEPARATION) {
            if (baseBand.spectralWindows.length % 2 != 0) {
                this.m_errorVector.addElement("BaseBand  " + baseBand.basebandName.toString() + " number of spectral windows should be even for the sideband separation mode ");
                bValidSpectralWindow = false;
            }
            for (int spw = 0; spw < baseBand.spectralWindows.length; ++spw) {
                int associated = baseBand.spectralWindows[spw].associatedSpectralWindowNumberInPair;
                if (associated == 0 || associated - 1 >= baseBand.spectralWindows.length) {
                    this.m_errorVector.addElement("BaseBand " + baseBand.basebandName.toString() + ": Spectral Window: " + (spw + 1) + " Invalid associated window index (" + associated + ")");
                    bValidSpectralWindow = false;
                    continue;
                }
                if (baseBand.spectralWindows[spw].sideBand == baseBand.spectralWindows[associated - 1].sideBand) {
                    this.m_errorVector.addElement("BaseBand " + baseBand.basebandName.toString() + ": Spectral Window: " + (spw + 1) + " " + associated + " Associated spectral window has same side-band (" + baseBand.spectralWindows[spw].sideBand + baseBand.spectralWindows[associated - 1].sideBand + ")");
                    bValidSpectralWindow = false;
                    continue;
                }
                if (!baseBand.spectralWindows[spw].useThisSpectralWindow && !baseBand.spectralWindows[associated - 1].useThisSpectralWindow) {
                    this.m_errorVector.addElement("BaseBand " + baseBand.basebandName.toString() + ": Spectral Window: " + (spw + 1) + " Present and associated spectral windows are disabled");
                    bValidSpectralWindow = false;
                    continue;
                }
                if (baseBand.spectralWindows[spw].centerFrequencyMHz != baseBand.spectralWindows[associated - 1].centerFrequencyMHz) {
                    this.m_errorVector.addElement("BaseBand " + baseBand.basebandName.toString() + ": Spectral Window: " + (spw + 1) + " " + associated + " Associated spectral window has different center frequency (" + baseBand.spectralWindows[spw].centerFrequencyMHz + "/" + baseBand.spectralWindows[associated - 1].centerFrequencyMHz + ")");
                    bValidSpectralWindow = false;
                    continue;
                }
                try {
                    int modeNumber0 = this.m_modesTable.findModeFromResolution((float)baseBand.spectralWindows[spw].effectiveBandwidthMHz, (long)baseBand.spectralWindows[spw].effectiveNumberOfChannels, baseBand.spectralWindows[spw].correlationBits, baseBand.spectralWindows[spw].correlationNyquistOversampling, baseBand.spectralWindows[spw].polnProductsSeq, eFraction.FRACTION_FULL);
                    int modeNumber1 = this.m_modesTable.findModeFromResolution((float)baseBand.spectralWindows[associated - 1].effectiveBandwidthMHz, (long)baseBand.spectralWindows[associated - 1].effectiveNumberOfChannels, baseBand.spectralWindows[associated - 1].correlationBits, baseBand.spectralWindows[associated - 1].correlationNyquistOversampling, baseBand.spectralWindows[associated - 1].polnProductsSeq, eFraction.FRACTION_FULL);
                    if (modeNumber0 == modeNumber1) continue;
                    this.m_errorVector.addElement("BaseBand " + baseBand.basebandName.toString() + ": Spectral Window: " + (spw + 1) + " " + associated + " Associated spectral window on different correlator mode (" + modeNumber0 + "/" + modeNumber1 + ")");
                    bValidSpectralWindow = false;
                    continue;
                }
                catch (AcsJInvalidModeEx ex) {
                    this.m_errorVector.addElement("failed to find mode number " + bbn + " spw " + (spw + 1) + " " + ex.toString());
                    bValidSpectralWindow = false;
                }
            }
        } else {
            for (si = 0; si < baseBand.spectralWindows.length; ++si) {
                if (!baseBand.spectralWindows[si].useThisSpectralWindow) {
                    this.m_errorVector.addElement("BaseBand " + baseBand.basebandName.toString() + ": Spectral Window: " + (si + 1) + " No side-band separation cannot suppress a spectral window: useThisSpectralWindow = false");
                    bValidSpectralWindow = false;
                }
                if (baseBand.spectralWindows[si].associatedSpectralWindowNumberInPair == 0) continue;
                this.m_errorVector.addElement("BaseBand " + baseBand.basebandName.toString() + ": Spectral Window: " + (si + 1) + " No side-band separation must not associate windows");
                bValidSpectralWindow = false;
            }
        }
        StokesParameter[] polarizationProducts = baseBand.spectralWindows[0].polnProductsSeq;
        resolution = baseBand.spectralWindows[0].effectiveBandwidthMHz / (double)baseBand.spectralWindows[0].effectiveNumberOfChannels;
        for (si = 0; si < baseBand.spectralWindows.length; ++si) {
            int si1 = si + 1;
            if (baseBand.spectralWindows[0].correlationBits != baseBand.spectralWindows[si].correlationBits) {
                this.m_errorVector.addElement("BaseBand " + bbn + ": SpectralWindow : " + si1 + " correlationBits " + baseBand.spectralWindows[si].correlationBits + " not the same for all spectral windows ");
                bValidSpectralWindow = false;
            }
            if (baseBand.spectralWindows[si].correlationNyquistOversampling) {
                this.m_errorVector.addElement("BaseBand " + bbn + ": SpectralWindow " + si1 + " has incorrect correlationNyquistOversampling value, only false allowed at this moment ");
                bValidSpectralWindow = false;
            }
            if (polarizationProducts.length != baseBand.spectralWindows[si].polnProductsSeq.length) {
                this.m_errorVector.addElement("BaseBand " + bbn + ": SpectralWindow : " + si1 + " number of polarization products " + polarizationProducts.length + " is inconsistent with other spectral windows: " + polarizationProducts.length);
                bValidSpectralWindow = false;
            }
            for (int pi = 0; pi < polarizationProducts.length; ++pi) {
                if (polarizationProducts.length == 1 && polarizationProducts[pi].equals(StokesParameter.YY)) {
                    this.m_errorVector.addElement("BaseBand " + bbn + ": SpectralWindow : " + si + ": Polarization : " + pi + ": single YY polarization product not supported ");
                    bValidSpectralWindow = false;
                }
                if (polarizationProducts[pi].equals(baseBand.spectralWindows[si].polnProductsSeq[pi])) continue;
                this.m_errorVector.addElement("BaseBand " + bbn + ": SpectralWindow : " + si + ": multiple regions polarizations are not same ");
                bValidSpectralWindow = false;
            }
            if (Math.abs(resolution - baseBand.spectralWindows[si].effectiveBandwidthMHz / (double)baseBand.spectralWindows[si].effectiveNumberOfChannels) > 0.01) {
                this.m_errorVector.addElement("BaseBand " + bbn + ": SpectralWindows should have the same resolution at this moment. ");
                bValidSpectralWindow = false;
            }
            if (baseBand.spectralWindows[si].centerFrequencyMHz < 2000.0 || baseBand.spectralWindows[si].centerFrequencyMHz > 4000.0) {
                this.m_errorVector.addElement("BaseBand " + bbn + ": SpectralWindow : " + si1 + " centerFrequencyMHz " + baseBand.spectralWindows[si].centerFrequencyMHz + " is out of [2000, 4000] MHz range");
                bValidSpectralWindow = false;
            }
            if (baseBand.spectralWindows[si].centerFrequencyMHz - baseBand.spectralWindows[si].effectiveBandwidthMHz / 2.0 < 2000.0) {
                this.m_errorVector.addElement("BaseBand " + bbn + ": SpectralWindow : " + si1 + " centerFrequencyMHz " + baseBand.spectralWindows[si].centerFrequencyMHz + " bandwidthMHz " + baseBand.spectralWindows[si].effectiveBandwidthMHz + " extends below baseband beginning");
                bValidSpectralWindow = false;
            }
            if (baseBand.spectralWindows[si].centerFrequencyMHz + baseBand.spectralWindows[si].effectiveBandwidthMHz / 2.0 > 4000.0) {
                this.m_errorVector.addElement("BaseBand " + bbn + ": SpectralWindow : " + si1 + " centerFrequencyMHz " + baseBand.spectralWindows[si].centerFrequencyMHz + " bandwidthMHz " + baseBand.spectralWindows[si].effectiveBandwidthMHz + " extends above baseband beginning");
                bValidSpectralWindow = false;
            }
            if (baseBand.spectralWindows[si].effectiveBandwidthMHz < 50.0 || baseBand.spectralWindows[si].effectiveBandwidthMHz > 2000.0) {
                this.m_errorVector.addElement("BaseBand " + bbn + ": SpectralWindow : " + si1 + " effective bandwidth " + baseBand.spectralWindows[si].effectiveBandwidthMHz + " is out of [62.5, 2000] MHz range");
                bValidSpectralWindow = false;
            }
            if (baseBand.spectralWindows[si].effectiveNumberOfChannels < 32 || baseBand.spectralWindows[si].effectiveNumberOfChannels > 8192) {
                this.m_errorVector.addElement("BaseBand " + bbn + ": SpectralWindow : " + si1 + " effective number of channels " + baseBand.spectralWindows[si].effectiveNumberOfChannels + " is out of [32,8192] range");
                bValidSpectralWindow = false;
            }
            switch (baseBand.spectralWindows[si].spectralAveragingFactor) {
                case 1: 
                case 2: 
                case 4: 
                case 8: 
                case 16: {
                    break;
                }
                default: {
                    this.m_errorVector.addElement("Baseband " + bbn + ": SpectralWindow " + si1 + ": Input spectralAveragingFactor " + baseBand.spectralWindows[si].spectralAveragingFactor + ", Not a power of 2 or > 16");
                    bValidSpectralWindow = false;
                }
            }
            this.m_logger.info(" >>> Baseband " + bbn + ": SpectralWindow " + si1 + " effectiveNumberOfChannels " + baseBand.spectralWindows[si].effectiveNumberOfChannels + " spectralAveragingFactor " + baseBand.spectralWindows[si].spectralAveragingFactor);
            quotient = baseBand.spectralWindows[si].effectiveNumberOfChannels / baseBand.spectralWindows[si].spectralAveragingFactor;
            if (quotient * (long)baseBand.spectralWindows[si].spectralAveragingFactor != (long)baseBand.spectralWindows[si].effectiveNumberOfChannels) {
                this.m_errorVector.addElement("Baseband " + bbn + ": SpectralWindow " + si1 + " effectiveNumberOfChannels " + baseBand.spectralWindows[si].effectiveNumberOfChannels + " is not spectralAveragingFactor " + baseBand.spectralWindows[si].spectralAveragingFactor + " integer multiple ");
                bValidSpectralWindow = false;
            }
            if (!this.validateChannelAverageRegions(bbn, baseBand.spectralWindows[si], si, this.m_errorVector)) {
                bValidSpectralWindow = false;
            }
            if (baseBand.spectralWindows[si].polnProductsSeq.length != 1 && baseBand.spectralWindows[si].polnProductsSeq.length != 2 && baseBand.spectralWindows[si].polnProductsSeq.length != 4) {
                this.m_errorVector.addElement("BaseBand " + bbn + ": Spectral Window: " + si1 + " invalid number of polarization products defined: " + baseBand.spectralWindows[si].polnProductsSeq.length);
                bValidSpectralWindow = false;
            }
            for (int pIdx1 = 0; pIdx1 < baseBand.spectralWindows[si].polnProductsSeq.length; ++pIdx1) {
                for (int pIdx2 = pIdx1 + 1; pIdx2 < baseBand.spectralWindows[si].polnProductsSeq.length; ++pIdx2) {
                    if (baseBand.spectralWindows[si].polnProductsSeq[pIdx1] != baseBand.spectralWindows[si].polnProductsSeq[pIdx2]) continue;
                    this.m_errorVector.addElement("BaseBand " + bbn + ": Spectral Window: " + si1 + " has duplicated Stokes parameter at polnProducts indexes " + pIdx1 + " and " + pIdx2);
                    bValidSpectralWindow = false;
                }
            }
            if (baseBand.spectralWindows[si].sideBand != NetSideband.NOSB) continue;
            this.m_errorVector.addElement("BaseBand " + baseBand.basebandName.toString() + ": Spectral Window: " + si1 + " does not specify a sideband ");
            bValidSpectralWindow = false;
        }
        try {
            modeNumber = this.m_modesTable.findModeFromResolution((float)baseBand.spectralWindows[0].effectiveBandwidthMHz, (long)baseBand.spectralWindows[0].effectiveNumberOfChannels, baseBand.spectralWindows[0].correlationBits, baseBand.spectralWindows[0].correlationNyquistOversampling, baseBand.spectralWindows[0].polnProductsSeq, eFraction.FRACTION_FULL);
            try {
                m = this.m_modesTable.getMode(modeNumber);
            }
            catch (AcsJInvalidKeyEx ex) {
                this.m_errorVector.addElement("No mode exists for this Baseband " + bbn + " configuration  " + ex.toString());
                this.m_logger.info("No mode exists for this Baseband " + bbn + " configuration  " + ex.toString());
                return false;
            }
        }
        catch (AcsJInvalidModeEx ex) {
            this.m_errorVector.addElement("Can not find ConfigMode from this Baseband " + bbn + "  " + ex.toString());
            this.m_logger.info("Can not find ConfigMode from this Baseband " + bbn + "  " + ex.toString());
            Object polnProdsStr = new String();
            for (int i = 0; i < baseBand.spectralWindows[0].polnProductsSeq.length; ++i) {
                polnProdsStr = (String)polnProdsStr + JStokesParameter.toString((StokesParameter)baseBand.spectralWindows[0].polnProductsSeq[i]) + " ";
            }
            this.m_errorVector.addElement("BaseBand " + bbn + ": Spectral Window: : has invalid combination of:\nEffective BW: " + baseBand.spectralWindows[0].effectiveBandwidthMHz + " # channels: " + baseBand.spectralWindows[0].effectiveNumberOfChannels + " Correlation Bits: " + baseBand.spectralWindows[0].correlationBits + " Oversampling: " + baseBand.spectralWindows[0].correlationNyquistOversampling + " Poln Products: " + (String)polnProdsStr + "\nException: " + ex.toString());
            return false;
        }
        for (NetSideband sideBand : new NetSideband[]{NetSideband.LSB, NetSideband.USB}) {
            if (m.filterMode == eFilterMode.FILTER_FDM) {
                int nominalChannelsOnBaseband = 0;
                float configTotalEffectiveBandWidth = 0.0f;
                float effectiveBandWidthMode = 0.0f;
                for (int si2 = 0; si2 < baseBand.spectralWindows.length; ++si2) {
                    if (baseBand.spectralWindows[si2].sideBand != sideBand) continue;
                    if (baseBand.spectralWindows[si2].correlationBits != CorrelationBit.BITS_2x2 && baseBand.spectralWindows[si2].correlationBits != CorrelationBit.BITS_4x4) {
                        this.m_errorVector.addElement("BaseBand " + bbn + ": SpectralWindow : " + si2 + " correlationBits " + baseBand.spectralWindows[si2].correlationBits + " setting is wrong for FDM ");
                        bValidSpectralWindow = false;
                    }
                    if (Math.IEEEremainder(baseBand.spectralWindows[si2].centerFrequencyMHz, 0.030517578125) != 0.0) {
                        this.m_errorVector.addElement("BaseBand " + bbn + ": SpectralWindow : " + (si2 + 1) + " centerFrequencyMHz " + baseBand.spectralWindows[si2].centerFrequencyMHz + " is not an integer multiple of the TFB DDS step frequency (30.517578125 KHz) has remainder of " + Math.IEEEremainder(baseBand.spectralWindows[si2].centerFrequencyMHz, 0.030517578125) + " MHz");
                        bValidSpectralWindow = false;
                    }
                    try {
                        int subbandsInRegion = this.m_modesTable.getSubbandsInRegionBandwidth(modeNumber, (float)baseBand.spectralWindows[si2].effectiveBandwidthMHz, true);
                        int effectiveChannelsPerSubband = this.m_modesTable.getEffectiveChannelsPerSubband(modeNumber);
                        int nominalChannelsPerSubband = this.m_modesTable.getNominalChannelsPerSubband(modeNumber);
                        int effectiveChannelsPerRegion = subbandsInRegion * effectiveChannelsPerSubband;
                        int nominalChannelsPerRegion = subbandsInRegion * nominalChannelsPerSubband;
                        nominalChannelsOnBaseband += nominalChannelsPerRegion;
                        configTotalEffectiveBandWidth = (float)((double)configTotalEffectiveBandWidth + baseBand.spectralWindows[si2].effectiveBandwidthMHz);
                        effectiveBandWidthMode = this.m_modesTable.getEffectiveBandWidth(modeNumber);
                        this.m_logger.info("Baseband " + bbn + " has modeNumber " + modeNumber + ": SpectralWindow " + si2 + " has effectiveNumberOfChannels " + baseBand.spectralWindows[si2].effectiveNumberOfChannels + " effectiveBandwidthMHz " + baseBand.spectralWindows[si2].effectiveBandwidthMHz + " # of subbands " + subbandsInRegion + " effectiveChannelsPerRegion " + effectiveChannelsPerRegion);
                        if (effectiveChannelsPerRegion <= baseBand.spectralWindows[si2].effectiveNumberOfChannels) continue;
                        this.m_errorVector.addElement("BaseBand " + bbn + ": SpectralWindow : " + si2 + ": total subband effective channels more than allowed ");
                        bValidSpectralWindow = false;
                        continue;
                    }
                    catch (AcsJInvalidKeyEx invalidKeyEx) {
                        this.m_logger.info("Baseband " + bbn + ": SpectralWindow " + si2 + invalidKeyEx.toString());
                        this.m_errorVector.addElement("Baseband " + bbn + ": SpectralWindow " + si2 + invalidKeyEx.toString());
                        bValidSpectralWindow = false;
                        continue;
                    }
                    catch (AcsJModeInconsistencyEx ex) {
                        this.m_logger.info("Baseband " + bbn + ": SpectralWindow " + si2 + ex.toString());
                        this.m_errorVector.addElement("Baseband " + bbn + ": SpectralWindow " + si2 + " : " + ex.toString());
                        bValidSpectralWindow = false;
                    }
                }
                this.m_logger.info("Baseband " + bbn + " mode effective band width: " + effectiveBandWidthMode + " config total effective band width " + configTotalEffectiveBandWidth);
                if (configTotalEffectiveBandWidth > effectiveBandWidthMode) {
                    this.m_errorVector.addElement("BaseBand " + bbn + ": configured total effectiveBandWidth over bound ");
                    bValidSpectralWindow = false;
                }
                if (nominalChannelsOnBaseband <= m.channels) continue;
                String errStr = String.format("BaseBand " + bbn + " " + sideBand + " configured total channels is %d , over the limit %d ", nominalChannelsOnBaseband, m.channels);
                this.m_errorVector.addElement(errStr);
                bValidSpectralWindow = false;
                continue;
            }
            int configedChannels = 0;
            int configedBandwidth = 0;
            for (int si3 = 0; si3 < baseBand.spectralWindows.length; ++si3) {
                if (baseBand.spectralWindows[si3].sideBand != sideBand) continue;
                if (baseBand.spectralWindows[si3].correlationBits != CorrelationBit.BITS_2x2) {
                    this.m_errorVector.addElement("BaseBand " + bbn + ": SpectralWindow : " + si3 + " correlationBits " + baseBand.spectralWindows[si3].correlationBits + " setting is wrong for TDM ");
                    bValidSpectralWindow = false;
                }
                configedChannels += baseBand.spectralWindows[si3].effectiveNumberOfChannels;
                configedBandwidth = (int)((double)configedBandwidth + baseBand.spectralWindows[si3].effectiveBandwidthMHz);
            }
            this.m_logger.info(" >>> This TDM mode on Baseband " + bbn + " configured total Number Of Channels is " + configedChannels + ", allowed channels is " + m.channels);
            if (configedChannels > m.channels) {
                this.m_errorVector.addElement(" >>> This TDM mode on Baseband " + bbn + " configured total Number Of Channels is " + configedChannels + ", allowed channels is " + m.channels);
                bValidSpectralWindow = false;
            }
            this.m_logger.info(" >>> This TDM mode on Baseband " + bbn + " configured total band width is " + configedBandwidth + ", allowed band width is " + m.bandWidth);
            if (!((float)configedBandwidth > m.bandWidth)) continue;
            this.m_errorVector.addElement(" >>> This TDM mode on Baseband " + bbn + " configured total band width is " + configedBandwidth + ", allowed band width is " + m.bandWidth);
            bValidSpectralWindow = false;
        }
        return bValidSpectralWindow;
    }

    private boolean validateChannelAverageRegions(String basebandName, SpectralWindow specWindow, int specWindowIdx, Vector m_errorVector) {
        boolean bValidChanAverRegion = true;
        if (specWindow.channelAverageRegions.length > 32) {
            m_errorVector.addElement("BaseBand " + basebandName + ": Input ChannelAverageRegions " + specWindow.channelAverageRegions.length + ", is out of [0,31] Regions !");
            bValidChanAverRegion = false;
        } else {
            this.m_totalChanAverRegionsPerBaseband += specWindow.channelAverageRegions.length;
            for (int carIdx = 0; carIdx < specWindow.channelAverageRegions.length; ++carIdx) {
                int stopChannel;
                if (specWindow.channelAverageRegions[carIdx].startChannel < 0 || specWindow.channelAverageRegions[carIdx].startChannel >= specWindow.effectiveNumberOfChannels - 1) {
                    m_errorVector.addElement("BaseBand " + basebandName + ": ChannelAverageRegion " + carIdx + "1 starting channel invalid: " + specWindow.channelAverageRegions[carIdx].startChannel);
                    bValidChanAverRegion = false;
                }
                if ((stopChannel = specWindow.channelAverageRegions[carIdx].startChannel + specWindow.channelAverageRegions[carIdx].numberChannels) > specWindow.effectiveNumberOfChannels) {
                    m_errorVector.addElement("BaseBand " + basebandName + ": ChannelAverageRegion " + carIdx + "1: last channel " + stopChannel + " extends beyond last channel of spectral window " + specWindow.effectiveNumberOfChannels);
                    bValidChanAverRegion = false;
                }
                if (specWindow.channelAverageRegions[carIdx].numberChannels >= 1) continue;
                m_errorVector.addElement("BaseBand " + basebandName + ": ChannelAverageRegion " + carIdx + "1: number of channels invalid: " + specWindow.channelAverageRegions[carIdx].numberChannels);
                bValidChanAverRegion = false;
            }
        }
        if (this.m_totalChanAverRegionsPerBaseband == 0) {
            m_errorVector.addElement("BaseBand " + basebandName.toString() + " has no channel average regions");
            bValidChanAverRegion = false;
        }
        return bValidChanAverRegion;
    }

    private boolean validateCamAndDataProduct(BaseBandConfig baseBand, boolean isSingleAntenna) {
        boolean bValidCamAndDataProduct = true;
        if (baseBand.dataProducts == CorrelationMode.CROSS_ONLY) {
            this.m_errorVector.addElement("BaseBand " + baseBand.basebandName + " Data product choice: CROSS_ONLY not allowed");
            bValidCamAndDataProduct = false;
        } else if (baseBand.dataProducts == CorrelationMode.CROSS_AND_AUTO && baseBand.CAM == AccumMode.FAST) {
            this.m_errorVector.addElement("BaseBand " + baseBand.basebandName.toString() + ": data products " + baseBand.dataProducts.toString() + " incompatible with accumulation mode " + baseBand.CAM.toString());
            bValidCamAndDataProduct = false;
        }
        if (baseBand.CAM == AccumMode.FAST && this.m_dumpDuration != 10000L) {
            this.m_errorVector.addElement("BaseBand " + baseBand.basebandName.toString() + ": Input dump duration " + this.m_dumpDuration + ", For the CAM = 'FAST', must be 1 ms");
            bValidCamAndDataProduct = false;
        }
        if (baseBand.CAM == AccumMode.NORMAL && this.m_dumpDuration % 160000L != 0L) {
            this.m_errorVector.addElement("BaseBand " + baseBand.basebandName.toString() + ": Input dump duration " + this.m_dumpDuration + ", For the CAM = 'NORMAL', must be a multiple of 16 ms");
            bValidCamAndDataProduct = false;
        }
        if (baseBand.dataProducts == CorrelationMode.CROSS_AND_AUTO && isSingleAntenna) {
            this.m_errorVector.addElement("BaseBand " + baseBand.basebandName.toString() + ", For dataProducts = CROSS_AND_AUTO, number of antennas in array must be > 1");
            bValidCamAndDataProduct = false;
        }
        if (baseBand.sideBandSeparationMode == SidebandProcessingMode.PHASE_SWITCH_SEPARATION && this.m_dumpDuration % 20480000L != 0L) {
            this.m_errorVector.addElement("BaseBand " + baseBand.basebandName.toString() + ": Sideband separation mode " + JSidebandProcessingMode.toString((SidebandProcessingMode)baseBand.sideBandSeparationMode) + " : Input dump duration " + (double)this.m_dumpDuration * 1.0E-7 + " sec(s), is Not an integral multiple of 2.048 secs ");
            bValidCamAndDataProduct = false;
        }
        return bValidCamAndDataProduct;
    }

    private boolean checkBaseBandDataRate(CorrelatorConfiguration corrConfig, int numOfAntennas) {
        for (int bbj = 0; bbj < corrConfig.baseBands.length; ++bbj) {
            if (this.validateBasebandDataRate(corrConfig.baseBands[bbj], numOfAntennas)) continue;
            return false;
        }
        return true;
    }

    private boolean validateBasebandDataRate(BaseBandConfig baseBand, int numOfAntennas) {
        int numBins = 1;
        boolean isHWBasebandDataRateOK = true;
        double bbDataRate = 0.0;
        int lagsOnThisBB = this.getLagsFromConfigParameters(baseBand);
        if (lagsOnThisBB == 0) {
            this.m_errorVector.addElement(" Cannot get lags value from this config ");
            return false;
        }
        String strNumLags = String.format(" Lags on this baseband %s  is %d ", baseBand.basebandName.toString(), lagsOnThisBB);
        this.m_logger.info(strNumLags);
        double dumpDurationInSec = (double)this.m_dumpDuration * 1.0E-7;
        int numOfAntennasForCompute = 0;
        int numAntennaIntersections = 0;
        numOfAntennasForCompute = numOfAntennas <= 32 ? numOfAntennas : 32;
        if (baseBand.CAM == AccumMode.FAST || baseBand.dataProducts == CorrelationMode.AUTO_ONLY) {
            numAntennaIntersections = numOfAntennasForCompute;
        } else {
            numAntennaIntersections = numOfAntennasForCompute * numOfAntennasForCompute;
            if (baseBand.sideBandSeparationMode == SidebandProcessingMode.PHASE_SWITCH_SEPARATION) {
                numBins = 3;
            }
        }
        bbDataRate = (double)(numBins * numAntennaIntersections * lagsOnThisBB * 4) / dumpDurationInSec;
        String strdr = String.format(" >>> Data rate on this Node (baseband) %s  is %8.3f MB/s with dumpDuration %10.3f ms", baseBand.basebandName.toString(), bbDataRate /= 1048576.0, (double)this.m_dumpDuration * 1.0E-4);
        this.m_logger.info(strdr);
        if (bbDataRate > 62.5) {
            strdr = String.format(" >>> Data rate on this Node (baseband) %s  is %8.3f MB/s, exceeds 62.5MB/s", baseBand.basebandName.toString(), bbDataRate);
            this.m_logger.info(strdr);
            this.m_errorVector.addElement(strdr);
            isHWBasebandDataRateOK = false;
        }
        return isHWBasebandDataRateOK;
    }

    private int getLagsFromConfigParameters(BaseBandConfig baseBand) {
        ConfigMode m = null;
        int modeNumber = 0;
        try {
            modeNumber = this.m_modesTable.findModeFromResolution((float)baseBand.spectralWindows[0].effectiveBandwidthMHz, (long)baseBand.spectralWindows[0].effectiveNumberOfChannels, baseBand.spectralWindows[0].correlationBits, baseBand.spectralWindows[0].correlationNyquistOversampling, baseBand.spectralWindows[0].polnProductsSeq, eFraction.FRACTION_FULL);
        }
        catch (AcsJInvalidModeEx ex) {
            this.m_errorVector.addElement("Can not find ConfigMode from this Baseband " + baseBand.basebandName.toString() + "  " + ex.toString());
            this.m_logger.info("Can not find ConfigMode from this Baseband " + baseBand.basebandName.toString() + "  " + ex.toString());
            return 0;
        }
        try {
            m = this.m_modesTable.getMode(modeNumber);
        }
        catch (AcsJInvalidKeyEx ex) {
            String errStr = String.format("Can not get Mode from this key %d", modeNumber + " caused by " + ex.toString());
            this.m_errorVector.addElement(errStr);
            this.m_logger.info(errStr);
            return 0;
        }
        int lags = 0;
        if (m.filterMode == eFilterMode.FILTER_FDM) {
            if (m.bits == CorrelationBit.BITS_2x2 && !m.overSampled) {
                lags = 8192;
            } else if (m.bits == CorrelationBit.BITS_2x2 && m.overSampled) {
                lags = (double)m.bandWidth == 31.25 ? 8192 : 4096;
            } else if (m.bits == CorrelationBit.BITS_4x4 && !m.overSampled) {
                lags = 2048;
            } else if (m.bits == CorrelationBit.BITS_4x4 && m.overSampled) {
                lags = (double)m.bandWidth == 31.25 ? 2048 : 1024;
            } else {
                this.m_logger.info("No correlator FDM mode exists with this configuration.");
                lags = 0;
            }
        } else if (m.filterMode == eFilterMode.FILTER_TDM) {
            if (m.bits == CorrelationBit.BITS_2x2) {
                lags = 256;
            } else if (m.bits == CorrelationBit.BITS_3x3) {
                lags = 64;
            } else {
                this.m_logger.info("No correlator TDM mode exists with this configuration.");
                lags = 0;
            }
        } else {
            this.m_logger.info("Config mode is null.");
            lags = 0;
        }
        return lags;
    }

    private boolean checkConfigDataRate(CorrelatorConfiguration corrConfig, int numOfAntennas) {
        Map<BasebandName, CorrConfigValidatorBase.BaseBandDataRate> dataRateMap = this.calculateTotalDataRateForConfig(corrConfig, numOfAntennas);
        double sum = 0.0;
        for (CorrConfigValidatorBase.BaseBandDataRate bbDataRate : dataRateMap.values()) {
            sum += bbDataRate.ancillary;
            for (double dr : bbDataRate.spectralWindow) {
                sum += dr;
            }
        }
        double configDataRateMB = sum;
        String str = String.format(" >>> Data rate to Archive is : %8.3f MB/s ", configDataRateMB);
        this.m_logger.info(str);
        if (configDataRateMB > 70.0) {
            String errstr = String.format("Correlator configuration Data Rate %8.3f MB/s exceeds 70.0 MB/s: with # of Antennas ", configDataRateMB, numOfAntennas);
            this.m_errorVector.addElement(errstr);
            return false;
        }
        return true;
    }

    private void copyErrorStrings(stringSeqHolder errorStringSeq) {
        int numErrors = this.m_errorVector.size();
        if (numErrors == 0) {
            String[] retSeqString = new String[]{};
            errorStringSeq.value = retSeqString;
            return;
        }
        String[] retSeqString = new String[numErrors + 1];
        Iterator iter = this.m_errorVector.iterator();
        int i = 0;
        retSeqString[i++] = new String("Errors found in configuration for Correlator type: ") + this.m_correlatorType + new String(":");
        while (iter.hasNext()) {
            Object obj = iter.next();
            retSeqString[i++] = obj.toString().replaceAll("The following exception occured while validating field:", " ");
        }
        errorStringSeq.value = retSeqString;
    }

    private void setCorrelatorLimits() {
        String coorType = " >> Correlator type is " + this.m_correlatorType;
        this.m_logger.info(coorType);
        this.m_sideBandProcessingModesAllowed = new Vector();
        this.m_sideBandProcessingModesAllowed.addElement(SidebandProcessingMode.NONE);
        this.m_sideBandProcessingModesAllowed.addElement(SidebandProcessingMode.PHASE_SWITCH_SEPARATION);
        this.m_sideBandProcessingModesAllowed.addElement(SidebandProcessingMode.FREQUENCY_OFFSET_REJECTION);
        this.m_maxNumSpectralWindowsPerBaseband = 32;
        if (this.m_correlatorType.equals("CORRELATOR_12m_1QUADRANT")) {
            this.m_maxNumAntennas = 16;
            this.m_maxNumBasebands = 4;
            this.m_maxNumChanAverRegions = 32;
            this.m_maxNumAPCDatasets = 2;
        } else if (this.m_correlatorType.equals("CORRELATOR_12m_2QUADRANT")) {
            this.m_maxNumAntennas = 32;
            this.m_maxNumBasebands = 4;
            this.m_maxNumChanAverRegions = 32;
            this.m_maxNumAPCDatasets = 2;
        } else if (this.m_correlatorType.equals("CORRELATOR_12m_4QUADRANT")) {
            this.m_maxNumAntennas = 64;
            this.m_maxNumBasebands = 4;
            this.m_maxNumChanAverRegions = 32;
            this.m_maxNumAPCDatasets = 2;
        } else {
            this.m_maxNumAntennas = 2;
            this.m_maxNumBasebands = 2;
            this.m_maxNumChanAverRegions = 32;
            this.m_maxNumAPCDatasets = 2;
        }
    }
}

