/*
 * Decompiled with CFR 0.152.
 */
package alma.Control.LOSolutions;

import alma.Control.LOSolutions.SB;
import alma.ReceiverBandMod.ReceiverBand;
import java.util.ArrayList;
import java.util.List;

public enum Band {
    Band1(ReceiverBand.ALMA_RB_01, 35.0, 50.0, SB.USB, 4.0, 12.0, 1, 1, 31.0, 38.0),
    Band2(ReceiverBand.ALMA_RB_02, 67.0, 116.0, SB.SB2, 4.0, 12.0, 4, 1, 79.0, 104.0),
    Band3(ReceiverBand.ALMA_RB_03, 84.0, 116.0, SB.SB2, 4.0, 8.0, 6, 1, 92.0, 108.0),
    Band4(ReceiverBand.ALMA_RB_04, 125.0, 163.0, SB.SB2, 4.0, 8.0, 3, 2, 66.5, 77.5),
    Band5(ReceiverBand.ALMA_RB_05, 158.0, 211.0, SB.SB2, 4.0, 8.0, 6, 2, 83.0, 101.5),
    Band6(ReceiverBand.ALMA_RB_06, 211.0, 275.0, SB.SB2, 4.5, 10.0, 6, 3, 73.6, 88.4),
    Band7(ReceiverBand.ALMA_RB_07, 275.0, 373.0, SB.SB2, 4.0, 8.0, 6, 3, 94.3, 121.66666666666667),
    Band8(ReceiverBand.ALMA_RB_08, 385.0, 500.0, SB.SB2, 4.0, 8.0, 3, 6, 65.5, 82.0),
    Band9(ReceiverBand.ALMA_RB_09, 602.0, 720.0, SB.DSB, 4.0, 12.0, 3, 9, 67.8, 79.1),
    Band10(ReceiverBand.ALMA_RB_10, 787.0, 950.0, SB.DSB, 4.0, 12.0, 6, 9, 83.3, 104.7);

    private final ReceiverBand receiverBand;
    private final double bandLowFreq;
    private final double bandHighFreq;
    private final SB sb;
    private final double IFlowFreq;
    private final double IFhighFreq;
    private final short warmMultiplier;
    private final short coldMultiplier;
    private final double lodriverLowFreq;
    private final double lodriverHighFreq;

    private Band(ReceiverBand receiverBand, double bandLowFreq, double bandHighFreq, SB sb, double IFlowFreq, double IFhighFreq, int warmMultiplier, int coldMultiplier, double lodriverLowFreq, double lodriverHighFreq) {
        this.receiverBand = receiverBand;
        this.bandLowFreq = bandLowFreq * 1.0E9;
        this.bandHighFreq = bandHighFreq * 1.0E9;
        this.sb = sb;
        this.IFlowFreq = IFlowFreq * 1.0E9;
        this.IFhighFreq = IFhighFreq * 1.0E9;
        this.warmMultiplier = (short)warmMultiplier;
        this.coldMultiplier = (short)coldMultiplier;
        this.lodriverLowFreq = lodriverLowFreq * 1.0E9;
        this.lodriverHighFreq = lodriverHighFreq * 1.0E9;
    }

    static Band band(ReceiverBand receiverBand) throws Exception {
        for (Band b : Band.values()) {
            if (b.receiverBand() != receiverBand) continue;
            return b;
        }
        String msg = "The " + receiverBand + " band is not part of the ALMA front-end.";
        throw new Exception(msg);
    }

    ReceiverBand receiverBand() {
        return this.receiverBand;
    }

    short warmMultiplier() {
        return this.warmMultiplier;
    }

    short coldMultiplier() {
        return this.coldMultiplier;
    }

    double bandLowFreq() {
        return this.bandLowFreq;
    }

    double bandHighFreq() {
        return this.bandHighFreq;
    }

    double IFlowFreq() {
        return this.IFlowFreq;
    }

    double IFhighFreq() {
        return this.IFhighFreq;
    }

    double lodriverLowFreq() {
        return this.lodriverLowFreq;
    }

    double lodriverHighFreq() {
        return this.lodriverHighFreq;
    }

    double lo1HighFreq() {
        return (double)this.coldMultiplier * this.lodriverHighFreq;
    }

    double lo1LowFreq() {
        return (double)this.coldMultiplier * this.lodriverLowFreq;
    }

    SB sb() {
        return this.sb;
    }

    static String bandHardwareParameterString(Band band, double lowFreq, double highFreq, SB sideband, double IFlowFreq, double IFhighFreq, short warmMultiplier, short coldMultiplier, double lodriverLowFreq, double lodriverHighFreq, boolean extended) {
        String fmt = "%-6s %5.1f %5.1f %3s %3.1f %4.1f %3d %4d  %4.1f %5.1f";
        String s = String.format(fmt, new Object[]{band, lowFreq * 1.0E-9, highFreq * 1.0E-9, sideband, IFlowFreq * 1.0E-9, IFhighFreq * 1.0E-9, warmMultiplier, coldMultiplier, lodriverLowFreq * 1.0E-9, lodriverHighFreq * 1.0E-9});
        if (extended) {
            fmt = "%s %5.1f %5.1f ";
            double IFoff = IFhighFreq;
            if (sideband == SB.USB) {
                IFoff = -IFlowFreq;
            }
            double lorangeLow = (lowFreq + IFoff) / (double)coldMultiplier;
            IFoff = -IFhighFreq;
            if (sideband == SB.LSB) {
                IFoff = IFlowFreq;
            }
            double lorangeHigh = (highFreq + IFoff) / (double)coldMultiplier;
            s = String.format(fmt, s, lorangeLow * 1.0E-9, lorangeHigh * 1.0E-9);
        }
        return s + "\n";
    }

    static String hardwareParameterString(boolean extended) {
        Object s = Band.headerString(extended);
        for (Band b : Band.values()) {
            s = (String)s + Band.bandHardwareParameterString(b, b.bandLowFreq(), b.bandHighFreq(), b.sb(), b.IFlowFreq(), b.IFhighFreq(), b.warmMultiplier(), b.coldMultiplier(), b.lodriverLowFreq(), b.lodriverHighFreq(), extended);
        }
        return s;
    }

    static String hardwareParameterString() {
        return Band.hardwareParameterString(false);
    }

    static String dump(Band band) {
        return Band.bandHardwareParameterString(band, band.bandLowFreq(), band.bandHighFreq(), band.sb(), band.IFlowFreq(), band.IFhighFreq(), band.warmMultiplier(), band.coldMultiplier(), band.lodriverLowFreq(), band.lodriverHighFreq(), false);
    }

    static String systemDescriptionString() {
        return "Hardware parameters for ALMA\n";
    }

    static String headerString(boolean extended) {
        Object s = Band.systemDescriptionString();
        s = (String)s + Band.columnHeadings(extended);
        return s;
    }

    static String columnHeadings(boolean extended) {
        Object s = "";
        s = (String)s + " Band     BandFreq  SB  IFfreq    Mult     LOdriver";
        if (extended) {
            s = (String)s + "   RxLOrange";
        }
        s = (String)s + "\n";
        s = (String)s + "         low  high     low high warm cold  low  high";
        if (extended) {
            s = (String)s + "   low  high";
        }
        s = (String)s + "\n";
        return s;
    }

    static String headerString() {
        return Band.headerString(false);
    }

    static String dumpAll() {
        Object s = Band.systemDescriptionString();
        s = (String)s + Band.columnHeadings(false);
        for (Band b : Band.values()) {
            s = (String)s + Band.dump(b);
        }
        return s;
    }

    public static List<ReceiverBand> frequencyToBand(double frequency) {
        ArrayList<ReceiverBand> bands = new ArrayList<ReceiverBand>();
        for (Band b : Band.values()) {
            if (!(frequency <= b.bandHighFreq()) || !(frequency >= b.bandLowFreq())) continue;
            bands.add(b.receiverBand);
        }
        return bands;
    }
}

