/*
 * Decompiled with CFR 0.152.
 */
package alma.alarmsystem.source;

import alma.JavaContainerError.wrappers.AcsJContainerServicesEx;
import alma.acs.alarmsystem.source.AlarmSource;
import alma.acs.alarmsystem.source.AlarmSourceFactory;
import alma.acs.container.ContainerServicesBase;
import alma.acs.logging.AcsLogLevel;
import alma.acsErrTypeAlarmSourceFactory.ACSASFactoryNotInitedEx;
import alma.acsErrTypeAlarmSourceFactory.FaultStateCreationErrorEx;
import alma.acsErrTypeAlarmSourceFactory.SourceCreationErrorEx;
import alma.acsErrTypeAlarmSourceFactory.wrappers.AcsJACSASFactoryNotInitedEx;
import alma.acsErrTypeAlarmSourceFactory.wrappers.AcsJFaultStateCreationErrorEx;
import alma.acsErrTypeAlarmSourceFactory.wrappers.AcsJSourceCreationErrorEx;
import alma.alarmsystem.source.ACSAlarmSystemInterface;
import alma.alarmsystem.source.ACSAlarmSystemInterfaceProxy;
import alma.alarmsystem.source.ACSFaultState;
import alma.alarmsystem.source.ACSFaultStateImpl;
import com.cosylab.CDB.DAL;
import java.io.StringReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class ACSAlarmSystemInterfaceFactory {
    private static final String CONFIGURATION_PATH = "Alarms/Administrative/AlarmSystemConfiguration";
    private static Boolean useACSAlarmSystem = null;
    private static ACSAlarmSystemInterface source = null;
    private static Logger logger = null;
    private static ContainerServicesBase containerServices;
    private static AlarmSourceFactory alarmSourceFactory;

    public static void init(ContainerServicesBase containerServices) throws AcsJContainerServicesEx {
        if (containerServices == null) {
            throw new AcsJContainerServicesEx((Throwable)new Exception("Invalid null ContainerServicesBase"));
        }
        ACSAlarmSystemInterfaceFactory.containerServices = containerServices;
        logger = containerServices.getLogger();
        DAL dal = containerServices.getCDB();
        if (logger == null || dal == null) {
            throw new IllegalArgumentException("Invalid DAL or Logger from ContainerServicesBase");
        }
        alarmSourceFactory = new AlarmSourceFactory(containerServices);
        useACSAlarmSystem = ACSAlarmSystemInterfaceFactory.retrieveImplementationType(dal);
        if (logger != null) {
            if (useACSAlarmSystem.booleanValue()) {
                logger.log((Level)AcsLogLevel.DEBUG, "Alarm system type: ACS");
            } else {
                logger.log((Level)AcsLogLevel.DEBUG, "Alarm system type: CERN");
                try {
                    ACSAlarmSystemInterfaceFactory.initCmwMom();
                }
                catch (Throwable t) {
                    throw new AcsJContainerServicesEx((Throwable)new Exception("Error initing cmw-mom", t));
                }
            }
        }
    }

    private static void initCmwMom() throws Exception {
        if (containerServices == null) {
            throw new IllegalStateException("Trying to init cmw-mom with null ContainerServicesBase");
        }
        try {
            Thread t = Thread.currentThread();
            ClassLoader loader = t.getContextClassLoader();
            Class<?> cl = loader.loadClass("cern.cmw.mom.pubsub.impl.ACSJMSTopicConnectionImpl");
            Field var = cl.getField("containerServices");
            var.set(null, containerServices);
            logger.log((Level)AcsLogLevel.DEBUG, "cmw-mom/acs-jms initialized");
        }
        catch (Throwable t) {
            throw new Exception("Error setting ContainerServices into cmw-mom", t);
        }
    }

    public static void done() {
        if (containerServices == null) {
            throw new IllegalStateException("Trying close with null ContainerServicesBase");
        }
        alarmSourceFactory.tearDown();
        if (useACSAlarmSystem != null) {
            if (source != null) {
                source.close();
                source = null;
            }
            useACSAlarmSystem = null;
        }
    }

    private static boolean retrieveImplementationType(DAL dal) {
        String dao;
        if (dal == null) {
            return true;
        }
        try {
            dao = dal.get_DAO(CONFIGURATION_PATH);
        }
        catch (Exception e) {
            return true;
        }
        String implementation = ACSAlarmSystemInterfaceFactory.getProperty(dao, "Implementation");
        return implementation == null || !implementation.equals("CERN");
    }

    private static String getProperty(String dao, String propName) {
        Document doc;
        if (dao == null || propName == null) {
            return null;
        }
        DocumentBuilder builder = null;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            builder = factory.newDocumentBuilder();
        }
        catch (Exception e) {
            System.out.println("Error instantiating the document builder");
            System.out.println(e.getMessage());
            e.printStackTrace();
            return null;
        }
        try {
            doc = builder.parse(new InputSource(new StringReader(dao)));
        }
        catch (Exception e) {
            System.out.println("Error parsing the DAO: [" + dao + "]");
            System.out.println(e.getMessage());
            e.printStackTrace();
            return null;
        }
        NodeList propNodeList = doc.getElementsByTagName("configuration-property");
        String val = null;
        for (int t = 0; t < propNodeList.getLength(); ++t) {
            String nameNode;
            Node attrNodeName;
            Node node = propNodeList.item(t);
            NamedNodeMap attributes = node.getAttributes();
            if (attributes == null || (attrNodeName = attributes.getNamedItem("name")) == null || (nameNode = attrNodeName.getNodeValue()) == null || !nameNode.equals(propName)) continue;
            Node child = node.getFirstChild();
            val = child.getNodeValue();
            break;
        }
        return val;
    }

    public static synchronized ACSAlarmSystemInterface createSource(String sourceName) throws ACSASFactoryNotInitedEx, SourceCreationErrorEx {
        if (useACSAlarmSystem == null) {
            IllegalStateException e = new IllegalStateException("Factory not initialised");
            throw new AcsJACSASFactoryNotInitedEx((Throwable)e).toACSASFactoryNotInitedEx();
        }
        if (useACSAlarmSystem.booleanValue()) {
            return new ACSAlarmSystemInterfaceProxy(sourceName, logger);
        }
        if (source != null) {
            return source;
        }
        try {
            Thread t = Thread.currentThread();
            ClassLoader loader = t.getContextClassLoader();
            Class<?> cl = loader.loadClass("alma.acs.alarmsystem.binding.ACSLaserSource");
            Class[] classes = new Class[]{String.class, Logger.class};
            Constructor<?> constructor = cl.getConstructor(classes);
            source = (ACSAlarmSystemInterface)constructor.newInstance(sourceName, logger);
            return source;
        }
        catch (Throwable t) {
            System.out.println("ERROR: " + t.getMessage());
            t.printStackTrace();
            throw new AcsJSourceCreationErrorEx(t).toSourceCreationErrorEx();
        }
    }

    public static ACSAlarmSystemInterface createSource() throws ACSASFactoryNotInitedEx, SourceCreationErrorEx {
        return ACSAlarmSystemInterfaceFactory.createSource("UNDEFINED");
    }

    public static synchronized ACSFaultState createFaultState() throws ACSASFactoryNotInitedEx, FaultStateCreationErrorEx {
        if (useACSAlarmSystem == null) {
            IllegalStateException e = new IllegalStateException("Factory not initialised");
            throw new AcsJACSASFactoryNotInitedEx((Throwable)e).toACSASFactoryNotInitedEx();
        }
        if (useACSAlarmSystem.booleanValue()) {
            return new ACSFaultStateImpl();
        }
        try {
            Thread t = Thread.currentThread();
            ClassLoader loader = t.getContextClassLoader();
            Class<?> cl = loader.loadClass("alma.acs.alarmsystem.binding.ACSLaserFaultStateImpl");
            Class[] classes = new Class[]{};
            Constructor<?> constructor = cl.getConstructor(classes);
            return (ACSFaultState)constructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new AcsJFaultStateCreationErrorEx((Throwable)e).toFaultStateCreationErrorEx();
        }
    }

    public static ACSFaultState createFaultState(String family, String member, int code) throws ACSASFactoryNotInitedEx, FaultStateCreationErrorEx {
        ACSFaultState state = ACSAlarmSystemInterfaceFactory.createFaultState();
        state.setFamily(family);
        state.setMember(member);
        state.setCode(code);
        return state;
    }

    public static boolean usingACSAlarmSystem() throws ACSASFactoryNotInitedEx {
        if (useACSAlarmSystem == null) {
            IllegalStateException e = new IllegalStateException("Factory not initialised");
            throw new AcsJACSASFactoryNotInitedEx((Throwable)e).toACSASFactoryNotInitedEx();
        }
        return useACSAlarmSystem;
    }

    public static AlarmSource getAlarmSource(ContainerServicesBase contSvcs) {
        return alarmSourceFactory.getAlarmSource(contSvcs);
    }

    public static void releaseAlarmSource(ContainerServicesBase contSvcs) {
        alarmSourceFactory.releaseAlarmSource(contSvcs);
    }
}

