/*
 * Decompiled with CFR 0.152.
 */
package alma.sourcecat.dao;

import alma.sourcecat.dao.SearchParameters;
import alma.sourcecat.model.Measurement;
import alma.sourcecat.model.Range;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class XmlRpcNullConverter {
    private static final Log LOG = LogFactory.getLog(XmlRpcNullConverter.class);
    public static final Double ENCODED_NULL = Double.MAX_VALUE;
    public static final Integer ENCODED_NULL_INTEGER = Integer.MAX_VALUE;
    private static final String ENCODED_NULL_STRING = new String("1.7976931348623157E308");
    private static final double FLOAT_TOLERANCE = 1.0E-10;
    public static final Double NO_VALUE = -500.0;

    public static final Range encode(Range range) {
        range.setfMin(XmlRpcNullConverter.encode(range.getfMin()));
        range.setfMax(XmlRpcNullConverter.encode(range.getfMax()));
        return range;
    }

    public static final String encode(String value) {
        String encodedValue = value;
        if (value == null) {
            encodedValue = ENCODED_NULL_STRING;
        }
        return encodedValue;
    }

    public static final Double encode(Double value) {
        Double encodedValue = value;
        if (value == null) {
            encodedValue = ENCODED_NULL;
        }
        return encodedValue;
    }

    public static final Double decode(Double value) {
        Double encodedValue = null;
        if (value != null && value < ENCODED_NULL - 1.0E-10) {
            encodedValue = value;
        }
        return encodedValue;
    }

    public static final String decode(String value) {
        String encodedValue = value;
        if (value == null || value.trim().isEmpty() || ENCODED_NULL_STRING.equals(value)) {
            encodedValue = null;
        }
        return encodedValue;
    }

    public static final List<Measurement> encodeMeasurements(List<Measurement> measurements) {
        for (Measurement m : measurements) {
            XmlRpcNullConverter.encode(m);
        }
        return measurements;
    }

    public static final List<Measurement> decodeMeasurements(List<Measurement> measurements) {
        for (Measurement m : measurements) {
            XmlRpcNullConverter.decode(m);
        }
        return measurements;
    }

    public static final List<Range> encodeRanges(List<Range> ranges) {
        for (Range r : ranges) {
            XmlRpcNullConverter.encode(r);
        }
        return ranges;
    }

    public static final Measurement encode(Measurement measurement) {
        measurement.setRaUncertainty(XmlRpcNullConverter.encode(measurement.getRaUncertainty()));
        measurement.setDecUncertainty(XmlRpcNullConverter.encode(measurement.getDecUncertainty()));
        measurement.setFluxUncertainty(XmlRpcNullConverter.encode(measurement.getFluxUncertainty()));
        measurement.setDegree(XmlRpcNullConverter.encode(measurement.getDegree()));
        measurement.setDegreeUncertainty(XmlRpcNullConverter.encode(measurement.getDegreeUncertainty()));
        measurement.setAngle(XmlRpcNullConverter.encode(measurement.getAngle()));
        measurement.setAngleUncertainty(XmlRpcNullConverter.encode(measurement.getAngleUncertainty()));
        measurement.setOrigin(XmlRpcNullConverter.encode(measurement.getOrigin()));
        measurement.setUvMin(XmlRpcNullConverter.encode(measurement.getUvMin()));
        measurement.setUvMax(XmlRpcNullConverter.encode(measurement.getUvMax()));
        return measurement;
    }

    public static final Measurement decode(Measurement measurement) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"-> decode");
        }
        measurement.setRaUncertainty(XmlRpcNullConverter.decode(measurement.getRaUncertainty()));
        measurement.setDecUncertainty(XmlRpcNullConverter.decode(measurement.getDecUncertainty()));
        measurement.setFluxUncertainty(XmlRpcNullConverter.decode(measurement.getFluxUncertainty()));
        measurement.setDegree(XmlRpcNullConverter.decode(measurement.getDegree()));
        measurement.setDegreeUncertainty(XmlRpcNullConverter.decode(measurement.getDegreeUncertainty()));
        measurement.setAngle(XmlRpcNullConverter.decode(measurement.getAngle()));
        measurement.setAngleUncertainty(XmlRpcNullConverter.decode(measurement.getAngleUncertainty()));
        measurement.setOrigin(XmlRpcNullConverter.decode(measurement.getOrigin()));
        measurement.setUvMin(XmlRpcNullConverter.decode(measurement.getUvMin()));
        measurement.setUvMax(XmlRpcNullConverter.decode(measurement.getUvMax()));
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("decoded measurement: " + measurement));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<- decode");
        }
        return measurement;
    }

    public static boolean queryValueSupplied(Double value) {
        return value != null && value > -1.0E-10;
    }

    public static boolean queryAngleValueSupplied(Double value) {
        return value != null && value > -360.0000000001 && value < 360.0000000001;
    }

    public static Object encode(Object[] ranges) {
        if (ranges == null) {
            ranges = new Object[]{};
        }
        return ranges;
    }

    public static Integer encode(Integer value) {
        if (value == null) {
            value = ENCODED_NULL_INTEGER;
        }
        return value;
    }

    public static Integer decode(Integer value) {
        if (value.equals(ENCODED_NULL_INTEGER)) {
            value = null;
        }
        return value;
    }

    public static void decode(SearchParameters params) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"-> decode");
        }
        params.setName(XmlRpcNullConverter.decode(params.getName()));
        params.setLimit(XmlRpcNullConverter.decode(params.getLimit()));
        params.setRa(XmlRpcNullConverter.decode(params.getRa()));
        params.setDec(XmlRpcNullConverter.decode(params.getDec()));
        params.setRadius(XmlRpcNullConverter.decode(params.getRadius()));
        params.setFLower(XmlRpcNullConverter.decode(params.getFLower()));
        params.setFUpper(XmlRpcNullConverter.decode(params.getFUpper()));
        params.setFluxMin(XmlRpcNullConverter.decode(params.getFluxMin()));
        params.setFluxMax(XmlRpcNullConverter.decode(params.getFluxMax()));
        params.setDegreeMin(XmlRpcNullConverter.decode(params.getDegreeMin()));
        params.setDegreeMax(XmlRpcNullConverter.decode(params.getDegreeMax()));
        params.setAngleMin(XmlRpcNullConverter.decode(params.getAngleMin()));
        params.setAngleMax(XmlRpcNullConverter.decode(params.getAngleMax()));
        params.setSortBy(XmlRpcNullConverter.decode(params.getSortBy()));
        params.setUvMin(XmlRpcNullConverter.decode(params.getUvMin()));
        params.setUvMax(XmlRpcNullConverter.decode(params.getUvMax()));
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<- decode");
        }
    }
}

