/*
 * Decompiled with CFR 0.152.
 */
package alma.acs.commandcenter.engine;

import alma.acs.commandcenter.util.MiscUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public class NativeCommand
implements Runnable {
    public static final String NEW = "new";
    public static final String RUNNING = "running";
    public static final String TERMINATED = "terminated";
    public static final String CANNOTRUN = "unable to run";
    public static final String TIMEOUT = "timed out";
    public static final long NO_TIMEOUT = -1L;
    public static long DEFAULT_WATCHER_INTERVAL = 1000L;
    public static long DEFAULT_WATCHER_DELAY = 500L;
    protected static Timer watchers;
    protected OutputStreamWriter stdin;
    protected Vector<Listener> listeners = new Vector();
    protected String command;
    protected String[] environ;
    protected Process process;
    protected long interval;
    protected long delay;
    protected long maxExecutionTime;
    protected String status;
    protected boolean foreground;
    protected String endMark;
    protected Throwable latestException;
    protected Integer exitValue = null;
    protected Logger log;
    protected ThreadFactory threadFactoryDefault;
    protected ThreadFactory threadFactory = this.threadFactoryDefault = new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            return new Thread(r);
        }
    };

    public NativeCommand(String command, boolean foreground) {
        this(command, foreground, -1L);
    }

    public NativeCommand(String command, boolean foreground, long maxExecutionTime) {
        this(command, foreground, maxExecutionTime, null);
    }

    public NativeCommand(String command, boolean foreground, long maxExecutionTime, String endMark) {
        this(command, foreground, maxExecutionTime, endMark, DEFAULT_WATCHER_INTERVAL, DEFAULT_WATCHER_DELAY);
    }

    public NativeCommand(String command, boolean foreground, long maxExecutionTime, String endMark, long interval, long delay) {
        this(command, null, foreground, maxExecutionTime, endMark, interval, delay);
    }

    public NativeCommand(String command, String environ, boolean foreground, long maxExecutionTime, String endMark) {
        this(command, environ, foreground, maxExecutionTime, endMark, DEFAULT_WATCHER_INTERVAL, DEFAULT_WATCHER_DELAY);
    }

    public NativeCommand(String command, String environ, boolean foreground, long maxExecutionTime, String endMark, long interval, long delay) {
        this.command = command;
        if (environ == null || environ.length() == 0) {
            this.environ = null;
        } else {
            int i;
            HashMap<String, String> env = new HashMap<String, String>(System.getenv());
            String[] envl = environ.split(" ");
            for (i = 0; i < envl.length; ++i) {
                String[] kv = envl[i].split("=", 2);
                env.put(kv[0], kv[1]);
            }
            this.environ = new String[env.size()];
            i = 0;
            for (String envName : env.keySet()) {
                this.environ[i++] = envName + "=" + (String)env.get(envName);
            }
        }
        this.foreground = foreground;
        this.maxExecutionTime = maxExecutionTime;
        this.endMark = endMark;
        this.interval = interval;
        this.delay = delay;
        this.status = NEW;
        this.log = MiscUtils.getPackageLogger(this);
    }

    public void setThreadFactory(ThreadFactory threads) {
        this.threadFactory = threads == null ? this.threadFactoryDefault : threads;
    }

    public void addListener(Listener po) {
        this.listeners.add(po);
    }

    public void removeListener(Listener po) {
        this.listeners.remove(po);
    }

    public String getStatus() {
        return this.status;
    }

    public Integer getExitValue() {
        return this.exitValue;
    }

    public Throwable getLatestException() {
        Throwable ret = this.latestException;
        this.latestException = null;
        return ret;
    }

    public void send(String text) {
        try {
            this.log.finer("writing command '" + text + "' to stdin of " + this.process);
            this.stdin.write(text + "\n");
            this.stdin.flush();
        }
        catch (IOException exc) {
            this.log.log(Level.FINE, "failed to write command '" + this.command + "' to stdin of " + this.process, exc);
        }
    }

    @Override
    public void run() {
        Spawner deleg1 = new Spawner();
        deleg1.run();
        if (this.status.equals(CANNOTRUN)) {
            return;
        }
        Watcher deleg2 = new Watcher();
        if (watchers == null) {
            watchers = new Timer();
        }
        watchers.schedule((TimerTask)deleg2, this.delay, this.interval);
        Reader deleg3 = new Reader(this.process.getInputStream());
        this.threadFactory.newThread(deleg3).start();
        Reader deleg4 = new Reader(this.process.getErrorStream());
        this.threadFactory.newThread(deleg4).start();
        this.stdin = new OutputStreamWriter(this.process.getOutputStream());
        if (this.foreground) {
            try {
                if (this.endMark != null) {
                    deleg3.interruptThreadOnExpectedOutput(Thread.currentThread(), this.endMark);
                    deleg4.interruptThreadOnExpectedOutput(Thread.currentThread(), this.endMark);
                }
                while (true) {
                    deleg2.interruptThreadOnTaskTermination(Thread.currentThread());
                    Thread.sleep(Long.MAX_VALUE);
                }
            }
            catch (InterruptedException e) {
                this.log.finer("Native command interrupted by InterruptedException");
            }
        }
    }

    protected void changeStatus(String newStatus) {
        if (TERMINATED == newStatus) {
            try {
                this.process.getOutputStream().close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.process.getErrorStream().close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.process.getInputStream().close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        String oldStatus = this.status;
        this.status = newStatus;
        this.fireStatusChanged(oldStatus, newStatus);
    }

    protected void fireStatusChanged(String oldStatus, String newStatus) {
        Enumeration<Listener> en = this.listeners.elements();
        while (en.hasMoreElements()) {
            Listener po = en.nextElement();
            po.statusChanged(this, oldStatus);
        }
    }

    protected void fireOutputWritten(InputStream sourceStream, String additionalOutput) {
        if (additionalOutput == null || "".equals(additionalOutput)) {
            return;
        }
        boolean isOutputOnStdout = sourceStream == this.process.getInputStream();
        Enumeration<Listener> en = this.listeners.elements();
        while (en.hasMoreElements()) {
            Listener po = en.nextElement();
            if (isOutputOnStdout) {
                po.stdoutWritten(this, additionalOutput);
                continue;
            }
            po.stderrWritten(this, additionalOutput);
        }
    }

    protected class Spawner {
        protected Spawner() {
        }

        public void run() {
            try {
                NativeCommand.this.process = Runtime.getRuntime().exec(NativeCommand.this.command, NativeCommand.this.environ);
                NativeCommand.this.changeStatus(NativeCommand.RUNNING);
            }
            catch (IOException e) {
                NativeCommand.this.latestException = e;
                NativeCommand.this.changeStatus(NativeCommand.CANNOTRUN);
            }
        }
    }

    protected class Watcher
    extends TimerTask {
        protected long startTime;
        protected Thread interruptableThread;

        protected Watcher() {
        }

        public void interruptThreadOnTaskTermination(Thread thread) {
            this.interruptableThread = thread;
        }

        @Override
        public void run() {
            block5: {
                if (NativeCommand.this.status.equals(NativeCommand.TERMINATED) || NativeCommand.this.status.equals(NativeCommand.CANNOTRUN)) {
                    this.cancel();
                }
                if (this.startTime == 0L) {
                    this.startTime = System.currentTimeMillis();
                }
                try {
                    int x = NativeCommand.this.process.exitValue();
                    NativeCommand.this.changeStatus(NativeCommand.TERMINATED);
                    NativeCommand.this.exitValue = x;
                    if (this.interruptableThread != null) {
                        this.interruptableThread.interrupt();
                    }
                }
                catch (IllegalThreadStateException exc) {
                    if (NativeCommand.this.maxExecutionTime <= -1L || System.currentTimeMillis() - this.startTime <= NativeCommand.this.maxExecutionTime) break block5;
                    NativeCommand.this.changeStatus(NativeCommand.TIMEOUT);
                }
            }
        }
    }

    protected class Reader
    implements Runnable {
        protected Thread interruptableThread;
        protected Pattern expectedOutput;
        protected InputStream sourceStream;

        protected Reader(InputStream sourceStream) {
            this.sourceStream = sourceStream;
        }

        public void interruptThreadOnExpectedOutput(Thread thread, String expectedRegex) {
            this.interruptableThread = thread;
            this.expectedOutput = Pattern.compile(expectedRegex);
        }

        @Override
        public void run() {
            try {
                String line;
                BufferedReader sourceReader = new BufferedReader(new InputStreamReader(this.sourceStream));
                while ((line = sourceReader.readLine()) != null) {
                    NativeCommand.this.fireOutputWritten(this.sourceStream, line + "\n");
                    if (this.expectedOutput == null || !this.expectedOutput.matcher(line).matches()) continue;
                    this.interruptableThread.interrupt();
                }
            }
            catch (IOException exc) {
                NativeCommand.this.log.fine("will stop reading from process output stream, an I/O error occurred: " + exc);
            }
        }
    }

    public static interface Listener {
        public void statusChanged(NativeCommand var1, String var2);

        public void stdoutWritten(NativeCommand var1, String var2);

        public void stderrWritten(NativeCommand var1, String var2);
    }

    public static class ListenerAdapter
    implements Listener {
        @Override
        public void statusChanged(NativeCommand command, String oldStatus) {
        }

        @Override
        public void stdoutWritten(NativeCommand command, String additionalOutput) {
        }

        @Override
        public void stderrWritten(NativeCommand command, String additionalOutput) {
        }
    }
}

