/*
 * Decompiled with CFR 0.152.
 */
package alma.acs.commandcenter.util;

import alma.acs.logging.AcsLogger;
import alma.acs.logging.ClientLogManager;
import alma.acs.util.ACSPorts;
import alma.acs.util.AcsLocations;
import java.util.StringTokenizer;

public class MiscUtils {
    public static AcsLogger getPackageLogger(Object requester) {
        return MiscUtils.getPackageLogger(requester.getClass());
    }

    public static AcsLogger getPackageLogger(Class<?> requester) {
        String pkg = requester.getPackage().getName();
        AcsLogger ret = ClientLogManager.getAcsLogManager().getLoggerForApplication(pkg, false);
        return ret;
    }

    public static int parseInt(String text) {
        try {
            return Integer.parseInt(text);
        }
        catch (NumberFormatException exc) {
            return 0;
        }
    }

    public static String convertShortNotationToCorbaloc(String manager) {
        try {
            String[] ss = manager.split(":");
            if (ss.length != 2) {
                return null;
            }
            if (ss[1].length() != 1) {
                return null;
            }
            String mgrPort = ACSPorts.globalInstance((int)Integer.parseInt(ss[1])).giveManagerPort();
            return AcsLocations.convertToManagerLocation((String)ss[0], (String)mgrPort);
        }
        catch (Exception exc) {
            return null;
        }
    }

    public static String join(String[] text) {
        if (text == null || text.length == 0) {
            return "";
        }
        StringBuilder ret = new StringBuilder(text[0]);
        for (int i = 1; i < text.length; ++i) {
            ret.append(",").append(text[i]);
        }
        return ret.toString();
    }

    public static String[] split(String text) {
        StringTokenizer t = new StringTokenizer(text, ",;");
        String[] ret = new String[t.countTokens()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = t.nextToken().trim();
        }
        return ret;
    }
}

