/*
 * Decompiled with CFR 0.152.
 */
package alma.acs.container.corba;

import alma.ACSErrTypeCommon.wrappers.AcsJUnexpectedExceptionEx;
import alma.JavaContainerError.wrappers.AcsJContainerEx;
import alma.JavaContainerError.wrappers.AcsJContainerServicesEx;
import alma.acs.concurrent.DaemonThreadFactory;
import alma.acs.container.AcsContainer;
import alma.acs.container.ComponentServantManager;
import alma.acs.container.corba.OrbConfigurator;
import alma.acs.logging.AcsLogger;
import alma.acs.util.StopWatch;
import alma.acs.util.UTCUtility;
import java.lang.reflect.Constructor;
import java.util.ConcurrentModificationException;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jacorb.orb.acs.AcsORBProfiler;
import org.jacorb.orb.acs.AcsProfilingORB;
import org.omg.CORBA.Any;
import org.omg.CORBA.ORB;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.CORBA.PolicyManager;
import org.omg.CORBA.PolicyManagerHelper;
import org.omg.CORBA.SetOverrideType;
import org.omg.PortableServer.IdAssignmentPolicyValue;
import org.omg.PortableServer.LifespanPolicyValue;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAHelper;
import org.omg.PortableServer.POAManager;
import org.omg.PortableServer.POAManagerPackage.AdapterInactive;
import org.omg.PortableServer.POAManagerPackage.State;
import org.omg.PortableServer.POAPackage.AdapterAlreadyExists;
import org.omg.PortableServer.POAPackage.AdapterNonExistent;
import org.omg.PortableServer.POAPackage.InvalidPolicy;
import org.omg.PortableServer.RequestProcessingPolicyValue;
import org.omg.PortableServer.Servant;
import org.omg.PortableServer.ServantManager;
import org.omg.PortableServer.ServantRetentionPolicyValue;
import si.ijs.maci.Container;
import si.ijs.maci.ContainerHelper;

public class AcsCorba {
    public static final String ORB_PROFILER_CLASS_PROPERTYNAME = "alma.acs.orb.profiler.class";
    private ORB m_orb;
    private POAManager sharedPoaManager;
    private POA m_rootPOA;
    private POA m_containerPOA;
    private POA m_componentPOA;
    private Policy[] m_compPolicies;
    private Policy[] m_offshootPolicies;
    private AcsLogger m_logger;
    private boolean m_isInitialized = false;
    private Integer orbPort;
    private Integer orbPortSearchRetry;
    private boolean isOrbChoosingPort = false;
    public static final String SYSPROP_FIRESTARTER_OAPORT = "acs.firestarter.oaport";
    protected int DEFAULT_PORT = 3075;
    protected int DEFAULT_RETRY = 5;

    public AcsCorba(AcsLogger logger) {
        this.m_logger = logger;
    }

    public void setPortOptions(Integer orbPort, Integer orbPortSearchRetry) {
        this.orbPort = orbPort;
        this.orbPortSearchRetry = orbPortSearchRetry;
        if (this.orbPort == null && orbPortSearchRetry != null && -1 == orbPortSearchRetry) {
            this.isOrbChoosingPort = true;
            return;
        }
        if (this.orbPort == null) {
            this.orbPort = Integer.getInteger(SYSPROP_FIRESTARTER_OAPORT, this.DEFAULT_PORT);
        }
        if (this.orbPortSearchRetry == null) {
            this.orbPortSearchRetry = this.DEFAULT_RETRY;
        }
    }

    public synchronized void setLogger(AcsLogger logger) {
        this.m_logger = logger;
    }

    public synchronized void initCorba(String[] args, int port) throws AcsJContainerEx {
        if (this.isInitialized()) {
            throw new IllegalStateException("Illegal call to initCorba. ORB/POAs have already been initialized.");
        }
        try {
            this.setPortOptions(port, 0);
            this.prepareOrb(args);
            this.initPOAForContainer();
            this.initPOAForComponents();
            this.setInitialized(true);
        }
        catch (Throwable thr) {
            if (thr instanceof AcsJContainerEx) {
                throw (AcsJContainerEx)thr;
            }
            AcsJContainerEx ex = new AcsJContainerEx(thr);
            ex.setContextInfo("initCorba failed.");
            throw ex;
        }
        this.initOrbProfiling();
    }

    private void initOrbProfiling() {
        block6: {
            try {
                String orbProfilerClassname = System.getProperty(ORB_PROFILER_CLASS_PROPERTYNAME);
                if (orbProfilerClassname != null) {
                    if (this.m_orb instanceof AcsProfilingORB) {
                        Class<AcsORBProfiler> orbProfilerClass = Class.forName(orbProfilerClassname).asSubclass(AcsORBProfiler.class);
                        Constructor<AcsORBProfiler> ctor = null;
                        try {
                            ctor = orbProfilerClass.getConstructor(AcsLogger.class);
                        }
                        catch (NoSuchMethodException ex) {
                            ctor = orbProfilerClass.getConstructor(Logger.class);
                        }
                        AcsORBProfiler profiler = ctor.newInstance(this.m_logger);
                        ((AcsProfilingORB)this.m_orb).registerAcsORBProfiler(profiler);
                        this.m_logger.finer("Orb profiling set up, using " + orbProfilerClassname);
                        break block6;
                    }
                    this.m_logger.warning("Orb profiling was selected, but the currently used ORB " + this.m_orb.getClass().getName() + " does not support it.");
                    break block6;
                }
                this.m_logger.finer("Orb profiling was not selected (see property 'alma.acs.orb.profiler.class').");
            }
            catch (Throwable th) {
                this.m_logger.log(Level.WARNING, "Failed to set up ORB profiling, will run without it.", th);
            }
        }
    }

    public synchronized boolean isInitialized() {
        return this.m_isInitialized;
    }

    private synchronized void setInitialized(boolean initialized) {
        this.m_isInitialized = initialized;
    }

    public synchronized POA initCorbaForClient(boolean isAdmin) throws Exception {
        if (this.isInitialized()) {
            throw new IllegalStateException("Illegal call to initCorba. ORB/POAs have already been initialized.");
        }
        try {
            OrbConfigurator orbConf = OrbConfigurator.getOrbConfigurator();
            this.setORB(ORB.init((String[])orbConf.getOptions(), (Properties)orbConf.getProperties()));
            this.initRootPoa(this.m_orb);
            this.sharedPoaManager.activate();
        }
        catch (Exception ex) {
            this.m_logger.log(Level.SEVERE, "failed to initialize CORBA.", (Throwable)ex);
            if (this.m_orb != null) {
                this.m_orb.destroy();
            }
            throw ex;
        }
        this.initOrbProfiling();
        this.setInitialized(true);
        return this.m_rootPOA;
    }

    protected void initRootPoa(ORB orb) {
        this.m_rootPOA = null;
        try {
            this.m_logger.fine("calling orb.resolve_initial_references");
            Object obj = orb.resolve_initial_references("RootPOA");
            this.m_rootPOA = POAHelper.narrow((Object)obj);
        }
        catch (InvalidName exc) {
            throw new IllegalStateException("couldn't retrieve RootPOA: " + exc);
        }
        catch (RuntimeException exc) {
            throw new IllegalStateException("port taken?, couldn't retrieve RootPOA:" + exc);
        }
        try {
            this.sharedPoaManager = this.m_rootPOA.the_POAManager();
        }
        catch (Exception exc) {
            throw new IllegalStateException("Failed to get POA manager: " + exc);
        }
        this.m_logger.fine("POA activated");
    }

    private void initPOAForContainer() throws AcsJContainerEx {
        if (this.m_containerPOA != null) {
            return;
        }
        Policy[] contPolicies = null;
        try {
            contPolicies = new Policy[]{this.m_rootPOA.create_id_assignment_policy(IdAssignmentPolicyValue.USER_ID), this.m_rootPOA.create_lifespan_policy(LifespanPolicyValue.PERSISTENT), this.m_rootPOA.create_request_processing_policy(RequestProcessingPolicyValue.USE_ACTIVE_OBJECT_MAP_ONLY), this.m_rootPOA.create_servant_retention_policy(ServantRetentionPolicyValue.RETAIN)};
            this.m_containerPOA = this.m_rootPOA.create_POA("ContainerPOA", this.sharedPoaManager, contPolicies);
            if (this.m_containerPOA == null) {
                throw new NullPointerException("ContainerPOA reference == null");
            }
            this.m_logger.finest("ContainerPOA created.");
        }
        catch (Throwable thr) {
            AcsJContainerEx ex = new AcsJContainerEx(thr);
            ex.setContextInfo("ContainerPOA creation failed");
            throw ex;
        }
        finally {
            if (contPolicies != null) {
                for (Policy policy : contPolicies) {
                    if (policy == null) continue;
                    policy.destroy();
                }
            }
        }
    }

    private void initPOAForComponents() throws AcsJContainerEx {
        if (this.m_componentPOA != null) {
            return;
        }
        try {
            this.m_compPolicies = new Policy[4];
            this.m_compPolicies[0] = this.m_rootPOA.create_id_assignment_policy(IdAssignmentPolicyValue.USER_ID);
            this.m_compPolicies[1] = this.m_rootPOA.create_lifespan_policy(LifespanPolicyValue.PERSISTENT);
            this.m_compPolicies[2] = this.m_rootPOA.create_servant_retention_policy(ServantRetentionPolicyValue.RETAIN);
            this.m_compPolicies[3] = this.m_rootPOA.create_request_processing_policy(RequestProcessingPolicyValue.USE_SERVANT_MANAGER);
            this.m_componentPOA = this.m_rootPOA.create_POA("ComponentPOA", this.sharedPoaManager, this.m_compPolicies);
            if (this.m_componentPOA == null) {
                throw new NullPointerException("ComponentPOA reference == null");
            }
            this.m_logger.finest("ComponentPOA created.");
        }
        catch (Throwable thr) {
            AcsJContainerEx ex = new AcsJContainerEx(thr);
            ex.setContextInfo("ComponentPOA creation failed");
            throw ex;
        }
    }

    public void runCorba() throws AcsJContainerEx {
        try {
            this.sharedPoaManager.activate();
        }
        catch (Throwable thr) {
            AcsJContainerEx ex = new AcsJContainerEx(thr);
            ex.setContextInfo("running CORBA failed");
            throw ex;
        }
    }

    public void blockOnORB() {
        this.getORB().run();
    }

    public void shutdownORB(boolean wait_for_completion, boolean isOrbThread) {
        block13: {
            if (this.m_orb != null) {
                if (isOrbThread) {
                    Runnable cmd = new Runnable(){

                        @Override
                        public void run() {
                            try {
                                AcsCorba.this.m_orb.shutdown(false);
                            }
                            catch (ConcurrentModificationException concurrentModificationException) {
                                // empty catch block
                            }
                        }
                    };
                    new DaemonThreadFactory("ShutdownORB").newThread(cmd).start();
                } else {
                    try {
                        if (wait_for_completion) {
                            final CountDownLatch synch1 = new CountDownLatch(1);
                            final CountDownLatch synch2 = new CountDownLatch(1);
                            Runnable cmd = new Runnable(){

                                @Override
                                public void run() {
                                    synch1.countDown();
                                    AcsCorba.this.m_orb.run();
                                    synch2.countDown();
                                }
                            };
                            new DaemonThreadFactory("WorkaroundBlockOnOrbTillShutdownCompletes").newThread(cmd).start();
                            try {
                                synch1.await();
                                Thread.sleep(1000L);
                            }
                            catch (InterruptedException ex1) {
                                System.out.println("Failed to wait for the thread that should call orb.run to synch with ORB shutdown. " + ex1.toString());
                            }
                            this.m_orb.shutdown(true);
                            try {
                                boolean orbRunUnblocked = synch2.await(30L, TimeUnit.SECONDS);
                                if (!orbRunUnblocked) {
                                    System.out.println("Failed to return within 30 s from orb.run() after ORB shutdown.");
                                }
                                break block13;
                            }
                            catch (InterruptedException ex) {
                                System.out.println("InterruptedException waiting for orb.run() to return after ORB shutdown. " + ex.toString());
                            }
                            break block13;
                        }
                        this.m_orb.shutdown(false);
                    }
                    catch (ConcurrentModificationException ex) {
                        System.out.println("Caught a ConcurrentModificationException from ORB shutdown. This should be harmless, see known JacORB bug http://www.jacorb.org/cgi-bin/bugzilla/show_bug.cgi?id=537");
                        if (!wait_for_completion) break block13;
                        try {
                            Thread.sleep(2000L);
                        }
                        catch (InterruptedException ex1) {
                            System.out.println("InterruptedException while sleeping after the ConcurrentModificationException in orb.shutdown");
                        }
                    }
                }
            }
        }
    }

    public void doneCorba() {
        if (this.m_orb != null) {
            try {
                this.m_orb.destroy();
            }
            catch (Exception ex) {
                System.out.println("Exception occured during destruction of the ORB.\n" + ex.toString());
            }
        }
    }

    private void setORB(ORB orb) throws IllegalArgumentException {
        if (orb == null) {
            throw new IllegalStateException("ORB reference must not be null.");
        }
        this.m_orb = orb;
    }

    public ORB getORB() {
        if (this.m_orb == null) {
            throw new IllegalStateException("ORB reference does not exist.");
        }
        if (!this.isInitialized()) {
            throw new IllegalStateException("ORB has not been initialized.");
        }
        return this.m_orb;
    }

    public POA getRootPOA() {
        this.getORB();
        return this.m_rootPOA;
    }

    public Object activateContainer(AcsContainer container, String name) throws AcsJContainerEx {
        if (name == null || name.length() == 0 || container == null) {
            String msg = "activateContainer called with missing parameter.";
            AcsJContainerEx ex = new AcsJContainerEx();
            ex.setContextInfo(msg);
            throw ex;
        }
        this.m_logger.finer("entering activateContainer name=" + name);
        Object actObj = null;
        try {
            byte[] id = name.getBytes();
            this.m_containerPOA.activate_object_with_id(id, (Servant)container);
            actObj = this.m_containerPOA.servant_to_reference((Servant)container);
            actObj._hash(Integer.MAX_VALUE);
        }
        catch (Throwable thr) {
            AcsJContainerEx ex = new AcsJContainerEx(thr);
            ex.setContextInfo("failed to activate container object " + name);
            throw ex;
        }
        return actObj;
    }

    public Container getContainerCorbaRef(AcsContainer container) throws AcsJContainerEx {
        try {
            return ContainerHelper.narrow((Object)this.m_containerPOA.servant_to_reference((Servant)container));
        }
        catch (Exception ex) {
            AcsJContainerEx ex2 = new AcsJContainerEx((Throwable)ex);
            ex2.setContextInfo("failed to retrieve corba ref for container servant " + container.name());
            throw ex2;
        }
    }

    public POA createPOAForComponent(String compName) throws AcsJContainerEx {
        if (this.m_componentPOA == null) {
            throw new IllegalStateException("Must call 'initPOAForComponents()' before 'createPOAForComponent'.");
        }
        POA compChildPOA = null;
        String compChildPOAName = "ComponentPOA_" + compName;
        try {
            try {
                compChildPOA = this.m_componentPOA.create_POA(compChildPOAName, null, this.m_compPolicies);
            }
            catch (AdapterAlreadyExists ex1) {
                this.m_logger.warning(compChildPOAName + " already exists even though it should not. Will try to reuse it...");
                compChildPOA = this.m_componentPOA.find_POA(compChildPOAName, true);
            }
            compChildPOA.the_POAManager().activate();
        }
        catch (Throwable thr) {
            AcsJContainerEx ex = new AcsJContainerEx();
            ex.setContextInfo("failed to create POA for component " + compName);
            throw ex;
        }
        return compChildPOA;
    }

    public ComponentServantManager setServantManagerOnComponentPOA(POA componentPOA) throws AcsJContainerEx {
        ComponentServantManager servantManager;
        try {
            servantManager = new ComponentServantManager((Logger)this.m_logger);
            componentPOA.set_servant_manager((ServantManager)servantManager);
        }
        catch (Throwable thr) {
            String msg = "Failed to set a servant activator on the component POA " + componentPOA.the_name();
            this.m_logger.log(Level.FINE, msg, thr);
            AcsJContainerEx ex = new AcsJContainerEx(thr);
            ex.setContextInfo(msg);
            throw ex;
        }
        return servantManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public POA getPOAForOffshoots(POA componentPOA) throws AcsJContainerEx, AcsJUnexpectedExceptionEx {
        String offshootPoaName = "offshootPoa";
        POA offshootPoa = null;
        POA pOA = componentPOA;
        synchronized (pOA) {
            try {
                offshootPoa = componentPOA.find_POA("offshootPoa", false);
            }
            catch (AdapterNonExistent e) {
                this.m_logger.finest("will have to create offshoot POA");
                if (this.m_offshootPolicies == null) {
                    this.m_offshootPolicies = new Policy[4];
                    this.m_offshootPolicies[0] = componentPOA.create_id_assignment_policy(IdAssignmentPolicyValue.SYSTEM_ID);
                    this.m_offshootPolicies[1] = componentPOA.create_lifespan_policy(LifespanPolicyValue.TRANSIENT);
                    this.m_offshootPolicies[2] = componentPOA.create_request_processing_policy(RequestProcessingPolicyValue.USE_ACTIVE_OBJECT_MAP_ONLY);
                    this.m_offshootPolicies[3] = componentPOA.create_servant_retention_policy(ServantRetentionPolicyValue.RETAIN);
                }
                try {
                    offshootPoa = componentPOA.create_POA("offshootPoa", this.sharedPoaManager, this.m_offshootPolicies);
                    this.m_logger.finest("successfully created offshoot POA");
                }
                catch (InvalidPolicy ex) {
                    AcsJContainerEx ex2 = new AcsJContainerEx((Throwable)ex);
                    ex2.setContextInfo("Attempted to create offshoot POA with invalid policies.");
                    throw ex2;
                }
                catch (AdapterAlreadyExists ex) {
                    throw new AcsJUnexpectedExceptionEx((Throwable)ex);
                }
            }
        }
        return offshootPoa;
    }

    public Object activateComponent(Servant servant, String name, POA compPOA) throws AcsJContainerEx {
        if (name == null || name.length() == 0 || servant == null || compPOA == null) {
            AcsJContainerEx ex = new AcsJContainerEx();
            ex.setContextInfo("activateComponent called with missing parameter.");
            throw ex;
        }
        this.m_logger.finer("entering activateComponent: name=" + name);
        Object actObj = null;
        try {
            byte[] id = name.getBytes();
            compPOA.activate_object_with_id(id, servant);
            actObj = compPOA.servant_to_reference(servant);
            actObj._hash(Integer.MAX_VALUE);
            this.m_logger.finer("component '" + name + "' activated as CORBA object.");
        }
        catch (Throwable thr) {
            AcsJContainerEx ex = new AcsJContainerEx(thr);
            ex.setContextInfo("failed to activate component " + name);
            throw ex;
        }
        return actObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean deactivateComponentPOAManager(POA compPOA, final String compName, int timeoutMillis) {
        final POAManager compPOAManager = compPOA.the_POAManager();
        if (compPOAManager.get_state() == State.INACTIVE) {
            return true;
        }
        final CountDownLatch deactivateSyncer = new CountDownLatch(1);
        Thread discardRequestsThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    compPOAManager.deactivate(false, true);
                    deactivateSyncer.countDown();
                }
                catch (AdapterInactive e) {
                    AcsCorba.this.m_logger.log(Level.INFO, "Failed to finish and reject requests for component " + compName, (Throwable)e);
                }
            }
        });
        discardRequestsThread.setDaemon(true);
        discardRequestsThread.setName("deactivatePOAManager_" + compName);
        StopWatch stopWatch = null;
        if (this.m_logger.isLoggable(Level.FINEST)) {
            stopWatch = new StopWatch();
        }
        discardRequestsThread.start();
        boolean isInactive = false;
        try {
            isInactive = deactivateSyncer.await(timeoutMillis, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException deactivationTime) {
            if (this.m_logger.isLoggable(Level.FINEST)) {
                long deactivationTime2 = stopWatch.getLapTimeMillis();
                String msg = "POA manager deactivation for component '" + compName + "' was " + (isInactive ? "" : "*not* ") + "successful and took " + deactivationTime2 + " ms. The component can" + (isInactive ? "not" : "") + " receive further calls over CORBA.";
                this.m_logger.finest(msg);
            }
            catch (Throwable throwable) {
                if (this.m_logger.isLoggable(Level.FINEST)) {
                    long deactivationTime3 = stopWatch.getLapTimeMillis();
                    String msg2 = "POA manager deactivation for component '" + compName + "' was " + (isInactive ? "" : "*not* ") + "successful and took " + deactivationTime3 + " ms. The component can" + (isInactive ? "not" : "") + " receive further calls over CORBA.";
                    this.m_logger.finest(msg2);
                }
                throw throwable;
            }
        }
        if (this.m_logger.isLoggable(Level.FINEST)) {
            long deactivationTime = stopWatch.getLapTimeMillis();
            String msg = "POA manager deactivation for component '" + compName + "' was " + (isInactive ? "" : "*not* ") + "successful and took " + deactivationTime + " ms. The component can" + (isInactive ? "not" : "") + " receive further calls over CORBA.";
            this.m_logger.finest(msg);
        }
        return isInactive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean destroyComponentPOA(POA compPOA, ComponentServantManager compServantManager, int timeoutMillis) {
        compServantManager.resetWaitForEtherealize();
        POA pOA = compPOA;
        synchronized (pOA) {
            compPOA.destroy(true, false);
        }
        return compServantManager.waitForEtherealize(timeoutMillis);
    }

    public Object activateOffShoot(Servant servant, POA compPOA) throws AcsJContainerEx, AcsJUnexpectedExceptionEx {
        if (servant == null || compPOA == null) {
            String msg = "activateOffShoot called with missing parameter.";
            AcsJContainerEx ex = new AcsJContainerEx();
            ex.setContextInfo(msg);
            throw ex;
        }
        POA offshootPoa = this.getPOAForOffshoots(compPOA);
        Object actObj = null;
        try {
            offshootPoa.activate_object(servant);
            actObj = offshootPoa.servant_to_reference(servant);
            actObj._hash(Integer.MAX_VALUE);
            this.m_logger.finer("offshoot of type '" + servant.getClass().getName() + "' activated as a CORBA object.");
        }
        catch (Throwable thr) {
            AcsJContainerEx ex = new AcsJContainerEx(thr);
            ex.setContextInfo("failed to activate offshoot of type '" + servant.getClass().getName());
            throw ex;
        }
        return actObj;
    }

    public void deactivateOffShoot(Servant servant, POA compPOA) throws AcsJContainerEx {
        if (servant == null || compPOA == null) {
            String msg = "deactivateOffShoot called with missing parameter.";
            AcsJContainerEx ex = new AcsJContainerEx();
            ex.setContextInfo(msg);
            throw ex;
        }
        byte[] id = null;
        try {
            POA offshootPoa = this.getPOAForOffshoots(compPOA);
            id = offshootPoa.servant_to_id(servant);
            offshootPoa.deactivate_object(id);
        }
        catch (AcsJContainerEx e) {
            throw e;
        }
        catch (Throwable thr) {
            String msg = "failed to deactivate offshoot of type '" + servant.getClass().getName() + "' (ID=" + String.valueOf(id) + ")";
            this.m_logger.log(Level.WARNING, msg, thr);
            AcsJContainerEx ex = new AcsJContainerEx(thr);
            ex.setContextInfo(msg);
            throw ex;
        }
    }

    public void setORBLevelRoundtripTimeout(double timeoutSeconds) throws AcsJContainerServicesEx {
        if (!this.isInitialized()) {
            throw new IllegalStateException("Only call when this object has been initialized!");
        }
        try {
            Any rrtPolicyAny = this.m_orb.create_any();
            rrtPolicyAny.insert_ulonglong(UTCUtility.durationJavaMillisToOmg((long)((long)timeoutSeconds * 1000L)));
            Policy p = this.m_orb.create_policy(32, rrtPolicyAny);
            PolicyManager pm = PolicyManagerHelper.narrow((Object)this.m_orb.resolve_initial_references("ORBPolicyManager"));
            pm.set_policy_overrides(new Policy[]{p}, SetOverrideType.SET_OVERRIDE);
            p.destroy();
        }
        catch (Throwable thr) {
            AcsJContainerServicesEx ex2 = new AcsJContainerServicesEx(thr);
            ex2.setContextInfo("Failed to set the ORB-level client-side corba roundtrip timeout to " + timeoutSeconds);
            throw ex2;
        }
        this.m_logger.fine("Set ORB level roundtrip timeout to " + timeoutSeconds + " seconds.");
    }

    public Object wrapForRoundtripTimeout(Object corbaRef, double timeoutSeconds) throws AcsJContainerServicesEx {
        if (!this.isInitialized()) {
            throw new IllegalStateException("Only call when this object has been initialized!");
        }
        Object ret = null;
        try {
            Any rrtPolicyAny = this.m_orb.create_any();
            rrtPolicyAny.insert_ulonglong(UTCUtility.durationJavaMillisToOmg((long)((long)timeoutSeconds * 1000L)));
            Policy p = this.m_orb.create_policy(32, rrtPolicyAny);
            ret = corbaRef._set_policy_override(new Policy[]{p}, SetOverrideType.SET_OVERRIDE);
            p.destroy();
        }
        catch (Throwable thr) {
            AcsJContainerServicesEx ex2 = new AcsJContainerServicesEx(thr);
            ex2.setContextInfo("Failed to set the object-level client-side corba roundtrip timeout to " + timeoutSeconds);
            throw ex2;
        }
        return ret;
    }

    public void prepareOrb(String[] args) {
        if (this.m_orb == null) {
            if (this.isOrbChoosingPort) {
                ORB orb = this.createOrb(args, null);
                this.initRootPoa(orb);
                this.setORB(orb);
                return;
            }
            if (this.orbPortSearchRetry <= 0) {
                ORB orb = this.createOrb(args, this.orbPort);
                this.initRootPoa(orb);
                this.setORB(orb);
            } else {
                RVtrialAndError re = this.trialAndError(args, this.orbPort, this.orbPortSearchRetry);
                this.setORB(re.orb);
            }
        }
    }

    private ORB createOrb(String[] args, Integer port) {
        ORB orb = null;
        OrbConfigurator orbConf = OrbConfigurator.getOrbConfigurator();
        orbConf.setORBInitRef("InterfaceRepository", System.getProperty("ACS.repository"));
        orbConf.setOptions(args);
        if (port != null) {
            orbConf.setPort(port);
        }
        String[] orbOpts = orbConf.getOptions();
        boolean suppressPortProperty = port == null;
        Properties orbProps = orbConf.getProperties(suppressPortProperty);
        StringBuffer logBuf = new StringBuffer("ORB options ");
        for (int i = 0; i < orbOpts.length; ++i) {
            logBuf.append(orbOpts[i]).append(' ');
        }
        logBuf.append("  ORB properties: ");
        logBuf.append(orbProps.toString());
        this.m_logger.finer(logBuf.toString());
        orb = ORB.init((String[])orbOpts, (Properties)orbProps);
        if (orb == null) {
            throw new NullPointerException("org.omg.CORBA.ORB.init returned null.");
        }
        this.m_logger.finer("ORB initialized.");
        return orb;
    }

    protected RVtrialAndError trialAndError(String[] args, int first, int retries) {
        int i;
        ORB orb = null;
        int next = first;
        for (i = 0; i < retries; ++i) {
            try {
                next = first + i;
                this.m_logger.info("trying to start an orb on port " + next);
                orb = this.createOrb(args, next);
                this.initRootPoa(orb);
                break;
            }
            catch (RuntimeException exc) {
                this.m_logger.finer("failed due to " + exc);
                orb.shutdown(true);
                continue;
            }
        }
        if (i == retries) {
            throw new RuntimeException("tried ports " + first + " to " + next + ": couldn't start orb; giving up");
        }
        return new RVtrialAndError(orb, next);
    }

    protected class RVtrialAndError {
        public ORB orb;
        public int port;

        public RVtrialAndError(ORB o, int p) {
            this.orb = o;
            this.port = p;
        }
    }
}

