/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.roe.ukatc.xsltchain;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import uk.ac.roe.ukatc.xsltchain.EdgeO;
import uk.ac.roe.ukatc.xsltchain.GraphException;
import uk.ac.roe.ukatc.xsltchain.VertexO;

public class UGraph {
    public static final double INFINITY = Double.MAX_VALUE;
    public Map<String, VertexO> vertexMap = new HashMap<String, VertexO>();

    public void addEdge(String sourceName, String destName, Object Value) {
        VertexO v = this.getVertex(sourceName);
        VertexO w = this.getVertex(destName);
        v.AddEdge(w, Value);
    }

    private VertexO getVertex(String vertexName) {
        VertexO v = this.vertexMap.get(vertexName);
        if (v == null) {
            v = new VertexO(vertexName);
            this.vertexMap.put(vertexName, v);
        }
        return v;
    }

    public void printPath(String destName) {
        VertexO w = this.vertexMap.get(destName);
        if (w == null) {
            throw new NoSuchElementException("Destination vertex not found");
        }
        if (w.dist == Double.MAX_VALUE) {
            System.out.println(String.valueOf(destName) + " is unreachable");
        } else {
            System.out.print("(Cost is: " + w.dist + ") ");
            this.printPath(w);
            System.out.println();
        }
    }

    private void printPath(VertexO dest) {
        if (dest.prev != null) {
            this.printPath(dest.prev);
            System.out.print(" to  (via ");
            System.out.print(dest.eobj);
            System.out.print(") ");
        }
        System.out.print(dest.name);
    }

    public List getPath(String destName) {
        LinkedList<Object> retval = new LinkedList<Object>();
        VertexO w = this.vertexMap.get(destName);
        if (w == null) {
            throw new NoSuchElementException("Destination vertex not found");
        }
        if (w.dist == Double.MAX_VALUE) {
            throw new NoSuchElementException("Destination is unreachable");
        }
        this.getPath(w, retval);
        return retval;
    }

    private void getPath(VertexO dest, List<Object> r) {
        if (dest.prev != null) {
            this.getPath(dest.prev, r);
            r.add(dest.eobj);
        }
    }

    private void clearAll() {
        Iterator<VertexO> itr = this.vertexMap.values().iterator();
        while (itr.hasNext()) {
            itr.next().reset();
        }
    }

    public void unweighted(String startName) {
        this.clearAll();
        VertexO start = this.vertexMap.get(startName);
        if (start == null) {
            throw new NoSuchElementException("Start vertex not found");
        }
        LinkedList<VertexO> q = new LinkedList<VertexO>();
        q.addLast(start);
        start.dist = 0.0;
        while (!q.isEmpty()) {
            VertexO v = (VertexO)q.removeFirst();
            for (EdgeO e : v.adj) {
                VertexO w = e.dest;
                if (w.dist != Double.MAX_VALUE) continue;
                w.dist = v.dist + 1.0;
                w.prev = v;
                w.eobj = e.obj;
                q.addLast(w);
            }
        }
    }

    public List getShortestPath(String start, String end, UGraph g) {
        try {
            g.unweighted(start);
            List l = g.getPath(end);
            return l;
        }
        catch (NoSuchElementException e) {
            System.err.println(e);
        }
        catch (GraphException e) {
            System.err.println(e);
        }
        return null;
    }

    public List getShortestPath(String start, String end) {
        try {
            this.unweighted(start);
            List l = this.getPath(end);
            return l;
        }
        catch (NoSuchElementException e) {
            System.err.println(e);
        }
        catch (GraphException e) {
            System.err.println(e);
        }
        return null;
    }
}

