/*
 * Decompiled with CFR 0.152.
 */
package jsky.image.graphics;

import diva.canvas.CanvasUtilities;
import diva.canvas.Figure;
import diva.canvas.interactor.Interactor;
import diva.canvas.interactor.SelectionInteractor;
import diva.canvas.toolbox.LabelFigure;
import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import jsky.graphics.CanvasFigure;
import jsky.graphics.CanvasFigureListener;
import jsky.graphics.CanvasFigureListenerManager;

public class ImageLabel
extends LabelFigure
implements CanvasFigure {
    private Object _clientData;
    private CanvasFigureListenerManager _listenerManager;
    private List<CanvasFigure> _slaves;
    private Composite _composite = AlphaComposite.getInstance(3, 1.0f);
    private boolean _persistent;

    public ImageLabel(String text, Point2D.Double pos, Paint fill, Font font, Interactor interactor) {
        super(text, font);
        this._listenerManager = new CanvasFigureListenerManager(this);
        this.setAnchor(6);
        this.setFillPaint(fill);
        if (interactor != null) {
            this.setInteractor(interactor);
        }
        this.translate(pos.x, pos.y);
        this.setFont(font);
    }

    @Override
    public void setClientData(Object o) {
        this._clientData = o;
    }

    @Override
    public Object getClientData() {
        return this._clientData;
    }

    @Override
    public Rectangle2D getBoundsWithoutLabel() {
        return this.getBounds();
    }

    @Override
    public boolean isSelected() {
        return this.getInteractor() instanceof SelectionInteractor;
    }

    @Override
    public boolean isPersistent() {
        return this._persistent;
    }

    public void setPersistent(boolean persistent) {
        this._persistent = persistent;
    }

    @Override
    public void paint(Graphics2D g) {
        g.setComposite(this._composite);
        super.paint(g);
    }

    @Override
    public void setVisible(boolean flag) {
        super.setVisible(flag);
        this.repaint();
    }

    @Override
    public void addCanvasFigureListener(CanvasFigureListener listener) {
        this._listenerManager.addCanvasFigureListener(listener);
    }

    @Override
    public void removeCanvasFigureListener(CanvasFigureListener listener) {
        this._listenerManager.removeCanvasFigureListener(listener);
    }

    @Override
    public void fireCanvasFigureEvent(int eventType) {
        this._listenerManager.fireCanvasFigureEvent(eventType);
    }

    @Override
    public void addSlave(CanvasFigure fig) {
        if (this._slaves == null) {
            this._slaves = new LinkedList<CanvasFigure>();
        }
        this._slaves.add(fig);
    }

    @Override
    public void translate(double x, double y) {
        super.translate(x, y);
        if (this._slaves != null) {
            ListIterator<CanvasFigure> it = this._slaves.listIterator(0);
            while (it.hasNext()) {
                Figure fig = it.next();
                fig.translate(x, y);
            }
        }
    }

    @Override
    public Point2D getAnchorPoint() {
        return CanvasUtilities.getLocation(this.getBounds(), 6);
    }
}

