/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.fits.test;

import nom.tam.fits.AsciiTable;
import nom.tam.fits.AsciiTableHDU;
import nom.tam.fits.Fits;
import nom.tam.fits.TableHDU;
import nom.tam.util.ArrayFuncs;
import nom.tam.util.BufferedFile;
import org.junit.Assert;
import org.junit.Test;

public class AsciiTableTester {
    Object[] getSampleCols() {
        float[] realCol = new float[50];
        for (int i = 0; i < realCol.length; ++i) {
            realCol[i] = 10000.0f * (float)i * (float)i * (float)i + 1.0f;
        }
        int[] intCol = (int[])ArrayFuncs.convertArray(realCol, Integer.TYPE);
        long[] longCol = (long[])ArrayFuncs.convertArray(realCol, Long.TYPE);
        double[] doubleCol = (double[])ArrayFuncs.convertArray(realCol, Double.TYPE);
        String[] strCol = new String[realCol.length];
        for (int i = 0; i < realCol.length; ++i) {
            strCol[i] = "ABC" + String.valueOf(realCol[i]) + "CDE";
        }
        return new Object[]{realCol, intCol, longCol, doubleCol, strCol};
    }

    Fits makeAsciiTable() throws Exception {
        Object[] cols = this.getSampleCols();
        Fits f = new Fits();
        f.addHDU(Fits.makeHDU(cols));
        return f;
    }

    public void writeFile(Fits f, String name) throws Exception {
        BufferedFile bf = new BufferedFile(name, "rw");
        f.write(bf);
        bf.flush();
        bf.close();
    }

    @Test
    public void test() throws Exception {
        this.createByColumn();
        this.createByRow();
        this.readByRow();
        this.readByColumn();
        this.readByElement();
        this.modifyTable();
        this.delete();
    }

    public void createByColumn() throws Exception {
        Fits f = this.makeAsciiTable();
        this.writeFile(f, "at1.fits");
        f = new Fits("at1.fits");
        AsciiTableHDU hdu = (AsciiTableHDU)f.getHDU(1);
        Object[] inputs = this.getSampleCols();
        Object[] outputs = (Object[])hdu.getKernel();
        for (int i = 0; i < 50; ++i) {
            ((String[])outputs[4])[i] = ((String[])outputs[4])[i].trim();
        }
        for (int j = 0; j < 5; ++j) {
            Assert.assertEquals((String)("ByCol:" + j), (Object)true, (Object)ArrayFuncs.arrayEquals(inputs[j], outputs[j], 1.0E-6, 1.0E-14));
        }
    }

    Object[] getRow(int i) {
        return new Object[]{new int[]{i}, new float[]{i}, new String[]{"Str" + i}};
    }

    Object[] getRowBlock(int max) {
        Object[] o = new Object[]{new int[max], new float[max], new String[max]};
        for (int i = 0; i < max; ++i) {
            ((int[])o[0])[i] = i;
            ((float[])o[1])[i] = i;
            ((String[])o[2])[i] = "Str" + i;
        }
        return o;
    }

    public void createByRow() throws Exception {
        Fits f = new Fits();
        AsciiTable data = new AsciiTable();
        Object[] row = new Object[4];
        for (int i = 0; i < 50; ++i) {
            data.addRow(this.getRow(i));
        }
        f.addHDU(Fits.makeHDU(data));
        this.writeFile(f, "at2.fits");
        f = new Fits("at2.fits");
        Object[] output = (Object[])f.getHDU(1).getKernel();
        Object[] input = this.getRowBlock(50);
        for (int i = 0; i < 50; ++i) {
            String[] str = (String[])output[2];
            String[] istr = (String[])input[2];
            int len1 = str[1].length();
            str[i] = str[i].trim();
            if (istr[i].length() <= len1) continue;
            istr[i] = istr[i].substring(0, len1);
        }
        for (int j = 0; j < 3; ++j) {
            Assert.assertEquals((String)("ByRow:" + j), (Object)true, (Object)ArrayFuncs.arrayEquals(input[j], output[j], 1.0E-6, 1.0E-14));
        }
    }

    public void readByRow() throws Exception {
        Fits f = new Fits("at1.fits");
        Object[] cols = this.getSampleCols();
        AsciiTableHDU hdu = (AsciiTableHDU)f.getHDU(1);
        AsciiTable data = (AsciiTable)hdu.getData();
        for (int i = 0; i < data.getNRows(); ++i) {
            Assert.assertEquals((String)("Rows:" + i), (Object)50, (Object)data.getNRows());
            Object[] row = data.getRow(i);
            Assert.assertEquals((String)("Ascii Rows: float" + i), (double)1.0, (double)(((float[])cols[0])[i] / ((float[])row[0])[0]), (double)1.0E-6);
            Assert.assertEquals((String)("Ascii Rows: int" + i), (Object)((int[])cols[1])[i], (Object)((int[])row[1])[0]);
            Assert.assertEquals((String)("Ascii Rows: long" + i), (Object)((long[])cols[2])[i], (Object)((long[])row[2])[0]);
            Assert.assertEquals((String)("Ascii Rows: double" + i), (double)1.0, (double)(((double[])cols[3])[i] / ((double[])row[3])[0]), (double)1.0E-14);
            String[] st = (String[])row[4];
            st[0] = st[0].trim();
            Assert.assertEquals((String)("Ascii Rows: Str" + i), (Object)((String[])cols[4])[i], (Object)((String[])row[4])[0]);
        }
    }

    public void readByColumn() throws Exception {
        Fits f = new Fits("at1.fits");
        AsciiTableHDU hdu = (AsciiTableHDU)f.getHDU(1);
        AsciiTable data = (AsciiTable)hdu.getData();
        Object[] cols = this.getSampleCols();
        Assert.assertEquals((String)"Number of rows", (Object)data.getNRows(), (Object)50);
        Assert.assertEquals((String)"Number of columns", (Object)data.getNCols(), (Object)5);
        for (int j = 0; j < data.getNCols(); ++j) {
            Object col = data.getColumn(j);
            if (j == 4) {
                String[] st = (String[])col;
                for (int i = 0; i < st.length; ++i) {
                    st[i] = st[i].trim();
                }
            }
            Assert.assertEquals((String)("Ascii Columns:" + j), (Object)true, (Object)ArrayFuncs.arrayEquals(cols[j], col, 1.0E-6, 1.0E-14));
        }
    }

    public void readByElement() throws Exception {
        Fits f = new Fits("at2.fits");
        AsciiTableHDU hdu = (AsciiTableHDU)f.getHDU(1);
        AsciiTable data = (AsciiTable)hdu.getData();
        for (int i = 0; i < data.getNRows(); ++i) {
            Object[] row = data.getRow(i);
            for (int j = 0; j < data.getNCols(); ++j) {
                Object val = data.getElement(i, j);
                Assert.assertEquals((String)"Ascii readElement", (Object)true, (Object)ArrayFuncs.arrayEquals(val, row[j]));
            }
        }
    }

    public void modifyTable() throws Exception {
        Fits f = new Fits("at1.fits");
        Object[] samp = this.getSampleCols();
        AsciiTableHDU hdu = (AsciiTableHDU)f.getHDU(1);
        AsciiTable data = (AsciiTable)hdu.getData();
        float[] f1 = (float[])data.getColumn(0);
        float[] f2 = (float[])f1.clone();
        for (int i = 0; i < f2.length; ++i) {
            f2[i] = 2.0f * f2[i];
        }
        data.setColumn(0, f2);
        f1 = new float[]{3.14159f};
        data.setElement(3, 0, f1);
        hdu.setNullString(0, "**INVALID**");
        data.setNull(5, 0, true);
        data.setNull(6, 0, true);
        Object[] row = new Object[]{new float[]{6.28f}, new int[]{22}, new long[]{0L}, new double[]{-3.0}, new String[]{"A string"}};
        data.setRow(5, row);
        data.setElement(4, 2, new long[]{54321L});
        BufferedFile bf = new BufferedFile("at1x.fits", "rw");
        f.write(bf);
        f = new Fits("at1x.fits");
        AsciiTable tab = (AsciiTable)f.getHDU(1).getData();
        Object[] kern = (Object[])tab.getKernel();
        float[] fx = (float[])kern[0];
        int[] ix = (int[])kern[1];
        long[] lx = (long[])kern[2];
        double[] dx = (double[])kern[3];
        String[] sx = (String[])kern[4];
        float[] fy = (float[])samp[0];
        int[] iy = (int[])samp[1];
        long[] ly = (long[])samp[2];
        double[] dy = (double[])samp[3];
        String[] sy = (String[])samp[4];
        Assert.assertEquals((String)"Null", (Object)true, (Object)tab.isNull(6, 0));
        Assert.assertEquals((String)"Null2", (Object)false, (Object)tab.isNull(5, 0));
        for (int i = 0; i < data.getNRows(); ++i) {
            if (i == 5) continue;
            if (i != 6) {
                Assert.assertEquals((String)("f" + i), (double)1.0, (double)(f2[i] / fx[i]), (double)1.0E-6);
            }
            Assert.assertEquals((String)("i" + i), (Object)iy[i], (Object)ix[i]);
            if (i == 4) {
                Assert.assertEquals((String)"l4", (Object)54321L, (Object)lx[i]);
            } else {
                Assert.assertEquals((String)("l" + i), (Object)ly[i], (Object)lx[i]);
            }
            Assert.assertEquals((String)("d" + i), (double)1.0, (double)(dy[i] / dx[i]), (double)1.0E-14);
            Assert.assertEquals((String)("s" + i), (Object)sy[i], (Object)sx[i].trim());
        }
        Object[] r5 = data.getRow(5);
        String[] st = (String[])r5[4];
        st[0] = st[0].trim();
        Assert.assertEquals((String)"row5", (Object)true, (Object)ArrayFuncs.arrayEquals(row, r5, 1.0E-6, 1.0E-14));
    }

    public void delete() throws Exception {
        Fits f = new Fits("at1.fits");
        TableHDU th = (TableHDU)f.getHDU(1);
        Assert.assertEquals((String)"delrBef", (Object)50, (Object)th.getNRows());
        th.deleteRows(2, 2);
        Assert.assertEquals((String)"delrAft", (Object)48, (Object)th.getNRows());
        BufferedFile bf = new BufferedFile("at1y.fits", "rw");
        f.write(bf);
        bf.close();
        f = new Fits("at1y.fits");
        th = (TableHDU)f.getHDU(1);
        Assert.assertEquals((String)"delrAft2", (Object)48, (Object)th.getNRows());
        Assert.assertEquals((String)"delcBef", (Object)5, (Object)th.getNCols());
        th.deleteColumnsIndexZero(3, 2);
        Assert.assertEquals((String)"delcAft1", (Object)3, (Object)th.getNCols());
        th.deleteColumnsIndexZero(0, 2);
        Assert.assertEquals((String)"delcAft2", (Object)1, (Object)th.getNCols());
        bf = new BufferedFile("at1z.fits", "rw");
        f.write(bf);
        bf.close();
        f = new Fits("at1z.fits");
        th = (TableHDU)f.getHDU(1);
        Assert.assertEquals((String)"delcAft3", (Object)1, (Object)th.getNCols());
    }
}

