/*
 * Decompiled with CFR 0.152.
 */
package skyview.ij;

import ij.IJ;
import ij.ImageJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.WindowManager;
import ij.io.FileSaver;
import ij.plugin.ContrastEnhancer;
import ij.plugin.LutLoader;
import ij.plugin.PNG_Writer;
import ij.plugin.RGBStackMerge;
import ij.process.ByteProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageConverter;
import ij.process.ImageProcessor;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.io.DataInputStream;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashSet;
import nom.tam.fits.Header;
import skyview.data.BoxSmoother;
import skyview.data.Contourer;
import skyview.data.Gridder;
import skyview.executive.Settings;
import skyview.geometry.DepthSampler;
import skyview.geometry.Sampler;
import skyview.ij.Drawer;
import skyview.process.Processor;
import skyview.survey.Image;
import skyview.survey.Util;
import skyview.vo.CatalogProcessor;

public class IJProcessor
implements Processor {
    private static ImageStack[] rgb = new ImageStack[3];
    private static ArrayList<ImagePlus> savedImages;
    private static String[] stdLUTs;
    private boolean headless = false;
    private double gridScale = Double.NaN;
    private Gridder grid;
    private ImageProcessor ip;
    private int nx;
    private int ny;
    private BufferedImage bi;
    static IndexColorModel icm;
    private Font userFont;
    private boolean setUserFont = false;
    private HashSet<Color> colorHash;
    private Image output;

    @Override
    public String getName() {
        return "IJProcess";
    }

    @Override
    public String getDescription() {
        return "Do image processing in ImageJ";
    }

    private void processMin(String min) {
        if (min != null) {
            try {
                double fmin = Double.parseDouble(min);
                this.ip.min(fmin);
            }
            catch (Exception e) {
                System.err.println("  Error parsing min value: " + min);
            }
        }
    }

    private void processMax(String max) {
        if (max != null) {
            try {
                double fmax = Double.parseDouble(max);
                this.ip.max(fmax);
            }
            catch (Exception e) {
                System.err.println("  Error parsing max value: " + max);
            }
        }
    }

    private void processScale(String scale) {
        if (scale == null) {
            scale = "log";
        }
        if (((scale = scale.toLowerCase()).equals("log") || scale.equals("sqrt")) && !Settings.has("min")) {
            double zmin = 1.0E20;
            double zmax = -1.0E20;
            double[] data = this.output.getDataArray();
            for (int i = 0; i < data.length; ++i) {
                if (data[i] > 0.0 && data[i] < zmin) {
                    zmin = data[i];
                }
                if (!(data[i] > zmax)) continue;
                zmax = data[i];
            }
            if (zmax / zmin > 100000.0) {
                zmin = zmax / 100000.0;
            }
            this.ip.min(zmin);
        }
        if (scale.equals("log")) {
            this.ip.log();
        } else if (scale.equals("loglog")) {
            double[] data = this.output.getDataArray();
            double min = Double.NaN;
            for (int i = 0; i < data.length; ++i) {
                if (min == min && (min != min || !(data[i] > 0.0) || !(min > data[i]))) continue;
                min = data[i];
            }
            if (min == min) {
                this.ip.multiply(1.01 / min);
                this.ip.log();
                this.ip.log();
            }
        } else if (scale.equals("sqrt")) {
            this.ip.sqrt();
        }
        if (scale.equals("histeq")) {
            ImagePlus imp = new ImagePlus(" ", this.ip);
            new ImageConverter(imp).convertToGray8();
            new ContrastEnhancer().equalize(imp);
            this.ip = imp.getProcessor();
        } else if (Settings.has("min") && Settings.has("max")) {
            this.standardScale(scale);
        }
    }

    private void standardScale(String scale) {
        float mn = Float.parseFloat(Settings.get("min"));
        float mx = Float.parseFloat(Settings.get("max"));
        if (mx <= mn) {
            System.err.println("Scaling has Max < Min");
        }
        if (scale.equals("sqrt")) {
            mn = (float)Math.sqrt(mn);
            mx = (float)Math.sqrt(mx);
        } else if (scale.equals("log")) {
            mn = (float)Math.log(mn);
            mx = (float)Math.log(mx);
        }
        float delta = (mx - mn) / 256.0f;
        float[] data = (float[])this.ip.getPixels();
        for (int i = 0; i < data.length; ++i) {
            data[i] = (data[i] - mn) / delta;
        }
        this.ip.setPixels(data);
        this.ip = this.ip.convertToByte(false);
    }

    ImageProcessor getImageProcessor() {
        return this.ip;
    }

    private void processCatalog(String catalog) {
        int i;
        if (catalog == null) {
            return;
        }
        boolean labels = Settings.has("CatalogIDs");
        CatalogProcessor cp = CatalogProcessor.getLastProcessor();
        double[][] pixels = cp.getPixels();
        int[] symbols = cp.getSymbols();
        for (i = 0; i < pixels.length; ++i) {
            this.drawSymbol(pixels[i][0], (double)this.ny - pixels[i][1], symbols[i]);
        }
        if (labels) {
            for (i = 0; i < pixels.length; ++i) {
                this.ip.addPlotString("" + (i + 1), pixels[i][0] - 3.0 + 0.5, (double)this.ny - pixels[i][1] - 3.0, 0.0);
            }
        }
    }

    private void processContour(String contourStr) {
        if (contourStr == null) {
            return;
        }
        String[] contours = Settings.getArray("contour");
        for (int i = 0; i < contours.length; ++i) {
            if (contours[i] == null || contours[i].length() == 0) continue;
            String[] flds = contours[i].split(":");
            String survey = flds[0];
            Contourer cntr = new Contourer();
            int nContour = 4;
            String contourScale = "Log";
            double[] range = null;
            if (survey.toLowerCase().equals(Settings.get("_currentSurvey").toLowerCase())) {
                cntr.putImage(this.output);
            } else if (!cntr.getData(survey)) continue;
            if (flds.length > 1) {
                contourScale = flds[1];
            }
            cntr.setFunction(contourScale);
            if (flds.length > 2) {
                try {
                    nContour = Integer.parseInt(flds[2]);
                }
                catch (Exception e) {
                    System.err.println("  Error parsing nContour:" + flds[2] + " using default");
                }
            }
            if (flds.length > 4) {
                try {
                    double mn = Double.parseDouble(flds[3]);
                    double mx = Double.parseDouble(flds[4]);
                    range = new double[]{mn, mx};
                }
                catch (Exception e) {
                    System.err.println("  Error parsing range values:" + flds[3] + " - " + flds[4]);
                }
            }
            double delta = 1.0;
            if (range == null) {
                delta = 0.8;
                range = cntr.getRange();
            }
            cntr.setLimits((double)range[0], range[1], nContour, delta);
            int[] overlay = cntr.contour();
            for (int j = 0; j < overlay.length; ++j) {
                if (overlay[j] == 0) continue;
                int x = j % this.nx;
                int y = j / this.nx;
                this.ip.drawPixel(x, this.ny - y);
            }
        }
    }

    private void processGrid(String gridStr) {
        if (gridStr != null) {
            try {
                if (this.output.getWCS().getScale() != this.gridScale) {
                    if (gridStr.equals("1")) {
                        gridStr = null;
                    }
                    this.grid = new Gridder(this.output, gridStr);
                    this.grid.grid();
                    this.gridScale = this.output.getWCS().getScale();
                }
                double[][][] lines = this.grid.getLines();
                for (int i = 0; i < lines.length; ++i) {
                    double[][] line = lines[i];
                    for (int j = 1; j < line.length; ++j) {
                        double[] p0 = line[j - 1];
                        double[] p1 = line[j];
                        this.drawLine(p0[0], (double)this.ny - p0[1], p1[0], (double)this.ny - p1[1]);
                    }
                }
                if (Settings.has("GridLabels")) {
                    String[] labels = this.grid.getLabels();
                    for (int i = 0; i < labels.length; ++i) {
                        double[][] line;
                        if (labels[i] == null || (line = lines[i]).length < 4) continue;
                        double len = 0.0;
                        for (int j = 1; j < line.length; ++j) {
                            len += Math.abs(line[j][0] - line[j - 1][0]) + Math.abs(line[j][1] - line[j - 1][1]);
                        }
                        if (len < 30.0) continue;
                        int p = (int)(0.3 * (double)lines[i].length);
                        double angle = Math.atan2(-line[p][1] + line[p - 1][1], line[p][0] - line[p - 1][0]);
                        if (angle > 1.5707963267948966) {
                            angle -= Math.PI;
                        } else if (angle < -1.5707963267948966) {
                            angle += Math.PI;
                        }
                        this.plotString(labels[i], line[p][0], line[p][1], angle);
                    }
                }
            }
            catch (Exception e) {
                System.err.println("  Error gridding image:" + e);
                e.printStackTrace();
            }
        }
    }

    void plotString(String label, double x, double y, double angle) {
        double sa = Math.sin(angle);
        double ca = Math.cos(angle);
        this.ip.addPlotString(label, x + 3.0 * sa + 0.5, (double)this.ny - (y + ca + 0.5), angle);
    }

    private boolean processRGB(String rgbStr, String outStem, int index) {
        if (rgbStr != null) {
            int i;
            float[] pix;
            if (Settings.has("rgboffset")) {
                try {
                    String[] offset = Settings.getArray("rgboffset");
                    if (offset.length > index) {
                        float off = Float.parseFloat(offset[index]);
                        pix = (float[])this.ip.getPixels();
                        i = 0;
                        while (i < pix.length) {
                            int n = i++;
                            pix[n] = pix[n] + off;
                        }
                        this.ip.setPixels(pix);
                    }
                }
                catch (Exception e) {
                    System.err.println("  Unable to parse rgboffset:" + Settings.get("rgboffset"));
                }
            }
            if (Settings.has("rgbscale")) {
                try {
                    String[] scales = Settings.getArray("rgbscales");
                    if (scales.length > index) {
                        float scale = Float.parseFloat(scales[index]);
                        pix = (float[])this.ip.getPixels();
                        i = 0;
                        while (i < pix.length) {
                            int n = i++;
                            pix[n] = pix[n] * scale;
                        }
                        this.ip.setPixels(pix);
                    }
                }
                catch (Exception e) {
                    System.err.println("  Unable to parse rgbscale:" + Settings.get("rgbscale"));
                }
            }
            if (index < 3) {
                String[] surveys = Settings.getArray("survey");
                IJProcessor.rgb[index] = new ImagePlus(surveys[index], this.ip).getStack();
                if (index == 2 || index == surveys.length - 1) {
                    RGBStackMerge rsm = new RGBStackMerge();
                    ImageStack is = rsm.mergeStacks(this.output.getWidth(), this.output.getHeight(), 1, rgb[0], rgb[1], rgb[2], true);
                    ImagePlus imp = new ImagePlus("rgb", is);
                    if (Settings.has("quicklook")) {
                        String filename = outStem.substring(0, outStem.length() - 1) + "rgb.jpg";
                        new FileSaver(imp).saveAsJpeg(filename);
                        System.err.println("  Writing 3-color image: " + filename);
                    }
                    if (Settings.has("imagej")) {
                        this.showImp(imp);
                    }
                }
            }
            return true;
        }
        return false;
    }

    void setColor(String colorString) {
        this.ip.plotStrings();
        Color col = this.getColor(colorString);
        if (col != null) {
            if (this.colorHash == null) {
                this.colorHash = new HashSet();
            }
            if (!this.colorHash.contains(col)) {
                this.ip.addColor(col, 255 - this.colorHash.size());
                this.colorHash.add(col);
            }
            this.ip.setColor(col);
        } else {
            System.err.println("  Unknown plot color specified:" + Settings.get("plotcolor"));
        }
    }

    @Override
    public void process(Image[] inputs, Image output, int[] source, Sampler samp, DepthSampler dsamp) {
        String[] smoothings;
        if (output == null) {
            return;
        }
        double[] img = output.getDataArray();
        this.nx = output.getWidth();
        this.ny = output.getHeight();
        int nz = output.getDepth();
        if (nz > 1) {
            int len = this.nx * this.ny;
            double[] ximg = new double[this.nx * this.ny];
            for (int p = 0; p < ximg.length; ++p) {
                for (int z = 0; z < nz; ++z) {
                    int n = p;
                    ximg[n] = ximg[n] + img[len * z + p];
                }
            }
            img = ximg;
        }
        this.output = output;
        this.setUserFont = false;
        if (Settings.has("plotfontsize")) {
            try {
                if (this.userFont == null) {
                    this.userFont = new Font("SansSerif", 0, Integer.parseInt(Settings.get("plotfontsize")));
                    this.setUserFont = true;
                }
            }
            catch (Exception e) {
                System.err.println("  Warning: Unable to set font to size " + Settings.get("plotfontsize"));
            }
        }
        String out = Settings.get("output");
        String indexStr = Settings.get("_surveycount");
        int index = 0;
        index = indexStr == null ? 0 : Integer.parseInt(indexStr) - 1;
        if (Settings.has("rgbsmooth") && (smoothings = Settings.getArray("rgbsmooth")).length >= index) {
            img = this.imgSmooth(img, smoothings[index]);
        }
        this.ip = new FloatProcessor(output.getWidth(), output.getHeight(), img);
        this.ip.flipVertical();
        this.processMin(Settings.get("min"));
        this.processMax(Settings.get("max"));
        if (Settings.has("scaling")) {
            int scount = 1;
            try {
                scount = Integer.parseInt(Settings.get("_surveycount"));
            }
            catch (Exception e) {
                // empty catch block
            }
            String[] sarr = Settings.getArray("scaling");
            if (sarr.length > 0) {
                this.processScale(sarr[(scount - 1) % sarr.length]);
            } else {
                this.processScale(null);
            }
        } else {
            this.processScale(null);
        }
        ImagePlus imp = new ImagePlus("", this.ip);
        new ImageConverter(imp).convertToGray8();
        this.ip = imp.getProcessor();
        this.ip.setValue(255.0);
        this.processLUT(Settings.get("lut"));
        if (Settings.has("invert")) {
            this.ip.invertLut();
        }
        if (Settings.has("plotcolor")) {
            this.setColor(Settings.get("plotcolor"));
        }
        if (this.setUserFont) {
            this.ip.setFont(this.userFont);
        }
        this.processContour(Settings.get("contour"));
        this.processCatalog(Settings.get("catalog"));
        this.processGrid(Settings.get("grid"));
        if (Settings.has("Annotations") || Settings.has("Draw") || Settings.has("DrawFile")) {
            Drawer ld = new Drawer(this, this.nx, this.ny, output.getWCS());
            if (Settings.has("Annotations")) {
                for (String file : Settings.getArray("Annotations")) {
                    ld.reset();
                    ld.drawFile(file);
                }
            }
            if (Settings.has("DrawFile")) {
                for (String file : Settings.getArray("DrawFile")) {
                    ld.reset();
                    ld.drawCommands();
                    ld.drawFile(file);
                }
            } else {
                ld.reset();
                ld.drawCommands();
            }
        }
        this.ip.plotStrings();
        if (this.processRGB(Settings.get("rgb"), out, index)) {
            return;
        }
        if (Settings.has("quicklook")) {
            this.writeFile(out, index);
        }
        if (Settings.has("imagej")) {
            String sname = Settings.getArray("survey")[index];
            imp = new ImagePlus(sname, this.ip);
            this.showImp(imp);
        }
    }

    private Color getColor(String color) {
        try {
            Field fld = Color.class.getField(color.toUpperCase());
            if (fld != null) {
                return (Color)fld.get(null);
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    private void showImp(ImagePlus imp) {
        if (imp == null) {
            return;
        }
        if (IJ.getInstance() == null) {
            ImageJ ij = new ImageJ();
            ij.setExitWhenQuitting(true);
        }
        imp.show();
    }

    private void writeFile(String outStem, int index) {
        String sname = Settings.getArray("survey")[index];
        ImagePlus imp1 = new ImagePlus(sname, this.ip);
        String format = Settings.get("quicklook");
        if (format == null || format.length() == 0) {
            if (Settings.has("rgb")) {
                return;
            }
            format = "jpeg";
        }
        if ((format = format.toLowerCase()).equals("object")) {
            if (savedImages == null) {
                savedImages = new ArrayList();
            }
            savedImages.add(imp1);
        } else if (format.equals("gif")) {
            this.ip = this.ip.convertToByte(true);
            new FileSaver(imp1).saveAsGif(outStem + ".gif");
            System.err.println("  Creating quicklook image: " + outStem + ".gif");
        } else if (format.equals("jpeg") || format.equals("jpg")) {
            String file = outStem;
            if (!file.equals("-")) {
                file = file + ".jpg";
            }
            new FileSaver(imp1).saveAsJpeg(file);
            System.err.println("  Creating quicklook image: " + file);
        } else if (format.equals("bmp")) {
            new FileSaver(imp1).saveAsBmp(outStem + ".bmp");
            System.err.println("  Creating quicklook image: " + outStem + ".bmp");
        } else if (format.equals("tiff")) {
            new FileSaver(imp1).saveAsTiff(outStem + ".tiff");
            System.err.println("  Creating quicklook image: " + outStem + ".tiff");
        } else if (format.equals("png")) {
            try {
                new PNG_Writer().writeImage(imp1, outStem + ".png");
                System.err.println("  Creating quicklook image: " + outStem + ".png");
            }
            catch (Exception e) {
                System.err.println("  Error creating PNG: " + outStem + ".png\nException: " + e);
            }
        } else {
            System.err.println("  Error: Unrecognized quicklook format: " + format);
        }
    }

    @Override
    public void updateHeader(Header header) {
    }

    private void processLUT(String origLUT) {
        if (origLUT == null) {
            return;
        }
        String lut = origLUT.toLowerCase();
        for (int i = 0; i < stdLUTs.length; ++i) {
            if (!stdLUTs[i].equals(lut)) continue;
            WindowManager.setTempCurrentImage(new ImagePlus(" ", this.ip));
            if (lut.equals("3-3-2 rgb")) {
                lut = "3-3-2 RGB";
            }
            new LutLoader().run(lut);
            return;
        }
        byte[] red = new byte[256];
        byte[] green = new byte[256];
        byte[] blue = new byte[256];
        try {
            InputStream is = Util.getResourceOrFile(lut);
            if (is == null && !lut.equals(origLUT)) {
                is = Util.getResourceOrFile(origLUT);
            }
            if (is == null) {
                System.err.println("  Error: Unable to find LUT " + origLUT);
                return;
            }
            DataInputStream dis = new DataInputStream(is);
            dis.readFully(red);
            dis.readFully(green);
            dis.readFully(blue);
            dis.close();
            dis = null;
        }
        catch (Exception e) {
            System.err.println("  Error trying to open/read LUT: " + origLUT + ". " + e);
            return;
        }
        IndexColorModel cm = new IndexColorModel(8, 256, red, green, blue);
        this.ip.setColorModel(cm);
    }

    void drawSymbol(double x, double y, int symbol) {
        double scale = 1.0;
        if (Settings.has("plotscale")) {
            try {
                scale = Double.parseDouble(Settings.get("plotscale"));
            }
            catch (Exception e) {
                System.err.println("  Warning: Unable to change plot scale to " + Settings.get("plotscale"));
            }
        }
        if ((symbol %= 5) == 0) {
            this.drawLine(x - 2.0 * scale, y, x + 2.0 * scale, y);
            this.drawLine(x, y - 2.0 * scale, x, y + 2.0 * scale);
        } else if (symbol == 1) {
            this.drawLine(x - 2.0 * scale, y - 2.0 * scale, x + 2.0 * scale, y + 2.0 * scale);
            this.drawLine(x + 2.0 * scale, y - 2.0 * scale, x - 2.0 * scale, y + 2.0 * scale);
        } else if (symbol == 2) {
            this.drawLine(x - scale, y + scale, x + scale, y + scale);
            this.drawLine(x + scale, y + scale, x, y - scale);
            this.drawLine(x, y - scale, x - scale, y + scale);
        } else if (symbol == 3) {
            this.drawLine(x - scale, y - scale, x + scale, y - scale);
            this.drawLine(x + scale, y - scale, x + scale, y + scale);
            this.drawLine(x + scale, y + scale, x - scale, y + scale);
            this.drawLine(x - scale, y + scale, x - scale, y - scale);
        } else if (symbol == 4) {
            this.drawLine(x + scale, y, x, y + scale);
            this.drawLine(x, y + scale, x - scale, y);
            this.drawLine(x - scale, y, x, y - scale);
            this.drawLine(x, y - scale, x + scale, y);
        }
    }

    void drawLine(double x0, double y0, double x1, double y1) {
        int ix0 = (int)(x0 + 0.5);
        int ix1 = (int)(x1 + 0.5);
        int iy0 = (int)(y0 + 0.5);
        int iy1 = (int)(y1 + 0.5);
        this.ip.drawLine(ix0, iy0, ix1, iy1);
    }

    private Graphics getGraphics() {
        if (!(this.ip instanceof ByteProcessor)) {
            ImagePlus imp = new ImagePlus("", this.ip);
            new ImageConverter(imp).convertToGray8();
            this.ip = imp.getProcessor();
        }
        byte[] pixels = (byte[])this.ip.getPixels();
        this.bi = new BufferedImage(this.nx, this.ny, 13, icm);
        int[] buf = new int[this.nx];
        for (int i = 0; i < this.ny; ++i) {
            for (int j = 0; j < this.nx; ++j) {
                int a = pixels[i * this.nx + j] & 0xFF;
                buf[j] = 0xFF000000 | a << 16 | a << 8 | a;
            }
            this.bi.setRGB(0, i, this.nx, 1, buf, 0, this.nx);
        }
        return this.bi.getGraphics();
    }

    private double[] imgSmooth(double[] img, String smooth) {
        double[] ximg = (double[])img.clone();
        try {
            int n = Integer.parseInt(smooth);
            BoxSmoother.smooth(ximg, this.nx, this.ny, 1, n, n);
        }
        catch (Exception e) {
            System.err.println("  Error in quicklook postprocessing smoothing");
        }
        return ximg;
    }

    public static ArrayList<ImagePlus> getSavedImages() {
        return savedImages;
    }

    static {
        stdLUTs = new String[]{"fire", "grays", "ice", "spectrum", "3-3-2 rgb", "red", "green", "cyan", "magenta", "yellow", "red/green"};
        byte[] r = new byte[256];
        for (int i = 0; i < r.length; ++i) {
            r[i] = (byte)i;
        }
        icm = new IndexColorModel(8, 256, r, r, r);
    }
}

