/*
 * Decompiled with CFR 0.152.
 */
package skyview.survey;

import nom.tam.fits.Header;
import skyview.executive.Settings;
import skyview.geometry.Position;
import skyview.survey.FitsImage;
import skyview.survey.Image;
import skyview.survey.Survey;

public class UserSurvey
implements Survey {
    private String[] files = Settings.getArray("userfile");

    @Override
    public String getName() {
        return "UserSurvey";
    }

    @Override
    public String getDescription() {
        return "A survey comprised of a set of user specified files.";
    }

    @Override
    public void updateSettings() {
    }

    @Override
    public void updateHeader(Header fitsHeader) {
        try {
            fitsHeader.insertHistory("");
            fitsHeader.insertHistory("User defined survey comprised of the files:");
            for (int i = 0; i < this.files.length; ++i) {
                fitsHeader.insertHistory("   " + this.files[i]);
            }
            fitsHeader.insertHistory("");
        }
        catch (Exception e) {
            System.err.println("Error updating header in UserSurvey:" + e);
        }
    }

    @Override
    public Image[] getImages(Position pos, double size) {
        if (this.files == null) {
            throw new Error("Attempt to invoke User survey without specifying constituent files");
        }
        Image[] userImages = new FitsImage[this.files.length];
        for (int i = 0; i < this.files.length; ++i) {
            try {
                userImages[i] = new FitsImage(this.files[i]);
                continue;
            }
            catch (Exception e) {
                System.err.println("Unable to read user image:" + this.files[i] + "\n" + e);
                e.printStackTrace();
                throw new Error("Unreadable user image");
            }
        }
        return userImages;
    }
}

