/*
 * Decompiled with CFR 0.152.
 */
package jsky.util;

import gnu.jel.CompiledExpression;
import gnu.jel.DVMap;
import gnu.jel.Evaluator;
import gnu.jel.Library;
import java.util.ArrayList;
import java.util.List;

public class JavaExpr
extends DVMap {
    private CompiledExpression _expr;
    private Object[] _context = new Object[1];
    private List<VarValue> _vars = new ArrayList<VarValue>();
    private int _numVars = 0;
    private static final Class[] _stLib = new Class[]{Math.class};
    private Class[] _dynLib = new Class[]{JavaExpr.class};

    public JavaExpr(String exprStr) throws Throwable {
        Library lib = new Library(_stLib, this._dynLib, null, (DVMap)this, null);
        this._context[0] = this;
        this._expr = Evaluator.compile((String)exprStr, (Library)lib);
    }

    public JavaExpr(String exprStr, DVMap resolver) throws Throwable {
        this._dynLib[0] = resolver.getClass();
        Library lib = new Library(_stLib, this._dynLib, null, resolver, null);
        this._context[0] = resolver;
        this._expr = Evaluator.compile((String)exprStr, (Library)lib);
    }

    public String getTypeName(String name) {
        return "Double";
    }

    public double getDoubleProperty(String name) {
        for (int i = 0; i < this._numVars; ++i) {
            VarValue v = this._vars.get(i);
            if (!v.name.equals(name)) continue;
            return v.value;
        }
        return 0.0;
    }

    public void setVar(String name, double value) {
        for (int i = 0; i < this._numVars; ++i) {
            VarValue v = this._vars.get(i);
            if (!v.name.equals(name)) continue;
            v.value = value;
            return;
        }
        this._vars.add(new VarValue(name, value));
        ++this._numVars;
    }

    public double eval() throws Throwable {
        return this._expr.evaluate_double(this._context);
    }

    public boolean evalBoolean() throws Throwable {
        return this._expr.evaluate_boolean(this._context);
    }

    public Object evalObject() throws Throwable {
        return this._expr.evaluate(this._context);
    }

    public static void main(String[] args) {
        try {
            String exprStr = "$XYZ*2";
            JavaExpr expr = new JavaExpr(exprStr);
            double x = 10.1;
            expr.setVar("$XYZ", x);
            System.out.println("$XYZ = " + x + ", " + exprStr + " = " + expr.eval());
            x = 20.0;
            expr.setVar("$XYZ", x);
            System.out.println("$XYZ = " + x + ", " + exprStr + " = " + expr.eval());
            expr = new JavaExpr("22.0");
            System.out.println("eval 22.0 = " + expr.eval());
            expr = new JavaExpr("123456789");
            System.out.println("eval 123456789 = " + expr.eval());
            Object o = expr.evalObject();
            System.out.println("evalObject 123456789 = " + o + ": " + o.getClass());
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    class VarValue {
        public String name;
        public double value;

        public VarValue(String s, double v) {
            this.name = s;
            this.value = v;
        }
    }
}

