/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot;

import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import uk.ac.starlink.ttools.plot.AxisLabels;

public class AxisLabeller {
    private double lo_;
    private double hi_;
    private int npix_;
    private int loPad_;
    private int hiPad_;
    private boolean log_;
    private boolean flip_;
    private TickLabel[] tickLabels_;
    private String axisLabel_;
    private FontMetrics fm_;
    private TickStyle tickStyle_;
    private int reqTick_;
    private int maxHeight_;
    private boolean drawText_ = true;
    public static final TickStyle X;
    public static final TickStyle Y;
    public static final TickStyle ANTI_Y;
    static final /* synthetic */ boolean $assertionsDisabled;

    public AxisLabeller(String axisLabel, double lo, double hi, int npix, boolean log, boolean flip, FontMetrics fm, TickStyle tickStyle, int reqTick, int loPad, int hiPad) {
        this.axisLabel_ = axisLabel;
        this.lo_ = lo;
        this.hi_ = hi;
        this.npix_ = npix;
        this.log_ = log;
        this.flip_ = flip;
        this.fm_ = fm;
        this.tickStyle_ = tickStyle;
        this.reqTick_ = reqTick;
        this.loPad_ = loPad;
        this.hiPad_ = hiPad;
        this.configure();
    }

    private void configure() {
        TickLabel[] labels = null;
        int maxh = 0;
        block0: for (int mTick = this.reqTick_; labels == null && mTick > 0; --mTick) {
            AxisLabels axer = this.log_ ? AxisLabels.labelLogAxis(this.lo_, this.hi_, mTick) : AxisLabels.labelLinearAxis(this.lo_, this.hi_, mTick);
            int nTick = axer.getCount();
            labels = new TickLabel[nTick];
            Rectangle lastBounds = null;
            for (int iTick = 0; iTick < nTick; ++iTick) {
                Rectangle r2;
                Rectangle r1;
                int pos = this.getTickPosition(axer.getTick(iTick));
                String text = axer.getLabel(iTick);
                labels[iTick] = new TickLabel(pos, text);
                Rectangle bounds = this.tickStyle_.getBounds(this.fm_, pos, 0, text);
                maxh = Math.max(maxh, bounds.height);
                if (iTick > 0 && (r1 = new Rectangle(bounds.x, bounds.y, (int)((double)bounds.width * 1.4), (int)((double)bounds.height * 1.4))).intersects(r2 = new Rectangle(lastBounds.x, lastBounds.y, (int)((double)lastBounds.width * 1.4), (int)((double)lastBounds.height * 1.4)))) {
                    labels = null;
                    continue block0;
                }
                lastBounds = bounds;
            }
        }
        if (!$assertionsDisabled && labels == null) {
            throw new AssertionError();
        }
        this.tickLabels_ = labels;
        this.maxHeight_ = maxh;
    }

    public int getAnnotationHeight() {
        int h = this.maxHeight_;
        if (this.axisLabel_ != null && this.axisLabel_.trim().length() > 0) {
            h += this.fm_.getHeight() + this.fm_.getDescent();
        }
        return h;
    }

    public int getNpix() {
        return this.npix_;
    }

    public void setNpix(int npix) {
        if (npix != this.npix_) {
            this.npix_ = npix;
            this.configure();
        }
    }

    public void annotateAxis(Graphics g) {
        if (this.drawText_ && this.axisLabel_ != null && this.axisLabel_.trim().length() > 0) {
            g.drawString(this.axisLabel_, (this.npix_ - this.fm_.stringWidth(this.axisLabel_)) / 2, this.tickStyle_.isDown() ? this.maxHeight_ + this.fm_.getHeight() : -this.maxHeight_ - this.fm_.getDescent());
        }
        for (int i = 0; i < this.tickLabels_.length; ++i) {
            int tpos = this.tickLabels_[i].pos_;
            String ttext = this.tickLabels_[i].text_;
            g.drawLine(tpos, -2, tpos, 2);
            if (!this.drawText_) continue;
            Rectangle bounds = this.tickStyle_.getBounds(this.fm_, tpos, 0, ttext);
            if (bounds.x < 0 - this.loPad_ || bounds.x + bounds.width > this.npix_ + this.hiPad_) continue;
            this.tickStyle_.drawString(g, this.fm_, tpos, 0, ttext);
        }
    }

    public void drawGridLines(Graphics g, int y0, int y1) {
        for (int i = 0; i < this.tickLabels_.length; ++i) {
            int tpos = this.tickLabels_[i].pos_;
            g.drawLine(tpos, y0, tpos, y1);
        }
    }

    public void drawGridLine(Graphics g, int y0, int y1, double value) {
        if (value >= this.lo_ && value <= this.hi_) {
            int tpos = this.getTickPosition(value);
            g.drawLine(tpos, y0, tpos, y1);
        }
    }

    public void setTickStyle(TickStyle tickStyle) {
        this.tickStyle_ = tickStyle;
    }

    public void setDrawText(boolean drawText) {
        this.drawText_ = drawText;
    }

    private int getTickPosition(double tick) {
        double frac = this.log_ ? Math.log(tick / this.lo_) / Math.log(this.hi_ / this.lo_) : (tick - this.lo_) / (this.hi_ - this.lo_);
        return (int)Math.round((double)this.npix_ * (this.flip_ ? 1.0 - frac : frac));
    }

    static {
        $assertionsDisabled = !AxisLabeller.class.desiredAssertionStatus();
        X = new TickStyle(){

            void drawString(Graphics g, FontMetrics fm, int x, int y, String label) {
                g.drawString(label, x - fm.stringWidth(label) / 2, y + fm.getHeight());
            }

            Rectangle getBounds(FontMetrics fm, int x, int y, String label) {
                int w = fm.stringWidth(label);
                int h = fm.getHeight();
                return new Rectangle(x - w / 2, y, w, h);
            }

            boolean isDown() {
                return true;
            }
        };
        Y = new TickStyle(){

            void drawString(Graphics g, FontMetrics fm, int x, int y, String label) {
                Graphics2D g2 = (Graphics2D)g.create();
                g2.translate(x, y);
                g2.rotate(1.5707963267948966);
                g2.drawString(label, -fm.stringWidth(label + "0"), fm.getAscent() / 2);
            }

            Rectangle getBounds(FontMetrics fm, int x, int y, String label) {
                int w = fm.stringWidth(label + "0");
                int h = fm.getHeight();
                return new Rectangle(x - h / 2, -y - w, h, w);
            }

            boolean isDown() {
                return false;
            }
        };
        ANTI_Y = new TickStyle(){

            void drawString(Graphics g, FontMetrics fm, int x, int y, String label) {
                Graphics2D g2 = (Graphics2D)g.create();
                g2.translate(x, y);
                g2.rotate(-1.5707963267948966);
                g2.drawString(label, fm.charWidth('0') / 2, fm.getAscent() / 2);
            }

            Rectangle getBounds(FontMetrics fm, int x, int y, String label) {
                int w = fm.stringWidth(label) + fm.charWidth('0') / 2;
                int h = fm.getHeight();
                return new Rectangle(x - h / 2, y - w, h, w);
            }

            boolean isDown() {
                return false;
            }
        };
    }

    private static class TickLabel {
        final int pos_;
        final String text_;

        TickLabel(int pos, String text) {
            this.pos_ = pos;
            this.text_ = text;
        }
    }

    public static abstract class TickStyle {
        private TickStyle() {
        }

        abstract void drawString(Graphics var1, FontMetrics var2, int var3, int var4, String var5);

        abstract Rectangle getBounds(FontMetrics var1, int var2, int var3, String var4);

        abstract boolean isDown();
    }
}

