/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.giop;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.jacorb.config.Configurable;
import org.jacorb.config.Configuration;
import org.jacorb.config.ConfigurationException;
import org.jacorb.orb.CDRInputStream;
import org.jacorb.orb.CodeSet;
import org.jacorb.orb.ORB;
import org.jacorb.orb.ParsedIOR;
import org.jacorb.orb.SystemExceptionHelper;
import org.jacorb.orb.acs.AcsORBProfiler;
import org.jacorb.orb.dsi.ServerRequest;
import org.jacorb.orb.giop.GIOPConnection;
import org.jacorb.orb.giop.LocateReplyOutputStream;
import org.jacorb.orb.giop.Messages;
import org.jacorb.orb.giop.ReplyOutputStream;
import org.jacorb.orb.giop.RequestInputStream;
import org.jacorb.orb.giop.RequestListener;
import org.jacorb.poa.GOA;
import org.jacorb.poa.POA;
import org.jacorb.poa.except.POAInternalError;
import org.jacorb.poa.except.ParentIsHolding;
import org.jacorb.poa.util.POAUtil;
import org.omg.CONV_FRAME.CodeSetContext;
import org.omg.CONV_FRAME.CodeSetContextHelper;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.NO_PERMISSION;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TRANSIENT;
import org.omg.CORBA.UNKNOWN;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.OutputStream;
import org.omg.GIOP.ReplyStatusType_1_2;
import org.omg.PortableGroup.TagGroupTaggedComponent;
import org.omg.PortableServer.POAPackage.WrongAdapter;
import org.slf4j.Logger;

public class ServerRequestListener
implements RequestListener,
Configurable {
    private final ORB orb;
    private final POA rootPOA;
    private Configuration configuration = null;
    private Logger logger = null;
    private boolean require_ssl = false;

    public ServerRequestListener(ORB orb, POA rootPOA) {
        this.orb = orb;
        this.rootPOA = rootPOA;
    }

    @Override
    public void configure(Configuration configuration) throws ConfigurationException {
        this.configuration = configuration;
        this.logger = configuration.getLogger("org.jacorb.giop.server.listener");
        boolean supportSSL = configuration.getAttributeAsBoolean("jacorb.security.support_ssl", false);
        if (supportSSL) {
            int required = configuration.getAttributeAsInteger("jacorb.security.ssl.server.required_options", 16, 16);
            this.require_ssl = supportSSL && (required & 0x60) != 0;
        }
    }

    @Override
    public void requestReceived(byte[] request, GIOPConnection connection) {
        LocateReplyOutputStream lr_out;
        RequestInputStream inputStream = new RequestInputStream((org.omg.CORBA.ORB)this.orb, connection, request);
        if (this.require_ssl && !connection.isSSL()) {
            ReplyOutputStream out = new ReplyOutputStream((org.omg.CORBA.ORB)this.orb, inputStream.req_hdr.request_id, ReplyStatusType_1_2.SYSTEM_EXCEPTION, inputStream.getGIOPMinor(), false, this.logger);
            this.logger.debug("About to reject request because connection is not SSL.");
            SystemExceptionHelper.write((OutputStream)out, (SystemException)((java.lang.Object)new NO_PERMISSION(3, CompletionStatus.COMPLETED_NO)));
            try {
                connection.sendReply(out);
            }
            catch (IOException e) {
                this.logger.warn("IOException", (Throwable)e);
            }
            return;
        }
        if (Messages.responseExpected(inputStream.req_hdr.response_flags)) {
            connection.incPendingMessages();
        }
        if (!connection.isTCSNegotiated()) {
            if (inputStream.getGIOPMinor() == 0) {
                connection.markTCSNegotiated();
            } else {
                CodeSetContext ctx = null;
                for (int i = 0; i < inputStream.req_hdr.service_context.length; ++i) {
                    if (inputStream.req_hdr.service_context[i].context_id != 1) continue;
                    CDRInputStream is = new CDRInputStream(inputStream.req_hdr.service_context[i].context_data);
                    is.openEncapsulatedArray();
                    ctx = CodeSetContextHelper.read((InputStream)is);
                }
                if (ctx != null) {
                    connection.setCodeSets(ctx.char_data, ctx.wchar_data);
                    connection.markTCSNegotiated();
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Received CodeSetContext. Using " + CodeSet.csName(ctx.char_data) + " as TCS and " + CodeSet.csName(ctx.wchar_data) + " as TCSW");
                    }
                }
            }
        }
        inputStream.setCodeSet(connection.getTCS(), connection.getTCSW());
        inputStream.updateMutatorConnection(connection);
        ServerRequest server_request = null;
        try {
            server_request = new ServerRequest(this.orb, inputStream, connection);
        }
        catch (POAInternalError pie) {
            if (this.configuration.getORB().getAcsORBProfiler() != null) {
                try {
                    this.configuration.getORB().getAcsORBProfiler().undeliveredRequest(request.length, null, null, false);
                }
                catch (Throwable thr) {
                    thr.printStackTrace();
                }
            }
            this.logger.warn("Received a request with a non-jacorb object key");
            if (inputStream.isLocateRequest()) {
                lr_out = new LocateReplyOutputStream((org.omg.CORBA.ORB)this.orb, inputStream.req_hdr.request_id, 0, inputStream.getGIOPMinor());
                try {
                    connection.sendReply(lr_out);
                }
                catch (IOException e) {
                    this.logger.warn("IOException", (Throwable)e);
                }
            } else {
                ReplyOutputStream out = new ReplyOutputStream((org.omg.CORBA.ORB)this.orb, inputStream.req_hdr.request_id, ReplyStatusType_1_2.SYSTEM_EXCEPTION, inputStream.getGIOPMinor(), false, this.logger);
                try {
                    SystemExceptionHelper.write((OutputStream)out, (SystemException)((java.lang.Object)new OBJECT_NOT_EXIST(1330446338, CompletionStatus.COMPLETED_NO)));
                    connection.sendReply(out);
                }
                catch (IOException e) {
                    this.logger.warn("unexpected exception during requestReceived", (Throwable)e);
                }
            }
            return;
        }
        if (inputStream.isLocateRequest() && !Arrays.equals(server_request.objectKey(), ParsedIOR.extractObjectKey(inputStream.req_hdr.target, this.orb))) {
            Object fwd = this.orb.getReference(this.orb.getRootPOA(), server_request.objectKey(), null, true);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Sending locate reply with object forward to " + this.orb.object_to_string(fwd));
            }
            lr_out = new LocateReplyOutputStream((org.omg.CORBA.ORB)this.orb, inputStream.req_hdr.request_id, 2, inputStream.getGIOPMinor());
            lr_out.write_Object(fwd);
            try {
                connection.sendReply(lr_out);
            }
            catch (IOException e) {
                this.logger.warn("IOException", (Throwable)e);
            }
            fwd._release();
            return;
        }
        this.deliverRequest(server_request);
    }

    @Override
    public void locateRequestReceived(byte[] request, GIOPConnection connection) {
        this.requestReceived(request, connection);
    }

    @Override
    public void cancelRequestReceived(byte[] request, GIOPConnection connection) {
    }

    private void deliverRequest(ServerRequest request) {
        POA tmp_poa = this.rootPOA;
        TagGroupTaggedComponent tagGroup = request.getTagGroup();
        if (tagGroup != null) {
            ((GOA)this.rootPOA).processGroupRequest(tagGroup, request);
            return;
        }
        try {
            String res;
            String refImplName = "";
            String orbImplName = this.orb.getImplName();
            String orbServerId = this.orb.getServerIdString();
            try {
                refImplName = POAUtil.extractImplName(request.objectKey());
            }
            catch (POAInternalError pie) {
                this.logger.debug("serverRequestListener: reference generated by foreign POA");
            }
            if (!orbImplName.equals(refImplName) && !orbServerId.equals(refImplName)) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("serverRequestListener: impl_name mismatch (refImplName: " + refImplName + " and orbServerId " + orbServerId + " and orbImplName " + orbImplName);
                }
                throw new WrongAdapter();
            }
            List<String> scopes = request.getScopes();
            for (int i = 0; i < scopes.size() && (res = scopes.get(i)).length() != 0; ++i) {
                try {
                    tmp_poa = tmp_poa._getChildPOA(res);
                    continue;
                }
                catch (ParentIsHolding p) {
                    String[] rest_of_name = new String[scopes.size() - i];
                    for (int j = 0; j < rest_of_name.length; ++j) {
                        rest_of_name[j] = scopes.get(j + i);
                    }
                    request.setRemainingPOAName(rest_of_name);
                    break;
                }
            }
            try {
                if (tmp_poa == null) {
                    throw new INTERNAL("Request POA null!");
                }
                tmp_poa._invoke(request);
            }
            catch (RuntimeException thr) {
                AcsORBProfiler acsProfiler = this.configuration.getORB().getAcsORBProfiler();
                if (acsProfiler != null) {
                    String poaName = tmp_poa == null ? null : tmp_poa.the_name();
                    int messageSize = request.get_in().available();
                    try {
                        if (thr instanceof TRANSIENT && thr.getMessage().equals("resource limit reached")) {
                            acsProfiler.undeliveredRequest(messageSize, poaName, request.operation(), true);
                        } else {
                            acsProfiler.undeliveredRequest(messageSize, poaName, request.operation(), false);
                        }
                    }
                    catch (Throwable thr2) {
                        thr2.printStackTrace();
                    }
                }
                throw thr;
            }
        }
        catch (WrongAdapter e) {
            request.setSystemException((SystemException)((java.lang.Object)new OBJECT_NOT_EXIST("unknown oid", 1330446338, CompletionStatus.COMPLETED_NO)));
            request.reply();
        }
        catch (SystemException e) {
            request.setSystemException(e);
            request.reply();
        }
        catch (RuntimeException e) {
            request.setSystemException((SystemException)new UNKNOWN(e.toString()));
            request.reply();
            this.logger.warn("unexpected exception", (Throwable)e);
        }
    }
}

