/*
 * Decompiled with CFR 0.152.
 */
package alma.acs.makesupport;

import alma.acs.makesupport.AbstractJarEntryExtractor;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipException;

public class JarSourceExtractor
extends AbstractJarEntryExtractor {
    public JarSourceExtractor() {
        super(".java");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void extractJavaSourcesToFiles(JarFile jarfile, File outDir) throws IOException {
        if (!(outDir.exists() && outDir.isDirectory() && outDir.canWrite())) {
            throw new IOException("specified directory " + outDir.getAbsolutePath() + " is not a valid writeable directory.");
        }
        JarEntry[] javaEntries = this.getJavaEntries(jarfile);
        for (int i = 0; i < javaEntries.length; ++i) {
            JarEntry javaEntry = javaEntries[i];
            String className = this.getClassName(javaEntry);
            try (FileOutputStream out = null;){
                File outFile = new File(outDir.getAbsolutePath() + File.separator + className);
                outFile.getParentFile().mkdirs();
                out = new FileOutputStream(outFile);
                this.extract(jarfile, javaEntry, out);
                continue;
            }
        }
    }

    public void extractJavaSourcesToJar(JarFile jarfile, JarOutputStream jarOut) throws IOException {
        JarEntry[] javaEntries = this.getJavaEntries(jarfile);
        if (javaEntries.length > 0) {
            System.out.println("extracting .java from " + jarfile.getName());
            for (int i = 0; i < javaEntries.length; ++i) {
                JarEntry javaEntry = javaEntries[i];
                String className = this.getClassName(javaEntry);
                JarEntry outEntry = new JarEntry(className);
                outEntry.setTime(javaEntry.getTime());
                try {
                    jarOut.putNextEntry(outEntry);
                    this.extract(jarfile, javaEntry, jarOut);
                    jarOut.closeEntry();
                    continue;
                }
                catch (ZipException e) {
                    System.err.println("failed to add JarEntry for class '" + className + "' from file '" + jarfile.getName() + "': " + e.toString());
                }
            }
            jarfile.close();
            jarOut.flush();
        } else {
            System.out.println("no .java found in " + jarfile.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void extract(JarFile jarfile, JarEntry entry, OutputStream out) throws IOException {
        if (entry != null) {
            try (InputStream entryStream = null;){
                int bytesRead;
                entryStream = jarfile.getInputStream(entry);
                byte[] buffer = new byte[1024];
                while ((bytesRead = entryStream.read(buffer)) != -1) {
                    out.write(buffer, 0, bytesRead);
                }
            }
        }
    }
}

