/*
 * Decompiled with CFR 0.152.
 */
package alma.hla.runtime.obsprep.util;

import alma.hla.runtime.obsprep.util.UnitException;
import java.util.HashMap;
import java.util.TreeMap;

public class UnitMap
extends TreeMap {
    private static HashMap runtimeImpls = new HashMap();
    private String m_defaultUnit;

    public static void addUnits(String type, UnitMap x) {
        runtimeImpls.put(type, x);
    }

    public static UnitMap getUnits(String type) {
        UnitMap ret = (UnitMap)runtimeImpls.get(type);
        if (ret == null) {
            throw new RuntimeException("need to be initialized via addUnits(), see class doc for details");
        }
        return ret;
    }

    public static UnitMap getAngleUnits() {
        return UnitMap.getUnits("Angle");
    }

    public static UnitMap getRotationUnits() {
        return UnitMap.getUnits("Rotation");
    }

    public static UnitMap getDataRateUnits() {
        return UnitMap.getUnits("DataRate");
    }

    public static UnitMap getStorageVolumeUnits() {
        return UnitMap.getUnits("StorageVolume");
    }

    public static UnitMap getFrequencyUnits() {
        return UnitMap.getUnits("Frequency");
    }

    public static UnitMap getSensitivityUnits() {
        return UnitMap.getUnits("Sensitivity");
    }

    public static UnitMap getTemperatureUnits() {
        return UnitMap.getUnits("Temperature");
    }

    public static UnitMap getTimeUnits() {
        return UnitMap.getUnits("Time");
    }

    public static UnitMap getTimeIntervalUnits() {
        return UnitMap.getUnits("TimeInterval");
    }

    public static UnitMap getSpeedUnits() {
        return UnitMap.getUnits("Speed");
    }

    public static UnitMap getUnknownUnits() {
        return UnitMap.getUnits("Unknown");
    }

    public static UnitMap getSmallAngleUnits() {
        return UnitMap.getUnits("SmallAngle");
    }

    public static UnitMap getLongitudeUnits() {
        return UnitMap.getUnits("Longitude");
    }

    public static UnitMap getLatitudeUnits() {
        return UnitMap.getUnits("Latitude");
    }

    public static UnitMap getLengthUnits() {
        return UnitMap.getUnits("Length");
    }

    public static UnitMap getIntTimeSourceUnits() {
        return UnitMap.getUnits("IntTimeSource");
    }

    public static UnitMap getIntTimeReferenceUnits() {
        return UnitMap.getUnits("IntTimeReference");
    }

    public static UnitMap getFluxUnits() {
        return UnitMap.getUnits("Flux");
    }

    public static UnitMap getAngularVelocityUnits() {
        return UnitMap.getUnits("AngularVelocity");
    }

    public String getDefaultUnit() {
        return this.m_defaultUnit;
    }

    public void setDefaultUnit(String newDefault) {
        this.m_defaultUnit = newDefault;
    }

    public double getScale(String unit) throws UnitException {
        Object retrieve = this.get(unit);
        if (retrieve == null) {
            throw new UnitException("Unknown unit - '" + unit + "'");
        }
        return (Double)retrieve;
    }

    public double getDefaultScale() throws UnitException {
        return this.getScale(this.getDefaultUnit());
    }

    public double getConversionFactor(String from, String to) throws UnitException {
        double f = this.getScale(from);
        double t = this.getScale(to);
        return f / t;
    }

    @Override
    public Object put(String name, double scale) {
        return super.put(name, new Double(scale));
    }

    public Object[] getUnitsSorted() {
        Object[] a = this.keySet().toArray();
        int size = a.length;
        for (int i = 0; i < size - 1; ++i) {
            for (int j = i + 1; j < size; ++j) {
                Double di = (Double)this.get(a[i]);
                Double dj = (Double)this.get(a[j]);
                if (!(di > dj)) continue;
                Object temp = a[i];
                a[i] = a[j];
                a[j] = temp;
            }
        }
        return a;
    }

    public static void main(String[] args) {
        int i;
        UnitMap um = UnitMap.getAngleUnits();
        System.out.println("Angle:");
        System.out.println(um.keySet());
        Object[] o = um.getUnitsSorted();
        for (i = 0; i < o.length; ++i) {
            System.out.println(o[i]);
        }
        um = UnitMap.getFrequencyUnits();
        System.out.println("Frequency:");
        System.out.println(um.keySet());
        o = um.getUnitsSorted();
        for (i = 0; i < o.length; ++i) {
            System.out.println(o[i]);
        }
        um = UnitMap.getRotationUnits();
        System.out.println("Rotation:");
        System.out.println(um.keySet());
        o = um.getUnitsSorted();
        for (i = 0; i < o.length; ++i) {
            System.out.println(o[i]);
        }
        um = UnitMap.getSensitivityUnits();
        System.out.println("Sensitivity:");
        System.out.println(um.keySet());
        o = um.getUnitsSorted();
        for (i = 0; i < o.length; ++i) {
            System.out.println(o[i]);
        }
        um = UnitMap.getTimeUnits();
        System.out.println("Time:");
        System.out.println(um.keySet());
        o = um.getUnitsSorted();
        for (i = 0; i < o.length; ++i) {
            System.out.println(o[i]);
        }
    }
}

