/*
 * Decompiled with CFR 0.152.
 */
package alma.common.sourcecatalog.utilities;

import alma.common.sourcecatalog.utilities.InvalidCoordException;
import alma.common.sourcecatalog.utilities.OutOfRangeException;
import alma.common.sourcecatalog.utilities.TextUtils;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.StringTokenizer;

public final class Convert4DP {
    private static MathContext workingPrecision = new MathContext(25);
    public static final int DECIMAL_PLACES_ACCURACY = 4;
    public static final double HOURS_TO_DEGREES = 15.0;
    public static final long MAX_DECIMILLISECS_DEC = 3240000000L;
    public static final long MAX_DECIMILLISECS_RA = 12959999985L;
    public static final long DECIMILLISECS_PER_SEC = 10000L;
    public static final long MILLISECS_PER_SEC = 1000L;
    public static final long SECONDS_PER_MINUTE = 60L;
    public static final long MINUTES_PER_DEGREE = 60L;
    public static final long MINUTES_PER_HOUR = 60L;
    public static final long DEC_MAX_DEGREES = 90L;
    public static final long RA_MAX_HOURS = 24L;
    public static final long DECIMILLISECS_PER_MINUTE = 600000L;
    public static final long DECIMILLISECS_PER_UNIT = 36000000L;
    public static final int FW_BEFORE = 2;
    public static final int FW_AFTER = 4;
    public static final BigDecimal BD_DECIMILLISECS_PER_UNIT = BigDecimal.valueOf(36000000L);
    public static final BigDecimal BD_DECIMILLISECS_PER_MINUTE = BigDecimal.valueOf(600000L);
    public static final BigDecimal BD_DECIMILLISECS_PER_SEC = BigDecimal.valueOf(10000L);

    private Convert4DP() {
    }

    private static void checkBoundsDDMMSS(int sign, int degrees, int minutes, int seconds, int deciMilliSecs) throws InvalidCoordException {
        if ((long)degrees > 90L || (long)minutes >= 60L || (long)seconds >= 60L || (long)deciMilliSecs >= 10000L) {
            throw new InvalidCoordException("Illegal DD:MM:SS value: " + Convert4DP.valuesToString(sign, degrees, minutes, seconds, deciMilliSecs));
        }
        if ((long)degrees == 90L && (minutes > 0 || seconds > 0 || deciMilliSecs > 0)) {
            throw new InvalidCoordException("Illegal DD:MM:SS value: " + Convert4DP.valuesToString(sign, degrees, minutes, seconds, deciMilliSecs));
        }
        if (minutes < 0 || seconds < 0 || deciMilliSecs < 0) {
            throw new InvalidCoordException("Illegal DD:MM:SS value: " + Convert4DP.valuesToString(sign, degrees, minutes, seconds, deciMilliSecs));
        }
    }

    private static void checkBoundsHHMMSS(int sign, int hours, int minutes, int seconds, int deciMilliSecs) throws InvalidCoordException {
        if (sign < 0 || (long)hours >= 24L || (long)minutes >= 60L || deciMilliSecs < 0 || hours < 0 || minutes < 0 || seconds < 0 || (long)seconds >= 60L || (long)deciMilliSecs >= 10000L) {
            throw new InvalidCoordException("Invalid HH:MM:SS.SSSS value: " + Convert4DP.valuesToString(sign, hours, minutes, seconds, deciMilliSecs));
        }
    }

    public static String convertToXXMMSS(long n) {
        String sign = "";
        if (n < 0L) {
            sign = "-";
            n = -n;
        }
        long decimilliSecs = n % 10000L;
        long secs = (n /= 10000L) % 60L;
        long mins = (n /= 60L) % 60L;
        long xxx = n /= 60L;
        return sign + TextUtils.zeroPadded(2, xxx) + TextUtils.zeroPadded(2, mins) + TextUtils.zeroPadded(2, secs) + "." + TextUtils.zeroPadded(4, decimilliSecs);
    }

    public static double DDMMSSToDeg(String value) throws InvalidCoordException, NumberFormatException {
        long dmas = Convert4DP.DDMMSSToDecimilliarcsec(value);
        double ret = (double)dmas / 3.6E7;
        return ret;
    }

    public static long DDMMSSToDecimilliarcsec(String dec) throws InvalidCoordException, NumberFormatException {
        return Convert4DP.stringToDecimilliarcsec(dec, false, false);
    }

    public static double HHMMSSToDeg(String ra) throws InvalidCoordException, NumberFormatException {
        long dmas = Convert4DP.HHMMSSToDecimilliarcsec(ra);
        BigDecimal ret = new BigDecimal(dmas, workingPrecision);
        ret = ret.divide(BD_DECIMILLISECS_PER_UNIT, workingPrecision);
        return ret.doubleValue();
    }

    public static long HHMMSSToDecimilliarcsec(String ra) throws InvalidCoordException, NumberFormatException {
        return Convert4DP.stringToDecimilliarcsec(ra, true, false);
    }

    public static double HHMMSSToSec(String ra) throws InvalidCoordException, NumberFormatException {
        long marcsec = Convert4DP.HHMMSSToDecimilliarcsec(ra);
        double ret = (double)marcsec / 10000.0;
        return ret;
    }

    public static boolean isValidDec(long dec) {
        return -3240000000L <= dec && dec <= 3240000000L;
    }

    public static boolean isValidDec(BigDecimal dec) {
        return BigDecimal.valueOf(3240000000L).negate().compareTo(dec) != 1 && dec.compareTo(BigDecimal.valueOf(3240000000L)) != 1;
    }

    public static boolean isValidRA(long bd) {
        return 0L <= bd && bd < 12959999985L;
    }

    public static boolean isValidRA(BigDecimal ra) {
        return BigDecimal.ZERO.compareTo(ra) != 1 && ra.compareTo(BigDecimal.valueOf(12959999986L)) != 1;
    }

    public static String degToDDMMSS(double degrees) throws OutOfRangeException, InvalidCoordException {
        BigDecimal dmas = new BigDecimal(degrees, workingPrecision);
        dmas = dmas.multiply(BigDecimal.valueOf(36000000L), workingPrecision);
        return Convert4DP.decimilliarcsecToString(dmas, false, false);
    }

    public static String degToHHMMSS(double degrees) throws OutOfRangeException, InvalidCoordException {
        BigDecimal dmas = new BigDecimal(degrees, workingPrecision);
        dmas = dmas.multiply(BigDecimal.valueOf(36000000L), workingPrecision);
        return Convert4DP.decimilliarcsecToString(dmas, true, false);
    }

    public static String decimilliarcsecToDDMMSS(long value) throws OutOfRangeException, InvalidCoordException {
        return Convert4DP.decimilliarcsecToString(BigDecimal.valueOf(value), false, false);
    }

    public static String decimilliarcsecToHHMMSS(long value) throws OutOfRangeException, InvalidCoordException {
        return Convert4DP.decimilliarcsecToString(BigDecimal.valueOf(value), true, false);
    }

    public static String decimilliarcsecToString(BigDecimal dmas, boolean isRA, boolean noCheck) throws OutOfRangeException, InvalidCoordException {
        if (!noCheck) {
            if (isRA) {
                if (!Convert4DP.isValidRA(dmas)) {
                    throw new InvalidCoordException("Invalid masec RA: " + dmas);
                }
            } else if (!Convert4DP.isValidDec(dmas)) {
                throw new InvalidCoordException("Invalid masec Dec: " + dmas);
            }
        }
        MathContext mathContext = new MathContext(dmas.precision());
        DecimalFormat decimalFormat = new DecimalFormat();
        decimalFormat.setMinimumIntegerDigits(2);
        decimalFormat.setRoundingMode(RoundingMode.DOWN);
        decimalFormat.setMinimumFractionDigits(4);
        BigDecimal value = isRA ? dmas.divide(BigDecimal.valueOf(15.0), mathContext) : new BigDecimal(dmas.toString());
        char sign = ' ';
        if (value.compareTo(BigDecimal.ZERO) < 0) {
            sign = '-';
            value = value.negate();
        }
        BigDecimal[] dr = value.divideAndRemainder(BD_DECIMILLISECS_PER_UNIT, mathContext);
        BigDecimal units = dr[0];
        value = value.subtract(units.multiply(BD_DECIMILLISECS_PER_UNIT));
        dr = value.divideAndRemainder(BD_DECIMILLISECS_PER_MINUTE, mathContext);
        BigDecimal minutes = dr[0];
        value = value.subtract(minutes.multiply(BD_DECIMILLISECS_PER_MINUTE));
        BigDecimal seconds = value.divide(BD_DECIMILLISECS_PER_SEC, mathContext);
        String s_seconds = decimalFormat.format(seconds);
        String returnValue = sign + TextUtils.zeroPadded(2, units.intValue()) + ":" + TextUtils.zeroPadded(2, minutes.intValue()) + ":" + s_seconds;
        return returnValue;
    }

    public static String normalizeDec(String dec) throws OutOfRangeException, InvalidCoordException, NumberFormatException {
        long dmas = Convert4DP.DDMMSSToDecimilliarcsec(dec);
        return Convert4DP.decimilliarcsecToDDMMSS(dmas);
    }

    public static String normalizeRa(String ra) throws OutOfRangeException, InvalidCoordException, NumberFormatException {
        long dmas = Convert4DP.HHMMSSToDecimilliarcsec(ra);
        return Convert4DP.decimilliarcsecToHHMMSS(dmas);
    }

    public static double round(double db, int places) {
        double base = 1.0;
        for (int i = 1; i <= places; ++i) {
            base *= 10.0;
        }
        double tmp = db * base;
        tmp = tmp >= 0.0 ? (tmp += 0.5) : (tmp -= 0.5);
        int ip = (int)tmp;
        tmp = (double)ip / base;
        return tmp;
    }

    public static String secToHHMMSS(long seconds) throws OutOfRangeException, InvalidCoordException {
        BigDecimal dmas = BigDecimal.valueOf(seconds).multiply(BigDecimal.valueOf(10000L));
        return Convert4DP.decimilliarcsecToString(dmas, false, false);
    }

    private static long stringToDecimilliarcsec(String value, boolean isRA, boolean noCheck) throws InvalidCoordException, NumberFormatException {
        long result = 0L;
        try {
            int units;
            value = value.trim();
            if (value.startsWith("+")) {
                value = value.substring(1);
            }
            if (value.indexOf(58) == -1) {
                return Convert4DP.stringToDecimilliarcsecNoColons(value, isRA, noCheck);
            }
            result = 0L;
            StringTokenizer st = new StringTokenizer(value, " :");
            String unitsString = st.nextToken();
            int minutes = 0;
            int seconds = 0;
            int deciMilliSecs = 0;
            int sign = 1;
            if (st.hasMoreTokens()) {
                minutes = new Integer(st.nextToken());
                if (st.hasMoreTokens()) {
                    seconds = new Integer(st.nextToken(": ,."));
                    if (st.hasMoreTokens()) {
                        Object tms = st.nextToken(".,");
                        for (int j = 1; j <= 4; ++j) {
                            tms = (String)tms + "0";
                        }
                        tms = ((String)tms).substring(0, 4);
                        deciMilliSecs = new Integer((String)tms);
                    }
                }
            }
            if (unitsString.startsWith("-")) {
                sign = -1;
                units = -new Integer(unitsString).intValue();
            } else {
                units = new Integer(unitsString);
            }
            if (!noCheck) {
                if (isRA) {
                    Convert4DP.checkBoundsHHMMSS(sign, units, minutes, seconds, deciMilliSecs);
                } else {
                    Convert4DP.checkBoundsDDMMSS(sign, units, minutes, seconds, deciMilliSecs);
                }
            }
            result = (long)sign * ((long)units * 36000000L + (long)minutes * 600000L + (long)seconds * 10000L + (long)deciMilliSecs);
            if (isRA) {
                result *= 15L;
            }
        }
        catch (NumberFormatException e) {
            throw new NumberFormatException("Invalid number: '" + e.getMessage() + "'");
        }
        return result;
    }

    private static long stringToDecimilliarcsecNoColons(String value, boolean isRA, boolean noCheck) throws InvalidCoordException, NumberFormatException {
        int decimillisecs;
        int sign;
        int length = 6;
        String zeros = "000000";
        long result = 0L;
        int iPoint = -1;
        int iSign = -1;
        Object main = null;
        Object frac = "0000";
        int t = 0;
        int l = 0;
        value = value.trim();
        t = value.indexOf(46);
        l = value.length();
        iPoint = t == -1 ? l : t;
        if (value.startsWith("-")) {
            iSign = 1;
            sign = -1;
        } else {
            iSign = 0;
            sign = 1;
        }
        main = value.substring(iSign, iPoint).trim();
        if (iPoint < l) {
            frac = value.substring(iPoint + 1, l) + "0000";
            main = TextUtils.padded("000000", 6, (String)main);
        } else {
            if (((String)main).length() == 1) {
                main = "0" + (String)main;
            }
            main = TextUtils.rightpadded("000000", 6, (String)main);
        }
        frac = ((String)frac).substring(0, 4);
        if (((String)main).length() > 6) {
            throw new InvalidCoordException("String too long: '" + value + "'");
        }
        String uu = ((String)main).substring(0, 2);
        String mm = ((String)main).substring(2, 4);
        String ss = ((String)main).substring(4, 6);
        int units = 0;
        try {
            units = new Integer(uu);
        }
        catch (NumberFormatException e) {
            throw new NumberFormatException(e.getMessage());
        }
        int minutes = new Integer(mm);
        int seconds = new Integer(ss);
        try {
            decimillisecs = new Integer((String)frac);
        }
        catch (NumberFormatException e) {
            throw new NumberFormatException(e.getMessage());
        }
        if (!noCheck) {
            if (isRA) {
                Convert4DP.checkBoundsHHMMSS(sign, units, minutes, seconds, decimillisecs);
            } else {
                Convert4DP.checkBoundsDDMMSS(sign, units, minutes, seconds, decimillisecs);
            }
        }
        result = (long)sign * ((long)units * 36000000L + (long)minutes * 600000L + (long)seconds * 10000L + (long)decimillisecs);
        if (isRA) {
            result *= 15L;
        }
        return result;
    }

    private static String valuesToString(int sign, int degrees, int minutes, int seconds, int decimillisecs) {
        Object ret = null;
        ret = sign < 0 ? "-" : "";
        ret = (String)ret + degrees + ":" + minutes + ":" + seconds + "." + decimillisecs;
        return ret;
    }
}

