/*
 * Decompiled with CFR 0.152.
 */
package com.cosylab.acs.maci.manager;

import alma.acs.alarmsystem.source.AlarmSource;
import com.cosylab.acs.maci.ClientInfo;
import com.cosylab.acs.maci.HandleHelper;
import com.cosylab.acs.maci.RemoteTimeoutException;
import com.cosylab.acs.maci.RemoteTransientException;
import com.cosylab.acs.maci.manager.ManagerImpl;
import com.cosylab.acs.maci.plug.CORBAReferenceSerializator;
import com.cosylab.acs.maci.plug.ClientProxy;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import si.ijs.maci.PingCallbackPOA;

public class PingTimerTask
extends TimerTask {
    private static final int MAX_TRANSIENT_COUNT = 3;
    private int transientCount;
    private ManagerImpl manager;
    private ClientInfo clientInfo;
    private Logger logger;
    private AlarmSource alarmSource;
    protected static final String FAULT_FAMILY = "Manager";
    protected static final int FAULT_CODE = 1;

    public PingTimerTask(ManagerImpl manager, Logger logger, ClientInfo clientInfo, AlarmSource alarmSource) {
        assert (manager != null);
        assert (logger != null);
        assert (clientInfo != null);
        this.manager = manager;
        this.logger = logger;
        this.clientInfo = clientInfo;
        this.alarmSource = alarmSource;
        this.transientCount = 0;
    }

    private void logout() {
        try {
            this.cancel();
            this.manager.logout(this.clientInfo.getHandle());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void run() {
        try {
            this.logger.finest("Invoking ping on " + HandleHelper.toString(this.clientInfo.getHandle()) + "].");
            PingCallbackImpl cb = new PingCallbackImpl();
            this.clientInfo.getClient().pingCB(cb._this(CORBAReferenceSerializator.getOrb()));
            if (!cb.waitForPing(ClientProxy.pingTimeoutSec)) {
                this.logger.info("Client '" + this.clientInfo.getName() + "' [" + HandleHelper.toString(this.clientInfo.getHandle()) + "] announced itself as malfunctioning.");
                this.raise_alarm(this.clientInfo.getName());
                this.logout();
                return;
            }
            this.clear_alarm(this.clientInfo.getName());
            this.transientCount = 0;
        }
        catch (RemoteTransientException rte) {
            ++this.transientCount;
            if (this.transientCount >= 3) {
                this.logger.info("Client '" + this.clientInfo.getName() + "' [" + HandleHelper.toString(this.clientInfo.getHandle()) + "] is unreachable, logging it out.");
                this.raise_alarm(this.clientInfo.getName());
                this.logout();
            }
        }
        catch (RemoteTimeoutException rtoe) {
            ++this.transientCount;
            if (this.transientCount >= 3) {
                this.logger.info("Client '" + this.clientInfo.getName() + "' [" + HandleHelper.toString(this.clientInfo.getHandle()) + "] ping method timed-out several times, logging it out.");
                this.raise_alarm(this.clientInfo.getName());
                this.logout();
            }
        }
        catch (Throwable ex) {
            this.logger.log(Level.INFO, "Invoking client '" + this.clientInfo.getName() + "' ping method thrown an exception, logging it out.", ex);
            this.raise_alarm(this.clientInfo.getName());
            this.logout();
        }
    }

    public String toString() {
        StringBuffer sbuff = new StringBuffer();
        sbuff.append("PingTimerTask = { ");
        sbuff.append("manager = '");
        sbuff.append(this.manager);
        sbuff.append(", clientInfo = '");
        sbuff.append(this.clientInfo);
        sbuff.append(", transientCount = '");
        sbuff.append(this.transientCount);
        sbuff.append("' }");
        return new String(sbuff);
    }

    private void raise_alarm(String faultMember) {
        if (!this.manager.hasActiveAlarm(this.clientInfo.getName())) {
            this.send_alarm(faultMember, true);
        }
    }

    private void clear_alarm(String faultMember) {
        if (this.manager.hasActiveAlarm(this.clientInfo.getName())) {
            this.send_alarm(faultMember, false);
        }
    }

    private void send_alarm(String faultMember, boolean raise) {
        if (this.alarmSource == null) {
            return;
        }
        try {
            this.alarmSource.setAlarm(FAULT_FAMILY, faultMember, 1, raise);
            if (raise) {
                this.manager.alarmRaised(faultMember);
            } else {
                this.manager.alarmCleared(faultMember);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    class PingCallbackImpl
    extends PingCallbackPOA {
        boolean pinged = false;
        boolean working = false;

        PingCallbackImpl() {
        }

        public synchronized void ping(boolean working) {
            this.pinged = true;
            this.working = working;
            ((Object)((Object)this)).notify();
        }

        public synchronized boolean waitForPing(long time) {
            if (this.pinged) {
                return this.working;
            }
            try {
                ((Object)((Object)this)).wait(time);
                if (this.pinged) {
                    return this.working;
                }
            }
            catch (InterruptedException e) {
                throw new RemoteTransientException("Failed to invoke 'ping()' method due to transient exception.", e);
            }
            throw new RemoteTimeoutException("Failed to invoke 'ping()' method due to timeout.");
        }
    }
}

