/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.samp.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.astrogrid.samp.Client;
import org.astrogrid.samp.Message;
import org.astrogrid.samp.Response;
import org.astrogrid.samp.client.CallableClient;
import org.astrogrid.samp.client.SampException;
import org.astrogrid.samp.gui.ClientTransmissionHolder;
import org.astrogrid.samp.gui.GuiClientSet;
import org.astrogrid.samp.gui.GuiHubService;
import org.astrogrid.samp.gui.HubClientPopupListener;
import org.astrogrid.samp.gui.HubView;
import org.astrogrid.samp.gui.MessageTrackerListCellRenderer;
import org.astrogrid.samp.gui.Transmission;
import org.astrogrid.samp.gui.TransmissionListModel;
import org.astrogrid.samp.gui.TransmissionTableModel;
import org.astrogrid.samp.gui.TransmissionView;
import org.astrogrid.samp.hub.ClientSet;
import org.astrogrid.samp.hub.HubClient;
import org.astrogrid.samp.hub.ProfileToken;

public class MessageTrackerHubService
extends GuiHubService
implements ClientTransmissionHolder {
    private final CallMap callMap_;
    private final TransmissionTableModel transTableModel_;
    private final int listRemoveDelay_;
    private final int tableRemoveDelay_;
    private final int tableMaxRows_;
    private MessageTrackerClientSet clientSet_;
    private ListSelectionModel selectionModel_;
    static /* synthetic */ Class class$org$astrogrid$samp$gui$MessageTrackerHubService;

    public MessageTrackerHubService(Random random) {
        this(random, 0, 20000, 100);
    }

    public MessageTrackerHubService(Random random, int listRemoveDelay, int tableRemoveDelay, int tableMaxRows) {
        super(random);
        this.listRemoveDelay_ = listRemoveDelay;
        this.tableRemoveDelay_ = tableRemoveDelay;
        this.tableMaxRows_ = tableMaxRows;
        this.callMap_ = new CallMap();
        this.transTableModel_ = new TransmissionTableModel(true, true, this.tableRemoveDelay_, this.tableMaxRows_);
    }

    public void start() {
        super.start();
        this.clientSet_ = (MessageTrackerClientSet)this.getClientSet();
    }

    public ClientSet createClientSet() {
        return new MessageTrackerClientSet(this.getIdComparator());
    }

    public HubClient createClient(String publicId, ProfileToken ptoken) {
        return new MessageTrackerHubClient(publicId, ptoken);
    }

    public JComponent createHubPanel() {
        JTabbedPane tabber = new JTabbedPane();
        HubView hubView = new HubView(true);
        hubView.setClientListModel(this.getClientListModel());
        JList jlist = hubView.getClientList();
        jlist.setCellRenderer(new MessageTrackerListCellRenderer(this));
        jlist.addMouseListener(new HubClientPopupListener(this));
        this.selectionModel_ = jlist.getSelectionModel();
        tabber.add("Clients", hubView);
        tabber.add("Messages", new TransmissionView(this.transTableModel_));
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)tabber, "Center");
        return panel;
    }

    public ListSelectionModel getClientSelectionModel() {
        return this.selectionModel_;
    }

    public ListModel getTxListModel(Client client) {
        return client instanceof MessageTrackerHubClient ? ((MessageTrackerHubClient)client).txListModel_ : null;
    }

    public ListModel getRxListModel(Client client) {
        return client instanceof MessageTrackerHubClient ? ((MessageTrackerHubClient)client).rxListModel_ : null;
    }

    protected void reply(HubClient caller, String msgId, final Map response) throws SampException {
        final Object callKey = MessageTrackerHubService.getCallKey(caller, msgId);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Transmission trans = MessageTrackerHubService.this.callMap_.remove(callKey);
                if (trans != null) {
                    trans.setResponse(Response.asResponse(response));
                }
            }
        });
        super.reply(caller, msgId, response);
    }

    private void addTransmission(Transmission trans) {
        ((MessageTrackerHubClient)trans.getSender()).txListModel_.addTransmission(trans);
        ((MessageTrackerHubClient)trans.getReceiver()).rxListModel_.addTransmission(trans);
        this.transTableModel_.addTransmission(trans);
    }

    private static Object getCallKey(Client receiver, String msgId) {
        return msgId + "->" + receiver.getId();
    }

    private static class CallMap {
        private final Map map_ = new HashMap();
        static final /* synthetic */ boolean $assertionsDisabled;

        private CallMap() {
        }

        public void add(Object key, Transmission trans) {
            if (!$assertionsDisabled && !SwingUtilities.isEventDispatchThread()) {
                throw new AssertionError();
            }
            if (!this.map_.containsKey(key)) {
                this.map_.put(key, new ArrayList(1));
            }
            ((List)this.map_.get(key)).add(trans);
        }

        public Transmission remove(Object key) {
            if (!$assertionsDisabled && !SwingUtilities.isEventDispatchThread()) {
                throw new AssertionError();
            }
            List transList = (List)this.map_.get(key);
            if (transList == null) {
                return null;
            }
            if (!$assertionsDisabled && transList.isEmpty()) {
                throw new AssertionError();
            }
            Transmission trans = (Transmission)transList.remove(0);
            if (transList.isEmpty()) {
                this.map_.remove(key);
            }
            return trans;
        }

        static {
            $assertionsDisabled = !(class$org$astrogrid$samp$gui$MessageTrackerHubService == null ? (class$org$astrogrid$samp$gui$MessageTrackerHubService = MessageTrackerHubService.class$("org.astrogrid.samp.gui.MessageTrackerHubService")) : class$org$astrogrid$samp$gui$MessageTrackerHubService).desiredAssertionStatus();
        }
    }

    private class MessageTrackerClientSet
    extends GuiClientSet {
        private final ListDataListener transListener_;

        MessageTrackerClientSet(Comparator clientIdComparator) {
            super(clientIdComparator);
            this.transListener_ = new ListDataListener(){
                static final /* synthetic */ boolean $assertionsDisabled;

                public void contentsChanged(ListDataEvent evt) {
                    this.transmissionChanged(evt);
                }

                public void intervalAdded(ListDataEvent evt) {
                    this.transmissionChanged(evt);
                }

                public void intervalRemoved(ListDataEvent evt) {
                    this.transmissionChanged(evt);
                }

                private void transmissionChanged(ListDataEvent evt) {
                    Object src = evt.getSource();
                    if (!$assertionsDisabled && !(src instanceof Transmission)) {
                        throw new AssertionError();
                    }
                    if (src instanceof Transmission) {
                        Transmission trans = (Transmission)src;
                        int nclient = MessageTrackerClientSet.this.getSize();
                        for (int ic = 0; ic < nclient; ++ic) {
                            Client client = (Client)MessageTrackerClientSet.this.getElementAt(ic);
                            if (!trans.getSender().equals(client) && !trans.getReceiver().equals(client)) continue;
                            ListDataEvent clientEvt = new ListDataEvent(trans, 0, ic, ic);
                            MessageTrackerClientSet.this.fireListDataEvent(clientEvt);
                        }
                    }
                }

                static {
                    $assertionsDisabled = !(class$org$astrogrid$samp$gui$MessageTrackerHubService == null ? (class$org$astrogrid$samp$gui$MessageTrackerHubService = MessageTrackerHubService.class$("org.astrogrid.samp.gui.MessageTrackerHubService")) : class$org$astrogrid$samp$gui$MessageTrackerHubService).desiredAssertionStatus();
                }
            };
        }

        public void add(HubClient client) {
            MessageTrackerHubClient mtClient = (MessageTrackerHubClient)client;
            final TransmissionListModel txListModel = mtClient.txListModel_;
            final TransmissionListModel rxListModel = mtClient.rxListModel_;
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    txListModel.addListDataListener(MessageTrackerClientSet.this.transListener_);
                    rxListModel.addListDataListener(MessageTrackerClientSet.this.transListener_);
                }
            });
            super.add(client);
        }

        public void remove(HubClient client) {
            super.remove(client);
            MessageTrackerHubClient mtClient = (MessageTrackerHubClient)client;
            final TransmissionListModel txListModel = mtClient.txListModel_;
            final TransmissionListModel rxListModel = mtClient.rxListModel_;
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    int i;
                    for (i = 0; i < txListModel.getSize(); ++i) {
                        ((Transmission)txListModel.getElementAt(i)).setSenderUnregistered();
                    }
                    for (i = 0; i < rxListModel.getSize(); ++i) {
                        ((Transmission)rxListModel.getElementAt(i)).setReceiverUnregistered();
                    }
                    txListModel.removeListDataListener(MessageTrackerClientSet.this.transListener_);
                    rxListModel.removeListDataListener(MessageTrackerClientSet.this.transListener_);
                }
            });
        }
    }

    private class MessageTrackerCallableClient
    implements CallableClient {
        private final CallableClient base_;
        private final MessageTrackerHubClient client_;

        MessageTrackerCallableClient(CallableClient base, MessageTrackerHubClient client) {
            this.base_ = base;
            this.client_ = client;
        }

        public void receiveCall(String senderId, String msgId, Message msg) throws SampException {
            MessageTrackerHubClient sender = (MessageTrackerHubClient)MessageTrackerHubService.this.clientSet_.getFromPublicId(senderId);
            MessageTrackerHubClient recipient = this.client_;
            final Transmission trans = new Transmission(sender, recipient, msg, null, msgId);
            final Object callKey = MessageTrackerHubService.getCallKey(recipient, msgId);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    MessageTrackerHubService.this.callMap_.add(callKey, trans);
                    MessageTrackerHubService.this.addTransmission(trans);
                }
            });
            try {
                this.base_.receiveCall(senderId, msgId, msg);
            }
            catch (Exception e) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        trans.setError(e);
                    }
                });
            }
        }

        public void receiveNotification(String senderId, Message msg) throws SampException {
            Exception error;
            MessageTrackerHubClient sender = (MessageTrackerHubClient)MessageTrackerHubService.this.clientSet_.getFromPublicId(senderId);
            MessageTrackerHubClient recipient = this.client_;
            final Transmission trans = new Transmission(sender, recipient, msg, null, null);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    MessageTrackerHubService.this.addTransmission(trans);
                }
            });
            try {
                this.base_.receiveNotification(senderId, msg);
                error = null;
            }
            catch (Exception e) {
                error = e;
            }
            final Exception err2 = error;
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    if (err2 == null) {
                        trans.setResponse(null);
                    } else {
                        trans.setError(err2);
                    }
                }
            });
        }

        public void receiveResponse(String responderId, String msgTag, Response response) throws Exception {
            this.base_.receiveResponse(responderId, msgTag, response);
        }
    }

    private class MessageTrackerHubClient
    extends HubClient {
        final TransmissionListModel rxListModel_;
        final TransmissionListModel txListModel_;

        public MessageTrackerHubClient(String publicId, ProfileToken ptoken) {
            super(publicId, ptoken);
            this.txListModel_ = new TransmissionListModel(MessageTrackerHubService.this.listRemoveDelay_);
            this.rxListModel_ = new TransmissionListModel(MessageTrackerHubService.this.listRemoveDelay_);
        }

        public void setCallable(CallableClient callable) {
            super.setCallable(callable == null ? null : new MessageTrackerCallableClient(callable, this));
        }
    }
}

