/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.samp.httpd;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.BindException;
import java.net.MalformedURLException;
import java.net.ServerSocket;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.astrogrid.samp.httpd.HttpServer;
import org.astrogrid.samp.httpd.MultiURLMapperHandler;
import org.astrogrid.samp.httpd.ResourceHandler;

public class UtilServer {
    private final HttpServer server_;
    private final Set baseSet_;
    private MultiURLMapperHandler mapperHandler_;
    private ResourceHandler resourceHandler_;
    public static final String PORT_PROP = "jsamp.server.port";
    private static int BUFSIZ;
    private static UtilServer instance_;
    private static final Pattern SLASH_REGEX;
    private static final Pattern NUMBER_REGEX;
    private static final Logger logger_;
    static final /* synthetic */ boolean $assertionsDisabled;

    public UtilServer(HttpServer server) throws IOException {
        this.server_ = server;
        this.baseSet_ = new HashSet();
    }

    public HttpServer getServer() {
        return this.server_;
    }

    public synchronized MultiURLMapperHandler getMapperHandler() {
        if (this.mapperHandler_ == null) {
            try {
                this.mapperHandler_ = new MultiURLMapperHandler(this.server_, this.getBasePath("/export"));
            }
            catch (MalformedURLException e) {
                throw (AssertionError)((Object)((Throwable)((Object)new AssertionError())).initCause(e));
            }
            this.server_.addHandler(this.mapperHandler_);
        }
        return this.mapperHandler_;
    }

    public synchronized ResourceHandler getResourceHandler() {
        if (this.resourceHandler_ == null) {
            this.resourceHandler_ = new ResourceHandler(this.server_, this.getBasePath("/docs"));
            this.server_.addHandler(this.resourceHandler_);
        }
        return this.resourceHandler_;
    }

    public URL exportResource(URL localUrl) throws IOException {
        return this.getMapperHandler().addLocalUrl(localUrl);
    }

    public URL exportResource(String resource) throws IOException {
        URL localUrl = UtilServer.class.getResource(resource);
        if (localUrl != null) {
            return this.getMapperHandler().addLocalUrl(localUrl);
        }
        throw new IOException("Not found on classpath: " + resource);
    }

    public URL exportFile(File file) throws IOException {
        if (file.exists()) {
            return this.getMapperHandler().addLocalUrl(file.toURL());
        }
        throw new FileNotFoundException("No such file: " + file);
    }

    public synchronized String getBasePath(String txt) {
        String post;
        String body;
        String pre;
        Matcher slashMatcher = SLASH_REGEX.matcher(txt);
        if (slashMatcher.matches()) {
            pre = slashMatcher.group(1);
            body = slashMatcher.group(2);
            post = slashMatcher.group(3);
        } else {
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
            pre = "";
            body = txt;
            post = "";
        }
        if (this.baseSet_.contains(body)) {
            String stem = body;
            int i = 1;
            while (this.baseSet_.contains(stem + "-" + i)) {
                ++i;
            }
            body = stem + "-" + i;
        }
        this.baseSet_.add(body);
        return pre + body + post;
    }

    public static synchronized UtilServer getInstance() throws IOException {
        if (instance_ == null) {
            ServerSocket sock = null;
            String sPort = System.getProperty(PORT_PROP);
            if (sPort != null && sPort.length() > 0) {
                int port = Integer.parseInt(sPort);
                try {
                    sock = new ServerSocket(port);
                }
                catch (BindException e) {
                    logger_.warning("Can't open socket on port " + port + " (" + e + ") - use another one");
                }
            }
            if (sock == null) {
                sock = new ServerSocket(0);
            }
            HttpServer server = new HttpServer(sock);
            server.setDaemon(true);
            server.start();
            instance_ = new UtilServer(server);
        }
        return instance_;
    }

    public static synchronized void setInstance(UtilServer server) {
        instance_ = server;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(InputStream in, OutputStream out) throws IOException {
        byte[] buf = new byte[BUFSIZ];
        try {
            int nb;
            while ((nb = in.read(buf)) >= 0) {
                out.write(buf, 0, nb);
            }
            out.flush();
        }
        finally {
            in.close();
        }
    }

    static {
        $assertionsDisabled = !UtilServer.class.desiredAssertionStatus();
        BUFSIZ = 16384;
        SLASH_REGEX = Pattern.compile("(/*)(.*?)(/*)");
        NUMBER_REGEX = Pattern.compile("(.*?)([0-9]+)");
        logger_ = Logger.getLogger(UtilServer.class.getName());
    }
}

