/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.samp.web;

import java.io.IOException;
import java.io.PrintStream;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.util.logging.Logger;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import org.astrogrid.samp.client.ClientProfile;
import org.astrogrid.samp.httpd.HttpServer;
import org.astrogrid.samp.hub.ConfigHubProfile;
import org.astrogrid.samp.hub.HubProfile;
import org.astrogrid.samp.hub.KeyGenerator;
import org.astrogrid.samp.hub.MessageRestriction;
import org.astrogrid.samp.web.ClientAuthorizer;
import org.astrogrid.samp.web.CorsHttpServer;
import org.astrogrid.samp.web.HubSwingClientAuthorizer;
import org.astrogrid.samp.web.ListMessageRestriction;
import org.astrogrid.samp.web.LoggingCorsHttpServer;
import org.astrogrid.samp.web.OpenPolicyResourceHandler;
import org.astrogrid.samp.web.OriginAuthorizer;
import org.astrogrid.samp.web.OriginAuthorizers;
import org.astrogrid.samp.web.UrlTracker;
import org.astrogrid.samp.web.WebCredentialPresenter;
import org.astrogrid.samp.web.WebHubXmlRpcHandler;
import org.astrogrid.samp.xmlrpc.internal.InternalServer;
import org.astrogrid.samp.xmlrpc.internal.RpcLoggingInternalServer;
import org.astrogrid.samp.xmlrpc.internal.XmlLoggingInternalServer;

public class WebHubProfile
implements HubProfile,
ConfigHubProfile {
    private final ServerFactory serverFactory_;
    private final ClientAuthorizer auth_;
    private final KeyGenerator keyGen_;
    private final ConfigEnabler configEnabler_;
    private final ConfigEnabler configDisabler_;
    private MessageRestriction mrestrict_;
    private boolean controlUrls_;
    private InternalServer xServer_;
    private JToggleButton.ToggleButtonModel[] configModels_;
    private static final Logger logger_ = Logger.getLogger(WebHubProfile.class.getName());

    public WebHubProfile(ServerFactory serverFactory, ClientAuthorizer auth, MessageRestriction mrestrict, KeyGenerator keyGen, boolean controlUrls) {
        this.serverFactory_ = serverFactory;
        this.auth_ = auth;
        this.mrestrict_ = mrestrict;
        this.keyGen_ = keyGen;
        this.controlUrls_ = controlUrls;
        this.configEnabler_ = new ConfigEnabler(true);
        this.configDisabler_ = new ConfigEnabler(false);
    }

    public WebHubProfile() throws IOException {
        this(new ServerFactory(), new HubSwingClientAuthorizer(null, WebCredentialPresenter.INSTANCE), ListMessageRestriction.DEFAULT, WebHubProfile.createKeyGenerator(), true);
    }

    public String getProfileName() {
        return "Web";
    }

    public MessageRestriction getMessageRestriction() {
        return this.mrestrict_;
    }

    public synchronized void start(ClientProfile profile) throws IOException {
        if (this.isRunning()) {
            logger_.info("Profile already running");
            return;
        }
        this.xServer_ = this.serverFactory_.createSampXmlRpcServer();
        HttpServer hServer = this.xServer_.getHttpServer();
        WebHubXmlRpcHandler wxHandler = new WebHubXmlRpcHandler(profile, this.auth_, this.keyGen_, hServer.getBaseUrl(), this.controlUrls_ ? new UrlTracker() : null);
        logger_.info("Web Profile URL controls: " + (this.controlUrls_ ? "on" : "off"));
        logger_.info("Web Profile MType restrictions: " + this.mrestrict_);
        this.xServer_.addHandler(wxHandler);
        hServer.addHandler(wxHandler.getUrlTranslationHandler());
        hServer.start();
        if (this.configModels_ != null) {
            SwingUtilities.invokeLater(this.configDisabler_);
        }
    }

    public synchronized boolean isRunning() {
        return this.xServer_ != null;
    }

    public synchronized void stop() {
        if (!this.isRunning()) {
            logger_.info("Profile already stopped");
            return;
        }
        this.xServer_.getHttpServer().stop();
        this.xServer_ = null;
        if (this.configModels_ != null) {
            SwingUtilities.invokeLater(this.configEnabler_);
        }
    }

    public synchronized JToggleButton.ToggleButtonModel[] getConfigModels() {
        if (this.configModels_ == null) {
            this.configModels_ = this.createConfigModels();
        }
        return this.configModels_;
    }

    private JToggleButton.ToggleButtonModel[] createConfigModels() {
        JToggleButton.ToggleButtonModel[] models = new ConfigModel[]{new ConfigModel("CORS cross-domain access"){

            void setOn(boolean on) {
                WebHubProfile.this.serverFactory_.setOriginAuthorizer(on ? OriginAuthorizers.TRUE : OriginAuthorizers.FALSE);
            }

            boolean isOn() {
                return WebHubProfile.this.serverFactory_.getOriginAuthorizer().authorize("");
            }
        }, new ConfigModel("Flash cross-domain access"){

            void setOn(boolean on) {
                WebHubProfile.this.serverFactory_.setAllowFlash(on);
            }

            boolean isOn() {
                return WebHubProfile.this.serverFactory_.isAllowFlash();
            }
        }, new ConfigModel("Silverlight cross-domain access"){

            void setOn(boolean on) {
                WebHubProfile.this.serverFactory_.setAllowSilverlight(on);
            }

            boolean isOn() {
                return WebHubProfile.this.serverFactory_.isAllowSilverlight();
            }
        }, new ConfigModel("URL Controls"){

            void setOn(boolean on) {
                WebHubProfile.this.controlUrls_ = on;
            }

            boolean isOn() {
                return WebHubProfile.this.controlUrls_;
            }
        }, new ConfigModel("MType Restrictions"){

            void setOn(boolean on) {
                WebHubProfile.this.mrestrict_ = on ? ListMessageRestriction.DEFAULT : null;
            }

            boolean isOn() {
                return WebHubProfile.this.mrestrict_ != null;
            }
        }};
        boolean enabled = !this.isRunning();
        for (int i = 0; i < models.length; ++i) {
            models[i].setEnabled(enabled);
        }
        return models;
    }

    public static KeyGenerator createKeyGenerator() {
        return new KeyGenerator("wk:", 24, KeyGenerator.createRandom());
    }

    public static class ServerFactory {
        private String logType_ = null;
        private int port_ = 21012;
        private String xmlrpcPath_ = "/";
        private boolean allowFlash_ = true;
        private boolean allowSilverlight_ = false;
        private OriginAuthorizer oAuth_ = OriginAuthorizers.TRUE;

        public InternalServer createSampXmlRpcServer() throws IOException {
            CorsHttpServer hServer;
            String path = this.getXmlrpcPath();
            ServerSocket socket = this.createServerSocket(this.getPort());
            String logType = this.getLogType();
            OriginAuthorizer oAuth = this.getOriginAuthorizer();
            PrintStream logOut = System.err;
            CorsHttpServer corsHttpServer = hServer = "http".equals(logType) ? new LoggingCorsHttpServer(socket, oAuth, logOut) : new CorsHttpServer(socket, oAuth);
            if (this.isAllowFlash()) {
                hServer.addHandler(OpenPolicyResourceHandler.createFlashPolicyHandler(oAuth));
                logger_.info("Web Profile HTTP server permits Flash-style cross-domain access");
            } else {
                logger_.info("Web Profile HTTP server does not permit Flash-style cross-domain access");
            }
            if (this.isAllowSilverlight()) {
                hServer.addHandler(OpenPolicyResourceHandler.createSilverlightPolicyHandler(oAuth));
                logger_.info("Web Profile HTTP server permits Silverlight-style cross-domain access");
            } else {
                logger_.info("Web Profile HTTP server does not permit Silverlight-style cross-domain access");
            }
            hServer.setDaemon(true);
            if ("rpc".equals(logType)) {
                return new RpcLoggingInternalServer(hServer, path, logOut);
            }
            if ("xml".equals(logType)) {
                return new XmlLoggingInternalServer(hServer, path, logOut);
            }
            if ("none".equals(logType) || "http".equals(logType) || logType == null || logType.length() == 0) {
                return new InternalServer(hServer, path);
            }
            throw new IllegalArgumentException("Unknown logType " + logType);
        }

        public void setLogType(String logType) {
            if (!(logType == null || logType.equals("http") || logType.equals("rpc") || logType.equals("xml") || logType.equals("none"))) {
                throw new IllegalArgumentException("Unknown log type " + logType);
            }
            this.logType_ = logType;
        }

        public String getLogType() {
            return this.logType_;
        }

        public void setPort(int port) {
            this.port_ = port;
        }

        public int getPort() {
            return this.port_;
        }

        public void setXmlrpcPath(String xmlrpcPath) {
            this.xmlrpcPath_ = xmlrpcPath;
        }

        public String getXmlrpcPath() {
            return this.xmlrpcPath_;
        }

        public void setAllowFlash(boolean allowFlash) {
            this.allowFlash_ = allowFlash;
        }

        public boolean isAllowFlash() {
            return this.allowFlash_;
        }

        public void setAllowSilverlight(boolean allowSilverlight) {
            this.allowSilverlight_ = allowSilverlight;
        }

        public boolean isAllowSilverlight() {
            return this.allowSilverlight_;
        }

        public void setOriginAuthorizer(OriginAuthorizer oAuth) {
            this.oAuth_ = oAuth;
        }

        public OriginAuthorizer getOriginAuthorizer() {
            return this.oAuth_;
        }

        protected ServerSocket createServerSocket(int port) throws IOException {
            ServerSocket sock = new ServerSocket();
            sock.setReuseAddress(true);
            sock.bind(new InetSocketAddress(port));
            return sock;
        }
    }

    private static abstract class ConfigModel
    extends JToggleButton.ToggleButtonModel {
        private final String name_;

        public ConfigModel(String name) {
            this.name_ = name;
        }

        abstract boolean isOn();

        abstract void setOn(boolean var1);

        public boolean isSelected() {
            return this.isOn();
        }

        public void setSelected(boolean on) {
            this.setOn(on);
            super.setSelected(on);
        }

        public String toString() {
            return this.name_;
        }
    }

    private class ConfigEnabler
    implements Runnable {
        private final boolean isEnabled_;

        ConfigEnabler(boolean isEnabled) {
            this.isEnabled_ = isEnabled;
        }

        public void run() {
            JToggleButton.ToggleButtonModel[] configModels = WebHubProfile.this.configModels_;
            if (configModels != null) {
                for (int i = 0; i < configModels.length; ++i) {
                    configModels[i].setEnabled(this.isEnabled_);
                }
            }
        }
    }
}

