/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.schema.reader;

import org.exolab.castor.xml.AttributeSet;
import org.exolab.castor.xml.Namespaces;
import org.exolab.castor.xml.XMLException;
import org.exolab.castor.xml.schema.Annotation;
import org.exolab.castor.xml.schema.AttributeDecl;
import org.exolab.castor.xml.schema.AttributeGroupReference;
import org.exolab.castor.xml.schema.ComplexType;
import org.exolab.castor.xml.schema.Facet;
import org.exolab.castor.xml.schema.Schema;
import org.exolab.castor.xml.schema.SchemaContext;
import org.exolab.castor.xml.schema.SchemaException;
import org.exolab.castor.xml.schema.SimpleContent;
import org.exolab.castor.xml.schema.SimpleType;
import org.exolab.castor.xml.schema.Wildcard;
import org.exolab.castor.xml.schema.XMLType;
import org.exolab.castor.xml.schema.reader.AnnotationUnmarshaller;
import org.exolab.castor.xml.schema.reader.AttributeGroupUnmarshaller;
import org.exolab.castor.xml.schema.reader.AttributeUnmarshaller;
import org.exolab.castor.xml.schema.reader.ComponentReader;
import org.exolab.castor.xml.schema.reader.FacetUnmarshaller;
import org.exolab.castor.xml.schema.reader.SimpleTypeDefinition;
import org.exolab.castor.xml.schema.reader.SimpleTypeUnmarshaller;
import org.exolab.castor.xml.schema.reader.WildcardUnmarshaller;

public class SimpleContentRestrictionUnmarshaller
extends ComponentReader {
    private ComponentReader unmarshaller;
    private int depth = 0;
    private ComplexType _complexType = null;
    private Schema _schema = null;
    private String _id = null;
    private boolean foundAnnotation = false;
    private boolean foundSimpleType = false;
    private boolean foundFacets = false;
    private boolean foundAttribute = false;
    private boolean foundAttributeGroup = false;
    private SimpleTypeDefinition _simpleTypeDef = null;

    public SimpleContentRestrictionUnmarshaller(SchemaContext schemaContext, ComplexType complexType, AttributeSet atts) {
        super(schemaContext);
        this._complexType = complexType;
        this._complexType.setDerivationMethod("restriction");
        this._complexType.setRestriction(true);
        this._schema = complexType.getSchema();
        this._id = atts.getValue("id");
        String base = atts.getValue("base");
        if (base != null && base.length() > 0) {
            XMLType baseType = this._schema.getType(base);
            if (baseType == null) {
                this._complexType.setBase(base);
                this._complexType.setContentType(new SimpleContent(this._schema, base));
            } else {
                if (baseType.isSimpleType()) {
                    Object err = "complexType: ";
                    String name = this._complexType.getName();
                    err = name != null ? (String)err + name : (String)err + "#anonymous-complexType#";
                    err = (String)err + "A complex type cannot be a restriction of a simpleType:";
                    err = (String)err + baseType.getName();
                    throw new IllegalStateException((String)err);
                }
                ComplexType temp = (ComplexType)baseType;
                if (!temp.isSimpleContent()) {
                    if (temp.getContentType().getType() != 1 || !temp.isEmptiable()) {
                        Object err = "complexType: ";
                        String name = this._complexType.getName();
                        err = name != null ? (String)err + name : (String)err + "#anonymous-complexType#";
                        err = (String)err + ": In a simpleContent when using restriction the base type must be a complexType with a simple content model or it must be a complex content model which is mixed and emptiable.";
                        throw new IllegalStateException((String)err);
                    }
                } else {
                    SimpleContent contentType = (SimpleContent)temp.getContentType();
                    this._complexType.setBaseType(temp);
                    this._complexType.setBase(temp.getName());
                    this._simpleTypeDef = new SimpleTypeDefinition(this._schema, temp.getName(), this._id);
                    SimpleType simpleType = contentType.getSimpleType();
                    if (simpleType != null) {
                        this._simpleTypeDef.setBaseType(simpleType);
                    } else {
                        this._simpleTypeDef.setBaseTypeName(contentType.getTypeName());
                    }
                }
            }
        }
    }

    @Override
    public String elementName() {
        return "restriction";
    }

    @Override
    public Object getObject() {
        return null;
    }

    @Override
    public void startElement(String name, String namespace, AttributeSet atts, Namespaces nsDecls) throws XMLException {
        if (this.unmarshaller != null) {
            this.unmarshaller.startElement(name, namespace, atts, nsDecls);
            ++this.depth;
            return;
        }
        if (name.equals("annotation")) {
            if (this.foundFacets || this.foundSimpleType || this.foundAttribute || this.foundAttributeGroup) {
                this.error("An annotation must appear as the first child of 'restriction' elements.");
            }
            if (this.foundAnnotation) {
                this.error("Only one (1) annotation may appear as a child of 'restriction' elements.");
            }
            this.foundAnnotation = true;
            this.unmarshaller = new AnnotationUnmarshaller(this.getSchemaContext(), atts);
        } else if ("simpleType".equals(name)) {
            if (this.foundSimpleType) {
                this.error("Only one (1) 'simpleType' may appear as a child of 'restriction' elements.");
            }
            if (this.foundFacets) {
                this.error("A 'simpleType', as a child of 'restriction' elements, must appear before any facets.");
            }
            if (this.foundAttribute || this.foundAttributeGroup) {
                this.error("A 'simpleType', as a child of 'restriction' elements, must appear before any attribute elements.");
            }
            this.foundSimpleType = true;
            this.unmarshaller = new SimpleTypeUnmarshaller(this.getSchemaContext(), this._schema, atts);
        } else if (FacetUnmarshaller.isFacet(name)) {
            this.foundFacets = true;
            if (this.foundAttribute || this.foundAttributeGroup) {
                this.error("A 'facet', as a child of 'restriction' elements, must appear before any attribute elements.");
            }
            this.unmarshaller = new FacetUnmarshaller(this.getSchemaContext(), name, atts);
            if (this._simpleTypeDef == null) {
                SimpleContent content = (SimpleContent)this._complexType.getContentType();
                this._simpleTypeDef = new SimpleTypeDefinition(this._schema, content.getTypeName(), this._id);
            }
        } else if ("attribute".equals(name)) {
            this.foundAttribute = true;
            this.unmarshaller = new AttributeUnmarshaller(this.getSchemaContext(), this._schema, atts);
        } else if ("attributeGroup".equals(name)) {
            if (atts.getValue("ref") == null) {
                this.error("A 'complexType' may contain referring attributeGroups, but not defining ones.");
            }
            this.foundAttributeGroup = true;
            this.unmarshaller = new AttributeGroupUnmarshaller(this.getSchemaContext(), this._schema, atts);
        } else if ("anyAttribute".equals(name)) {
            this.unmarshaller = new WildcardUnmarshaller(this.getSchemaContext(), this._complexType, this._schema, name, atts);
        } else {
            this.illegalElement(name);
        }
    }

    @Override
    public void endElement(String name, String namespace) throws XMLException {
        if (this.unmarshaller != null && this.depth > 0) {
            this.unmarshaller.endElement(name, namespace);
            --this.depth;
            return;
        }
        this.unmarshaller.finish();
        if ("annotation".equals(name)) {
            Annotation ann = ((AnnotationUnmarshaller)this.unmarshaller).getAnnotation();
            this._complexType.addAnnotation(ann);
        } else if ("anyAttribute".equals(name)) {
            Wildcard wildcard = ((WildcardUnmarshaller)this.unmarshaller).getWildcard();
            try {
                this._complexType.setAnyAttribute(wildcard);
            }
            catch (SchemaException e) {
                throw new IllegalArgumentException(e.getMessage());
            }
        } else if ("attribute".equals(name)) {
            AttributeDecl attrDecl = ((AttributeUnmarshaller)this.unmarshaller).getAttribute();
            this._complexType.addAttributeDecl(attrDecl);
        } else if ("attributeGroup".equals(name)) {
            AttributeGroupReference attrGroupRef = (AttributeGroupReference)this.unmarshaller.getObject();
            this._complexType.addAttributeGroupReference(attrGroupRef);
        } else if ("simpleType".equals(name)) {
            SimpleType type = (SimpleType)this.unmarshaller.getObject();
            this._complexType.setContentType(new SimpleContent(type));
        } else {
            this._simpleTypeDef.addFacet((Facet)this.unmarshaller.getObject());
            this.foundFacets = true;
        }
        this.unmarshaller = null;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws XMLException {
        if (this.unmarshaller != null) {
            this.unmarshaller.characters(ch, start, length);
        }
    }

    @Override
    public void finish() {
        if (this._simpleTypeDef != null) {
            SimpleType baseType = this._simpleTypeDef.createSimpleType();
            this._complexType.setContentType(new SimpleContent(baseType));
        }
        this._complexType.setRestriction(true);
    }
}

