/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.xjc.addon.at_generated;

import com.sun.codemodel.JAnnotatable;
import com.sun.codemodel.JAnnotationUse;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JMethod;
import com.sun.tools.xjc.BadCommandLineException;
import com.sun.tools.xjc.Driver;
import com.sun.tools.xjc.Options;
import com.sun.tools.xjc.Plugin;
import com.sun.tools.xjc.outline.ClassOutline;
import com.sun.tools.xjc.outline.EnumOutline;
import com.sun.tools.xjc.outline.Outline;
import com.sun.tools.xjc.outline.PackageOutline;
import java.io.IOException;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import org.xml.sax.ErrorHandler;

public class PluginImpl
extends Plugin {
    private JClass annotation;
    private boolean noDate = false;
    private String genAnnotation = "jakarta.annotation.Generated";
    private String date = null;

    @Override
    public String getOptionName() {
        return "mark-generated";
    }

    @Override
    public String getUsage() {
        return "  -mark-generated     :  mark the generated code as @jakarta.annotation.Generated\n                      -noDate            : do not add date\n                      -Xann <annotation> : generate <annotation> instead of @jakarta.annotation.Generated";
    }

    @Override
    public int parseArgument(Options opt, String[] args, int i) throws BadCommandLineException, IOException {
        if ("-noDate".equals(args[i])) {
            this.noDate = true;
            return 1;
        }
        if ("-Xann".equals(args[i])) {
            this.genAnnotation = opt.requireArgument("-Xann", args, ++i);
            return 2;
        }
        return 0;
    }

    @Override
    public boolean run(Outline model, Options opt, ErrorHandler errorHandler) {
        this.annotation = model.getCodeModel().ref(this.genAnnotation);
        for (ClassOutline classOutline : model.getClasses()) {
            this.augument(classOutline);
        }
        for (EnumOutline enumOutline : model.getEnums()) {
            this.augument(enumOutline);
        }
        for (PackageOutline packageOutline : model.getAllPackageContexts()) {
            this.augument(packageOutline);
        }
        return true;
    }

    private void augument(EnumOutline eo) {
        this.annotate(eo.clazz);
    }

    private void augument(ClassOutline co) {
        this.annotate(co.implClass);
        for (JMethod m : co.implClass.methods()) {
            this.annotate(m);
        }
        for (JFieldVar f : co.implClass.fields().values()) {
            this.annotate(f);
        }
    }

    private void augument(PackageOutline po) {
        this.annotate(po.objectFactory());
    }

    private void annotate(JAnnotatable m) {
        JAnnotationUse au = m.annotate(this.annotation).param("value", Driver.class.getName()).param("comments", "JAXB RI v" + Options.getBuildID());
        if (!this.noDate) {
            au.param("date", this.getISO8601Date());
        }
    }

    private String getISO8601Date() {
        if (this.date == null) {
            ZonedDateTime zdt = ZonedDateTime.now().withNano(0);
            this.date = zdt.format(DateTimeFormatter.ISO_OFFSET_DATE_TIME);
        }
        return this.date;
    }
}

