/*
 * Decompiled with CFR 0.152.
 */
package alma.observatorycharacteristics.timings;

import alma.hla.runtime.obsprep.util.Log;
import alma.observatorycharacteristics.capabilities.AlmaCapabilities;
import alma.observatorycharacteristics.timings.CorrelatorTimings;
import alma.observatorycharacteristics.timings.ObjectFactory;
import alma.observatorycharacteristics.timings.Timings;
import alma.obsprep.ot.gui.toplevel.InitServices;
import alma.obsprep.util.MiscUtils;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Objects;
import java.util.logging.Level;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.util.ValidationEventCollector;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;

public class SchedBlockTimingsXMLReader {
    public static final File ALMA_TIMING_CONFIGURATION_PROPERTIES_FOLDER = new File("alma/observatorycharacteristics/timings");
    private Timings sbTimings = null;
    private String telescopeUsedDuringLastUnmarshalling = null;
    private static SchedBlockTimingsXMLReader instance;

    public Timings getSBTimingInformation() throws JAXBException, InvalidOTCOnfigurationException {
        String string = System.getProperty("Telescope", "Cycle11");
        if (StringUtils.equals((CharSequence)string, (CharSequence)this.telescopeUsedDuringLastUnmarshalling) && this.sbTimings != null) {
            return this.sbTimings;
        }
        this.telescopeUsedDuringLastUnmarshalling = string;
        JAXBContext jAXBContext = JAXBContext.newInstance((Class[])new Class[]{ObjectFactory.class});
        Unmarshaller unmarshaller = jAXBContext.createUnmarshaller();
        ValidationEventCollector validationEventCollector = new ValidationEventCollector();
        unmarshaller.setEventHandler((ValidationEventHandler)validationEventCollector);
        InputStream inputStream = null;
        String string2 = string + "SBTimingConfiguration.xml";
        Log.logger(SchedBlockTimingsXMLReader.class).info("Loading SB Timing file : " + string2);
        try {
            ValidationEvent[] validationEventArray = MiscUtils.findResource(ALMA_TIMING_CONFIGURATION_PROPERTIES_FOLDER, string2);
            inputStream = validationEventArray.openStream();
        }
        catch (Exception exception) {
            Log.logger(AlmaCapabilities.class).log(Level.WARNING, "Error accessing " + string2 + " file: " + exception.getMessage(), (Throwable)exception);
            throw new RuntimeException(exception);
        }
        assert (inputStream != null);
        this.sbTimings = (Timings)((JAXBElement)unmarshaller.unmarshal(inputStream)).getValue();
        if (validationEventCollector.hasEvents()) {
            for (ValidationEvent validationEvent : validationEventCollector.getEvents()) {
                Log.logger(SchedBlockTimingsXMLReader.class).warning(validationEvent.getMessage());
            }
            throw new JAXBException("Unable to unmarshall SB timing parameters XML");
        }
        this.performIntegrityCheck(this.sbTimings);
        return this.sbTimings;
    }

    private void performIntegrityCheck(@NonNull Timings timings) {
        if (timings == null) {
            throw new NullPointerException("timings is marked non-null but is null");
        }
        int n = 1;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (CorrelatorTimings correlatorTimings : timings.getCorrelatorTimings()) {
            int n2 = Objects.hash(new Object[]{correlatorTimings.correlator}) * 3 + Objects.hash(correlatorTimings.isVLBI) * 37 + Objects.hash(new Object[]{correlatorTimings.divisionMode}) * 17 + Objects.hash(correlatorTimings.isFullPolarization) * 31 + Objects.hash(correlatorTimings.isHighDataRate) * 43 + Objects.hash(correlatorTimings.isLongBaseline) * 7 + Objects.hash(correlatorTimings.isSingleContinuumFDM) * 97 + Objects.hash(correlatorTimings.isWalshEnabled) * 73;
            for (int i = 0; i < arrayList.size(); ++i) {
                if (!((Integer)arrayList.get(i)).equals(n2)) continue;
                throw new RuntimeException("Duplicate entries found in XML file - check timing " + n + " and " + i + "1");
            }
            ++n;
            arrayList.add(n2);
        }
    }

    public static SchedBlockTimingsXMLReader getInstance() {
        if (null == instance) {
            instance = new SchedBlockTimingsXMLReader();
        }
        return instance;
    }

    public static void main(String[] stringArray) throws InvalidOTCOnfigurationException {
        System.setProperty("otData.dir", "config\\otData");
        InitServices.initModelSupportClasses();
        SchedBlockTimingsXMLReader schedBlockTimingsXMLReader = SchedBlockTimingsXMLReader.getInstance();
        try {
            schedBlockTimingsXMLReader.getSBTimingInformation();
        }
        catch (JAXBException jAXBException) {
            jAXBException.printStackTrace();
            System.exit(-1);
        }
        assert (schedBlockTimingsXMLReader != null);
        System.out.println("OT SB timing configuration XML file read in");
    }

    public class InvalidOTCOnfigurationException
    extends Exception {
        private static final long serialVersionUID = 115074371526577720L;

        public InvalidOTCOnfigurationException(String string) {
            super(string);
        }
    }
}

