/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.bo.obsproject;

import alma.hla.runtime.obsprep.bo.ValueUnitPair;
import alma.obsprep.bo.obsproject.SpectralSetupParameters;
import alma.obsprep.bo.schedblock.ReceiverBand;
import alma.obsprep.services.experts.SingleContinuumExpert;
import alma.obsprep.services.generator.BaseBandDeployer;
import alma.obsprep.services.generator.BaseBandNotDeployableException;
import alma.obsprep.services.losolutions.LOSolutionException;
import alma.obsprep.services.losolutions.OTLOsolutions;
import alma.valuetypes.Frequency;
import alma.valuetypes.Velocity;
import lombok.NonNull;
import org.apache.commons.jcs3.JCS;
import org.apache.commons.jcs3.access.CacheAccess;

public class LO1Manager {
    private final OTLOsolutions loconfigurator = OTLOsolutions.createOTLOsolutions();
    private static CacheAccess<Double, Frequency> loSolutionCache = JCS.getInstance((String)"loSolutionCache");
    @NonNull
    private final SpectralSetupParameters ssp;
    private Frequency lo1frequency;
    private boolean solutionFound = false;

    private BaseBandDeployer getDeployer() throws BaseBandNotDeployableException {
        return new BaseBandDeployer(this.ssp);
    }

    Frequency getLO1Frequency() {
        ReceiverBand receiverBand;
        if (this.lo1frequency == null) {
            this.lo1frequency = Frequency.createFrequency();
        }
        if (this.lo1frequency.isZero() && (receiverBand = this.ssp.getReceiverBand()) != null) {
            this.resetLO1Frequency();
        }
        return this.lo1frequency;
    }

    private void resetLO1Frequency() {
        this.setSolutionFound(false);
        ReceiverBand receiverBand = this.ssp.getReceiverBand();
        if (receiverBand == null) {
            return;
        }
        if (this.lo1frequency == null) {
            this.lo1frequency = Frequency.createFrequency();
        }
        this.lo1frequency.setContentAndUnit((ValueUnitPair)receiverBand.getRFRange().mid());
    }

    /*
     * WARNING - void declaration
     */
    public void updateLO1() throws BaseBandNotDeployableException {
        Frequency[] frequencyArray;
        Velocity velocity = this.ssp.getShiftVelocity();
        if (this.ssp.isSingleContinuum()) {
            SingleContinuumExpert singleContinuumExpert;
            try {
                singleContinuumExpert = this.ssp.getSingleContinuumExpert();
            }
            catch (Exception exception) {
                this.resetLO1Frequency();
                throw new BaseBandNotDeployableException(exception);
            }
            frequencyArray = singleContinuumExpert.getSingleContinuumBasebandCenters(true);
        } else if (this.ssp.getSSPDerivedFromSpectralScanSetup()) {
            frequencyArray = this.getDeployer().getAdjustedBaseBandCenterFrequenciesSky();
            velocity = Velocity.createVelocity();
        } else {
            frequencyArray = this.getDeployer().getAdjustedBaseBandCenterFrequenciesRest();
        }
        try {
            void var6_11;
            double d = 0.0;
            int n = 0;
            for (Frequency frequency : frequencyArray) {
                double[] dArray = new double[]{5.0, 17.0, 31.0, 37.0};
                double d2 = dArray[n++];
                n %= dArray.length;
                d += frequency.getContentInGHz() * d2;
            }
            Object var6_9 = null;
            if (!Double.isNaN(d += velocity.getCenterVelocity().getContentInDefaultUnits() * 13.0)) {
                Frequency frequency = (Frequency)((Object)loSolutionCache.get((Object)d));
            }
            if (var6_11 != null) {
                this.setSolutionFound(true);
                this.getLO1Frequency().setContentAndUnit((ValueUnitPair)var6_11.deepCopy());
            } else {
                ReceiverBand receiverBand = this.ssp.getReceiverBand();
                this.loconfigurator.setBasebandCenterFrequencies(frequencyArray, velocity, receiverBand);
                this.loconfigurator.computeSolutions(receiverBand);
                this.setSolutionFound(true);
                Frequency frequency = this.loconfigurator.getPreferredLO1FrequencySky();
                if (frequency == null) {
                    this.resetLO1Frequency();
                } else {
                    loSolutionCache.put((Object)d, (Object)frequency.deepCopy());
                    this.getLO1Frequency().setContentAndUnit((ValueUnitPair)frequency);
                }
            }
        }
        catch (LOSolutionException lOSolutionException) {
            this.resetLO1Frequency();
            throw new BaseBandNotDeployableException(lOSolutionException);
        }
    }

    public LO1Manager(@NonNull SpectralSetupParameters spectralSetupParameters) {
        if (spectralSetupParameters == null) {
            throw new NullPointerException("ssp is marked non-null but is null");
        }
        this.ssp = spectralSetupParameters;
    }

    public String toString() {
        return "LO1Manager(loconfigurator=" + this.loconfigurator + ", ssp=" + this.ssp + ", lo1frequency=" + this.getLO1Frequency() + ", solutionFound=" + this.isSolutionFound() + ")";
    }

    public boolean isSolutionFound() {
        return this.solutionFound;
    }

    public void setSolutionFound(boolean bl) {
        this.solutionFound = bl;
    }
}

