/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.bo.obsproject;

import alma.entity.xmlbinding.obsproject.ObsProgramT;
import alma.obsprep.bo.annotations.GUIScienceGoalAcceptor;
import alma.obsprep.bo.annotations.SummaryTable;
import alma.obsprep.bo.obsproject.AbstractScienceGoal;
import alma.obsprep.bo.obsproject.ObsUnitSet;
import alma.obsprep.bo.obsproject.data.ObsProgramData;
import alma.obsprep.ot.models.misc.SummaryTableRow;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;

public class ObsProgram
extends ObsProgramData
implements GUIScienceGoalAcceptor,
SummaryTable<SummaryTableRow> {
    private static final String OPTICAL_POINTING_OUS_NAME = "Optical Pointing";

    public ObsProgram(ObsProgramT obsProgramT) {
        super(obsProgramT);
    }

    public ObsUnitSet obsUnitSetForOpticalPointing() {
        ObsUnitSet obsUnitSet = this.getObsPlan();
        ObsUnitSet obsUnitSet2 = obsUnitSet.findObsUnitSetByName(OPTICAL_POINTING_OUS_NAME);
        if (obsUnitSet2 == null) {
            obsUnitSet2 = ObsUnitSet.createObsUnitSet();
            obsUnitSet2.setName(OPTICAL_POINTING_OUS_NAME);
            obsUnitSet.addObsUnitSet(obsUnitSet2);
        }
        return obsUnitSet2;
    }

    public String toTreeString(int n, boolean bl, boolean bl2) {
        StringBuilder stringBuilder = new StringBuilder();
        if (bl) {
            stringBuilder.append("Science Plan");
        } else {
            stringBuilder.append("Phase-I Setup");
            if (!bl2) {
                stringBuilder.append(' ');
                stringBuilder.append(this.getObsPlan().briefDescription());
            }
        }
        return stringBuilder.toString();
    }

    public ObsProgram placeToAdd() {
        return this;
    }

    @Override
    public void removeScienceGoal(AbstractScienceGoal abstractScienceGoal) {
        this.removeAbstractScienceGoal(abstractScienceGoal);
    }

    public ObsUnitSet findObsUnitSetById(String string) {
        return this.getObsPlan().findObsUnitSetById(string);
    }

    @Override
    public Iterator<SummaryTableRow> iterator() {
        return new ArrayList<AbstractScienceGoal>(Arrays.asList(this.getAbstractScienceGoal())).iterator();
    }

    @Override
    public boolean expandsRow() {
        return false;
    }

    @Override
    public boolean isSummaryTableEditable() {
        return false;
    }
}

