/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.bo.obsproject;

import alma.entity.xmlbinding.obsproject.SpectralScanT;
import alma.hla.runtime.obsprep.bo.AbstractDoubleWithUnit;
import alma.hla.runtime.obsprep.util.Log;
import alma.observatorycharacteristics.capabilities.AlmaCapabilities;
import alma.obsprep.bo.enumerations.CorrPolarization;
import alma.obsprep.bo.obsproject.AbstractScienceGoal;
import alma.obsprep.bo.obsproject.AbstractScienceSpectralWindow;
import alma.obsprep.bo.obsproject.ObservatoryGoal;
import alma.obsprep.bo.obsproject.RepresentativeWindowInterface;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproject.ScienceSpectralWindow;
import alma.obsprep.bo.obsproject.ScienceSpectralWindowFactory;
import alma.obsprep.bo.obsproject.SpectralFeedback;
import alma.obsprep.bo.obsproject.SpectralSetupParameters;
import alma.obsprep.bo.obsproject.UnableToFindSolutionException;
import alma.obsprep.bo.obsproject.data.SpectralScanData;
import alma.obsprep.bo.schedblock.CorrConfigMode;
import alma.obsprep.bo.schedblock.OTConfigModeDecoder;
import alma.obsprep.bo.schedblock.ReceiverBand;
import alma.obsprep.services.experts.ReceiverExpert;
import alma.obsprep.util.FrequencyRange;
import alma.valuetypes.Frequency;
import alma.valuetypes.Speed;
import alma.valuetypes.Velocity;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import lombok.NonNull;

public class SpectralScan
extends SpectralScanData
implements RepresentativeWindowInterface {
    private static final Map<Integer, SpectralScanConfiguration> scanSpecificBandInfo = new HashMap<Integer, SpectralScanConfiguration>();
    private static final Map<Frequency, Frequency> tuningOverlap = new HashMap<Frequency, Frequency>();
    private SpectralFeedback spectralScanFeedback = null;
    public static final Integer MAXTUNINGS;

    public SpectralScan(SpectralScanT spectralScanT) {
        super(spectralScanT);
    }

    public String shortDescription() {
        return "Scan";
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getClass().getSimpleName());
        stringBuilder.append("[");
        stringBuilder.append("name=" + this.getName());
        stringBuilder.append(",start=" + this.getStartFrequency());
        stringBuilder.append(",end=" + this.getEndFrequency());
        stringBuilder.append(",bandwidth=" + this.getBandWidth());
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    @Override
    public Frequency getCenterFrequency() {
        return (Frequency)((Frequency)this.getStartFrequency().plus((AbstractDoubleWithUnit)this.getEndFrequency())).divide(2.0);
    }

    public FrequencyRange getRealisableScanRange() {
        SpectralScanTunings spectralScanTunings = null;
        FrequencyRange frequencyRange = null;
        try {
            spectralScanTunings = this.getTunings();
        }
        catch (UnableToFindSolutionException unableToFindSolutionException) {
            return null;
        }
        try {
            frequencyRange = spectralScanTunings.getAchievedScanRange();
        }
        catch (SpectralScanTunings.SpectralScanTuningException spectralScanTuningException) {
            return null;
        }
        return frequencyRange;
    }

    public SpectralScanTunings getTunings() throws UnableToFindSolutionException {
        return this.getTunings(this.getStartFrequency(), this.getEndFrequency());
    }

    private SpectralScanTunings getTunings(@NonNull Frequency frequency, @NonNull Frequency frequency2) throws UnableToFindSolutionException {
        Object object;
        ReceiverBand receiverBand;
        Set<ReceiverBand> set;
        if (frequency == null) {
            throw new NullPointerException("startFrequencyOfScan is marked non-null but is null");
        }
        if (frequency2 == null) {
            throw new NullPointerException("endFrequencyOfScan is marked non-null but is null");
        }
        ReceiverExpert receiverExpert = ReceiverExpert.getInstance();
        Set<ReceiverBand> set2 = receiverExpert.getSuitableReceiverSet(frequency.getContentInGHz());
        if (Sets.intersection(set2, set = receiverExpert.getSuitableReceiverSet(frequency2.getContentInGHz())).isEmpty()) {
            throw new UnableToFindSolutionException(SpectralScanErrors.RECEIVERBANDRANGEVIOLATION, "The scan covers multiple receiver bands");
        }
        SpectralScanTunings spectralScanTunings = new SpectralScanTunings();
        if (this.getParent() == null) {
            throw new UnableToFindSolutionException(SpectralScanErrors.NULLDOCUMENT, "No parent document");
        }
        this.spectralScanFeedback = null;
        if (!this.isSpectralScanParametersValid()) {
            throw new UnableToFindSolutionException(SpectralScanErrors.SCANPARAMETERSINVALID, "Invalid scan parameters found");
        }
        FrequencyRange frequencyRange = new FrequencyRange(frequency, frequency2);
        try {
            receiverBand = ReceiverBand.getReceiverBand(frequencyRange);
        }
        catch (ReceiverBand.ReceiverNotFoundException receiverNotFoundException) {
            this.spectralScanFeedback = new SpectralFeedback(SpectralFeedback.AdvisoryType.ERROR, "Unable to identify receiver band associated with scan range");
            throw new UnableToFindSolutionException(SpectralScanErrors.ILLEGALRECEIVERBAND, this.spectralScanFeedback.getMessage());
        }
        int n = receiverBand.getNumber();
        double d = ((Frequency)((Object)receiverBand.getRFRange().range())).getContentInGHz();
        double d2 = -1.0;
        if (!scanSpecificBandInfo.containsKey(n)) {
            throw new UnableToFindSolutionException(SpectralScanErrors.SCANPARAMETERSINVALID, "Unable to determine the sideband gap");
        }
        d2 = scanSpecificBandInfo.get(n).getSidebandGap().getContentInDefaultUnits();
        assert (d2 != -1.0);
        double d3 = this.getEffectiveBandwidth().getContentInGHz();
        double d4 = frequency2.getContentInGHz() - frequency.getContentInGHz();
        double d5 = this.getTuningOverlap().getContentInGHz();
        double d6 = (double)MAXTUNINGS.intValue() * (2.0 * d3 - d5);
        if (d5 > d3) {
            this.spectralScanFeedback = new SpectralFeedback(SpectralFeedback.AdvisoryType.ERROR, "Specified overlap is greater than the effective bandwidth");
            throw new UnableToFindSolutionException(SpectralScanErrors.SCANPARAMETERSINVALID, this.spectralScanFeedback.getMessage());
        }
        ArrayList<Frequency> arrayList = new ArrayList<Frequency>();
        ArrayList<Frequency> arrayList2 = new ArrayList<Frequency>();
        double d7 = d3 / 2.0;
        Integer n2 = MAXTUNINGS;
        if (d3 < 1.5 || d4 < d6 || n == 1) {
            Log.logger(SpectralScan.class).finer("Single sideband case: effectiveBandWidth: " + d3);
            spectralScanTunings.setTwoSidebandScanSolution(false);
            int n3 = d3 > 1.5 && n > 1 && n < 9 ? 2 : 4;
            double d8 = (double)n3 * (d3 - d5);
            n2 = Math.min(MAXTUNINGS, (int)(d / d8));
            int n4 = Math.min(n2, (int)Math.ceil(d4 / d8));
            int n5 = Math.min(MAXTUNINGS, n4);
            Log.logger(SpectralScan.class).finer("requiredNumberOfTunings: " + n4);
            for (int i = 0; i < n3 * n5; ++i) {
                Frequency frequency3;
                Frequency frequency4;
                if (i == 0 && (frequency4 = Frequency.createFrequencyGHZ(frequency.getContentInGHz() + d7)).isLessThan((AbstractDoubleWithUnit)(frequency3 = Frequency.createFrequencyGHZ(receiverBand.getRFMin() + this.getBandWidth().getContentInMHz() / 2.0 / 1000.0)))) {
                    frequency = (Frequency)frequency.plus((AbstractDoubleWithUnit)((Frequency)frequency3.minus((AbstractDoubleWithUnit)frequency4)));
                }
                int n6 = i % n3;
                frequency4 = Frequency.createFrequencyGHZ(frequency.getContentInGHz() + d7 + (d3 - d5) * (double)i);
                Log.logger(SpectralScan.class).finer("SPW centreFrequency: " + frequency4);
                arrayList.add(frequency4);
                if (n6 != n3 - 1) continue;
                spectralScanTunings.addTuning(arrayList);
                arrayList = new ArrayList();
            }
        } else {
            int n7;
            double d9;
            double d10;
            int n8;
            Log.logger(SpectralScan.class).finer("Two sideband spectral scan solution scenario");
            Log.logger(SpectralScan.class).finer("effectiveBandWidth: " + d3);
            SpectralSetupParameters spectralSetupParameters = (SpectralSetupParameters)this.getParent();
            object = spectralSetupParameters.getReceiverBand();
            if (object == null) {
                this.spectralScanFeedback = new SpectralFeedback(SpectralFeedback.AdvisoryType.ERROR, "Unable to identify receiver band associated with scan range");
                throw new UnableToFindSolutionException(SpectralScanErrors.ILLEGALRECEIVERBAND, this.spectralScanFeedback.getMessage());
            }
            boolean bl = ReceiverBand.isReceiverBandInSet(object, new int[]{9, 10});
            if (bl) {
                n8 = 8;
                d10 = 4.0 * d3 - 3.0 * d5;
                d9 = d2 + (8.0 - d10);
            } else {
                n8 = 4;
                d10 = 2.0 * d3 - d5;
                d9 = d2 + (4.0 - d10);
            }
            double d11 = d10 - d5;
            int n9 = (int)Math.ceil(d9 / d10 + 1.0);
            double d12 = (double)n9 * d10 + d9 + d10;
            int n10 = 0;
            if (bl) {
                if (d4 >= d12 - d7) {
                    n7 = (int)Math.ceil((d4 - d12) / d11);
                    n10 = Math.min(n2, n9 + n7);
                } else {
                    n10 = n9;
                }
            } else {
                n7 = d4 >= d12 - d7 ? 1 : 0;
                n10 = n9 + n7;
                n10 = Math.min(n2, n10);
            }
            for (n7 = 0; n7 < n10; ++n7) {
                Frequency frequency5;
                Object object2;
                if (n7 == 0 && (object2 = Frequency.createFrequencyGHZ(frequency.getContentInGHz() + d7)).isLessThan((AbstractDoubleWithUnit)(frequency5 = Frequency.createFrequencyGHZ(receiverBand.getRFMin() + this.getBandWidth().getContentInMHz() / 2.0 / 1000.0)))) {
                    frequency = (Frequency)frequency.plus((AbstractDoubleWithUnit)((Frequency)frequency5.minus((AbstractDoubleWithUnit)object2)));
                }
                if (n8 == 4) {
                    arrayList.add(Frequency.createFrequencyGHZ(frequency.getContentInGHz() + d7 + d11 * (double)n7));
                    arrayList.add(Frequency.createFrequencyGHZ(arrayList.get(0).getContentInGHz() + d3 - d5));
                    arrayList.add(Frequency.createFrequencyGHZ(arrayList.get(0).getContentInGHz() + d2 + 4.0));
                    arrayList.add(Frequency.createFrequencyGHZ(arrayList.get(1).getContentInGHz() + d2 + 4.0));
                } else if (n8 == 8) {
                    arrayList.add(Frequency.createFrequencyGHZ(frequency.getContentInGHz() + d7 + d11 * (double)n7));
                    arrayList.add(Frequency.createFrequencyGHZ(arrayList.get(0).getContentInGHz() + d3 - d5));
                    arrayList.add(Frequency.createFrequencyGHZ(arrayList.get(1).getContentInGHz() + d3 - d5));
                    arrayList.add(Frequency.createFrequencyGHZ(arrayList.get(2).getContentInGHz() + d3 - d5));
                    arrayList2.add(Frequency.createFrequencyGHZ(arrayList.get(0).getContentInGHz() + d2 + 8.0));
                    arrayList2.add(Frequency.createFrequencyGHZ(arrayList.get(1).getContentInGHz() + d2 + 8.0));
                    arrayList2.add(Frequency.createFrequencyGHZ(arrayList.get(2).getContentInGHz() + d2 + 8.0));
                    arrayList2.add(Frequency.createFrequencyGHZ(arrayList.get(3).getContentInGHz() + d2 + 8.0));
                    spectralScanTunings.addImageTuning(arrayList2);
                }
                if (Log.logger(SpectralScan.class).isLoggable(Level.FINEST)) {
                    object2 = arrayList.iterator();
                    while (object2.hasNext()) {
                        frequency5 = (Frequency)((Object)object2.next());
                        Log.logger(SpectralScan.class).finest("Tuning: " + n7 + " SPW central frequency: " + frequency5);
                    }
                }
                spectralScanTunings.addTuning(arrayList);
                spectralScanTunings.setTwoSidebandScanSolution(true);
                arrayList = new ArrayList();
                arrayList2 = new ArrayList();
            }
        }
        Frequency frequency6 = null;
        try {
            frequency6 = spectralScanTunings.getImageTunings().isEmpty() ? spectralScanTunings.getTuning(spectralScanTunings.getNumberOfTunings() - 1).get(spectralScanTunings.getNumberOfSPWs() - 1) : spectralScanTunings.getImageTuning(spectralScanTunings.getNumberOfTunings() - 1).get(spectralScanTunings.getNumberOfSPWs() - 1);
        }
        catch (SpectralScanTunings.SpectralScanTuningException spectralScanTuningException) {
            throw new UnableToFindSolutionException(SpectralScanErrors.SCANPARAMETERSINVALID, "Unable to get tuning details");
        }
        if (frequency6.getContentInGHz() + d7 < frequency2.getContentInGHz()) {
            this.spectralScanFeedback = new SpectralFeedback(SpectralFeedback.AdvisoryType.WARNING, "This scan requires more than " + n2 + " tunings to cover the frequency range specified, the achievable scan is narrower than requested");
        }
        if (frequency6.getContentInGHz() + d7 > receiverBand.getRFMax() - 0.11) {
            object = Frequency.createFrequencyGHZ(frequency.getContentInGHz() - 0.11 - (frequency6.getContentInGHz() + d7 - receiverBand.getRFMax()));
            Frequency frequency7 = Frequency.createFrequencyGHZ(frequency2.getContentInGHz() - 0.11 - (frequency6.getContentInGHz() + d7 - receiverBand.getRFMax()));
            return this.getTunings((Frequency)((Object)object), frequency7);
        }
        return spectralScanTunings;
    }

    public Frequency getTuningOverlap() throws UnableToFindSolutionException {
        if (!tuningOverlap.containsKey(this.getBandwidth())) {
            throw new UnableToFindSolutionException(SpectralScanErrors.SCANPARAMETERSINVALID, "Unable to establish overlap");
        }
        Log.logger(SpectralScan.class).finest("Using tuning overlap: " + (Object)((Object)tuningOverlap.get(this.getBandwidth())) + " for BW " + this.getBandwidth());
        return tuningOverlap.get(this.getBandwidth()).deepCopy();
    }

    private boolean isSpectralScanParametersValid() {
        ReceiverBand receiverBand;
        boolean bl;
        List<ReceiverBand> list = AlmaCapabilities.getInstance().getSpectralScanReceiverBands();
        Frequency frequency = this.getStartFrequency().deepCopy();
        Frequency frequency2 = this.getEndFrequency().deepCopy();
        assert (frequency != null);
        assert (frequency2 != null);
        FrequencyRange frequencyRange = new FrequencyRange(frequency, frequency2);
        boolean bl2 = bl = Math.round(this.getStartFrequency().getContentInGHz()) > 0L && Math.round(this.getEndFrequency().getContentInGHz()) > 0L;
        if (!bl) {
            return false;
        }
        if (frequency.isGreaterThanOrEqualTo((AbstractDoubleWithUnit)frequency2)) {
            return false;
        }
        try {
            receiverBand = ReceiverBand.getReceiverBand(frequencyRange);
        }
        catch (ReceiverBand.ReceiverNotFoundException receiverNotFoundException) {
            return false;
        }
        if (receiverBand == null) {
            return false;
        }
        return list.contains(receiverBand);
    }

    @Override
    public CorrConfigMode getCorrConfigMode() {
        OTConfigModeDecoder oTConfigModeDecoder = OTConfigModeDecoder.getInstance();
        SpectralSetupParameters spectralSetupParameters = (SpectralSetupParameters)this.getParent();
        CorrPolarization corrPolarization = CorrPolarization.getCorrPolarization(spectralSetupParameters.getPolarisation());
        Set<CorrConfigMode> set = oTConfigModeDecoder.findMode(corrPolarization, CorrConfigMode.getAllModes());
        Set<CorrConfigMode> set2 = oTConfigModeDecoder.findMode((Frequency)((Object)this.getBandWidth()), this.getSpectralResolution(), set, (Boolean)true, false);
        set2 = oTConfigModeDecoder.findMode((Frequency)((Object)this.getBandWidth()), this.getSpectralResolution(), set, (Boolean)true, false);
        return set2.isEmpty() ? CorrConfigMode.INVALID_CORRCONFIGMODE : set2.toArray(new CorrConfigMode[1])[0];
    }

    public void setSpectralAveraging(int n) {
        this.getAdvancedWindowSetup().setSmoothingFactor(n);
    }

    public void setSpectralAveraging(String string) {
        int n;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            Log.logger((Object)this).info("Unable to convert spectral averaging value " + string + " to an integer");
            return;
        }
        this.setSpectralAveraging(n);
    }

    public Integer getSpectralAverageFactor() {
        return this.getAdvancedWindowSetup().getSmoothingFactor();
    }

    public Frequency getEffectiveBandwidth() {
        return this.getCorrConfigMode().getEffectiveBandwidth();
    }

    public static SpectralSetupParameters createSPWBasedSSPFromSpectralScanTuning(SpectralSetupParameters spectralSetupParameters, List<Frequency> list) throws UnableToFindSolutionException {
        SpectralSetupParameters spectralSetupParameters2 = spectralSetupParameters.deepCopy();
        AbstractScienceGoal abstractScienceGoal = (AbstractScienceGoal)spectralSetupParameters.getParent().deepCopy();
        Frequency frequency = spectralSetupParameters2.getRepresentativeFrequency().deepCopy();
        spectralSetupParameters2.setSSPDerivedFromSpectralScanSetup(true);
        if (abstractScienceGoal instanceof ScienceGoal) {
            var5_5 = (ScienceGoal)((Object)abstractScienceGoal);
            ((ScienceGoal)var5_5).setSpectralSetupParameters(spectralSetupParameters2);
            ((ScienceGoal)var5_5).setParentSpectralSetupParameters(spectralSetupParameters.deepCopy());
        } else if (abstractScienceGoal instanceof ObservatoryGoal) {
            var5_5 = (ObservatoryGoal)((Object)abstractScienceGoal);
            var5_5.setSpectralSetupParameters(spectralSetupParameters2);
            ((ObservatoryGoal)var5_5).setParentSpectralSetupParameters(spectralSetupParameters.deepCopy());
        } else {
            throw new RuntimeException("Unable to determine subclass of AbstractScienceGoal");
        }
        spectralSetupParameters2.setSpectralType(SpectralSetupParameters.SpectralSetupTypeChoice.SPECTRALLINE);
        spectralSetupParameters2.clearAbstractScienceSpectralWindow();
        for (int i = 0; i < list.size(); ++i) {
            SpectralScan spectralScan = spectralSetupParameters.getSpectralScan();
            ScienceSpectralWindow scienceSpectralWindow = ScienceSpectralWindowFactory.createScienceSpectralWindow(list.get(i).getContentInGHz(), "Spec. Scan ", spectralScan.getBandwidth().getContentInMHz(), spectralScan.getSpectralResolution().getContentInMHz());
            scienceSpectralWindow.setAdvancedWindowSetup(spectralScan.getAdvancedWindowSetup().deepCopy());
            scienceSpectralWindow.resetCorrConfigMode();
            scienceSpectralWindow.setIsSkyFrequency(true);
            scienceSpectralWindow.setGroupIndex(i);
            spectralSetupParameters2.addAbstractScienceSpectralWindow((AbstractScienceSpectralWindow)((Object)scienceSpectralWindow));
        }
        spectralSetupParameters2.setRepresentativeFrequency(frequency);
        return spectralSetupParameters2;
    }

    Frequency getEffectiveResolution() {
        return this.getCorrConfigMode().getEffectiveResolution(this.getAdvancedWindowSetup());
    }

    double getVelocityResolutionInSky(Velocity velocity) {
        Frequency frequency = this.getEffectiveResolution();
        Frequency frequency2 = this.getCenterFrequency();
        if (!this.hasIsSkyFrequency() || !(!this.getIsSkyFrequency())) {
            frequency2 = velocity.dopplerShift(frequency2);
        }
        return Speed.getSpeedResolution(frequency, frequency2).getContentInUnits(Speed.UNIT_KM_S);
    }

    public ReceiverBand getSpectralScanReceiverBand() throws ReceiverBand.ReceiverNotFoundException {
        FrequencyRange frequencyRange = FrequencyRange.wholeRange(List.of(this.getStartFrequency(), this.getEndFrequency()));
        ReceiverBand receiverBand = ReceiverBand.getReceiverBand(frequencyRange);
        if (receiverBand == null) {
            throw new ReceiverBand.ReceiverNotFoundException("Unable to determine spectral scan receiver band");
        }
        return receiverBand;
    }

    public double getSpectralAveragingFactor() {
        int n = this.getAdvancedWindowSetup().getSmoothingFactor();
        Map<Integer, Number> map = ScienceSpectralWindow.getSpectralAverageBUFSFactorMapping();
        if (!map.containsKey(n)) {
            throw new RuntimeException("Mapping for spectralAverage " + n + " not found");
        }
        return map.getOrDefault(n, 1).doubleValue();
    }

    public SpectralFeedback getSpectralScanFeedback() {
        return this.spectralScanFeedback;
    }

    static {
        scanSpecificBandInfo.put(1, new SpectralScanConfiguration(Frequency.createFrequencyGHZ(12.0), Frequency.createFrequencyGHZ(24.75)));
        scanSpecificBandInfo.put(2, new SpectralScanConfiguration(Frequency.createFrequencyGHZ(8.0), Frequency.createFrequencyGHZ(24.75)));
        scanSpecificBandInfo.put(3, new SpectralScanConfiguration(Frequency.createFrequencyGHZ(8.0), Frequency.createFrequencyGHZ(24.75)));
        scanSpecificBandInfo.put(4, new SpectralScanConfiguration(Frequency.createFrequencyGHZ(8.0), Frequency.createFrequencyGHZ(24.75)));
        scanSpecificBandInfo.put(5, new SpectralScanConfiguration(Frequency.createFrequencyGHZ(8.0), Frequency.createFrequencyGHZ(24.75)));
        scanSpecificBandInfo.put(6, new SpectralScanConfiguration(Frequency.createFrequencyGHZ(12.0), Frequency.createFrequencyGHZ(31.75)));
        scanSpecificBandInfo.put(7, new SpectralScanConfiguration(Frequency.createFrequencyGHZ(8.0), Frequency.createFrequencyGHZ(24.75)));
        scanSpecificBandInfo.put(8, new SpectralScanConfiguration(Frequency.createFrequencyGHZ(8.0), Frequency.createFrequencyGHZ(24.75)));
        scanSpecificBandInfo.put(9, new SpectralScanConfiguration(Frequency.createFrequencyGHZ(8.0), Frequency.createFrequencyGHZ(38.5)));
        scanSpecificBandInfo.put(10, new SpectralScanConfiguration(Frequency.createFrequencyGHZ(8.0), Frequency.createFrequencyGHZ(38.5)));
        tuningOverlap.put(Frequency.createFrequencyMHZ(2000.0), Frequency.createFrequencyMHZ(171.875));
        tuningOverlap.put(Frequency.createFrequencyMHZ(1000.0), Frequency.createFrequencyMHZ(31.25));
        tuningOverlap.put(Frequency.createFrequencyMHZ(500.0), Frequency.createFrequencyMHZ(31.25));
        MAXTUNINGS = 5;
    }

    public class SpectralScanTunings {
        private boolean isTwoSidebandScanSolution = false;
        private final List<ArrayList<Frequency>> tunings = new ArrayList<ArrayList<Frequency>>();
        private final List<ArrayList<Frequency>> imageTunings = new ArrayList<ArrayList<Frequency>>();

        public Integer getNumberOfTunings() {
            return this.tunings.size();
        }

        public void clearTunings() {
            this.tunings.clear();
        }

        public void addTuning(ArrayList<Frequency> arrayList) {
            this.tunings.add(arrayList);
        }

        public void addImageTuning(ArrayList<Frequency> arrayList) {
            this.imageTunings.add(arrayList);
        }

        public List<ArrayList<Frequency>> getTunings() throws SpectralScanTuningException {
            if (this.getNumberOfTunings() == 0) {
                throw new SpectralScanTuningException("No tunings have been calculated");
            }
            return this.tunings;
        }

        public List<ArrayList<Frequency>> getImageTunings() throws SpectralScanTuningException {
            if (this.getNumberOfTunings() == 0) {
                throw new SpectralScanTuningException("No tunings have been calculated");
            }
            return this.imageTunings;
        }

        public FrequencyRange getAchievedScanRange() throws SpectralScanTuningException {
            List<ArrayList<Frequency>> list;
            boolean bl;
            if (this.getNumberOfTunings() == 0) {
                throw new SpectralScanTuningException("No tunings have been calculated");
            }
            Frequency frequency = (Frequency)SpectralScan.this.getEffectiveBandwidth().divide(2.0);
            Frequency frequency2 = (Frequency)this.tunings.get(0).get(0).minus((AbstractDoubleWithUnit)frequency);
            Frequency frequency3 = (Frequency)this.tunings.get(this.tunings.size() - 1).get(this.tunings.get(0).size() - 1).plus((AbstractDoubleWithUnit)frequency);
            FrequencyRange frequencyRange = new FrequencyRange(frequency2, frequency3);
            try {
                bl = ReceiverBand.isReceiverBandInSet(ReceiverBand.getReceiverBand(frequencyRange), 9, 10);
            }
            catch (ReceiverBand.ReceiverNotFoundException receiverNotFoundException) {
                throw new RuntimeException("Unable to determine receiver band" + receiverNotFoundException.getMessage());
            }
            if (bl && SpectralScan.this.getEffectiveBandwidth().isEqual((AbstractDoubleWithUnit)Frequency.createFrequencyMHZ(1875.0)) && !(list = this.getImageTunings()).isEmpty()) {
                frequency3 = (Frequency)list.get(list.size() - 1).get(list.get(0).size() - 1).plus((AbstractDoubleWithUnit)frequency);
                frequencyRange = new FrequencyRange(frequency2, frequency3);
            }
            return frequencyRange;
        }

        public List<Frequency> getTuning(int n) throws SpectralScanTuningException {
            if (n >= this.getNumberOfTunings()) {
                throw new SpectralScanTuningException("Requested tuning exceeds the number of tunings");
            }
            return this.tunings.get(n);
        }

        public List<Frequency> getImageTuning(int n) throws SpectralScanTuningException {
            if (n >= this.getNumberOfTunings()) {
                throw new SpectralScanTuningException("Requested tuning exceeds the number of tunings");
            }
            return this.imageTunings.get(n);
        }

        public Integer getNumberOfSPWs() throws SpectralScanTuningException {
            if (this.getNumberOfTunings() == 0) {
                throw new SpectralScanTuningException("No tunings calculated");
            }
            return this.tunings.get(0).size();
        }

        public boolean isTwoSidebandScanSolution() {
            return this.isTwoSidebandScanSolution;
        }

        public void setTwoSidebandScanSolution(boolean bl) {
            this.isTwoSidebandScanSolution = bl;
        }

        public class SpectralScanTuningException
        extends Exception {
            public SpectralScanTuningException(String string) {
                super(string);
            }
        }
    }

    public static enum SpectralScanErrors {
        RECEIVERBANDRANGEVIOLATION,
        MAXTUNINGSEXCEEDED,
        ILLEGALRECEIVERBAND,
        SCANPARAMETERSINVALID,
        CALCULATEDSOLUTIONINSUFFICIENT,
        NULLDOCUMENT;

    }

    @NonNull
    public static class SpectralScanConfiguration {
        private Frequency sidebandGap;
        private Frequency twoSidebandWidthThreshold;

        public Frequency getSidebandGap() {
            return this.sidebandGap;
        }

        public Frequency getTwoSidebandWidthThreshold() {
            return this.twoSidebandWidthThreshold;
        }

        public void setSidebandGap(Frequency frequency) {
            this.sidebandGap = frequency;
        }

        public void setTwoSidebandWidthThreshold(Frequency frequency) {
            this.twoSidebandWidthThreshold = frequency;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof SpectralScanConfiguration)) {
                return false;
            }
            SpectralScanConfiguration spectralScanConfiguration = (SpectralScanConfiguration)object;
            if (!spectralScanConfiguration.canEqual(this)) {
                return false;
            }
            Frequency frequency = this.getSidebandGap();
            Frequency frequency2 = spectralScanConfiguration.getSidebandGap();
            if (frequency == null ? frequency2 != null : !((Object)((Object)frequency)).equals((Object)frequency2)) {
                return false;
            }
            Frequency frequency3 = this.getTwoSidebandWidthThreshold();
            Frequency frequency4 = spectralScanConfiguration.getTwoSidebandWidthThreshold();
            return !(frequency3 == null ? frequency4 != null : !((Object)((Object)frequency3)).equals((Object)frequency4));
        }

        protected boolean canEqual(Object object) {
            return object instanceof SpectralScanConfiguration;
        }

        public int hashCode() {
            int n = 1;
            Frequency frequency = this.getSidebandGap();
            n = n * 59 + (frequency == null ? 43 : ((Object)((Object)frequency)).hashCode());
            Frequency frequency2 = this.getTwoSidebandWidthThreshold();
            n = n * 59 + (frequency2 == null ? 43 : ((Object)((Object)frequency2)).hashCode());
            return n;
        }

        public String toString() {
            return "SpectralScan.SpectralScanConfiguration(sidebandGap=" + this.getSidebandGap() + ", twoSidebandWidthThreshold=" + this.getTwoSidebandWidthThreshold() + ")";
        }

        public SpectralScanConfiguration(Frequency frequency, Frequency frequency2) {
            this.sidebandGap = frequency;
            this.twoSidebandWidthThreshold = frequency2;
        }
    }
}

