/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.bo.obsproject;

import alma.entity.xmlbinding.obsproject.SpectralSetupParametersT;
import alma.hla.runtime.obsprep.bo.AbstractDoubleWithUnit;
import alma.hla.runtime.obsprep.bo.BusinessObject;
import alma.hla.runtime.obsprep.bo.Copier;
import alma.hla.runtime.obsprep.bo.CopyException;
import alma.hla.runtime.obsprep.bo.IBusinessObject;
import alma.hla.runtime.obsprep.bo.ReferenceableProxy;
import alma.hla.runtime.obsprep.bo.ReferenceablesMap;
import alma.hla.runtime.obsprep.bo.ValueUnitPair;
import alma.hla.runtime.obsprep.util.Log;
import alma.hla.runtime.obsprep.util.UnknownEntityException;
import alma.observatorycharacteristics.capabilities.AlmaCapabilities;
import alma.observatorycharacteristics.configuration.VLBIFrequencyBands;
import alma.obsprep.bo.annotations.ObservingFrequency;
import alma.obsprep.bo.enumerations.CorrFilter;
import alma.obsprep.bo.enumerations.CorrPolarization;
import alma.obsprep.bo.enumerations.CorrelatorType;
import alma.obsprep.bo.enumerations.ReceiverType;
import alma.obsprep.bo.enumerations.SpectralAverage;
import alma.obsprep.bo.obsproject.AbstractScienceGoal;
import alma.obsprep.bo.obsproject.AbstractScienceSpectralWindow;
import alma.obsprep.bo.obsproject.BasebandSwapListener;
import alma.obsprep.bo.obsproject.InvalidGroupIndexException;
import alma.obsprep.bo.obsproject.LO1Manager;
import alma.obsprep.bo.obsproject.ObsProject;
import alma.obsprep.bo.obsproject.ObservatoryGoal;
import alma.obsprep.bo.obsproject.OverlaidSpectralLine;
import alma.obsprep.bo.obsproject.PerformanceParameters;
import alma.obsprep.bo.obsproject.RepresentativeFrequencyListener;
import alma.obsprep.bo.obsproject.RepresentativeFrequencyListenerHelper;
import alma.obsprep.bo.obsproject.RepresentativeWindowInterface;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproject.ScienceSpectralWindow;
import alma.obsprep.bo.obsproject.SpectralFeedback;
import alma.obsprep.bo.obsproject.SpectralScan;
import alma.obsprep.bo.obsproject.TargetParameters;
import alma.obsprep.bo.obsproject.UnableToFindSolutionException;
import alma.obsprep.bo.obsproject.data.SpectralSetupParametersData;
import alma.obsprep.bo.obsproposal.ObsProposal;
import alma.obsprep.bo.schedblock.CorrConfigMode;
import alma.obsprep.bo.schedblock.ReceiverBand;
import alma.obsprep.services.etc.AtmosphereTable;
import alma.obsprep.services.etc.editor.WaterVaporColumns;
import alma.obsprep.services.experts.CorrelatorExpert;
import alma.obsprep.services.experts.SingleContinuumExpert;
import alma.obsprep.services.experts.VLBIExpert;
import alma.obsprep.services.experts.spectralline.SpectralLine;
import alma.obsprep.services.generator.BaseBandDeployer;
import alma.obsprep.services.generator.BaseBandNotDeployableException;
import alma.obsprep.services.generator.FrequencyRangeInspector;
import alma.obsprep.services.generator.refactored.RequestedArray;
import alma.obsprep.util.FrequencyRange;
import alma.obsprep.util.Range;
import alma.obsprep.util.TextUtils;
import alma.obsprep.util.VupRange;
import alma.valuetypes.Frequency;
import alma.valuetypes.SkyCoordinates;
import alma.valuetypes.Speed;
import alma.valuetypes.UserFrequency;
import alma.valuetypes.Velocity;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Stream;
import lombok.NonNull;

public class SpectralSetupParameters
extends SpectralSetupParametersData {
    FrequencyRangeInspector frequencyRangeInspector;
    boolean isForce90DWSOn = false;
    private boolean isSpectralLineWSEnabled = true;
    private boolean isSSPDerivedFromSpectralScanSetup = false;
    private boolean isDerivedForDGCCalibrator = false;
    private final SpectralWindowStore windowStore;
    private final LO1Manager lo1manager;
    private static final String defaultSpectralType = TYPE_FULL;
    private static final Frequency TDM_THRESHOLD = Frequency.createFrequencyGHZ(0.9375);
    private final RepresentativeFrequencyListenerHelper repFreqHelper = new RepresentativeFrequencyListenerHelper();
    private final List<SpectralLine> overlayLines = new ArrayList<SpectralLine>();
    private Optional<Frequency> overrideLO1 = Optional.empty();
    private final PropertyChangeListener centreFrequencyChangedListener = propertyChangeEvent -> {
        if (propertyChangeEvent == null) {
            return;
        }
        Object object = propertyChangeEvent.getSource();
        if (object instanceof Frequency && propertyChangeEvent.getPropertyName().endsWith(".content")) {
            Frequency frequency = (Frequency)((Object)((Object)object));
            this.getRepresentativeFrequency().setContentAndUnit((ValueUnitPair)frequency);
        }
    };
    private final PropertyChangeListener centreFrequencyReplacedListener = propertyChangeEvent -> {
        if (propertyChangeEvent == null) {
            return;
        }
        Object object = propertyChangeEvent.getSource();
        if (object instanceof ScienceSpectralWindow && propertyChangeEvent.getPropertyName().endsWith("ScienceSpectralWindow.centerFrequency")) {
            ScienceSpectralWindow scienceSpectralWindow = (ScienceSpectralWindow)object;
            Frequency frequency = scienceSpectralWindow.getCenterFrequency();
            frequency.addPropertyChangeListener(this.centreFrequencyChangedListener);
            this.getRepresentativeFrequency().setContentAndUnit((ValueUnitPair)frequency);
        }
    };
    private SpectralSetupTypeChoice spectralType = null;
    private final Map<SpectralSetupTypeChoice, Frequency> representativeFrequencyBeforeStore = new HashMap<SpectralSetupTypeChoice, Frequency>();
    public boolean isSuspendAdvancedFeedback = false;
    private boolean isCalculatingFeedback = false;
    private final Collection<BasebandSwapListener> basebandSwapListeners = new ArrayList<BasebandSwapListener>();

    public SpectralSetupParameters(SpectralSetupParametersT spectralSetupParametersT) {
        super(spectralSetupParametersT);
        this.windowStore = new SpectralWindowStore();
        this.lo1manager = new LO1Manager(this);
        this.repFreqHelper.listenTo(this);
    }

    public void wrapObjects(ReferenceablesMap referenceablesMap, List<ReferenceableProxy<? extends IBusinessObject>> list) {
        super.wrapObjects(referenceablesMap, list);
        this.repFreqHelper.listenTo(this);
    }

    public synchronized void reattachReprFreqCentreFrequencyListeners() {
        ScienceSpectralWindow scienceSpectralWindow = this.getRepresentativeSpectralWindow();
        if (scienceSpectralWindow != null) {
            scienceSpectralWindow.getCenterFrequency().addPropertyChangeListener(this.centreFrequencyChangedListener);
            scienceSpectralWindow.addPropertyChangeListener(this.centreFrequencyReplacedListener);
        }
    }

    public synchronized void reattachReprFreqListener() {
        this.repFreqHelper.listenTo(this);
    }

    protected void initAsNew() {
        super.initAsNew();
        this.setType(defaultSpectralType);
        this.setPolarisation(POLARISATION_DOUBLE);
        this.setRepresentativeFrequency(Frequency.createFrequencyGHZ(0.0));
        this.setSingleContinuumFrequency(Frequency.createFrequencyGHZ(0.0));
        this.setSingleContinuumCorrelatorMode(SINGLECONTINUUMCORRELATORMODE_LOWRES);
    }

    public ScienceGoal getScienceGoal() {
        AbstractScienceGoal abstractScienceGoal = (AbstractScienceGoal)this.getParent();
        if (abstractScienceGoal instanceof ScienceGoal) {
            return (ScienceGoal)((Object)abstractScienceGoal);
        }
        return null;
    }

    public ObservatoryGoal getObservatoryGoal() {
        AbstractScienceGoal abstractScienceGoal = (AbstractScienceGoal)this.getParent();
        if (abstractScienceGoal instanceof ObservatoryGoal) {
            return (ObservatoryGoal)((Object)abstractScienceGoal);
        }
        return null;
    }

    public synchronized void setType(String string) {
        this.windowStore.restore(SpectralSetupTypeChoice.getTypeChoice(string));
    }

    public synchronized void setPolarisation(String string) {
        block3: {
            block2: {
                super.setPolarisation(string);
                if (!TYPE_CONTINUUM.equals(this.getType())) break block2;
                for (int i = 0; i < this.getScienceSpectralWindowCount(); ++i) {
                    this.getScienceSpectralWindow(i).updateContinuumCorrMode();
                }
                break block3;
            }
            if (!TYPE_FULL.equals(this.getType()) || !this.getAdvancedSpectralSetup().getSideBandSeparation()) break block3;
            CorrelatorExpert correlatorExpert = CorrelatorExpert.getBLInstance();
            CorrConfigMode corrConfigMode = correlatorExpert.getSpectralLineWalshSwitchMode(this.getCorrPolarization());
            for (ScienceSpectralWindow scienceSpectralWindow : this.getScienceSpectralWindow()) {
                scienceSpectralWindow.setCorrConfigMode(corrConfigMode);
            }
        }
    }

    public static String[] getKnownPolarisationList() {
        String[] stringArray = !AlmaCapabilities.getInstance().isFullPolarizationAllowed() ? new String[]{POLARISATION_SINGLE_Y, POLARISATION_FULL} : new String[]{POLARISATION_SINGLE_Y};
        return TextUtils.removeFromArray(knownPolarisationList, stringArray);
    }

    public ScienceSpectralWindow[] getScienceSpectralWindow() {
        return this.getAbstractScienceSpectralWindowScienceSpectralWindow();
    }

    public SpectralScan getSpectralScan() {
        SpectralScan[] spectralScanArray = this.getAbstractScienceSpectralWindowSpectralScan();
        if (spectralScanArray == null || spectralScanArray.length == 0) {
            return null;
        }
        return spectralScanArray[0];
    }

    public SpectralScan[] getScienceSpectralScan() {
        return this.getAbstractScienceSpectralWindowSpectralScan();
    }

    public VupRange<Frequency>[] getSkyFrequencyNominalRanges(ScienceSpectralWindow[] scienceSpectralWindowArray) {
        return this.getSkyFrequencyRanges(false, scienceSpectralWindowArray);
    }

    public VupRange<Frequency>[] getSkyFrequencyEffectiveRanges(ScienceSpectralWindow[] scienceSpectralWindowArray) {
        return this.getSkyFrequencyRanges(true, scienceSpectralWindowArray);
    }

    private VupRange<Frequency>[] getSkyFrequencyRanges(boolean bl, ScienceSpectralWindow[] scienceSpectralWindowArray) {
        FrequencyRange[] frequencyRangeArray = new FrequencyRange[scienceSpectralWindowArray.length];
        int n = 0;
        for (ScienceSpectralWindow scienceSpectralWindow : scienceSpectralWindowArray) {
            frequencyRangeArray[n++] = bl ? scienceSpectralWindow.getSkyFrequencyEffectiveRange() : scienceSpectralWindow.getSkyFrequencyNominalRange();
        }
        return frequencyRangeArray;
    }

    public ScienceSpectralWindow getScienceSpectralWindow(int n) {
        try {
            return this.getScienceSpectralWindow()[n];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return null;
        }
    }

    public SpectralScan getScienceSpectralScan(int n) {
        try {
            return this.getScienceSpectralScan()[n];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return null;
        }
    }

    public ScienceSpectralWindow[] getScienceSpectralWindowGroup(int n) {
        if (n == -1) {
            return this.getScienceSpectralWindow();
        }
        ArrayList<ScienceSpectralWindow> arrayList = new ArrayList<ScienceSpectralWindow>();
        for (ScienceSpectralWindow scienceSpectralWindow : this.getScienceSpectralWindow()) {
            if (scienceSpectralWindow.getGroupIndex() != n) continue;
            arrayList.add(scienceSpectralWindow);
        }
        return arrayList.toArray(new ScienceSpectralWindow[arrayList.size()]);
    }

    public ScienceSpectralWindow getScienceSpectralWindow(int n, int n2) {
        int n3 = 0;
        for (ScienceSpectralWindow scienceSpectralWindow : this.getScienceSpectralWindowGroup(n)) {
            if (n3 == n2) {
                return scienceSpectralWindow;
            }
            ++n3;
        }
        return null;
    }

    public int getScienceSpectralWindowCount() {
        return this.getAbstractScienceSpectralWindowScienceSpectralWindowCount();
    }

    public int getScienceSpectralWindowCount(int n) {
        if (n == -1) {
            return this.getScienceSpectralWindowCount();
        }
        int n2 = 0;
        for (ScienceSpectralWindow scienceSpectralWindow : this.getScienceSpectralWindow()) {
            if (scienceSpectralWindow.getGroupIndex() != n) continue;
            ++n2;
        }
        return n2;
    }

    public ScienceSpectralWindow addScienceSpectralWindow(int n, int n2) {
        ScienceSpectralWindow scienceSpectralWindow = ScienceSpectralWindow.createScienceSpectralWindow();
        this.addScienceSpectralWindow(n, n2, scienceSpectralWindow);
        return scienceSpectralWindow;
    }

    public void addScienceSpectralWindow(int n, int n2, ScienceSpectralWindow scienceSpectralWindow) {
        if (scienceSpectralWindow == null) {
            return;
        }
        int n3 = this.getScienceSpectralWindowCount(n);
        int n4 = Math.min(n3, n2);
        scienceSpectralWindow.setGroupIndex(n);
        scienceSpectralWindow.setIndex(n4);
        this.addAbstractScienceSpectralWindow(n4, (AbstractScienceSpectralWindow)((Object)scienceSpectralWindow));
    }

    public void addAbstractScienceSpectralWindow(int n, AbstractScienceSpectralWindow abstractScienceSpectralWindow) {
        super.addAbstractScienceSpectralWindow(n, abstractScienceSpectralWindow);
        if (abstractScienceSpectralWindow instanceof ScienceSpectralWindow) {
            ScienceSpectralWindow scienceSpectralWindow = (ScienceSpectralWindow)((Object)abstractScienceSpectralWindow);
            if (this.getScienceSpectralWindowCount() == 1 || scienceSpectralWindow.getRepresentativeWindow()) {
                this.setRepresentativeSpectralWindow(scienceSpectralWindow);
            }
        }
        this.adjustMainIndex();
    }

    public int indexOf(ScienceSpectralWindow scienceSpectralWindow) {
        int n = 0;
        for (ScienceSpectralWindow scienceSpectralWindow2 : this.getScienceSpectralWindow()) {
            if (scienceSpectralWindow2 == scienceSpectralWindow) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public void adjustGroupIndex() {
        if (this.getScienceSpectralWindowCount() > 4) {
            return;
        }
        for (int i = 0; i < this.getScienceSpectralWindowCount(); ++i) {
            ScienceSpectralWindow scienceSpectralWindow = this.getScienceSpectralWindow(i);
            if (!scienceSpectralWindow.isSingleContinuum()) continue;
            scienceSpectralWindow.setGroupIndex(i);
        }
    }

    private void adjustMainIndex() {
        for (int n : new int[]{0, 1, 2, 3}) {
            int n2 = 0;
            for (ScienceSpectralWindow scienceSpectralWindow : this.getScienceSpectralWindowGroup(n)) {
                scienceSpectralWindow.setIndex(n2++);
            }
        }
    }

    public void swapGroupIndex(int n, int n2) {
        int n3;
        if (n == n2) {
            throw new IllegalArgumentException("index1 and index2 must be different");
        }
        if (n < 0 || n > 4) {
            throw new IllegalArgumentException("invalid group index : " + n);
        }
        if (n2 < 0 || n2 > 4) {
            throw new IllegalArgumentException("invalid group index : " + n2);
        }
        ScienceSpectralWindow[] scienceSpectralWindowArray = this.getScienceSpectralWindowGroup(n);
        ScienceSpectralWindow[] scienceSpectralWindowArray2 = this.getScienceSpectralWindowGroup(n2);
        Optional<ScienceSpectralWindow> optional = Stream.of(scienceSpectralWindowArray).filter(scienceSpectralWindow -> scienceSpectralWindow.getRepresentativeWindow()).findFirst();
        if (optional.isEmpty()) {
            optional = Stream.of(scienceSpectralWindowArray2).filter(scienceSpectralWindow -> scienceSpectralWindow.getRepresentativeWindow()).findFirst();
        }
        for (ScienceSpectralWindow scienceSpectralWindow2 : scienceSpectralWindowArray) {
            this.removeAbstractScienceSpectralWindow((AbstractScienceSpectralWindow)((Object)scienceSpectralWindow2));
        }
        for (ScienceSpectralWindow scienceSpectralWindow2 : scienceSpectralWindowArray2) {
            this.removeAbstractScienceSpectralWindow((AbstractScienceSpectralWindow)((Object)scienceSpectralWindow2));
        }
        for (n3 = scienceSpectralWindowArray.length - 1; n3 >= 0; --n3) {
            ScienceSpectralWindow scienceSpectralWindow3 = scienceSpectralWindowArray[n3];
            scienceSpectralWindow3.setRepresentativeWindow(false);
            this.addScienceSpectralWindow(n2, 0, scienceSpectralWindow3);
        }
        for (n3 = scienceSpectralWindowArray2.length - 1; n3 >= 0; --n3) {
            ScienceSpectralWindow scienceSpectralWindow4 = scienceSpectralWindowArray2[n3];
            scienceSpectralWindow4.setRepresentativeWindow(false);
            this.addScienceSpectralWindow(n, 0, scienceSpectralWindow4);
        }
        optional.ifPresent(this::setRepresentativeSpectralWindow);
        this.basebandSwapListeners.stream().forEach(basebandSwapListener -> basebandSwapListener.BasebandsSwapped(n, n2));
    }

    public SortedSet<Integer> getGroupIndexSet() throws InvalidGroupIndexException {
        TreeSet<Integer> treeSet = new TreeSet<Integer>();
        for (ScienceSpectralWindow scienceSpectralWindow : this.getScienceSpectralWindow()) {
            int n = scienceSpectralWindow.getGroupIndex();
            if (n > 4 || n < 0 && n != -1) {
                throw new InvalidGroupIndexException("Invalid group index : " + n);
            }
            treeSet.add(n);
        }
        if (treeSet.contains(-1) && treeSet.size() != 1) {
            throw new InvalidGroupIndexException("Invalid group index set");
        }
        return treeSet;
    }

    public Velocity getSourceVelocity() {
        ScienceGoal scienceGoal;
        TargetParameters targetParameters;
        BusinessObject businessObject = this.getParent();
        if (businessObject instanceof ScienceGoal && (targetParameters = (scienceGoal = (ScienceGoal)businessObject).getKeyTargetParameters()) != null) {
            return targetParameters.getSourceVelocityInDefaultReferenceFrame(Optional.of(scienceGoal));
        }
        return Velocity.createVelocity();
    }

    public SkyCoordinates getSourceCoordinates() {
        ScienceGoal scienceGoal;
        TargetParameters targetParameters;
        BusinessObject businessObject = this.getParent();
        if (businessObject instanceof ScienceGoal && (targetParameters = (scienceGoal = (ScienceGoal)businessObject).getKeyTargetParameters()) != null) {
            return targetParameters.getSourceCoordinates();
        }
        return SkyCoordinates.createAbsoluteCoordinates();
    }

    public PerformanceParameters getPerformanceParameters() {
        BusinessObject businessObject = this.getParent();
        if (businessObject instanceof ScienceGoal) {
            ScienceGoal scienceGoal = (ScienceGoal)businessObject;
            return scienceGoal.getPerformanceParameters();
        }
        return null;
    }

    public CorrPolarization getCorrPolarization() {
        return CorrPolarization.getCorrPolarization(this.getPolarisation());
    }

    public Frequency getRepresentativeBandwidth() {
        if (this.isSingleContinuum()) {
            return Frequency.createFrequencyGHZ(8.0);
        }
        ScienceSpectralWindow scienceSpectralWindow = this.getRepresentativeSpectralWindow();
        if (scienceSpectralWindow != null) {
            return scienceSpectralWindow.getBandWidth().deepCopy();
        }
        return Frequency.createFrequencyGHZ(0.0);
    }

    public ScienceSpectralWindow getStringentSpectralWindow() {
        if (this.getScienceSpectralWindowCount() == 0 && !this.isSpectralScan()) {
            return null;
        }
        String string = this.getType();
        if (TYPE_CONTINUUM.equals(string)) {
            return this.getScienceSpectralWindow(0);
        }
        if (TYPE_FULL.equals(string)) {
            ScienceSpectralWindow scienceSpectralWindow = this.getScienceSpectralWindow()[0];
            UserFrequency userFrequency = scienceSpectralWindow.getSpectralResolutionSmoothed();
            for (ScienceSpectralWindow scienceSpectralWindow2 : this.getScienceSpectralWindow()) {
                if (!scienceSpectralWindow2.getSpectralResolutionSmoothed().isLessThan((AbstractDoubleWithUnit)userFrequency)) continue;
                scienceSpectralWindow = scienceSpectralWindow2;
                userFrequency = scienceSpectralWindow2.getSpectralResolutionSmoothed();
            }
            return scienceSpectralWindow;
        }
        if (TYPE_SCAN.equals(string)) {
            try {
                List<Frequency> list = this.getSpectralScan().getTunings().getTuning(0);
                SpectralSetupParameters spectralSetupParameters = SpectralScan.createSPWBasedSSPFromSpectralScanTuning(this, list);
                return spectralSetupParameters.getScienceSpectralWindow(0);
            }
            catch (SpectralScan.SpectralScanTunings.SpectralScanTuningException | UnableToFindSolutionException exception) {
                return null;
            }
        }
        return null;
    }

    public ScienceSpectralWindow getWorstOpacityWindow() {
        double d = 0.0;
        ScienceSpectralWindow scienceSpectralWindow = null;
        Velocity velocity = this.getSourceVelocity();
        SkyCoordinates skyCoordinates = this.getSourceCoordinates();
        AtmosphereTable atmosphereTable = AtmosphereTable.getInstance();
        for (ScienceSpectralWindow scienceSpectralWindow2 : this.getScienceSpectralWindow()) {
            double d2;
            int n;
            Frequency frequency = scienceSpectralWindow2.getOpacityReferenceFrequency(velocity);
            float f = (float)frequency.getContentInGHz();
            AtmosphereTable.Data data = atmosphereTable.lookup(f, n = WaterVaporColumns.wvindexSelector(f, d2 = skyCoordinates.getICRSSkyCoordinates().getLatitude().getDegs(), Optional.ofNullable(this.getReceiverBand())));
            if (data == null) {
                scienceSpectralWindow = scienceSpectralWindow2;
                continue;
            }
            float f2 = data.getTau();
            if (!((double)f2 > d)) continue;
            d = f2;
            scienceSpectralWindow = scienceSpectralWindow2;
        }
        return scienceSpectralWindow;
    }

    private Frequency getAggregatedBandwidth() {
        Frequency frequency = Frequency.createFrequency();
        if (this.isSpectralScan()) {
            SpectralScan spectralScan = this.getSpectralScan();
            Frequency frequency2 = spectralScan.getEffectiveBandwidth();
            SpectralScan.SpectralScanTunings spectralScanTunings = null;
            try {
                spectralScanTunings = spectralScan.getTunings();
            }
            catch (UnableToFindSolutionException unableToFindSolutionException) {
                return frequency;
            }
            try {
                for (int i = 0; i < spectralScanTunings.getNumberOfSPWs(); ++i) {
                    frequency = (Frequency)frequency.plus((AbstractDoubleWithUnit)frequency2);
                }
            }
            catch (SpectralScan.SpectralScanTunings.SpectralScanTuningException spectralScanTuningException) {
                throw new RuntimeException("Unable to establish number of SPWs");
            }
            if (this.isWalshSwitching()) {
                frequency = (Frequency)frequency.multiply(2.0);
            }
        } else if (this.isSingleContinuum()) {
            List<VupRange> list = Arrays.asList(this.getSkyFrequencyEffectiveRanges(this.getScienceSpectralWindow()));
            List<VupRange> list2 = VupRange.aggregate(list);
            for (VupRange vupRange : list2) {
                frequency = (Frequency)frequency.plus((AbstractDoubleWithUnit)((Frequency)((Object)vupRange.range())));
            }
            if (this.isWalshSwitching()) {
                frequency = (Frequency)frequency.multiply(2.0);
            }
        } else if (this.isSpectralLine()) {
            frequency = this.calculateAggregatedBWForSpectralLine();
        }
        frequency.convertToFriendlyUnit();
        return frequency;
    }

    private Frequency calculateAggregatedBWForSpectralLine() {
        Frequency frequency = Frequency.createFrequency();
        List<VupRange> list = Arrays.asList(this.getSkyFrequencyEffectiveRanges(this.getScienceSpectralWindow()));
        List<VupRange> list2 = VupRange.aggregate(list);
        List<ScienceSpectralWindow> list3 = Arrays.stream(this.getScienceSpectralWindow()).filter(scienceSpectralWindow -> scienceSpectralWindow.getAdvancedWindowSetup().getUseImage()).toList();
        ScienceSpectralWindow[] scienceSpectralWindowArray = new ScienceSpectralWindow[list3.size()];
        scienceSpectralWindowArray = list3.toArray(scienceSpectralWindowArray);
        List<VupRange> list4 = Arrays.asList(this.getSkyFrequencyEffectiveRanges(scienceSpectralWindowArray));
        List<VupRange> list5 = VupRange.aggregate(list4);
        for (VupRange vupRange : list2) {
            frequency = (Frequency)frequency.plus((AbstractDoubleWithUnit)((Frequency)((Object)vupRange.range())));
        }
        for (VupRange vupRange : list5) {
            frequency = (Frequency)frequency.plus((AbstractDoubleWithUnit)((Frequency)((Object)vupRange.range())));
        }
        return frequency;
    }

    public Frequency getDesiredSensitivityFrequencyWidth(String string) {
        Frequency frequency = Frequency.createFrequency();
        if (PerformanceParameters.DESIREDSENSITIVITYFREQUENCYMEASURE_AGGREGATEBANDWIDTH.equals(string)) {
            return this.getAggregatedBandwidth();
        }
        if (PerformanceParameters.DESIREDSENSITIVITYFREQUENCYMEASURE_LARGESTWINDOWBANDWIDTH.equals(string)) {
            if (!this.isSpectralScan()) {
                for (ScienceSpectralWindow scienceSpectralWindow : this.getScienceSpectralWindow()) {
                    if (!scienceSpectralWindow.getEffectiveBandwidth().isGreaterThan((AbstractDoubleWithUnit)frequency)) continue;
                    frequency = scienceSpectralWindow.getEffectiveBandwidth();
                }
            } else {
                SpectralScan spectralScan = this.getSpectralScan();
                frequency = spectralScan.getEffectiveBandwidth();
            }
            frequency.convertToFriendlyUnit();
            return frequency;
        }
        if (PerformanceParameters.DESIREDSENSITIVITYFREQUENCYMEASURE_FINESTRESOLUTION.equals(string)) {
            if (this.getCriticalResolutionPerPolnSmoothed() != null) {
                frequency.setContentInMHz(this.getCriticalResolutionPerPolnSmoothed().getContentInMHz());
            }
            return frequency;
        }
        if (PerformanceParameters.DESIREDSENSITIVITYFREQUENCYMEASURE_REPRESENTATIVEWINDOWRESOLUTION.equals(string)) {
            if (this.getRepresentativeSpectralWindow() != null) {
                frequency.setContentInMHz(this.getRepresentativeSpectralWindow().getSpectralResolutionSmoothed().getContentInMHz());
            }
            return frequency;
        }
        if (PerformanceParameters.DESIREDSENSITIVITYFREQUENCYMEASURE_REPRESENTATIVEWINDOWBANDWIDTH.equals(string)) {
            if (this.getRepresentativeSpectralWindow() != null) {
                frequency.setContentInMHz(this.getRepresentativeSpectralWindow().getEffectiveBandwidth().getContentInMHz());
            }
            return frequency;
        }
        if (PerformanceParameters.DESIREDSENSITIVITYFREQUENCYMEASURE_USER.equals(string)) {
            PerformanceParameters performanceParameters = this.getPerformanceParameters();
            frequency.setContentInMHz(performanceParameters.getDesiredSensitivityReferenceFrequencyWidth().getContentInMHz());
            return frequency;
        }
        throw new IllegalArgumentException(string);
    }

    public Frequency getDesiredSensitivityFrequencyWidth() {
        PerformanceParameters performanceParameters = this.getPerformanceParameters();
        String string = performanceParameters == null ? PerformanceParameters.DESIREDSENSITIVITYFREQUENCYMEASURE_FINESTRESOLUTION : performanceParameters.getDesiredSensitivityFrequencyMeasure();
        return this.getDesiredSensitivityFrequencyWidth(string);
    }

    public int getPolarizationFactor() {
        CorrPolarization corrPolarization = CorrPolarization.getCorrPolarization(this.getPolarisation());
        return corrPolarization.getProductsCount() == 1 ? 1 : 2;
    }

    public UserFrequency getCriticalResolutionPerPoln() {
        UserFrequency userFrequency = null;
        if (this.isSpectralScan()) {
            SpectralScan spectralScan = this.getSpectralScan();
            userFrequency = UserFrequency.createUserFrequency(spectralScan.getSpectralResolution());
            userFrequency.setUnit(Frequency.UNIT_GHZ);
        } else {
            ScienceSpectralWindow scienceSpectralWindow = this.getStringentSpectralWindow();
            if (scienceSpectralWindow == null) {
                return null;
            }
            userFrequency = scienceSpectralWindow.getResolutionPerPoln();
            if (userFrequency.getContentInGHz() > 1.0) {
                userFrequency.convertToUnit(Frequency.UNIT_GHZ);
            } else if (userFrequency.getContentInMHz() > 1.0) {
                userFrequency.convertToUnit(Frequency.UNIT_MHZ);
            } else {
                userFrequency.convertToUnit(Frequency.UNIT_KHZ);
            }
        }
        return userFrequency;
    }

    public UserFrequency getCriticalResolutionPerPolnSmoothed() {
        return this.isSingleContinuum() ? this.getCriticalResolutionPerPolnSmoothedForSingleContinuum() : this.getCriticalResolutionPerPolnSmoothedForNonSingleContinuum();
    }

    private UserFrequency getCriticalResolutionPerPolnSmoothedForSingleContinuum() {
        double d;
        UserFrequency userFrequency = this.getCriticalResolutionPerPoln();
        if (userFrequency == null) {
            return null;
        }
        userFrequency = userFrequency.deepCopy();
        if (this.isSpectralScan()) {
            SpectralScan spectralScan = this.getScienceSpectralScan(0);
            try {
                SpectralAverage spectralAverage = SpectralAverage.getValue(spectralScan.getAdvancedWindowSetup().getSmoothingFactor());
                d = spectralAverage.getResolutionScalingFactor(spectralScan.getAdvancedWindowSetup().getSmoothingFunction());
            }
            catch (SpectralAverage.UnknownWindowingFunctionException unknownWindowingFunctionException) {
                return null;
            }
        }
        ScienceSpectralWindow scienceSpectralWindow = this.getStringentSpectralWindow();
        if (scienceSpectralWindow == null) {
            return null;
        }
        try {
            SpectralAverage spectralAverage = SpectralAverage.getValue(scienceSpectralWindow.getAdvancedWindowSetup().getSmoothingFactor());
            d = spectralAverage.getResolutionScalingFactor(scienceSpectralWindow.getAdvancedWindowSetup().getSmoothingFunction());
        }
        catch (SpectralAverage.UnknownWindowingFunctionException unknownWindowingFunctionException) {
            return null;
        }
        double d2 = userFrequency.getContent() * d;
        userFrequency.setContent(d2);
        if (userFrequency.getContentInGHz() > 1.0) {
            userFrequency.convertToUnit(Frequency.UNIT_GHZ);
        } else if (userFrequency.getContentInMHz() > 1.0) {
            userFrequency.convertToUnit(Frequency.UNIT_MHZ);
        } else {
            userFrequency.convertToUnit(Frequency.UNIT_KHZ);
        }
        return userFrequency;
    }

    public UserFrequency getCriticalResolutionPerPolnSmoothedForNonSingleContinuum() {
        double d;
        int n;
        UserFrequency userFrequency = this.getCriticalResolutionPerPoln();
        if (userFrequency == null) {
            return null;
        }
        userFrequency = userFrequency.deepCopy();
        if (this.isSpectralScan()) {
            var5_2 = this.getScienceSpectralScan(0);
            n = var5_2.getAdvancedWindowSetup().getSmoothingFactor();
            d = var5_2.getBandWidth().getContentInMHz() / (double)var5_2.getNumberOfChannels();
        } else {
            var5_2 = this.getStringentSpectralWindow();
            if (var5_2 == null) {
                return null;
            }
            n = var5_2.getAdvancedWindowSetup().getSmoothingFactor();
            d = var5_2.getBandWidth().getContentInMHz() / (double)((ScienceSpectralWindow)var5_2).getNumberOfChannels();
        }
        double d2 = ScienceSpectralWindow.getSpectralAveragingFactor(n) * d;
        userFrequency.setContentInMHz(d2);
        if (userFrequency.getContentInGHz() > 1.0) {
            userFrequency.convertToUnit(Frequency.UNIT_GHZ);
        } else if (userFrequency.getContentInMHz() > 1.0) {
            userFrequency.convertToUnit(Frequency.UNIT_MHZ);
        } else {
            userFrequency.convertToUnit(Frequency.UNIT_KHZ);
        }
        return userFrequency;
    }

    public ScienceSpectralWindow getRepresentativeSpectralWindow() {
        for (ScienceSpectralWindow scienceSpectralWindow : this.getScienceSpectralWindow()) {
            if (!scienceSpectralWindow.getRepresentativeWindow()) continue;
            return scienceSpectralWindow;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void setRepresentativeSpectralWindow(ScienceSpectralWindow scienceSpectralWindow) {
        ScienceSpectralWindow scienceSpectralWindow2 = this.getRepresentativeSpectralWindow();
        if (scienceSpectralWindow2 != null) {
            scienceSpectralWindow2.getCenterFrequency().removePropertyChangeListener(this.centreFrequencyChangedListener);
            scienceSpectralWindow2.removePropertyChangeListener(this.centreFrequencyReplacedListener);
        }
        for (ScienceSpectralWindow scienceSpectralWindow3 : this.getScienceSpectralWindow()) {
            if (!scienceSpectralWindow3.getRepresentativeWindow()) continue;
            scienceSpectralWindow3.setRepresentativeWindow(false);
        }
        if (scienceSpectralWindow != null) {
            void var3_6;
            if (scienceSpectralWindow.getIsSkyFrequency() && this.isSingleContinuum()) {
                Frequency frequency = scienceSpectralWindow.getCenterFrequencySky();
            } else {
                Frequency frequency = scienceSpectralWindow.getCenterFrequencyRest();
            }
            this.getRepresentativeFrequency().setContentAndUnit((ValueUnitPair)var3_6);
            scienceSpectralWindow.getCenterFrequency().addPropertyChangeListener(this.centreFrequencyChangedListener);
            scienceSpectralWindow.addPropertyChangeListener(this.centreFrequencyReplacedListener);
            scienceSpectralWindow.setRepresentativeWindow(true);
        }
    }

    public Frequency getLO1Frequency() {
        return this.overrideLO1.orElse(this.lo1manager.getLO1Frequency());
    }

    public boolean getLOSolutionFound() {
        return this.overrideLO1.isEmpty() ? this.lo1manager.isSolutionFound() : true;
    }

    public boolean removeAbstractScienceSpectralWindow(AbstractScienceSpectralWindow abstractScienceSpectralWindow) {
        boolean bl = super.removeAbstractScienceSpectralWindow(abstractScienceSpectralWindow);
        if (bl && abstractScienceSpectralWindow instanceof ScienceSpectralWindow) {
            this.adjustMainIndex();
            ScienceSpectralWindow scienceSpectralWindow = (ScienceSpectralWindow)((Object)abstractScienceSpectralWindow);
            if (!scienceSpectralWindow.getRepresentativeWindow()) {
                return bl;
            }
            int n = scienceSpectralWindow.getGroupIndex();
            ScienceSpectralWindow[] scienceSpectralWindowArray = this.getScienceSpectralWindowGroup(n);
            if (scienceSpectralWindowArray.length > 0) {
                this.setRepresentativeSpectralWindow(scienceSpectralWindowArray[0]);
            } else if (this.getScienceSpectralWindowCount() > 0) {
                this.setRepresentativeSpectralWindow(this.getScienceSpectralWindow(0));
            } else {
                this.setRepresentativeSpectralWindow(null);
            }
        }
        return bl;
    }

    public void clearAbstractScienceSpectralWindow() {
        this.setRepresentativeSpectralWindow(null);
        super.clearAbstractScienceSpectralWindow();
    }

    public ScienceSpectralWindow addNewSpectralWindow() {
        ScienceSpectralWindow scienceSpectralWindow = ScienceSpectralWindow.createScienceSpectralWindow();
        this.addAbstractScienceSpectralWindow((AbstractScienceSpectralWindow)((Object)scienceSpectralWindow));
        return scienceSpectralWindow;
    }

    public SpectralScan addNewSpectralScan() {
        SpectralScan spectralScan = SpectralScan.createSpectralScan();
        this.addAbstractScienceSpectralWindow((AbstractScienceSpectralWindow)((Object)spectralScan));
        return spectralScan;
    }

    public AbstractScienceSpectralWindow addNewAbstractScienceSpectralWindow(String string) {
        RepresentativeWindowInterface representativeWindowInterface = null;
        if (string == TYPE_CONTINUUM || string == TYPE_FULL) {
            representativeWindowInterface = ScienceSpectralWindow.createScienceSpectralWindow();
        } else if (string == TYPE_SCAN) {
            representativeWindowInterface = SpectralScan.createSpectralScan();
        } else {
            return null;
        }
        this.addAbstractScienceSpectralWindow((AbstractScienceSpectralWindow)((Object)representativeWindowInterface));
        return representativeWindowInterface;
    }

    public Frequency getSoleFrequency() {
        ScienceSpectralWindow scienceSpectralWindow = this.getRepresentativeSpectralWindow();
        if (scienceSpectralWindow == null) {
            if (this.getScienceSpectralWindowCount() > 0) {
                return this.getScienceSpectralWindow(0).getCenterFrequencyRest();
            }
            return Frequency.createFrequency();
        }
        return scienceSpectralWindow.getCenterFrequencyRest();
    }

    public ReceiverBand getReceiverBand() {
        ReceiverBand receiverBand = null;
        if (this.isSpectralScan()) {
            SpectralScan spectralScan = this.getSpectralScan();
            if (spectralScan == null) {
                return null;
            }
            try {
                receiverBand = spectralScan.getSpectralScanReceiverBand();
            }
            catch (ReceiverBand.ReceiverNotFoundException | IllegalArgumentException exception) {}
        } else {
            receiverBand = this.overrideLO1.map(ReceiverBand::getReceiverBand).orElseGet(() -> {
                try {
                    return ReceiverBand.getReceiverBand(this);
                }
                catch (ReceiverBand.ReceiverNotFoundException | IllegalArgumentException exception) {
                    return null;
                }
            });
        }
        return receiverBand;
    }

    public SpectralSetupTypeChoice getSpectralType() {
        if (this.spectralType == null) {
            String string = this.getType();
            this.spectralType = string == TYPE_FULL ? SpectralSetupTypeChoice.SPECTRALLINE : SpectralSetupTypeChoice.getTypeChoice(string);
        }
        return this.spectralType;
    }

    private synchronized void setRepFreqBeforeStore(SpectralSetupTypeChoice spectralSetupTypeChoice, Frequency frequency) {
        this.representativeFrequencyBeforeStore.put(spectralSetupTypeChoice, frequency);
    }

    public Frequency getRepFreqBeforeStore(SpectralSetupTypeChoice spectralSetupTypeChoice) {
        return this.representativeFrequencyBeforeStore.get((Object)spectralSetupTypeChoice);
    }

    public synchronized void setSpectralType(SpectralSetupTypeChoice spectralSetupTypeChoice) {
        this.spectralType = spectralSetupTypeChoice;
        this.setType(spectralSetupTypeChoice.getType());
    }

    public boolean isSingleContinuumTDM() {
        String string = this.getSingleContinuumCorrelatorMode();
        return string == null ? false : string.equals(SINGLECONTINUUMCORRELATORMODE_LOWRES);
    }

    public boolean isSingleContinuum() {
        return this.getType().equals(TYPE_CONTINUUM);
    }

    public boolean isSpectralScan() {
        return this.getType().equals(TYPE_SCAN);
    }

    public boolean isSpectralLine() {
        return this.getType().equals(TYPE_FULL);
    }

    public boolean isFullPolarisation() {
        return this.getPolarisation().equals(SpectralSetupParametersData.POLARISATION_FULL);
    }

    public boolean isSingleContinuumSkyFrequency() {
        if (!this.isSingleContinuum()) {
            return false;
        }
        if (this.getScienceSpectralWindowCount(0) > 0) {
            return this.getScienceSpectralWindow(0, 0).getIsSkyFrequency();
        }
        return false;
    }

    public boolean needsTDMSpec(RequestedArray requestedArray) {
        Frequency frequency;
        ArrayList<VupRange> arrayList = new ArrayList<VupRange>();
        for (ScienceSpectralWindow object : this.getScienceSpectralWindow()) {
            frequency = object.getCenterFrequency();
            Frequency frequency2 = object.getEffectiveBandwidth();
            arrayList.add(FrequencyRange.centredOn(frequency, frequency2));
        }
        List<VupRange> list = FrequencyRange.aggregate(arrayList);
        Frequency frequency3 = Frequency.createFrequency();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            VupRange vupRange = (VupRange)iterator.next();
            frequency = vupRange.range();
            if (!(frequency instanceof Frequency)) continue;
            frequency3 = (Frequency)frequency3.plus((AbstractDoubleWithUnit)frequency);
        }
        return !frequency3.isGreaterThanOrEqualTo((AbstractDoubleWithUnit)TDM_THRESHOLD);
    }

    public boolean isPureTDM() {
        boolean bl;
        block2: {
            block1: {
                bl = true;
                if (!TYPE_SCAN.equals(this.getSpectralType().getType())) break block1;
                if (this.getSpectralScan().getCorrConfigMode().getFilter().equals((Object)CorrFilter.TDM)) break block2;
                bl = false;
                break block2;
            }
            for (ScienceSpectralWindow scienceSpectralWindow : this.getScienceSpectralWindow()) {
                if (scienceSpectralWindow.getCorrConfigMode().getFilter().equals((Object)CorrFilter.TDM)) continue;
                bl = false;
                break;
            }
        }
        return bl;
    }

    public boolean isAdvancedSetup() {
        int n = this.getScienceSpectralWindowCount();
        if (n > 4) {
            return true;
        }
        for (int i = 0; i < 4; ++i) {
            if (this.getScienceSpectralWindowCount(i) <= 1) continue;
            return true;
        }
        return false;
    }

    public synchronized void setSuspendAdvancedFeedback(boolean bl) {
        this.isSuspendAdvancedFeedback = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String feedbackAdvancedSetup(int n) throws InvalidGroupIndexException {
        if (this.isSuspendAdvancedFeedback || this.isCalculatingFeedback) {
            return "";
        }
        if (!this.getSpectralType().equals((Object)SpectralSetupTypeChoice.SPECTRALSCAN)) {
            this.isCalculatingFeedback = true;
            ScienceGoal scienceGoal = this.getScienceGoal();
            int n2 = 0;
            if (scienceGoal == null) {
                return "Unable to determine science goal";
            }
            n2 = scienceGoal.getKeyTargetParametersPosition();
            scienceGoal.setKeyTargetParameters(n);
            try {
                this.lo1manager.setSolutionFound(false);
                StringBuilder stringBuilder = new StringBuilder();
                ScienceSpectralWindow[] scienceSpectralWindowArray = this.getScienceSpectralWindow();
                if (!this.verifyReceiverBand((Range<Frequency>[])scienceSpectralWindowArray)) {
                    stringBuilder.append(this.frequencyRangeInspector.getWarningMessage());
                    String string = stringBuilder.toString();
                    return string;
                }
                if (!this.verifyBasebandSetting()) {
                    stringBuilder.append("Can not configure LOs for these spectral windows");
                    String string = stringBuilder.toString();
                    return string;
                }
                for (int i = 0; i < 4; ++i) {
                    int n3 = i + 1;
                    String string = "Baseband-" + n3;
                    if (!this.verifyBaseBandRange(this.getSkyFrequencyNominalRanges(this.getScienceSpectralWindowGroup(i)))) {
                        stringBuilder.append(string + this.frequencyRangeInspector.getWarningMessage());
                        String string2 = stringBuilder.toString();
                        return string2;
                    }
                    if (!this.verifyTotalFraction(this.getScienceSpectralWindowGroup(i))) {
                        stringBuilder.append(string + " : The sum of fractions for all spectral windows must be equal to or less than 1.\n");
                        String string3 = stringBuilder.toString();
                        return string3;
                    }
                    if (!this.verifyConfigMode(this.getScienceSpectralWindowGroup(i))) {
                        stringBuilder.append(string + " : Bandwidth and channel spacing must be set to all spectral windows.");
                        String string4 = stringBuilder.toString();
                        return string4;
                    }
                    if (this.verifyResolutionsMatch(this.getScienceSpectralWindowGroup(i))) continue;
                    stringBuilder.append(string + " : Spectral window resolution mismatch in spectral set-up. All windows must be allocated the same resolution.");
                    String string5 = stringBuilder.toString();
                    return string5;
                }
                String string = stringBuilder.toString();
                return string;
            }
            finally {
                this.isCalculatingFeedback = false;
                scienceGoal.setKeyTargetParameters(n2);
            }
        }
        this.isCalculatingFeedback = false;
        return "";
    }

    SingleContinuumExpert getSingleContinuumExpert() {
        if (this.getScienceSpectralWindow(0).getIsSkyFrequency()) {
            return new SingleContinuumExpert(this.getSingleContinuumFrequency(), this.getShiftVelocity(), ObservingFrequency.FrequencyType.SKY_FREQUENCY);
        }
        return new SingleContinuumExpert(this.getSingleContinuumFrequency(), this.getShiftVelocity(), ObservingFrequency.FrequencyType.REST_FREQUENCY);
    }

    private SingleContinuumExpert getSingleContinuumExpert(boolean bl) {
        if (bl) {
            return new SingleContinuumExpert(this.getSingleContinuumFrequency(), this.getShiftVelocity(), ObservingFrequency.FrequencyType.REST_FREQUENCY);
        }
        return new SingleContinuumExpert(this.getSingleContinuumFrequency(), this.getShiftVelocity(), ObservingFrequency.FrequencyType.SKY_FREQUENCY);
    }

    public String feedbackSingleContinuumSetup() {
        Range<Frequency>[] rangeArray;
        if (this.overrideLO1.isPresent()) {
            return "";
        }
        this.lo1manager.setSolutionFound(false);
        StringBuilder stringBuilder = new StringBuilder();
        try {
            SingleContinuumExpert singleContinuumExpert = this.getSingleContinuumExpert(!this.getScienceSpectralWindow(0, 0).getIsSkyFrequency());
            rangeArray = singleContinuumExpert.calculateSingleContinuumBasebands(!this.getScienceSpectralWindow(0, 0).getIsSkyFrequency());
        }
        catch (Exception exception) {
            Frequency frequency = this.getSingleContinuumFrequency();
            Velocity velocity = this.getShiftVelocity();
            Frequency frequency2 = velocity.dopplerShift(frequency);
            stringBuilder.append("Sky Frequency " + TextUtils.format(frequency2) + " can not be observed by any ALMA receivers.\n");
            return stringBuilder.toString();
        }
        if (!this.verifyReceiverBand(rangeArray)) {
            stringBuilder.append(this.frequencyRangeInspector.getWarningMessage());
            return stringBuilder.toString();
        }
        try {
            if (!this.verifyBasebandSetting()) {
                stringBuilder.append("Can not configure LOs for these spectral windows");
                return stringBuilder.toString();
            }
        }
        catch (BaseBandNotDeployableException baseBandNotDeployableException) {
            stringBuilder.append(baseBandNotDeployableException.getMessage());
            return stringBuilder.toString();
        }
        return stringBuilder.toString();
    }

    private boolean verifyConfigMode(ScienceSpectralWindow[] scienceSpectralWindowArray) {
        for (ScienceSpectralWindow scienceSpectralWindow : scienceSpectralWindowArray) {
            if (scienceSpectralWindow.getCorrConfigMode().isValid()) continue;
            return false;
        }
        return true;
    }

    private boolean verifyTotalFraction(ScienceSpectralWindow[] scienceSpectralWindowArray) {
        int n = 0;
        for (ScienceSpectralWindow scienceSpectralWindow : scienceSpectralWindowArray) {
            try {
                n += scienceSpectralWindow.getFraction().getUnits();
            }
            catch (ClassCastException classCastException) {
                return false;
            }
        }
        return n <= 32;
    }

    private boolean verifyResolutionsMatch(ScienceSpectralWindow[] scienceSpectralWindowArray) {
        boolean bl = false;
        if (scienceSpectralWindowArray.length > 0) {
            ScienceSpectralWindow scienceSpectralWindow = scienceSpectralWindowArray[0];
            for (ScienceSpectralWindow scienceSpectralWindow2 : scienceSpectralWindowArray) {
                if (scienceSpectralWindow.getSpectralResolution().equals(scienceSpectralWindow2.getSpectralResolution())) continue;
                bl = true;
                break;
            }
        }
        return !bl;
    }

    private void newInspector(Range<Frequency>[] rangeArray) {
        this.frequencyRangeInspector = new FrequencyRangeInspector(rangeArray);
        boolean bl = VLBIExpert.isScienceGoalLegalVLBISpectralLine(this.getScienceGoal());
        this.frequencyRangeInspector.setVLBISpectralLine(bl);
    }

    Velocity getShiftVelocity() {
        boolean bl = false;
        if (this.getAbstractScienceSpectralWindowScienceSpectralWindowCount() > 0) {
            bl = this.getScienceSpectralWindow(0).getIsSkyFrequency();
        }
        if (this.isSpectralScan() || TYPE_CONTINUUM.equals(this.getType()) && bl) {
            Velocity velocity = Velocity.createVelocity();
            velocity.setCenterVelocity(Speed.createSpeed((double)0.0, (String)Speed.UNIT_KM_S));
            return velocity;
        }
        return this.getSourceVelocity();
    }

    public boolean verifyReceiverBand(@NonNull Range<Frequency>[] rangeArray) {
        if (rangeArray == null) {
            throw new NullPointerException("frequencyArray is marked non-null but is null");
        }
        this.newInspector(rangeArray);
        return this.frequencyRangeInspector.inOneReceiverBand(this.getShiftVelocity());
    }

    public boolean verifyBaseBandRange(Range<Frequency>[] rangeArray) {
        this.newInspector(rangeArray);
        return this.frequencyRangeInspector.inOneBaseBand(this.getShiftVelocity());
    }

    public boolean verifyBasebandSetting() throws BaseBandNotDeployableException {
        if (this.overrideLO1.isPresent()) {
            return true;
        }
        BaseBandDeployer baseBandDeployer = new BaseBandDeployer(this);
        boolean bl = baseBandDeployer.isDeployable(true);
        try {
            if (bl) {
                this.lo1manager.updateLO1();
            }
        }
        catch (Exception exception) {
            throw new BaseBandNotDeployableException(exception);
        }
        return bl;
    }

    private ScienceSpectralWindow createSingleVLBIContinuumWindow(int n, @NonNull Frequency frequency) {
        ScienceSpectralWindow scienceSpectralWindow;
        if (frequency == null) {
            throw new NullPointerException("centreFrequency is marked non-null but is null");
        }
        ScienceSpectralWindow[] scienceSpectralWindowArray = this.getScienceSpectralWindowGroup(n);
        boolean bl = false;
        if (scienceSpectralWindowArray.length != 1) {
            for (ScienceSpectralWindow scienceSpectralWindow2 : scienceSpectralWindowArray) {
                this.removeAbstractScienceSpectralWindow((AbstractScienceSpectralWindow)((Object)scienceSpectralWindow2));
            }
            scienceSpectralWindow = ScienceSpectralWindow.createSingleVLBIContinuumWindow();
            bl = true;
        } else {
            scienceSpectralWindow = scienceSpectralWindowArray[0];
        }
        if (!scienceSpectralWindow.getCenterFrequency().equals((Object)frequency) || !frequency.getUnit().equals(scienceSpectralWindow.getCenterFrequency().getUnit())) {
            scienceSpectralWindow.getCenterFrequency().setContentAndUnit((ValueUnitPair)frequency);
        }
        scienceSpectralWindow.setIsSkyFrequency(true);
        scienceSpectralWindow.setCorrConfigMode(52);
        scienceSpectralWindow.setGroupIndex(n);
        scienceSpectralWindow.getAdvancedWindowSetup().setSmoothingFactor(8);
        if (bl) {
            this.addScienceSpectralWindow(n, 0, scienceSpectralWindow);
        }
        return scienceSpectralWindow;
    }

    private ScienceSpectralWindow createSingleVLBISpectralLineWindow(int n, @NonNull Frequency frequency) {
        ScienceSpectralWindow scienceSpectralWindow;
        if (frequency == null) {
            throw new NullPointerException("centreFrequency is marked non-null but is null");
        }
        ScienceSpectralWindow[] scienceSpectralWindowArray = this.getScienceSpectralWindowGroup(n);
        boolean bl = false;
        if (scienceSpectralWindowArray.length != 1) {
            for (ScienceSpectralWindow scienceSpectralWindow2 : scienceSpectralWindowArray) {
                this.removeAbstractScienceSpectralWindow((AbstractScienceSpectralWindow)((Object)scienceSpectralWindow2));
            }
            scienceSpectralWindow = ScienceSpectralWindow.createSingleVLBISpectralLineWindow();
            bl = true;
        } else {
            scienceSpectralWindow = scienceSpectralWindowArray[0];
        }
        if (!scienceSpectralWindow.getCenterFrequency().equals((Object)frequency) || !frequency.getUnit().equals(scienceSpectralWindow.getCenterFrequency().getUnit())) {
            scienceSpectralWindow.getCenterFrequency().setContentAndUnit((ValueUnitPair)frequency);
        }
        scienceSpectralWindow.setIsSkyFrequency(true);
        scienceSpectralWindow.setCorrConfigMode(52);
        scienceSpectralWindow.setGroupIndex(n);
        scienceSpectralWindow.getAdvancedWindowSetup().setSmoothingFactor(1);
        if (bl) {
            this.addScienceSpectralWindow(n, 0, scienceSpectralWindow);
        }
        return scienceSpectralWindow;
    }

    private ScienceSpectralWindow createSingleContinuumWindow(int n, @NonNull Frequency frequency, @NonNull ObservingFrequency.FrequencyType frequencyType) {
        ScienceSpectralWindow scienceSpectralWindow;
        if (frequency == null) {
            throw new NullPointerException("centreFrequency is marked non-null but is null");
        }
        if (frequencyType == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        ScienceSpectralWindow[] scienceSpectralWindowArray = this.getScienceSpectralWindowGroup(n);
        boolean bl = false;
        if (scienceSpectralWindowArray.length != 1) {
            for (ScienceSpectralWindow scienceSpectralWindow2 : scienceSpectralWindowArray) {
                this.removeAbstractScienceSpectralWindow((AbstractScienceSpectralWindow)((Object)scienceSpectralWindow2));
            }
            scienceSpectralWindow = ScienceSpectralWindow.createSingleContinuum();
            bl = true;
        } else {
            scienceSpectralWindow = scienceSpectralWindowArray[0];
        }
        if (!scienceSpectralWindow.getCenterFrequency().equals((Object)frequency) || !frequency.getUnit().equals(scienceSpectralWindow.getCenterFrequency().getUnit())) {
            scienceSpectralWindow.getCenterFrequency().setContentAndUnit((ValueUnitPair)frequency);
        }
        if (frequencyType == ObservingFrequency.FrequencyType.SKY_FREQUENCY) {
            if (!scienceSpectralWindow.getIsSkyFrequency()) {
                scienceSpectralWindow.setIsSkyFrequency(true);
            }
        } else if (scienceSpectralWindow.getIsSkyFrequency()) {
            scienceSpectralWindow.setIsSkyFrequency(false);
        }
        CorrelatorExpert correlatorExpert = CorrelatorExpert.getInstance(CorrelatorType.BL);
        int n2 = this.getSingleContinuumCorrelatorMode().equals(SINGLECONTINUUMCORRELATORMODE_LOWRES) ? 1 : 0;
        CorrConfigMode corrConfigMode = n2 != 0 ? correlatorExpert.getContinuumMode(this.getCorrPolarization()) : correlatorExpert.getFDMContinuumMode(this.getCorrPolarization());
        scienceSpectralWindow.setCorrConfigMode(corrConfigMode);
        scienceSpectralWindow.setGroupIndex(n);
        if (bl) {
            this.addScienceSpectralWindow(n, 0, scienceSpectralWindow);
        }
        return scienceSpectralWindow;
    }

    public void createSingleContinuumWindows(Frequency[] frequencyArray, ObservingFrequency.FrequencyType frequencyType) {
        int n = 0;
        for (Frequency frequency : frequencyArray) {
            this.createSingleContinuumWindow(n, frequency, frequencyType);
            if (n == -1) {
                this.adjustGroupIndex();
            }
            ++n;
        }
        for (ScienceSpectralWindow scienceSpectralWindow : this.getScienceSpectralWindow()) {
            if (scienceSpectralWindow.getGroupIndex() != -1) continue;
            this.removeAbstractScienceSpectralWindow((AbstractScienceSpectralWindow)((Object)scienceSpectralWindow));
        }
    }

    public void createContinuumVLBIWindows(List<Frequency> list) {
        int n = 0;
        for (Frequency frequency : list) {
            this.createSingleVLBIContinuumWindow(n, frequency);
            if (n == -1) {
                this.adjustGroupIndex();
            }
            ++n;
        }
        for (ScienceSpectralWindow scienceSpectralWindow : this.getScienceSpectralWindow()) {
            if (scienceSpectralWindow.getGroupIndex() != -1) continue;
            this.removeAbstractScienceSpectralWindow((AbstractScienceSpectralWindow)((Object)scienceSpectralWindow));
        }
    }

    public void createTDMSpectralLineVLBIWindows(List<Frequency> list) {
        int n = 0;
        for (Frequency frequency : list) {
            this.createSingleVLBISpectralLineWindow(n++, frequency);
        }
        for (ScienceSpectralWindow scienceSpectralWindow : this.getScienceSpectralWindow()) {
            if (scienceSpectralWindow.getGroupIndex() != -1) continue;
            this.removeAbstractScienceSpectralWindow((AbstractScienceSpectralWindow)((Object)scienceSpectralWindow));
        }
    }

    public void updateSingleContinuumWindows(Frequency frequency, Velocity velocity, ObservingFrequency.FrequencyType frequencyType, CorrPolarization corrPolarization) {
        SingleContinuumExpert singleContinuumExpert = new SingleContinuumExpert(frequency, velocity, frequencyType);
        boolean bl = false;
        boolean bl2 = false;
        try {
            if (this.getObservatoryGoal() == null) {
                bl = ObsProposal.isProposalVLBI();
                bl2 = ObsProposal.isProposalPhasedArray();
            }
        }
        catch (UnknownEntityException | NullPointerException throwable) {
            Log.logger(SpectralSetupParameters.class).warning("Unable to determine if project is a VLBI project");
            return;
        }
        AlmaCapabilities almaCapabilities = AlmaCapabilities.getInstance();
        List<Frequency> list = null;
        if (bl || bl2) {
            ReceiverBand receiverBand = ReceiverBand.getReceiverBand(frequency);
            VLBIFrequencyBands vLBIFrequencyBands = bl ? almaCapabilities.getVLBIBands() : almaCapabilities.getVLBIPhaserBands();
            List<Integer> list2 = vLBIFrequencyBands.getVLBIBands().stream().map(vLBIBands -> vLBIBands.getBand()).toList();
            for (Integer n : list2) {
                if (receiverBand.getNumber() != n.intValue()) continue;
                list = almaCapabilities.getVLBISPWCentralFrequencies(n);
                break;
            }
            if (list == null) {
                Log.logger(SpectralSetupParameters.class).warning("Unable to determine VLBI central frequencies");
                return;
            }
            assert (list != null);
            this.createContinuumVLBIWindows(list);
        } else {
            Frequency[] frequencyArray = singleContinuumExpert.getSingleContinuumBasebandCenters(frequencyType != ObservingFrequency.FrequencyType.SKY_FREQUENCY);
            this.createSingleContinuumWindows(frequencyArray, frequencyType);
        }
        Arrays.stream(this.getAbstractScienceSpectralWindow()).forEach(abstractScienceSpectralWindow -> abstractScienceSpectralWindow.getAdvancedWindowSetup().setUseImage(true));
    }

    public void addRepresentativeFrequencyListener(RepresentativeFrequencyListener representativeFrequencyListener) {
        this.repFreqHelper.add(representativeFrequencyListener);
    }

    public boolean removeRepresentativeFrequencyListener(RepresentativeFrequencyListener representativeFrequencyListener) {
        return this.repFreqHelper.remove(representativeFrequencyListener);
    }

    public void addBasebandSwapListener(BasebandSwapListener basebandSwapListener) {
        if (basebandSwapListener != null) {
            this.basebandSwapListeners.add(basebandSwapListener);
        }
    }

    public boolean removeBasebandSwapListener(BasebandSwapListener basebandSwapListener) {
        return this.basebandSwapListeners.remove(basebandSwapListener);
    }

    public synchronized void setOverlayLines(List<SpectralLine> list) {
        this.overlayLines.clear();
        this.clearOverlaidSpectralLine();
        if (list != null) {
            this.overlayLines.addAll(list);
            int n = 0;
            for (SpectralLine spectralLine : list) {
                if (n > 50) break;
                this.addOverlaidSpectralLine(OverlaidSpectralLine.createOverlaidLine(spectralLine));
                ++n;
            }
        }
    }

    public List<SpectralLine> getOverlayLines() {
        return this.overlayLines;
    }

    public SpectralFeedback feedbackSpectralScanSetup() {
        Object object;
        Object object2;
        SpectralScan[] spectralScanArray = this.getAbstractScienceSpectralWindowSpectralScan();
        if (spectralScanArray.length == 0) {
            return null;
        }
        SpectralScan spectralScan = spectralScanArray[0];
        if (spectralScan == null) {
            return null;
        }
        Frequency frequency = spectralScan.getStartFrequency();
        Frequency frequency2 = spectralScan.getEndFrequency();
        if (spectralScan.getStartFrequency().getContentInGHz() != 0.0 && spectralScan.getEndFrequency().getContentInGHz() != 0.0) {
            if (frequency.isGreaterThanOrEqualTo((AbstractDoubleWithUnit)frequency2)) {
                return new SpectralFeedback(SpectralFeedback.AdvisoryType.ERROR, "<html>The start frequency of the scan should be less than the end frequency of the scan</br></html>\n");
            }
            object2 = AlmaCapabilities.getInstance().getSpectralScanReceiverBands();
            FrequencyRange frequencyRange = new FrequencyRange(frequency, frequency2);
            String string = "The requested spectral scan frequency range does not fit within a single receiver band";
            try {
                object = ReceiverBand.getReceiverBand(frequencyRange);
            }
            catch (ReceiverBand.ReceiverNotFoundException receiverNotFoundException) {
                return new SpectralFeedback(SpectralFeedback.AdvisoryType.ERROR, "<html>" + string + "</br></html>\n");
            }
            if (object == null || !object2.contains(object)) {
                return new SpectralFeedback(SpectralFeedback.AdvisoryType.ERROR, "<html>" + string + "</br></html>\n");
            }
            FrequencyRange frequencyRange2 = spectralScan.getRealisableScanRange();
            if (frequencyRange2 != null && !frequencyRange2.contains(this.getRepresentativeFrequency())) {
                return new SpectralFeedback(SpectralFeedback.AdvisoryType.ERROR, "<html>The representative frequency should fall within the realised spectral scan frequency range.</br></html>\n");
            }
        }
        if ((object2 = spectralScan.getSpectralScanFeedback()) != null) {
            object = ((SpectralFeedback)object2).getAdvisoryType().getColour();
            return new SpectralFeedback(((SpectralFeedback)object2).getAdvisoryType(), "<html> <font color=" + (String)object + ">" + ((SpectralFeedback)object2).getMessage() + "</font></br></html>\n");
        }
        return null;
    }

    public List<ScienceSpectralWindow> getSortedScienceSpectralWindowList() {
        List<ScienceSpectralWindow> list = Arrays.asList(this.getScienceSpectralWindow());
        Collections.sort(list, new SpectralWindowComparator());
        return list;
    }

    public boolean getSSPDerivedFromSpectralScanSetup() {
        return this.isSSPDerivedFromSpectralScanSetup;
    }

    public boolean isDerivedSSP() {
        return this.isSSPDerivedFromSpectralScanSetup || this.isDerivedForDGCCalibrator;
    }

    public synchronized void setSSPDerivedFromSpectralScanSetup(Boolean bl) {
        this.isSSPDerivedFromSpectralScanSetup = bl;
    }

    public boolean isNonStandardContinuumFrequency() {
        boolean bl = false;
        if (this.isSingleContinuum()) {
            CorrPolarization corrPolarization = CorrPolarization.getCorrPolarization(this.getPolarisation());
            List<Frequency> list = corrPolarization.equals((Object)CorrPolarization.FULL) ? AlmaCapabilities.getInstance().getPolarizationFrequencies() : AlmaCapabilities.getInstance().getContinuumFrequencies();
            Frequency frequency = null;
            ReceiverBand receiverBand = this.getReceiverBand();
            Frequency frequency2 = this.getSingleContinuumFrequency();
            for (Frequency frequency3 : list) {
                if (!ReceiverBand.getReceiverBand(frequency3).equals(receiverBand)) continue;
                frequency = frequency3;
                break;
            }
            if (null == frequency || Math.abs(frequency.getContentInGHz() - frequency2.getContentInGHz()) > 1.0E-6) {
                bl = true;
            }
        }
        return bl;
    }

    public double getVelocityResolutionInSky(Velocity velocity) {
        double d = 0.0;
        if (this.isSpectralScan()) {
            SpectralScan spectralScan = this.getSpectralScan();
            d = spectralScan.getVelocityResolutionInSky(velocity);
        } else if (this.getScienceSpectralWindowCount() > 0) {
            ScienceSpectralWindow scienceSpectralWindow = this.getRepresentativeSpectralWindow();
            if (null == scienceSpectralWindow) {
                scienceSpectralWindow = this.getScienceSpectralWindow(0);
            }
            if (null != scienceSpectralWindow) {
                d = scienceSpectralWindow.getVelocityResolutionInSky(velocity);
            }
        }
        return d;
    }

    public boolean isSpectralSetupInSky() {
        return this.isSingleContinuumSkyFrequency() || this.isSpectralScan();
    }

    public Frequency getRepresentativeFrequencyWithSkyOffset() {
        if (this.isSpectralSetupInSky()) {
            return this.getRepresentativeFrequency();
        }
        return this.getRepresentativeFrequency().dopplerShifted(this.getSourceVelocity());
    }

    public boolean isWalshSwitching() {
        return this.getAdvancedSpectralSetup().getSideBandSeparation();
    }

    public void setWalshSwitching(boolean bl) {
        this.getAdvancedSpectralSetup().setSideBandSeparation(bl);
    }

    public Optional<FrequencyRange> getSPWImageFrequency(ScienceSpectralWindow scienceSpectralWindow) {
        if (!this.isWalshSwitchingEnabledForWindow(scienceSpectralWindow)) {
            return Optional.empty();
        }
        Velocity velocity = this.getSourceVelocity();
        double d = scienceSpectralWindow.getCenterFrequencyRest().getContentInGHz();
        try {
            if (this.overrideLO1.isEmpty()) {
                this.lo1manager.updateLO1();
            }
        }
        catch (BaseBandNotDeployableException baseBandNotDeployableException) {
            return Optional.empty();
        }
        double d2 = this.getLO1Frequency().inverseDopplerShifted(velocity).getContentInGHz();
        double d3 = 2.0 * d2 - d;
        Frequency frequency = scienceSpectralWindow.getEffectiveBandwidth().inverseDopplerShifted(velocity);
        return Optional.of(FrequencyRange.fastCentredOn(Frequency.createFrequencyGHZ(d3), frequency));
    }

    public boolean isWalshSwitchingEnabledForWindow(ScienceSpectralWindow scienceSpectralWindow) {
        if (!this.getAdvancedSpectralSetup().getSideBandSeparation() || !scienceSpectralWindow.getAdvancedWindowSetup().getUseImage()) {
            return false;
        }
        ReceiverBand receiverBand = this.getReceiverBand();
        return receiverBand != null && receiverBand.getReceiverType().equals((Object)ReceiverType.DSB);
    }

    public SpectralSetupParameters deepCopy() throws CopyException {
        SpectralSetupParameters spectralSetupParameters = super.deepCopy();
        spectralSetupParameters.setSpectralLineWSEnabled(this.isSpectralLineWSEnabled());
        spectralSetupParameters.setSingleContinuumCorrelatorMode(this.getSingleContinuumCorrelatorMode());
        spectralSetupParameters.setForce90DWSOn(this.isForce90DWSOn());
        this.overrideLO1.ifPresent(frequency -> spectralSetupParameters.setOverrideLO1(Optional.of(frequency.deepCopy())));
        return spectralSetupParameters;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[Type] : " + this.getSpectralType() + "\n");
        stringBuilder.append("[LO1] " + this.getLO1Frequency() + "\n");
        this.overrideLO1.ifPresent(frequency -> stringBuilder.append("[OverrideLO1] " + frequency + "\n"));
        stringBuilder.append("[RF] " + this.getRepresentativeFrequencyWithSkyOffset() + "\n");
        for (ScienceSpectralWindow scienceSpectralWindow : this.getScienceSpectralWindow()) {
            stringBuilder.append("[TransitionName] : " + scienceSpectralWindow.getTransitionName() + " [Sky Freq] :  " + scienceSpectralWindow.getCenterFrequencySky() + " [BB] : " + scienceSpectralWindow.getGroupIndex() + "[BW] : " + scienceSpectralWindow.getBandWidth() + "\n");
        }
        return stringBuilder.toString();
    }

    public static void setAttributesForHistoricalProjects(@NonNull ObsProject obsProject) throws UnknownEntityException {
        if (obsProject == null) {
            throw new NullPointerException("lastObsProjectLoaded is marked non-null but is null");
        }
        ObsProposal obsProposal = obsProject.getObsProposal();
        boolean bl = obsProposal.isVLBIorPhasedArray();
        Stream.of(obsProposal.getAbstractScienceGoalScienceGoal()).map(scienceGoal -> scienceGoal.getSpectralSetupParameters()).forEach(spectralSetupParameters -> {
            if (spectralSetupParameters.getSingleContinuumCorrelatorMode() == null) {
                spectralSetupParameters.setSingleContinuumCorrelatorMode(bl ? SINGLECONTINUUMCORRELATORMODE_HIGHRES : SINGLECONTINUUMCORRELATORMODE_LOWRES);
            }
        });
        Stream.of(obsProject.getObsProgram().getAbstractScienceGoalScienceGoal()).map(scienceGoal -> scienceGoal.getSpectralSetupParameters()).forEach(spectralSetupParameters -> {
            if (spectralSetupParameters.getSingleContinuumCorrelatorMode() == null) {
                spectralSetupParameters.setSingleContinuumCorrelatorMode(bl ? SINGLECONTINUUMCORRELATORMODE_HIGHRES : SINGLECONTINUUMCORRELATORMODE_LOWRES);
            }
        });
    }

    protected void initAttribsAndPartsFrom(IBusinessObject iBusinessObject, Copier copier) throws CopyException {
        SpectralSetupParametersData spectralSetupParametersData = (SpectralSetupParametersData)iBusinessObject;
        if (spectralSetupParametersData.getSingleContinuumCorrelatorMode() != null) {
            this.setSingleContinuumCorrelatorMode(spectralSetupParametersData.getSingleContinuumCorrelatorMode());
        }
        super.initAttribsAndPartsFrom(iBusinessObject, copier);
    }

    public void updateLO1() throws BaseBandNotDeployableException {
        this.lo1manager.updateLO1();
    }

    public Frequency getLowestCentralFrequency() throws CannotDetermineLowestFrequencyException {
        Frequency frequency;
        if (this.isSpectralScan()) {
            if (this.getSpectralScan().getStartFrequency() == null) {
                throw new CannotDetermineLowestFrequencyException();
            }
            frequency = this.getSpectralScan().getStartFrequency().deepCopy();
        } else {
            ScienceSpectralWindow scienceSpectralWindow = null;
            for (ScienceSpectralWindow scienceSpectralWindow2 : this.getScienceSpectralWindow()) {
                if (scienceSpectralWindow != null && !scienceSpectralWindow2.getCenterFrequencySky().isLessThan((AbstractDoubleWithUnit)scienceSpectralWindow.getCenterFrequencySky())) continue;
                scienceSpectralWindow = scienceSpectralWindow2;
            }
            if (scienceSpectralWindow == null) {
                throw new CannotDetermineLowestFrequencyException();
            }
            frequency = scienceSpectralWindow.getCenterFrequencySky();
        }
        return frequency;
    }

    public boolean isSinglePolarisation() {
        return this.getPolarisation().equals(SpectralSetupParametersData.POLARISATION_SINGLE_X) || this.getPolarisation().equals(SpectralSetupParametersData.POLARISATION_SINGLE_Y);
    }

    public boolean isForce90DWSOn() {
        return this.isForce90DWSOn;
    }

    public void setForce90DWSOn(boolean bl) {
        this.isForce90DWSOn = bl;
    }

    public boolean isSpectralLineWSEnabled() {
        return this.isSpectralLineWSEnabled;
    }

    public void setSpectralLineWSEnabled(boolean bl) {
        this.isSpectralLineWSEnabled = bl;
    }

    public boolean isDerivedForDGCCalibrator() {
        return this.isDerivedForDGCCalibrator;
    }

    public void setDerivedForDGCCalibrator(boolean bl) {
        this.isDerivedForDGCCalibrator = bl;
    }

    public void setOverrideLO1(Optional<Frequency> optional) {
        this.overrideLO1 = optional;
    }

    public Optional<Frequency> getOverrideLO1() {
        return this.overrideLO1;
    }

    public static enum SpectralSetupTypeChoice {
        SPECTRALLINE(TYPE_FULL, "Spectral Line", "<html>Define high and low resolution spectral<br>windows of different bandwidths</html>"),
        SINGLECONTINUUM(TYPE_CONTINUUM, "Single Continuum", "<html>Cover the maximum available bandwidth with<br>four low resolution spectral windows</html>"),
        SPECTRALSCAN(TYPE_SCAN, "Spectral Scan", "<html>Automatically set up multiple tunings to cover a user-defined bandwidth</html>");

        private String type;
        private String label;
        private String tooltip;

        public static SpectralSetupTypeChoice getTypeChoice(String string) {
            for (SpectralSetupTypeChoice spectralSetupTypeChoice : SpectralSetupTypeChoice.values()) {
                if (spectralSetupTypeChoice.type != string && spectralSetupTypeChoice.label != string) continue;
                return spectralSetupTypeChoice;
            }
            return null;
        }

        public static String[] getKnownTypeChoiceLabels() {
            String[] stringArray = new String[SpectralSetupTypeChoice.values().length];
            int n = 0;
            for (SpectralSetupTypeChoice spectralSetupTypeChoice : SpectralSetupTypeChoice.values()) {
                stringArray[n++] = spectralSetupTypeChoice.label;
            }
            return stringArray;
        }

        public static String[] getKnownTypeChoiceTooltips() {
            String[] stringArray = new String[SpectralSetupTypeChoice.values().length];
            int n = 0;
            for (SpectralSetupTypeChoice spectralSetupTypeChoice : SpectralSetupTypeChoice.values()) {
                stringArray[n++] = spectralSetupTypeChoice.tooltip;
            }
            return stringArray;
        }

        private SpectralSetupTypeChoice(String string2, String string3, String string4) {
            this.type = string2;
            this.label = string3;
            this.tooltip = string4;
        }

        public String getType() {
            return this.type;
        }

        public String getLabel() {
            return this.label;
        }

        public String getTooltip() {
            return this.tooltip;
        }
    }

    private class SpectralWindowStore {
        private SpectralSetupTypeChoice prevChoice = null;
        private final Map<String, AbstractScienceSpectralWindow[]> undoStore = new HashMap<String, AbstractScienceSpectralWindow[]>();

        private SpectralWindowStore() {
        }

        private AbstractScienceSpectralWindow[] get(String string) {
            if (this.undoStore.get(string) == null) {
                this.put(string, new AbstractScienceSpectralWindow[0]);
            }
            return this.undoStore.get(string);
        }

        private void put(String string, AbstractScienceSpectralWindow[] abstractScienceSpectralWindowArray) {
            this.undoStore.put(string, abstractScienceSpectralWindowArray);
            for (AbstractScienceSpectralWindow abstractScienceSpectralWindow : abstractScienceSpectralWindowArray) {
                abstractScienceSpectralWindow.isRepresentativeBeforeWindowClear = false;
                if (!(abstractScienceSpectralWindow instanceof ScienceSpectralWindow) || !((ScienceSpectralWindow)((Object)abstractScienceSpectralWindow)).getRepresentativeWindow()) continue;
                abstractScienceSpectralWindow.isRepresentativeBeforeWindowClear = true;
            }
            SpectralSetupParameters.this.setRepFreqBeforeStore(SpectralSetupTypeChoice.getTypeChoice(string), SpectralSetupParameters.this.getRepresentativeFrequency().deepCopy());
        }

        public void restore(SpectralSetupTypeChoice spectralSetupTypeChoice) {
            AbstractScienceSpectralWindow[] abstractScienceSpectralWindowArray;
            if (this.prevChoice == null) {
                abstractScienceSpectralWindowArray = SpectralSetupParameters.super.getType();
                this.prevChoice = abstractScienceSpectralWindowArray == TYPE_CONTINUUM ? SpectralSetupTypeChoice.SINGLECONTINUUM : (abstractScienceSpectralWindowArray == TYPE_SCAN ? SpectralSetupTypeChoice.SPECTRALSCAN : SpectralSetupTypeChoice.SPECTRALLINE);
            }
            SpectralSetupParameters.super.setType(spectralSetupTypeChoice.getType());
            if (this.prevChoice.type == spectralSetupTypeChoice.type) {
                this.prevChoice = spectralSetupTypeChoice;
                return;
            }
            abstractScienceSpectralWindowArray = SpectralSetupParameters.this.getAbstractScienceSpectralWindow();
            if (this.prevChoice != null) {
                this.put(this.prevChoice.type, abstractScienceSpectralWindowArray);
            }
            SpectralSetupParameters.this.clearAbstractScienceSpectralWindow();
            AbstractScienceSpectralWindow[] abstractScienceSpectralWindowArray2 = this.get(spectralSetupTypeChoice.type);
            SpectralSetupParameters.this.setAbstractScienceSpectralWindow(abstractScienceSpectralWindowArray2);
            if (spectralSetupTypeChoice == SpectralSetupTypeChoice.SINGLECONTINUUM && SpectralSetupParameters.this.getAbstractScienceSpectralWindowCount() == 0) {
                AbstractScienceSpectralWindow[] abstractScienceSpectralWindowArray3 = ScienceSpectralWindow.createSingleContinuum();
                CorrelatorExpert correlatorExpert = CorrelatorExpert.getInstance(CorrelatorType.BL);
                CorrConfigMode corrConfigMode = SpectralSetupParameters.this.isSingleContinuumTDM() ? correlatorExpert.getContinuumMode(SpectralSetupParameters.this.getCorrPolarization()) : correlatorExpert.getFDMContinuumMode(SpectralSetupParameters.this.getCorrPolarization());
                abstractScienceSpectralWindowArray3.setCorrConfigMode(corrConfigMode);
                SpectralSetupParameters.this.addScienceSpectralWindow(-1, 0, (ScienceSpectralWindow)abstractScienceSpectralWindowArray3);
            }
            if (spectralSetupTypeChoice == SpectralSetupTypeChoice.SPECTRALSCAN) {
                SpectralSetupParameters.this.setRepresentativeSpectralWindow(null);
                if (SpectralSetupParameters.this.getAbstractScienceSpectralWindowSpectralScanCount() == 0) {
                    SpectralSetupParameters.this.addNewSpectralScan();
                    SpectralSetupParameters.this.getRepresentativeFrequency().setContentAndUnit((ValueUnitPair)Frequency.createFrequency());
                }
            } else {
                for (AbstractScienceSpectralWindow abstractScienceSpectralWindow : SpectralSetupParameters.this.getAbstractScienceSpectralWindow()) {
                    if (!abstractScienceSpectralWindow.isRepresentativeBeforeWindowClear || !(abstractScienceSpectralWindow instanceof ScienceSpectralWindow)) continue;
                    SpectralSetupParameters.this.setRepresentativeSpectralWindow((ScienceSpectralWindow)((Object)abstractScienceSpectralWindow));
                }
            }
            if (SpectralSetupParameters.this.getRepFreqBeforeStore(spectralSetupTypeChoice) != null) {
                SpectralSetupParameters.this.getRepresentativeFrequency().setContentAndUnit((ValueUnitPair)SpectralSetupParameters.this.getRepFreqBeforeStore(spectralSetupTypeChoice));
            }
            this.prevChoice = spectralSetupTypeChoice;
        }
    }

    public static class SpectralWindowComparator
    implements Comparator<ScienceSpectralWindow> {
        @Override
        public int compare(ScienceSpectralWindow scienceSpectralWindow, ScienceSpectralWindow scienceSpectralWindow2) {
            int n;
            ScienceSpectralWindow scienceSpectralWindow3 = scienceSpectralWindow;
            ScienceSpectralWindow scienceSpectralWindow4 = scienceSpectralWindow2;
            int n2 = scienceSpectralWindow3.getGroupIndex();
            int n3 = n2 - (n = scienceSpectralWindow4.getGroupIndex());
            if (n3 != 0) {
                return n3;
            }
            Frequency frequency = scienceSpectralWindow3.getCenterFrequency();
            Frequency frequency2 = scienceSpectralWindow4.getCenterFrequency();
            Frequency frequency3 = (Frequency)frequency2.minus((AbstractDoubleWithUnit)frequency);
            return (int)(frequency3.getContent() / Math.abs(frequency3.getContent()));
        }
    }

    public class CannotDetermineLowestFrequencyException
    extends Exception {
    }
}

