/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.bo.schedblock;

import alma.Control.LO2Parameters;
import alma.Control.TuningParameters;
import alma.hla.runtime.obsprep.bo.AbstractDoubleWithUnit;
import alma.hla.runtime.obsprep.util.Log;
import alma.obsprep.bo.annotations.SpectralWindowI;
import alma.obsprep.bo.schedblock.BaseBandSpecification;
import alma.obsprep.bo.schedblock.ReceiverBand;
import alma.obsprep.bo.schedblock.SpectralSpec;
import alma.obsprep.ot.gui.toplevel.DialogId;
import alma.obsprep.ot.gui.toplevel.ObservingToolGui;
import alma.obsprep.services.losolutions.OTLOsolutions;
import alma.obsprep.services.losolutions.wrappers.AbstractBasebandSpecWrapper;
import alma.obsprep.services.losolutions.wrappers.BasebandSpecWrapper;
import alma.obsprep.services.losolutions.wrappers.DSBbasebandSpecWrapper;
import alma.obsprep.services.losolutions.wrappers.SSBbasebandSpecWrapper;
import alma.obsprep.services.losolutions.wrappers.SidebandPreferenceWrapper;
import alma.obsprep.services.losolutions.wrappers.SidebandSelectWrapper;
import alma.obsprep.util.GUIUtilities;
import alma.obsprep.util.TextUtils;
import alma.valuetypes.Frequency;
import alma.valuetypes.Velocity;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

public class LOsolutionsAdaptor {
    private static final double ONE_GHZ = 1.0E9;
    public static final DialogId loConfigDialogId = new DialogId("SpectralSpec.LOconfigurationDialog");
    private final SpectralSpec ss;
    private final OTLOsolutions loSolutions;
    private ObservingToolGui.FeedbackInfo feedbackInfo = null;

    public LOsolutionsAdaptor(SpectralSpec spectralSpec) {
        this.ss = spectralSpec;
        this.loSolutions = OTLOsolutions.createOTLOsolutions();
        if (spectralSpec == null) {
            throw new IllegalArgumentException("SpectralSpec must not be null");
        }
    }

    private boolean isDSBmode() {
        return this.ss.getReceiverType() == SpectralSpec.RECEIVERTYPE_DSB;
    }

    public boolean calculate(Velocity velocity, String[] stringArray, boolean bl, int n) {
        List<AbstractBasebandSpecWrapper> list = this.getBaseBandSpecWrapperVector(velocity, stringArray);
        try {
            assert (this.ss != null);
            TuningParameters tuningParameters = this.loSolutions.computeSolutions(list, Optional.of(this.ss.getReceiverBand()));
            if (ReceiverBand.getReceiverBand(tuningParameters.receiverBand.toString()) == null) {
                int n2 = tuningParameters.receiverBand.value() + 1;
                String string = "Requested basebands are within the observable range of Band " + n2 + ", but the band is not available";
                throw new RuntimeException(string);
            }
            double d = this.loSolutions.getLO1Freq(tuningParameters);
            Frequency frequency = this.ss.getFrequencySetup().getLO1Frequency();
            frequency.setContentInGHz(d / 1.0E9);
            LO2Parameters[] lO2ParametersArray = tuningParameters.LO2;
            for (int i = 0; i < this.ss.getFrequencySetup().getBaseBandCount(); ++i) {
                BaseBandSpecification baseBandSpecification = this.ss.getFrequencySetup().getBaseBandSpecification(i);
                int n3 = baseBandSpecification.getBaseBandNameIndex();
                double d2 = this.loSolutions.getLO2Freq(lO2ParametersArray[n3]);
                baseBandSpecification.getLO2Frequency().setContentInGHz(d2 / 1.0E9);
                SidebandSelectWrapper sidebandSelectWrapper = frequency.isGreaterThan((AbstractDoubleWithUnit)baseBandSpecification.getCenterFrequency().dopplerShifted(velocity)) ? SidebandSelectWrapper.Lower : SidebandSelectWrapper.Upper;
                double d3 = this.loSolutions.getActualSkyFreq(tuningParameters, n3, sidebandSelectWrapper);
                baseBandSpecification.getActualBaseBandCenterFrequencySky().setContentInGHz(d3 / 1.0E9);
                for (SpectralWindowI spectralWindowI : baseBandSpecification.getSpectralWindow()) {
                    spectralWindowI.updateSideband(velocity);
                }
            }
        }
        catch (Exception exception) {
            if (bl) {
                if (n > 0) {
                    GUIUtilities.warning(loConfigDialogId, (Object)exception.getMessage(), n);
                } else {
                    GUIUtilities.warning(loConfigDialogId, exception.getMessage());
                }
            }
            this.feedbackInfo = new ObservingToolGui.FeedbackInfo("LO configuration failed", exception.getMessage());
            return false;
        }
        this.feedbackInfo = null;
        return true;
    }

    private SidebandPreferenceWrapper[] getSidebandPreferenceWrapper(String[] stringArray) {
        int n = stringArray == null ? 0 : stringArray.length;
        SidebandPreferenceWrapper[] sidebandPreferenceWrapperArray = new SidebandPreferenceWrapper[n];
        for (int i = 0; i < n; ++i) {
            sidebandPreferenceWrapperArray[i] = SidebandPreferenceWrapper.getOTSidebandPreference(stringArray[i]);
        }
        return sidebandPreferenceWrapperArray;
    }

    private List<AbstractBasebandSpecWrapper> getBaseBandSpecWrapperVector(Velocity velocity, String[] stringArray) {
        SidebandPreferenceWrapper[] sidebandPreferenceWrapperArray = this.getSidebandPreferenceWrapper(stringArray);
        AbstractBasebandSpecWrapper[] abstractBasebandSpecWrapperArray = new AbstractBasebandSpecWrapper[4];
        for (int i = 0; i < 4; ++i) {
            abstractBasebandSpecWrapperArray[i] = this.isDSBmode() ? new DSBbasebandSpecWrapper(new BasebandSpecWrapper(), new BasebandSpecWrapper()) : new SSBbasebandSpecWrapper();
        }
        Frequency frequency = this.ss.getFrequencySetup().gettrueLO1Frequency();
        boolean bl = frequency != null && frequency.getContentInGHz() > 0.0;
        double d = 0.0;
        StringBuilder stringBuilder = new StringBuilder();
        int n = this.ss.getFrequencySetup().getBaseBandSpecificationCount();
        for (int i = 0; i < n; ++i) {
            Object object;
            BaseBandSpecification baseBandSpecification = this.ss.getFrequencySetup().getBaseBandSpecification(i);
            int n2 = baseBandSpecification.getBaseBandNameIndex();
            Frequency frequency2 = baseBandSpecification.getCenterFrequency().dopplerShifted(velocity);
            Frequency frequency3 = Frequency.createFrequencyGHZ(0.0);
            if (baseBandSpecification.gettrueImageCenterFrequency() != null) {
                frequency3 = baseBandSpecification.getImageCenterFrequency().dopplerShifted(velocity);
            }
            double d2 = baseBandSpecification.getWeighting();
            double d3 = baseBandSpecification.getImageWeighting();
            if (bl) {
                d = Math.abs(((Frequency)frequency.minus((AbstractDoubleWithUnit)frequency2)).getContentInGHz());
            }
            double d4 = frequency2.getContentInGHz() * 1.0E9;
            double d5 = frequency3.getContentInGHz() * 1.0E9;
            if (Log.logger((Object)this).finest()) {
                stringBuilder.append("\nfreqHz = " + TextUtils.format(d4 / 1.0E9, 3, 5));
                stringBuilder.append("  imageHz = " + TextUtils.format(d5 / 1.0E9, 3, 5));
                stringBuilder.append(", weight = " + d2);
                stringBuilder.append(", weight_image = " + d3);
                stringBuilder.append(", ifreq = " + TextUtils.format(d, 1, 5));
                stringBuilder.append(", sbprefs = " + sidebandPreferenceWrapperArray[i]);
            }
            if (!(d4 > 0.0)) continue;
            if (this.isDSBmode()) {
                object = new BasebandSpecWrapper(d4, d2, d);
                BasebandSpecWrapper basebandSpecWrapper = new BasebandSpecWrapper(d5, d3, d);
                DSBbasebandSpecWrapper dSBbasebandSpecWrapper = new DSBbasebandSpecWrapper((BasebandSpecWrapper)object, basebandSpecWrapper);
                dSBbasebandSpecWrapper.setSidebandSelect(SidebandSelectWrapper.getSidebandSelectWrapper(sidebandPreferenceWrapperArray[i], d5 > 0.0));
                abstractBasebandSpecWrapperArray[n2] = dSBbasebandSpecWrapper;
                continue;
            }
            abstractBasebandSpecWrapperArray[n2] = object = new SSBbasebandSpecWrapper(d4, d2, d, sidebandPreferenceWrapperArray[i]);
        }
        Log.logger((Object)this).finest(stringBuilder.toString());
        ArrayList<AbstractBasebandSpecWrapper> arrayList = new ArrayList<AbstractBasebandSpecWrapper>(4);
        arrayList.addAll(Arrays.asList(abstractBasebandSpecWrapperArray));
        return arrayList;
    }

    public ObservingToolGui.FeedbackInfo getFeedbackInfo() {
        return this.feedbackInfo;
    }
}

