/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.bo.schedblock;

import alma.hla.runtime.obsprep.util.Log;
import alma.obsprep.bo.schedblock.ACASpectralWindow;
import alma.obsprep.bo.schedblock.AbstractSpectralWindow;
import alma.obsprep.bo.schedblock.OTConfigModeDecoder;
import alma.obsprep.services.generator.WizardSBGenerationException;
import alma.valuetypes.Frequency;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;

public class SpectralWindowBand {
    private final Bandwidth swBandwidth;
    private final NumberOfChannels swChannels;
    private final Resolution swResolution;
    private final AbstractSpectralWindow window;
    private final boolean isACA;

    public SpectralWindowBand(AbstractSpectralWindow abstractSpectralWindow) {
        this.window = abstractSpectralWindow;
        this.isACA = abstractSpectralWindow instanceof ACASpectralWindow;
        this.swBandwidth = new Bandwidth(abstractSpectralWindow);
        this.swChannels = new NumberOfChannels(abstractSpectralWindow);
        this.swResolution = new Resolution();
    }

    private boolean wasACABasebandAvoidanceZoneInfringed(@NonNull Frequency frequency, int n) {
        if (frequency == null) {
            throw new NullPointerException("effectiveBandwidth is marked non-null but is null");
        }
        Log.logger(SpectralWindowBand.class).finer("effectiveBandwidth: " + frequency + " effectiveNumberOfChannels: " + n);
        if (n <= 0) {
            throw new IllegalArgumentException("Illegal argument: effectiveNumberOfChannels (" + n + ") did not pass the test: effectiveNumberOfChannels <= 0");
        }
        ACAFCPRevisedBandwidthParameters aCAFCPRevisedBandwidthParameters = this.getACAFCPRevisedBandWidthParameters(false, frequency.getContentInMHz(), n);
        assert (aCAFCPRevisedBandwidthParameters != null);
        assert (this.window != null);
        boolean bl = this.isAvoidanceZoneInfringed(this.window.getCenterFrequency().getContentInMHz(), aCAFCPRevisedBandwidthParameters.getRevisedBandWidth(), aCAFCPRevisedBandwidthParameters.getRevisedNoChannels());
        Log.logger(SpectralWindowBand.class).fine("avoidanceZoneInfringed: " + bl);
        return bl;
    }

    public void setParameters(Frequency frequency, int n, ChannelType channelType) {
        boolean bl = this.isTfbMode(frequency, n, channelType);
        if (channelType == ChannelType.EFFECTIVE) {
            this.swBandwidth.setEffectiveBandwidth(frequency, bl);
            this.swChannels.setEffectiveChannels(n);
            this.swBandwidth.updateNominalBandwidth(bl);
            this.swChannels.updateNominalNumberOfChannels(bl);
            this.swBandwidth.updateEffectiveBandwidth(bl);
            this.swChannels.updateEffectiveNumberOfChannels(bl);
        } else {
            this.swBandwidth.setNominalBandwidth(frequency, bl);
            this.swChannels.setNominalChannels(n, bl);
            this.swBandwidth.updateEffectiveBandwidth(bl);
            this.swChannels.updateEffectiveNumberOfChannels(bl);
        }
        this.swResolution.setResolution(SpectralWindowBand.calcResolution(frequency, n));
    }

    public void setParameters(int n, Frequency frequency, ChannelType channelType) {
        boolean bl = this.isTfbMode(n, frequency, channelType);
        if (channelType == ChannelType.EFFECTIVE) {
            this.swChannels.setEffectiveChannels(n);
            this.swBandwidth.setEffectiveBandwidth(SpectralWindowBand.calcBandwidth(n, frequency), bl);
        } else {
            this.swChannels.setNominalChannels(n, bl);
            this.swBandwidth.setNominalBandwidth(SpectralWindowBand.calcBandwidth(n, frequency), bl);
        }
        this.swResolution.setResolution(frequency);
    }

    public void setParameters(Frequency frequency, Frequency frequency2, ChannelType channelType) {
        boolean bl = this.isTfbMode(frequency, frequency2, channelType);
        if (channelType == ChannelType.EFFECTIVE) {
            this.swBandwidth.setEffectiveBandwidth(frequency, bl);
            this.swChannels.setEffectiveChannels(SpectralWindowBand.calcChannels(frequency, frequency2));
        } else {
            this.swBandwidth.setNominalBandwidth(frequency, bl);
            this.swChannels.setNominalChannels(SpectralWindowBand.calcChannels(frequency, frequency2), bl);
        }
        this.swResolution.setResolution(frequency2);
    }

    public Frequency getEffectiveBandwidth() {
        return this.swBandwidth.getEffectiveBandwidth();
    }

    public Frequency getNominalBandwidth() {
        return this.swBandwidth.getNominalBandwidth();
    }

    public int getEffectiveChannels() {
        return this.swChannels.getEffectiveChannels();
    }

    public int getNominalChannels() {
        return this.swChannels.getNominalChannels();
    }

    public Frequency getResolution() {
        return this.swResolution.getResolution();
    }

    private boolean isTfbMode(Frequency frequency, int n, ChannelType channelType) {
        if (this.isACA) {
            return false;
        }
        double d = frequency.getContentInMHz();
        int n2 = (int)Math.round(d);
        int n3 = n;
        if (channelType == ChannelType.EFFECTIVE) {
            if (n2 == 2000 && n3 < 1024) {
                return false;
            }
            n2 = (int)Math.round(SpectralWindowBand.toNominalBandwidthValue(d));
            n3 = SpectralWindowBand.toNominalChannelsValue(n);
        }
        return n2 != 2000 || n3 >= 1024;
    }

    private boolean isTfbMode(int n, Frequency frequency, ChannelType channelType) {
        if (this.isACA) {
            return false;
        }
        Frequency frequency2 = (Frequency)frequency.multiply(n);
        return this.isTfbMode(frequency2, n, channelType);
    }

    private boolean isTfbMode(Frequency frequency, Frequency frequency2, ChannelType channelType) {
        if (this.isACA) {
            return false;
        }
        int n = SpectralWindowBand.calcChannels(frequency, frequency2);
        return this.isTfbMode(frequency, n, channelType);
    }

    public static int calcChannels(Frequency frequency, Frequency frequency2) {
        return (int)Math.round(frequency.getContentInMHz() / frequency2.getContentInMHz());
    }

    public static Frequency calcResolution(Frequency frequency, int n) {
        return (Frequency)frequency.divide(n);
    }

    public static Frequency calcBandwidth(int n, Frequency frequency) {
        return (Frequency)frequency.multiply(n);
    }

    static double toNominalBandwidthValue(double d) {
        return d * 16.0 / 15.0;
    }

    static double toEffectiveBandwidthValue(double d) {
        return d * 15.0 / 16.0;
    }

    static int toNominalChannelsValue(int n) {
        return n * 16 / 15;
    }

    static int toEffectiveChannelsValue(int n) {
        return n * 15 / 16;
    }

    static int toACANominalValue(int n) {
        switch (n) {
            case 62: {
                return 64;
            }
            case 124: {
                return 128;
            }
            case 248: {
                return 256;
            }
            case 2040: {
                return 2048;
            }
            case 4080: {
                return 4096;
            }
            case 8160: {
                return 8192;
            }
        }
        return n;
    }

    static int toACAFrqChProfValue(int n) {
        switch (n) {
            case 64: {
                return 62;
            }
            case 128: {
                return 124;
            }
            case 256: {
                return 248;
            }
            case 2048: {
                return 2040;
            }
            case 4096: {
                return 4080;
            }
            case 8192: {
                return 8160;
            }
        }
        return n;
    }

    public String toString() {
        return this.swBandwidth.toString() + "," + this.swChannels + "," + this.swResolution;
    }

    private double calculateStepSize(double d, int n) {
        if (d < 0.0 || n < 1) {
            throw new IllegalArgumentException("BW: " + d + " No of channels: " + n);
        }
        double d2 = d / 3.90625;
        double d3 = Math.max(d2, (double)n);
        double d4 = d / d3;
        double d5 = 8.0 * d4;
        return d5;
    }

    private boolean isAvoidanceZoneInfringed(double d, double d2, int n) {
        if (d2 < 0.0 || n < 1) {
            throw new WizardSBGenerationException("The bandwidth/no of channels is setup incorrectly: please check your spectral setup");
        }
        double d3 = this.calculateStepSize(d2, n);
        return d - d2 / 2.0 < 2000.0 + d3 || d + d2 / 2.0 > 4000.0 - d3;
    }

    private ACAFCPRevisedBandwidthParameters getACAFCPRevisedBandWidthParameters(boolean bl, double d, int n) {
        int n2;
        if (d < 0.0 || n < 1) {
            throw new IllegalArgumentException("bandWidthMHz: " + d + " noChannels: " + n);
        }
        double d2 = d / 3.90625;
        double d3 = Math.max(d2, (double)n);
        double d4 = d / d3;
        double d5 = 8.0 * d4;
        double d6 = bl ? d - 2.0 * d5 : d + 2.0 * d5;
        int n3 = n2 = bl ? (int)((double)n - 2.0 * d5 / d4) : (int)((double)n + 2.0 * d5 / d4);
        assert (d6 > 0.0);
        assert (n2 > 0);
        return new ACAFCPRevisedBandwidthParameters(d6, n2, d5);
    }

    class Bandwidth {
        AbstractSpectralWindow window;
        Frequency nominalBandwidth;

        public Bandwidth(AbstractSpectralWindow abstractSpectralWindow) {
            this.window = abstractSpectralWindow;
            this.nominalBandwidth = Frequency.createFrequency();
            this.updateNominalBandwidth(false);
        }

        public Frequency getEffectiveBandwidth() {
            return this.window.getEffectiveBandwidth();
        }

        public void setEffectiveBandwidth(Frequency frequency, boolean bl) {
            this.getEffectiveBandwidth().setContent(frequency.getContent());
            this.getEffectiveBandwidth().setUnit(frequency.getUnit());
        }

        public void setNominalBandwidth(Frequency frequency, boolean bl) {
            this.nominalBandwidth.setContent(frequency.getContent());
            this.nominalBandwidth.setUnit(frequency.getUnit());
        }

        public void updateNominalBandwidth(boolean bl) {
            Frequency frequency = this.window.gettrueEffectiveBandwidth();
            if (frequency != null) {
                if (this.window.isACA()) {
                    Frequency frequency2 = this.getEffectiveBandwidth();
                    double d = frequency2.getContentInMHz();
                    int n = this.window.getEffectiveNumberOfChannels();
                    int n2 = SpectralWindowBand.toACANominalValue(n);
                    double d2 = frequency2.getContentInMHz() / (double)n * (double)n2;
                    if (this.window.isFrqChProfile()) {
                        assert (n > 0);
                        assert (frequency2.getContentInMHz() > 0.0);
                        if (d2 == 2000.0) {
                            d = d2;
                        } else {
                            boolean bl2 = false;
                            for (String string : OTConfigModeDecoder.getInstance().getKnownNominalBandwidthLabels()) {
                                if (Double.valueOf(StringUtils.split((String)string)[0]).doubleValue() != frequency2.getContentInMHz()) continue;
                                bl2 = true;
                                break;
                            }
                            if (!bl2 && SpectralWindowBand.this.wasACABasebandAvoidanceZoneInfringed(frequency2, n)) {
                                d = SpectralWindowBand.this.getACAFCPRevisedBandWidthParameters(false, frequency2.getContentInMHz(), n).getRevisedBandWidth();
                            }
                        }
                    }
                    Log.logger(Bandwidth.class).fine("ACA Nominal revised BW (MHz): " + d);
                    this.nominalBandwidth.setContentAndUnit(d, Frequency.UNIT_MHZ);
                } else {
                    this.nominalBandwidth.setContent(this.nominalValue(this.getEffectiveBandwidth(), bl));
                    this.nominalBandwidth.setUnit(this.getEffectiveBandwidth().getUnit());
                }
            }
        }

        public void updateEffectiveBandwidth(boolean bl) {
            if (this.window.isACA() && !this.window.getACASynthProf().equals(ACASpectralWindow.SYNTHPROF_ACA_CDP)) {
                double d = this.nominalBandwidth.getContentInMHz();
                double d2 = this.nominalBandwidth.getContentInMHz();
                if (this.window.isFrqChProfile()) {
                    int n = this.window.getNominalNumberOfChannels();
                    if (d == 2000.0) {
                        int n2 = SpectralWindowBand.toACAFrqChProfValue(n);
                        d2 = d / (double)n * (double)n2;
                    } else if (SpectralWindowBand.this.isAvoidanceZoneInfringed(this.window.getCenterFrequency().getContentInMHz(), d, n)) {
                        d2 = SpectralWindowBand.this.getACAFCPRevisedBandWidthParameters(true, d, n).getRevisedBandWidth();
                        Log.logger(Bandwidth.class).fine("ACA baseband avoidance zone infringed: effectiveBWMHz: " + d2 + " from " + d);
                    }
                }
                this.getEffectiveBandwidth().setContentAndUnit(d2, Frequency.UNIT_MHZ);
            } else {
                this.getEffectiveBandwidth().setContent(this.effectiveValue(this.nominalBandwidth, bl));
                this.getEffectiveBandwidth().setUnit(this.nominalBandwidth.getUnit());
            }
        }

        private double nominalValue(Frequency frequency, boolean bl) {
            double d = frequency.getContent();
            if (bl) {
                d = SpectralWindowBand.toNominalBandwidthValue(frequency.getContent());
            }
            return d;
        }

        private double effectiveValue(Frequency frequency, boolean bl) {
            double d = frequency.getContent();
            if (bl) {
                d = SpectralWindowBand.toEffectiveBandwidthValue(frequency.getContent());
            }
            return d;
        }

        public String toString() {
            return "Eff=" + this.getEffectiveBandwidth() + ",Nom=" + this.nominalBandwidth;
        }

        public Frequency getNominalBandwidth() {
            return this.nominalBandwidth;
        }
    }

    class NumberOfChannels {
        AbstractSpectralWindow window;
        int nominalChannels;

        public NumberOfChannels(AbstractSpectralWindow abstractSpectralWindow) {
            if (abstractSpectralWindow == null) {
                throw new NullPointerException("window is marked non-null but is null");
            }
            this.window = abstractSpectralWindow;
        }

        public int getEffectiveChannels() {
            return this.window.getEffectiveNumberOfChannels();
        }

        public void setEffectiveChannels(int n) {
            this.window.settrueEffectiveNumberOfChannels(n);
        }

        public void updateNominalNumberOfChannels(boolean bl) {
            int n = this.window.getEffectiveNumberOfChannels();
            this.nominalChannels = this.nominalValue(n, bl);
            if (this.window.isACA() && this.window.isFrqChProfile()) {
                if (this.window.getNominalBandwidth().getContentInMHz() == 2000.0) {
                    this.nominalChannels = SpectralWindowBand.toACANominalValue(n);
                } else {
                    boolean bl2 = false;
                    for (String string : OTConfigModeDecoder.getInstance().getKnownNominalChannelLabels()) {
                        if (Integer.valueOf(string) != this.nominalChannels) continue;
                        bl2 = true;
                        break;
                    }
                    if (!bl2 && SpectralWindowBand.this.wasACABasebandAvoidanceZoneInfringed(SpectralWindowBand.this.getEffectiveBandwidth(), n)) {
                        this.nominalChannels = SpectralWindowBand.this.getACAFCPRevisedBandWidthParameters(false, this.window.getEffectiveBandwidth().getContentInMHz(), n).getRevisedNoChannels();
                    }
                }
            }
            Log.logger(NumberOfChannels.class).finer("nominalChannels: " + this.nominalChannels);
        }

        public void setNominalChannels(int n, boolean bl) {
            this.nominalChannels = n;
        }

        public void updateEffectiveNumberOfChannels(boolean bl) {
            int n = this.effectiveValue(this.nominalChannels, bl);
            if (this.window.isACA() && this.window.isFrqChProfile() && !this.window.getACASynthProf().equals(ACASpectralWindow.SYNTHPROF_ACA_CDP)) {
                double d = this.window.getNominalBandwidth().getContentInMHz();
                if (d == 2000.0) {
                    n = SpectralWindowBand.toACAFrqChProfValue(this.nominalChannels);
                } else if (SpectralWindowBand.this.isAvoidanceZoneInfringed(this.window.getCenterFrequency().getContentInMHz(), d, this.nominalChannels)) {
                    n = SpectralWindowBand.this.getACAFCPRevisedBandWidthParameters(true, d, this.nominalChannels).getRevisedNoChannels();
                    Log.logger(NumberOfChannels.class).fine("ACA baseband avoidance zone infringed: effectiveChannels: " + n + " was " + this.nominalChannels);
                } else {
                    n = this.effectiveValue(this.nominalChannels, bl);
                }
            }
            this.window.settrueEffectiveNumberOfChannels(n);
        }

        private int nominalValue(int n, boolean bl) {
            int n2 = n;
            if (bl) {
                n2 = SpectralWindowBand.toNominalChannelsValue(n);
            }
            return n2;
        }

        private int effectiveValue(int n, boolean bl) {
            int n2 = n;
            if (bl) {
                n2 = SpectralWindowBand.toEffectiveChannelsValue(n);
            }
            return n2;
        }

        public String toString() {
            String string = "Eff=" + this.window.getEffectiveNumberOfChannels() + ",Nom=" + this.nominalChannels;
            return string;
        }

        public int getNominalChannels() {
            return this.nominalChannels;
        }
    }

    static class Resolution {
        private final Frequency resolution = Frequency.createFrequency();

        public void setResolution(Frequency frequency) {
            this.resolution.setContent(frequency.getContent());
            this.resolution.setUnit(frequency.getUnit());
        }

        public String toString() {
            String string = "Res=" + this.resolution;
            return string;
        }

        public Frequency getResolution() {
            return this.resolution;
        }
    }

    static class ACAFCPRevisedBandwidthParameters {
        private final double revisedBandWidth;
        private int revisedNoChannels;
        private double stepSize;

        public ACAFCPRevisedBandwidthParameters(double d, int n, double d2) {
            this.revisedBandWidth = d;
            this.revisedNoChannels = n;
            this.stepSize = d2;
        }

        public String toString() {
            return "SpectralWindowBand.ACAFCPRevisedBandwidthParameters(revisedBandWidth=" + this.getRevisedBandWidth() + ", revisedNoChannels=" + this.getRevisedNoChannels() + ", stepSize=" + this.getStepSize() + ")";
        }

        public double getRevisedBandWidth() {
            return this.revisedBandWidth;
        }

        public int getRevisedNoChannels() {
            return this.revisedNoChannels;
        }

        public void setRevisedNoChannels(int n) {
            this.revisedNoChannels = n;
        }

        public double getStepSize() {
            return this.stepSize;
        }

        public void setStepSize(double d) {
            this.stepSize = d;
        }
    }

    public static enum ChannelType {
        NOMINAL,
        EFFECTIVE;

    }
}

