/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.guiutil.mvc.examples;

import alma.hla.runtime.obsprep.util.Log;
import alma.obsprep.guiutil.events.Event;
import alma.obsprep.guiutil.events.EventManager;
import alma.obsprep.guiutil.events.EventReceiver;
import alma.obsprep.guiutil.events.EventTypes;
import alma.obsprep.guiutil.mvc.Editor;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.guiutil.mvc.examples.Book;
import alma.obsprep.guiutil.mvc.examples.BookEditor;
import alma.obsprep.guiutil.mvc.examples.BookModel;
import alma.obsprep.guiutil.mvc.examples.Library;
import alma.obsprep.guiutil.mvc.examples.LibraryEditor;
import alma.obsprep.guiutil.mvc.examples.LibraryModel;
import alma.obsprep.guiutil.mvc.examples.LibraryTree;
import alma.obsprep.guiutil.mvc.examples.LibraryTreeAction;
import alma.obsprep.guiutil.mvc.examples.Shelf;
import alma.obsprep.guiutil.mvc.examples.ShelfEditor;
import alma.obsprep.guiutil.mvc.examples.ShelfModel;
import alma.obsprep.util.LogLoggerProviderImpl;
import java.awt.Container;
import java.awt.Dimension;
import java.beans.XMLDecoder;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import javax.swing.Box;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.UIManager;

public class LibraryMain
implements EventReceiver {
    public static final String PATH_TO_HERE = "src/alma/obsprep/guiutil/mvc/examples/";
    private Editor eBook;
    private JPanel editors;
    private Editor eLibrary;
    private Editor eShelf;

    public LibraryMain(JFrame jFrame) {
        Log.setRuntimeImplementation((Log.LoggerProvider)new LogLoggerProviderImpl());
        Library library = this.readLibrary("src/alma/obsprep/guiutil/mvc/examples/library.xml");
        LibraryModel libraryModel = new LibraryModel(library);
        this.eLibrary = new LibraryEditor(libraryModel);
        Shelf shelf = new Shelf();
        ShelfModel shelfModel = new ShelfModel(shelf);
        this.eShelf = new ShelfEditor(shelfModel);
        Book book = new Book();
        BookModel bookModel = new BookModel(book);
        this.eBook = new BookEditor(bookModel);
        LibraryTree libraryTree = new LibraryTree(libraryModel);
        this.editors = new JPanel();
        libraryTree.setPreferredSize(new Dimension(300, 600));
        this.editors.setPreferredSize(new Dimension(350, 200));
        Box box = Box.createHorizontalBox();
        box.add(libraryTree);
        box.add(Box.createVerticalStrut(5));
        box.add(this.editors);
        Container container = jFrame.getContentPane();
        container.add(box);
        JPopupMenu jPopupMenu = this.makePopupMenu();
        libraryTree.setPopup(jPopupMenu);
    }

    private Library readLibrary(String string) {
        Library library = null;
        try {
            XMLDecoder xMLDecoder = new XMLDecoder(new FileInputStream(new File(string)));
            library = (Library)xMLDecoder.readObject();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        return library;
    }

    @Override
    public void receiveEvent(Event event) {
        Object object = event.getData();
        this.updateEditor(object);
    }

    public void updateEditor(Object object) {
        Editor editor = null;
        if (LibraryMain.isLibrary(object)) {
            editor = this.eLibrary;
        } else if (LibraryMain.isShelf(object)) {
            editor = this.eShelf;
        } else if (LibraryMain.isBook(object)) {
            editor = this.eBook;
        } else {
            throw new IllegalArgumentException("Unknown class: " + object.getClass().getName());
        }
        Model model = editor.getModel();
        model.setDocument(object);
        this.editors.removeAll();
        this.editors.add(editor);
        this.editors.revalidate();
        this.editors.repaint();
    }

    public static boolean isBook(Object object) {
        return object.getClass().isAssignableFrom(Book.class);
    }

    public static boolean isLibrary(Object object) {
        return object.getClass().isAssignableFrom(Library.class);
    }

    public static boolean isShelf(Object object) {
        return object.getClass().isAssignableFrom(Shelf.class);
    }

    public static void main(String[] stringArray) throws Exception {
        UIManager.setLookAndFeel("javax.swing.plaf.metal.MetalLookAndFeel");
        JFrame jFrame = new JFrame("Library tree demo");
        LibraryMain libraryMain = new LibraryMain(jFrame);
        EventManager.subscribeByType(EventTypes.NODESELECTED, libraryMain);
        jFrame.setDefaultCloseOperation(3);
        jFrame.pack();
        jFrame.setVisible(true);
    }

    private JPopupMenu makePopupMenu() {
        JPopupMenu jPopupMenu = new JPopupMenu("Empty");
        LibraryTreeAction libraryTreeAction = new LibraryTreeAction("Print");
        jPopupMenu.addSeparator();
        jPopupMenu.add(libraryTreeAction);
        jPopupMenu.addSeparator();
        return jPopupMenu;
    }

    protected static URL findResource(String string) {
        URL uRL = null;
        try {
            String string2 = new File(".").getCanonicalPath();
            String string3 = "file:" + string2 + "/src/alma/obsprep/guiutil/mvc/examples/" + string;
            uRL = new URL(string3);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return uRL;
    }
}

