/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.actions;

import alma.hla.runtime.obsprep.bo.BusinessObject;
import alma.hla.runtime.obsprep.util.Log;
import alma.hla.runtime.obsprep.util.UnknownEntityException;
import alma.obsprep.bo.obsproject.AbstractScienceGoal;
import alma.obsprep.bo.obsproject.ObsProgram;
import alma.obsprep.bo.obsproject.ObsProject;
import alma.obsprep.bo.obsproject.ObsUnitSet;
import alma.obsprep.bo.obsproposal.ObsProposal;
import alma.obsprep.bo.schedblock.SchedBlock;
import alma.obsprep.guiutil.events.Event;
import alma.obsprep.guiutil.events.EventManager;
import alma.obsprep.guiutil.events.EventReceiver;
import alma.obsprep.guiutil.events.EventTypes;
import alma.obsprep.ot.actions.OTAction;
import alma.obsprep.ot.actions.WizardInteractor;
import alma.obsprep.ot.actions.WizardPerformer;
import alma.obsprep.ot.gui.toplevel.ObservingToolGui;
import alma.obsprep.ot.persistence.ImpexFactory;
import alma.obsprep.ot.persistence.ProjectResetListener;
import alma.obsprep.ot.project.ProjectTree;
import alma.obsprep.ot.project.ProjectTreeNode;
import alma.obsprep.services.network.roledirectory.RoleDirectoryService;
import alma.obsprep.services.network.roledirectory.RoleDirectoryServiceHelper;
import alma.obsprep.util.GUIUtilities;

public class BatchGenerationAction
extends OTAction
implements WizardInteractor,
EventReceiver,
RoleDirectoryService.UserAuthenticatesListener,
ProjectResetListener {
    protected BusinessObject m_selectedBO = null;
    protected BusinessObject m_parentBO = null;
    protected ProjectTreeNode m_selectedNode = null;
    protected ProjectTreeNode m_parentNode = null;
    private final ObservingToolGui gui;
    private final ProjectTree phase2Tree;
    private boolean isPhaseII = false;

    public BatchGenerationAction(ProjectTree projectTree, ObservingToolGui observingToolGui) {
        this.gui = observingToolGui;
        this.phase2Tree = projectTree;
        WizardPerformer wizardPerformer = new WizardPerformer(this);
        this.setPerformer(wizardPerformer);
        EventManager.subscribeByType(EventTypes.NODESELECTED, this);
        this.setEnabled(false);
        ImpexFactory.getInstance().addProjectImportListener(this);
        RoleDirectoryService.addUserAuthenticatesListener(this);
    }

    public BatchGenerationAction(ProjectTree projectTree, ObservingToolGui observingToolGui, boolean bl) {
        this.phase2Tree = projectTree;
        this.gui = observingToolGui;
        this.isPhaseII = bl;
        WizardPerformer wizardPerformer = new WizardPerformer(this);
        this.setPerformer(wizardPerformer);
        EventManager.subscribeByType(EventTypes.NODESELECTED, this);
        this.setEnabled(false);
        ImpexFactory.getInstance().addProjectImportListener(this);
        RoleDirectoryService.addUserAuthenticatesListener(this);
    }

    @Override
    public boolean shouldScienceGoalKnowItGotGenerated() {
        return true;
    }

    @Override
    public boolean confirmOverwrite() {
        AbstractScienceGoal[] abstractScienceGoalArray = this.getScienceGoals();
        int n = 0;
        int n2 = RoleDirectoryServiceHelper.isUserP2G() ? this.determineNumberSGsWithNonDeleteableEntitiesForPrivilegedUser().intValue() : this.determineNumberSGsWithNonDeleteableEntities().intValue();
        for (AbstractScienceGoal abstractScienceGoal : abstractScienceGoalArray) {
            if (abstractScienceGoal.getObsUnitSet() == null) continue;
            ++n;
        }
        if (n - n2 > 0) {
            if (System.getProperty("alma.obsprep.noconfirmations") == null) {
                return GUIUtilities.confirm(DIALOG_OVERWRITE_PROGRAM, "Overwrite the previously generated ObsUnitSets for " + (n - n2) + " science goal(s)?");
            }
            return true;
        }
        return true;
    }

    private void setEnabledFor(BusinessObject businessObject) {
        if (!RoleDirectoryServiceHelper.isUserP2G()) {
            this.setEnabled(false);
            return;
        }
        if (this.isPhaseII) {
            this.setEnabled(businessObject instanceof ObsProgram);
        } else {
            this.setEnabled(businessObject instanceof ObsProposal);
        }
    }

    @Override
    public void receiveEvent(Event event) {
        if (this.phase2Tree.isDndReadonly()) {
            this.setEnabled(false);
            return;
        }
        this.m_selectedNode = (ProjectTreeNode)event.getSource();
        this.m_parentNode = (ProjectTreeNode)this.m_selectedNode.getParent();
        this.m_selectedBO = (BusinessObject)this.m_selectedNode.getUserObject();
        this.m_parentBO = this.m_parentNode != null ? (BusinessObject)this.m_parentNode.getUserObject() : null;
        this.setEnabledFor(this.m_selectedBO);
    }

    @Override
    public AbstractScienceGoal[] getScienceGoals() {
        if (this.isPhaseII) {
            ObsProgram obsProgram = (ObsProgram)this.m_selectedBO;
            return obsProgram.getAbstractScienceGoalScienceGoal();
        }
        try {
            ObsProposal obsProposal = (ObsProposal)this.m_selectedBO;
            return obsProposal.getAbstractScienceGoalScienceGoal();
        }
        catch (Exception exception) {
            GUIUtilities.error(DIALOG_NO_PROPOSAL, String.format("No Proposal associated with selected object (of type %s)", this.m_selectedBO.getClass().getSimpleName()));
            return new AbstractScienceGoal[0];
        }
    }

    @Override
    public void error(String string, Exception exception) {
        Log.logger((Object)this).info(string + " due to: " + exception);
    }

    @Override
    public void busy(boolean bl) {
        if (this.gui instanceof ObservingToolGui) {
            this.gui.showAsBusy(bl);
        }
    }

    @Override
    public boolean requestConfirmation(String string) {
        if (string.equals(WizardPerformer.ConfirmationReasons.GENERATESBSFORDELETEABLESSCIENCEGOALS.getReason())) {
            Integer n = RoleDirectoryServiceHelper.isUserP2G() ? this.determineNumberSGsWithNonDeleteableEntitiesForPrivilegedUser() : this.determineNumberSGsWithNonDeleteableEntities();
            if (n == this.getScienceGoals().length) {
                GUIUtilities.error(DIALOG_OVERWRITE_PROGRAM, "In each of the science goals there is an OUS or SB that cannot be deleted so therefore the SBs cannot be re-generated.");
                return false;
            }
            if (n > 0) {
                return GUIUtilities.confirm(DIALOG_OVERWRITE_PROGRAM, n + " science goal(s) have an existing OUS structure that contain components that cannot be deleted; generate SBs for those science goals that do not?");
            }
        }
        return true;
    }

    private Integer determineNumberSGsWithNonDeleteableEntitiesForPrivilegedUser() {
        AbstractScienceGoal[] abstractScienceGoalArray = this.getScienceGoals();
        Integer n = 0;
        for (AbstractScienceGoal abstractScienceGoal : abstractScienceGoalArray) {
            if (abstractScienceGoal.getObsUnitSet() == null || !this.hasNonDeletableSGOUS(abstractScienceGoal)) continue;
            Integer n2 = n;
            n = n + 1;
        }
        return n;
    }

    private boolean hasNonDeletableSGOUS(AbstractScienceGoal abstractScienceGoal) {
        ObsUnitSet obsUnitSet = abstractScienceGoal.gettrueObsUnitSet();
        if (obsUnitSet == null) {
            return false;
        }
        return !obsUnitSet.isSBRegenerationPossible();
    }

    private Integer determineNumberSGsWithNonDeleteableEntities() {
        AbstractScienceGoal[] abstractScienceGoalArray = this.getScienceGoals();
        Integer n = 0;
        for (AbstractScienceGoal abstractScienceGoal : abstractScienceGoalArray) {
            if (abstractScienceGoal.getObsUnitSet() == null || !this.hasNonDeletableOUSorSB(abstractScienceGoal).booleanValue()) continue;
            Integer n2 = n;
            n = n + 1;
        }
        return n;
    }

    private Boolean hasNonDeletableOUSorSB(AbstractScienceGoal abstractScienceGoal) {
        ObsUnitSet obsUnitSet = abstractScienceGoal.gettrueObsUnitSet();
        if (obsUnitSet == null) {
            return false;
        }
        if (!obsUnitSet.isDeletable()) {
            return true;
        }
        try {
            for (SchedBlock obsUnitSetComponent : obsUnitSet.findSchedBlocks()) {
                if (obsUnitSetComponent.isDeletable()) continue;
                return true;
            }
        }
        catch (UnknownEntityException unknownEntityException) {
            // empty catch block
        }
        for (ObsUnitSet obsUnitSet2 : obsUnitSet.findObsUnitSets()) {
            if (obsUnitSet2.isDeletable()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void projectDocumentReset(ObsProject obsProject, ImpexFactory.WorkingPersistenceData workingPersistenceData) {
        if (this.m_selectedBO == null) {
            return;
        }
        this.setEnabledFor(this.m_selectedBO);
    }

    @Override
    public void userHasAuthenticated() {
        if (this.m_selectedBO == null) {
            return;
        }
        this.setEnabledFor(this.m_selectedBO);
    }
}

