/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.actions;

import alma.hla.runtime.obsprep.bo.BusinessObject;
import alma.hla.runtime.obsprep.util.Log;
import alma.hla.runtime.obsprep.util.UnknownEntityException;
import alma.obsprep.bo.OusCollection;
import alma.obsprep.bo.annotations.ObsUnitSetComponent;
import alma.obsprep.bo.obsproject.AbstractScienceGoal;
import alma.obsprep.bo.obsproject.ObsProject;
import alma.obsprep.bo.obsproject.ObsUnitSet;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.schedblock.ObservingGroup;
import alma.obsprep.bo.schedblock.SchedBlock;
import alma.obsprep.guiutil.events.Event;
import alma.obsprep.guiutil.events.EventManager;
import alma.obsprep.guiutil.events.EventReceiver;
import alma.obsprep.guiutil.events.EventTypes;
import alma.obsprep.ot.actions.DeleteInteractor;
import alma.obsprep.ot.actions.DeletePerformer;
import alma.obsprep.ot.actions.OTAction;
import alma.obsprep.ot.actions.deletechecker.DeleteChecker;
import alma.obsprep.ot.actions.deletechecker.DeleteCheckerFactory;
import alma.obsprep.ot.gui.toplevel.DialogId;
import alma.obsprep.ot.project.ProjectTree;
import alma.obsprep.ot.project.ProjectTreeNode;
import alma.obsprep.services.network.roledirectory.RoleDirectoryService;
import alma.obsprep.services.network.roledirectory.RoleDirectoryServiceHelper;
import alma.obsprep.util.GUIUtilities;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import lombok.NonNull;

public class Delete
extends OTAction
implements DeleteInteractor,
EventReceiver,
RoleDirectoryService.UserAuthenticatesListener {
    private static DialogId DIALOG_DELETE = new DialogId("Delete.Confirm");
    private final ProjectTree m_usertree;
    private BusinessObject m_selectedBO = null;
    private BusinessObject m_parentBO = null;
    private ProjectTreeNode m_selectedNode = null;
    private ProjectTreeNode m_parentNode = null;
    private boolean m_userview;

    public Delete(ProjectTree projectTree, ProjectTree projectTree2) {
        this.m_usertree = projectTree;
        DeletePerformer deletePerformer = new DeletePerformer(this);
        this.setPerformer(deletePerformer);
        EventManager.subscribeByType(EventTypes.NODESELECTED, this);
        RoleDirectoryService.addUserAuthenticatesListener(this);
        this.setEnabled(false);
        this.setHidable(false);
    }

    @Override
    public void receiveEvent(Event event) {
        this.m_selectedNode = (ProjectTreeNode)event.getSource();
        this.m_selectedBO = (BusinessObject)this.m_selectedNode.getUserObject();
        this.m_parentNode = (ProjectTreeNode)this.m_selectedNode.getParent();
        this.m_parentBO = this.m_parentNode != null ? (BusinessObject)this.m_parentNode.getUserObject() : null;
        this.m_userview = this.m_usertree.getTop() == this.m_selectedNode.getRoot();
        boolean bl = this.setEnabledFor(this.m_userview, this.m_selectedBO);
        this.setEnabled(bl);
    }

    @Override
    public BusinessObject getSelectedBO() {
        return this.m_selectedBO;
    }

    @Override
    public BusinessObject getParentBO() {
        return this.m_parentBO;
    }

    @Override
    public TreeNode getParentNode() {
        return this.m_parentNode;
    }

    @Override
    public void error(String string) {
        GUIUtilities.error(null, string);
    }

    @Override
    public void info(String string) {
        GUIUtilities.info(null, string);
    }

    @Override
    public boolean confirmDelete() {
        String string = String.format("<html>Do you want to delete<br><br>&nbsp;&nbsp;&nbsp;%s?<br><br><strong>Note</strong>: there is currently no undo facility.</html>", this.m_selectedBO.toTreeString(1, false, false));
        return GUIUtilities.confirm(DIALOG_DELETE, string);
    }

    @Override
    public boolean confirmDeleteScienceGoalWithGeneratedOus() {
        String string = String.format("<html>The Science Goal %s has an associated set of Scheduling Blocks in the System View.<br>Deleting the Science Goal will also delete this set.<br>Do you wish to proceed?<br><strong>Note</strong>: there is currently no undo facility.</html>", this.m_selectedBO.toTreeString(1, false, false));
        return GUIUtilities.confirm(DIALOG_DELETE, string);
    }

    @Override
    public boolean confirmDeleteGeneratedOusOrPartOfIt(boolean bl, BusinessObject businessObject, BusinessObject businessObject2) {
        String string = bl ? "part of " : "";
        String string2 = "";
        if (businessObject instanceof ObsUnitSet) {
            try {
                string2 = this.establishUnitDependencyLinksInSBsToBeDeleted((ObsUnitSet)businessObject);
            }
            catch (UnknownEntityException unknownEntityException) {
                Log.logger(Delete.class).warning("Unable to determine unit dependencies");
            }
        }
        String string3 = String.format("<html>Do you want to delete<br><br>&nbsp;&nbsp;&nbsp;%s?<br><br><strong>Note</strong>: it is %sthe ObsUnitSet generated from the Science Goal:<br><br>&nbsp;&nbsp;&nbsp;%s<br>%s</html>", this.m_selectedBO.toTreeString(1, false, false), string, businessObject2.toTreeString(1, false, false), string2);
        return GUIUtilities.confirm(DIALOG_DELETE, string3);
    }

    private String establishUnitDependencyLinksInSBsToBeDeleted(@NonNull ObsUnitSet obsUnitSet) throws UnknownEntityException {
        if (obsUnitSet == null) {
            throw new NullPointerException("ousToDelete is marked non-null but is null");
        }
        List<SchedBlock> list = obsUnitSet.findSchedBlocks();
        Optional<SchedBlock> optional = list.stream().filter(schedBlock -> schedBlock.getUnitDependencies().getDependencyListCount() > 0).findFirst();
        String string2 = "";
        if (optional.isPresent()) {
            string2 = "<br>SBs under this OUS contain dependencies on other SBs.<br>";
        }
        String string3 = "";
        for (SchedBlock schedBlock2 : ObsProject.getAllSBsInProject()) {
            List<String> list2;
            List<String> list3;
            if (list.contains(schedBlock2) || (list3 = (list2 = Arrays.asList(schedBlock2.getUnitDependencies().getDependencyList())).stream().filter(string -> list.stream().filter(schedBlock -> string.equals(schedBlock.getEntityID())).findFirst().isPresent()).toList()).isEmpty()) continue;
            string3 = "<br>SBs in other OUSes have dependencies on SBs in this OUS.";
            break;
        }
        return string2 + string3;
    }

    @Override
    public boolean confirmDeleteRepresentativeTarget() {
        String string = String.format("<html>Do you want to delete<br><br>&nbsp;&nbsp;&nbsp;%s?<br><br><strong>Note</strong>: This is the representative target of this SchedBlock.<br>Another target must be set as representative.</html>", this.m_selectedBO.toTreeString(1, false, false));
        return GUIUtilities.confirm(DIALOG_DELETE, string);
    }

    @Override
    public void deleteGuiSpecialNode() {
        if (this.m_selectedBO instanceof OusCollection) {
            this.m_parentNode.remove(this.m_selectedNode);
            this.m_usertree.refresh(this.m_parentNode);
        }
    }

    @Override
    public void updateDisplay(TreeNode treeNode) {
        if (treeNode != null) {
            ProjectTreeNode projectTreeNode = (ProjectTreeNode)treeNode;
            this.m_usertree.select(new TreePath(projectTreeNode.getPath()));
        }
    }

    private boolean setEnabledFor(boolean bl, BusinessObject businessObject) {
        boolean bl2 = false;
        DeleteChecker deleteChecker = DeleteCheckerFactory.getInstance().getChecker(businessObject);
        if (deleteChecker != null) {
            return deleteChecker.canDelete();
        }
        boolean bl3 = RoleDirectoryServiceHelper.isUserP2G();
        if (bl) {
            ScienceGoal scienceGoal;
            if (businessObject instanceof ObsUnitSetComponent) {
                return !this.m_usertree.isOusCompProtected() && bl3;
            }
            if (businessObject instanceof OusCollection) {
                return this.m_selectedNode.getChildCount() == 0 && bl3;
            }
            bl2 = businessObject instanceof AbstractScienceGoal ? (!bl3 && businessObject instanceof ScienceGoal ? !(scienceGoal = (ScienceGoal)businessObject).isPhase2ScienceGoal() : businessObject instanceof AbstractScienceGoal) : businessObject instanceof ObservingGroup;
        } else {
            bl2 = businessObject instanceof AbstractScienceGoal;
        }
        return bl2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean confirmDeleteOfSBWithUnitDependency(@NonNull BusinessObject businessObject) {
        boolean bl;
        if (businessObject == null) {
            throw new NullPointerException("objectToDelete is marked non-null but is null");
        }
        if (!(businessObject instanceof SchedBlock)) {
            return true;
        }
        SchedBlock schedBlock2 = (SchedBlock)businessObject;
        ArrayList<SchedBlock> arrayList = new ArrayList<SchedBlock>();
        List<String> list = Arrays.asList(schedBlock2.getUnitDependencies().getDependencyList());
        for (SchedBlock object2 : ObsProject.getAllSBsInProject()) {
            arrayList.addAll(list.stream().filter(string -> string.equals(object2.getEntityID())).map(string -> object2).toList());
        }
        List<SchedBlock> list2 = this.getAllSBsWithDependencyOnTargetSB(schedBlock2);
        String string2 = "";
        boolean bl2 = bl = !list2.isEmpty() || !arrayList.isEmpty();
        if (bl) {
            void var6_12;
            String string3;
            String string4 = "<html>";
            if (!arrayList.isEmpty()) {
                string3 = "<ul>" + arrayList.stream().map(schedBlock -> "<li>" + schedBlock.getName()).collect(Collectors.joining("<br>")) + "</ul>";
                String string5 = String.format("%sThis SB has dependencies to the following SB(s): %s", string4, string3);
            }
            if (!list2.isEmpty()) {
                void var6_10;
                string3 = "<ul>" + list2.stream().map(schedBlock -> "<li>" + schedBlock.getName()).collect(Collectors.joining("<br>")) + "</ul>";
                String string6 = String.format("%s<br>The following SB(s) have dependencies on this SB: <br>%s<br>", var6_10, string3);
            }
            String string7 = (String)var6_12 + "Are you sure you want to delete it?</html>";
            return GUIUtilities.confirm(DIALOG_DELETE, string7);
        }
        return true;
    }

    @Override
    public List<SchedBlock> getAllSBsWithDependencyOnTargetSB(SchedBlock schedBlock) {
        ArrayList<SchedBlock> arrayList = new ArrayList<SchedBlock>();
        for (SchedBlock schedBlock2 : ObsProject.getAllSBsInProject()) {
            if (schedBlock.equals(schedBlock2)) continue;
            List<String> list = Arrays.asList(schedBlock2.getUnitDependencies().getDependencyList());
            arrayList.addAll(list.stream().filter(string -> string.equals(object2.getEntityID())).map(string -> object2).toList());
        }
        return arrayList;
    }

    @Override
    public void userHasAuthenticated() {
        if (this.m_selectedBO == null) {
            return;
        }
        this.setEnabled(this.setEnabledFor(this.m_userview, this.m_selectedBO));
    }
}

