/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.actions;

import alma.hla.runtime.obsprep.util.UnknownEntityPartException;
import alma.obsprep.bo.obsproject.ObsProject;
import alma.obsprep.ot.actions.ActionLog;
import alma.obsprep.ot.actions.Performer;
import alma.obsprep.ot.actions.RevertProjectFromDiskInteractorInterface;
import alma.obsprep.ot.persistence.ImpexFactory;
import alma.obsprep.ot.persistence.PersistenceException;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.exolab.castor.xml.XMLException;

public class RevertProjectPerformer
extends Performer {
    public RevertProjectPerformer(RevertProjectFromDiskInteractorInterface revertProjectFromDiskInteractorInterface) {
        super(revertProjectFromDiskInteractorInterface);
    }

    @Override
    public void perform() {
        RevertProjectFromDiskInteractorInterface revertProjectFromDiskInteractorInterface = (RevertProjectFromDiskInteractorInterface)this.getGui();
        ObsProject obsProject = null;
        URL uRL = null;
        try {
            if (!ImpexFactory.getInstance().getUrlOfLastProjectFileImported().isPresent()) {
                revertProjectFromDiskInteractorInterface.error("The OT has no recently loaded files in its history");
                return;
            }
            uRL = ImpexFactory.getInstance().getUrlOfLastProjectFileImported().get();
            obsProject = ImpexFactory.getInstance().importObsProject(uRL, false);
        }
        catch (PersistenceException persistenceException) {
            revertProjectFromDiskInteractorInterface.error("Usage error: " + persistenceException.getMessage());
        }
        catch (IOException iOException) {
            revertProjectFromDiskInteractorInterface.error("I/O error: " + iOException.getMessage());
        }
        catch (XMLException xMLException) {
            revertProjectFromDiskInteractorInterface.error("XML (syntax or validity) error: " + xMLException.getMessage());
        }
        catch (UnknownEntityPartException unknownEntityPartException) {
            revertProjectFromDiskInteractorInterface.error("Data integrity error: " + unknownEntityPartException.getMessage());
        }
        if (obsProject == null) {
            return;
        }
        obsProject.getObsProgram();
        File file = null;
        String string = uRL.toExternalForm();
        if (string.startsWith("file:")) {
            file = new File(string.substring(5));
        }
        revertProjectFromDiskInteractorInterface.display(obsProject, file);
        ActionLog.performed("Reverted " + file + " from disk");
    }
}

