/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.actions;

import alma.hla.runtime.obsprep.bo.BusinessObject;
import alma.obsprep.bo.schedblock.SchedBlock;
import alma.obsprep.bo.schedblock.Target;
import alma.obsprep.guiutil.events.Event;
import alma.obsprep.guiutil.events.EventManager;
import alma.obsprep.guiutil.events.EventReceiver;
import alma.obsprep.guiutil.events.EventTypes;
import alma.obsprep.ot.actions.OTAction;
import alma.obsprep.ot.actions.SetRepresentativeInteractor;
import alma.obsprep.ot.actions.SetRepresentativePerformer;
import alma.obsprep.ot.gui.toplevel.DialogId;
import alma.obsprep.ot.project.ProjectTree;
import alma.obsprep.ot.project.ProjectTreeNode;
import alma.obsprep.services.network.roledirectory.RoleDirectoryServiceHelper;
import alma.obsprep.util.GUIUtilities;

public class SetRepresentativeTarget
extends OTAction
implements SetRepresentativeInteractor,
EventReceiver {
    private static DialogId DIALOG_CONFIRM = new DialogId("SetRepresentativeTarget.Confirm");
    private final ProjectTree m_ptree;
    private BusinessObject m_bo = null;
    private ProjectTreeNode m_treeNode = null;

    public SetRepresentativeTarget(ProjectTree projectTree) {
        this.m_ptree = projectTree;
        SetRepresentativePerformer setRepresentativePerformer = new SetRepresentativePerformer(this);
        this.setPerformer(setRepresentativePerformer);
        EventManager.subscribeByType(EventTypes.NODESELECTED, this);
        this.setEnabled(false);
    }

    @Override
    public Target getSelectedTarget() {
        return (Target)this.m_bo;
    }

    public ProjectTreeNode getSelectedNode() {
        return this.m_treeNode;
    }

    private void setEnabledFor(BusinessObject businessObject) {
        boolean bl = businessObject.getClass() == Target.class ? !this.m_ptree.isOusCompProtected() && RoleDirectoryServiceHelper.isUserP2G() : false;
        this.setEnabled(bl);
    }

    @Override
    public void receiveEvent(Event event) {
        this.m_treeNode = (ProjectTreeNode)event.getSource();
        this.m_bo = (BusinessObject)this.m_treeNode.getUserObject();
        this.setEnabledFor(this.m_bo);
    }

    @Override
    public boolean confirmSet(BusinessObject businessObject) {
        try {
            Target target = (Target)businessObject;
            SchedBlock schedBlock = target.getSchedBlock();
            Target target2 = schedBlock.getSchedulingConstraints().getRepresentativeTarget();
            if (target2 == null) {
                return true;
            }
            if (target2 == target) {
                return false;
            }
            String string = String.format("<html>Do you want to change the representative target of %s<br><br>from %s to %s ?", schedBlock.getNameOrDefault(), target2.getNameOrDefault(), target.getNameOrDefault());
            return GUIUtilities.confirm(DIALOG_CONFIRM, string);
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }
}

