/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.investigator;

import alma.hla.runtime.obsprep.util.Log;
import alma.hla.runtime.obsprep.util.UnknownEntityException;
import alma.obsprep.bo.obsproject.ObsProject;
import alma.obsprep.bo.obsproposal.Investigator;
import alma.obsprep.bo.obsproposal.ObsProposal;
import alma.obsprep.guiutil.mvc.Editor;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.guiutil.mvc.widgets.OTTextField;
import alma.obsprep.ot.boEditors.FieldIDs;
import alma.obsprep.ot.editors.investigator.InvestigatorSearchDialog;
import alma.obsprep.ot.gui.toplevel.InitServices;
import alma.obsprep.ot.gui.toplevel.ObservingToolController;
import alma.obsprep.ot.gui.toplevel.ObservingToolGui;
import alma.obsprep.ot.models.obsproject.ObsProposalModel;
import alma.obsprep.roledirectory.OTOperation;
import alma.obsprep.roledirectory.RoleDirectory;
import alma.obsprep.services.userlookup.UserLookupRemote;
import alma.obsprep.util.GUIUtilities;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import lombok.NonNull;

public class PiSummaryEditor
extends Editor {
    private final RoleDirectory roleDirectory;
    private OTTextField piSummary;
    private JButton setPiButton;

    public PiSummaryEditor(Model model, @NonNull ObservingToolController observingToolController) {
        if (observingToolController == null) {
            throw new NullPointerException("controller is marked non-null but is null");
        }
        this.setName("PiSummaryEditor");
        this.build();
        this.setModel(model, true);
        this.roleDirectory = observingToolController.getRoleDirectory();
        this.setButtons();
        observingToolController.getUserAuthenticator().addChangeListener(userAuthenticator -> SwingUtilities.invokeLater(() -> this.setButtons()));
    }

    @Override
    protected void build() {
        this.initComponents();
    }

    private ObsProposalModel getObsProposalModel() {
        return (ObsProposalModel)this.getModel();
    }

    @Override
    public void update(FieldID fieldID, Object object) {
        if (fieldID == FieldIDs.investigatorSetPiFID && object instanceof Investigator) {
            Investigator investigator = (Investigator)((Object)object);
            StringBuilder stringBuilder = new StringBuilder(investigator.getFullName());
            if (!investigator.getFullName().equals("")) {
                stringBuilder.append(" (" + investigator.getEMail() + ")");
            }
            this.piSummary.setText(stringBuilder.toString());
            this.setButtons();
        }
    }

    private void removeDuplicateInvestigators(List<Investigator> list) {
        if (list == null) {
            return;
        }
        ObsProposalModel obsProposalModel = this.getObsProposalModel();
        if (obsProposalModel == null) {
            return;
        }
        ArrayList<Investigator> arrayList = new ArrayList<Investigator>();
        arrayList.addAll(obsProposalModel.getCoInvestigators());
        arrayList.add(obsProposalModel.getPrincipalInvestigator());
        arrayList.retainAll(list);
        if (list.size() == 1 && arrayList.size() == 1) {
            GUIUtilities.info(null, "The investigator you selected is already part of your project and will not be duplicated.");
        } else if (arrayList.size() == 1) {
            GUIUtilities.info(null, arrayList.size() + " of the investigators you selected is already part of your project and will not be duplicated.");
        } else if (arrayList.size() > 1) {
            GUIUtilities.info(null, arrayList.size() + " of the investigators you selected are already part of your project and will not be duplicated.");
        }
        list.removeAll(arrayList);
    }

    private void setButtons() {
        boolean bl = false;
        boolean bl2 = true;
        if (this.getModel() != null) {
            ObsProposal obsProposal = (ObsProposal)this.getModel().getDocument();
            if (obsProposal != null) {
                try {
                    ObsProject obsProject = obsProposal.getObsProject();
                    if (obsProject != null && !ObservingToolGui.getPhase1stati().contains(obsProject.getStatus())) {
                        bl2 = false;
                    }
                }
                catch (UnknownEntityException unknownEntityException) {
                    // empty catch block
                }
            }
            try {
                bl = obsProposal.isUserCoI() || obsProposal.isUserCoPI();
            }
            catch (ObsProposal.UnableToDetermineIfUserIsCoIException | ObsProposal.UnableToDetermineIfUserIsCoPIException exception) {
                Log.logger(PiSummaryEditor.class).warning("Unable to determine if the user is a CoI");
            }
        }
        boolean bl3 = false;
        if ((!bl2 || bl) && this.roleDirectory != null) {
            try {
                bl3 = this.roleDirectory.canExecute(OTOperation.CHANGE_PI);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        boolean bl4 = bl3 || bl2 && !bl;
        ObservingToolController.getMyInstance();
        ObservingToolGui observingToolGui = ObservingToolController.getOTGui();
        if (observingToolGui != null && bl4) {
            observingToolGui.setEnabledOverride(this.setPiButton, bl4);
        }
        this.setPiButton.setEnabled(bl4);
        this.setPiButton.setToolTipText(this.setPiButton.isEnabled() ? "Click to assign a PI" : "Cannot change the PI of a submitted project");
    }

    private void initComponents() {
        this.piSummary = new OTTextField();
        this.piSummary.setName("PiSummaryEditor.piSummary");
        this.setPiButton = new JButton();
        this.setPiButton.setName("PiSummaryEditor.setPiButton");
        this.piSummary.setEditable(false);
        this.piSummary.setToolTipText("The name of the principal investigator for this project");
        this.setPiButton.setText("Select PI...");
        this.setPiButton.setToolTipText("Click to assign a PI");
        this.setPiButton.addActionListener(actionEvent -> this.setPiButtonActionPerformed());
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addContainerGap().addComponent(this.piSummary, -1, 329, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.setPiButton).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.piSummary, -2, -1, -2).addComponent(this.setPiButton)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void setPiButtonActionPerformed() {
        List<Investigator> list = InvestigatorSearchDialog.showDialog(true, "Select PI");
        this.removeDuplicateInvestigators(list);
        if (list.size() > 0) {
            this.getController().widgetUpdated(this, FieldIDs.investigatorSetPiFID, (Object)list.get(0));
        }
    }

    public static void main(String[] stringArray) throws MalformedURLException {
        InitServices.initModelSupportClasses();
        ObservingToolController observingToolController = new ObservingToolController();
        UserLookupRemote userLookupRemote = new UserLookupRemote();
        userLookupRemote.setUrl("http://192.168.56.101:8180");
        observingToolController.heap.setUserLookup(userLookupRemote);
        ObsProposal obsProposal = ObsProposal.createObsProposal();
        ObsProposalModel obsProposalModel = new ObsProposalModel(obsProposal);
        PiSummaryEditor piSummaryEditor = new PiSummaryEditor((Model)obsProposalModel, observingToolController);
        JFrame jFrame = new JFrame("PI Summary Editor");
        jFrame.setDefaultCloseOperation(3);
        jFrame.getContentPane().add(piSummaryEditor);
        jFrame.pack();
        jFrame.setVisible(true);
        observingToolController.heap.getNetworkServiceHandler().goOnline();
    }

    @Override
    public String toString() {
        return "PiSummaryEditor(roleDirectory=" + this.roleDirectory + ", piSummary=" + this.piSummary + ", setPiButton=" + this.setPiButton + ")";
    }
}

