/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.obsproject;

import alma.hla.runtime.obsprep.util.Log;
import alma.hla.runtime.obsprep.util.UnknownEntityException;
import alma.obsprep.bo.enumerations.Telescope;
import alma.obsprep.bo.obsproject.CalibrationSetupParameters;
import alma.obsprep.bo.obsproject.CalibrationTargetParameters;
import alma.obsprep.bo.obsproject.IQuerySource;
import alma.obsprep.bo.obsproject.QuerySourceAdapter;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproposal.ObsProposal;
import alma.obsprep.guiutil.ScrollWhenFocusedPane;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.guiutil.mvc.ModelChangeSubscriber;
import alma.obsprep.guiutil.mvc.widgets.OTButtonGroup;
import alma.obsprep.ot.boEditors.EditorWithGridBagLayout;
import alma.obsprep.ot.editors.obsproject.CalibrationSetupParametersQuerySourceEditorDialog;
import alma.obsprep.ot.editors.obsproject.CalibrationSetupParametersTableModel;
import alma.obsprep.ot.editors.obsproject.CalibrationTargetParametersDialog;
import alma.obsprep.ot.editors.obsproject.CalibratorTableElement;
import alma.obsprep.ot.editors.obsproject.NewCalibratorDialog;
import alma.obsprep.ot.editors.obsproject.ObservatoryGoalTargetsEditor;
import alma.obsprep.ot.editors.valuetypes.AstrometryModeEnum;
import alma.obsprep.ot.gui.toplevel.InitServices;
import alma.obsprep.ot.gui.toplevel.ObservingToolController;
import alma.obsprep.ot.models.obsproject.CalibratedGoalModel;
import alma.obsprep.ot.models.obsproject.CalibrationSetupParametersModel;
import alma.obsprep.services.experts.VLBIExpert;
import alma.obsprep.services.experts.calibrators.CalibratorExpertModel;
import alma.obsprep.services.generator.refactored.DGCExpert;
import alma.obsprep.services.network.roledirectory.RoleDirectoryServiceHelper;
import alma.obsprep.services.sfi.ScienceGoalEditorViewEnum;
import alma.obsprep.services.sfi.SingleFieldScienceGoalModel;
import com.google.common.collect.Streams;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import javax.help.CSH;
import javax.swing.AbstractButton;
import javax.swing.AbstractCellEditor;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import lombok.NonNull;

public class CalibrationSetupParametersEditor
extends EditorWithGridBagLayout
implements ListSelectionListener,
ModelChangeSubscriber {
    private static final String EDIT_CALIBRATOR_QUERY_BUTTON_TEXT = "Edit";
    private static final String EDIT_FIXED_CALIBRATOR_BUTTON_TEXT = "Edit";
    public static final FieldID SYSTEM_CALIBRATORS_STANDARD = new FieldID("CalibratorSetupParametersEditor system calibrator query FID");
    public static final FieldID SYSTEM_CALIBRATORS_AMPLITUDE = new FieldID("CalibratorSetupParametersEditor system calibrator amplitude query FID");
    public static final FieldID MANUAL_CALIBRATORS = new FieldID("CalibratorSetupParametersEditor manual calibrator query FID");
    public static final FieldID EDIT_CALIBRATOR_QUERY = new FieldID("CalibratorSetupParametersEditor edit calibrator query FID");
    public static final FieldID ADD_CALIBRATOR_QUERY = new FieldID("CalibratorSetupParametersEditor add calibrator FID");
    public static final FieldID ADD_FIXED_CALIBRATOR = new FieldID("CalibratorSetupParametersEditor add fixed calibrator FID");
    public static final FieldID DELETE_CALIBRATOR_QUERY = new FieldID("CalibratorSetupParametersEditor delete calibrator FID");
    public static final FieldID DELETE_ALL_CALIBRATORS = new FieldID("CalibratorSetupParametersEditor delete all calibrators FID");
    public static final FieldID FORCE_DGC = new FieldID("CalibratorSetupParametersEditor force DGC FID");
    public static final FieldID FORCE_DGC_LABEL = new FieldID("CalibratorSetupParametersEditor.forceDGCLabel.FID");
    public static final FieldID DGC_USER_SELECTABLE = new FieldID("CalibrationSetupParametersEditor.dgcUserSelectable");
    public static final FieldID DGC_OVERRIDE_SELECTOR = new FieldID("CalibrationSetupParametersEditor.dgcOverride");
    public static final FieldID DGC_STRATEGY = new FieldID("CalibrationSetupParametersEditor.dgcOverride");
    public static final FieldID ASTROMETRY_MODE_FID = new FieldID("CalibrationSetupParametersEditor.astrometryMode");
    public static final FieldID FORCE_DGC_AVAILABLE = new FieldID("CalibrationSetupParametersEditor.forceDGCModeForEOC");
    private JLabel userHelpLabel;
    private JPanel calibratorsPanel;
    private JButton addDynamicCalibratorButton;
    private JButton addFixedCalibratorButton;
    private JButton deleteCalibratorButton;
    private JTable calibratorTable;
    private JRadioButton systemCalibratorsStandardButton;
    private JRadioButton userCalibratorsButton;
    private ButtonGroup calibrationTypeButtonGroup;
    private JScrollPane scrollPane;
    private JPanel spacer;
    private final CalibrationSetupParametersTableModel calibrationSetupParametersTableModel = new CalibrationSetupParametersTableModel();
    private final CalibratorExpertModel calibratorExpertModel;
    private final CalibrationSetupParametersModel calibratorsSetupParametersModel;
    private JRadioButton systemCalibratorsModifiedAmplitudeStrategyButton;
    private JPanel overrideDGCPanel;
    private JLabel dgcOverrideLabel;
    private JComponent astrometryPanel;
    private JButton deleteAllCalibratorButton;

    public CalibrationSetupParametersEditor(CalibratedGoalModel calibratedGoalModel) {
        this.setName("CalibratorSetupParametersEditor");
        this.calibratorsSetupParametersModel = calibratedGoalModel.getCalibrationSetupParametersModel();
        this.setModel(this.calibratorsSetupParametersModel);
        this.calibratorExpertModel = this.calibratorsSetupParametersModel.getCalibratorExpertModel();
        this.initCalibratorsPanel();
        this.initAstrometryPanel();
        this.initDGCOverridePanel();
        this.build();
        this.calibratorsSetupParametersModel.publish();
    }

    private void initAstrometryPanel() {
        this.astrometryPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(8, 12, 0, 12);
        this.astrometryPanel.setLayout(gridBagLayout);
        JLabel jLabel = new JLabel("If you wish positional accuracy that is better than that provided by default (see the Proposer's Guide for more information) then select enhanced accuracy.");
        this.astrometryPanel.add((Component)jLabel, gridBagConstraints);
        ++gridBagConstraints.gridy;
        OTButtonGroup oTButtonGroup = new OTButtonGroup((Enum[])AstrometryModeEnum.values(), 1, new String[]{AstrometryModeEnum.Standard.getUILabel(), AstrometryModeEnum.Enhanced.getUILabel()});
        this.initEvents(oTButtonGroup, ASTROMETRY_MODE_FID);
        oTButtonGroup.setName("CSP.astrometryEditor");
        oTButtonGroup.setButtonName(AstrometryModeEnum.Standard.getBOMapping(), "CSP.standardButton");
        oTButtonGroup.setButtonName(AstrometryModeEnum.Enhanced.getBOMapping(), "CSP.enhancedButton");
        this.astrometryPanel.add((Component)oTButtonGroup, gridBagConstraints);
    }

    private void initDGCOverridePanel() {
        this.overrideDGCPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.overrideDGCPanel.setLayout(gridBagLayout);
        JLabel jLabel = new JLabel("DGC Override");
        JCheckBox jCheckBox = new JCheckBox();
        this.initEvents(jCheckBox, DGC_OVERRIDE_SELECTOR);
        this.set(jCheckBox, false);
        JLabel jLabel2 = this.makeLabel(FORCE_DGC_LABEL, "Force DGC ", null);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        this.overrideDGCPanel.add((Component)jLabel2, gridBagConstraints);
        List<String> list = Stream.of(CalibrationSetupParameters.getKnownForcedDGCStrategyList()).filter(string -> !string.equals(CalibrationSetupParameters.FORCEDDGCSTRATEGY_BWSWB2B)).toList();
        JComboBox jComboBox = this.makeComboBox(FORCE_DGC, list.toArray(new String[list.size()]), "Permits the user to force DGC B2B or BWSW");
        this.set2(jComboBox, (Object)CalibrationSetupParameters.FORCEDDGCSTRATEGY_NONE);
        ++gridBagConstraints.gridx;
        this.overrideDGCPanel.add((Component)jComboBox, gridBagConstraints);
        boolean bl = Telescope.isOTConfiguredAs(Telescope.CSVALMA);
        jLabel2.setVisible(bl);
        jComboBox.setVisible(bl);
        this.dgcOverrideLabel = new JLabel("User has overridden the OT and turned DGC observing ([BWSW|B2B]) off.");
        this.dgcOverrideLabel.setVisible(true);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.fill = 0;
        this.overrideDGCPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        ++gridBagConstraints.gridx;
        this.overrideDGCPanel.add((Component)jCheckBox, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets = new Insets(20, 0, 0, 0);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 2;
        this.overrideDGCPanel.add((Component)this.dgcOverrideLabel, gridBagConstraints);
    }

    @Override
    public void update(@NonNull FieldID fieldID, Object object) {
        EnumSet enumSet;
        Object object2;
        boolean bl;
        Object object3;
        if (fieldID == null) {
            throw new NullPointerException("fid is marked non-null but is null");
        }
        if (fieldID == SingleFieldScienceGoalModel.EDITOR_SUBVIEW_FID) {
            object3 = (ScienceGoalEditorViewEnum)((Object)object);
            Log.logger(this.getClass()).fine("Instructed to display view : " + (ScienceGoalEditorViewEnum)((Object)object3));
            this.configureEditorForView((ScienceGoalEditorViewEnum)((Object)object3));
        }
        object3 = this.getComponent(DGC_OVERRIDE_SELECTOR);
        if (fieldID.equals(DGC_OVERRIDE_SELECTOR)) {
            bl = (Boolean)object;
            this.dgcOverrideLabel.setVisible(bl);
            object2 = (JCheckBox)object3;
            ((AbstractButton)object2).setSelected(bl);
            this.setUserForceDGCSelection(bl);
        }
        if (fieldID.equals(DGC_USER_SELECTABLE)) {
            bl = (Boolean)object;
            boolean bl2 = RoleDirectoryServiceHelper.isUserP2G();
            if (object3 != null) {
                ((JComponent)object3).setEnabled(bl && bl2);
            }
        }
        if (fieldID.equals(DGC_STRATEGY) && object instanceof EnumSet && !(enumSet = (EnumSet)object).isEmpty()) {
            object2 = null;
            if (enumSet.contains((Object)DGCExpert.DGCTypeEnum.DGCBandToBand)) {
                object2 = DGCExpert.DGCTypeEnum.DGCBandToBand;
            } else if (enumSet.contains((Object)DGCExpert.DGCTypeEnum.DGCBandwidthSwitching)) {
                object2 = DGCExpert.DGCTypeEnum.DGCBandwidthSwitching;
            } else {
                Log.logger(CalibrationSetupParametersEditor.class).warning("Unknown DGC strategy detected " + enumSet);
                return;
            }
            this.dgcOverrideLabel.setText("User has overridden the OT and turned DGC observing " + ((DGCExpert.DGCTypeEnum)((Object)object2)).getLabel() + " off.");
        }
        if (fieldID.equals(FORCE_DGC_AVAILABLE) && object instanceof Boolean) {
            JComponent jComponent = this.getComponent(FORCE_DGC_LABEL);
            object2 = this.getComponent(FORCE_DGC);
            Boolean bl3 = (Boolean)object;
            ((JComponent)object2).setVisible(bl3);
            jComponent.setVisible(bl3);
            jComponent.setEnabled(bl3);
            ((JComponent)object2).setEnabled(bl3);
        }
        if (fieldID.equals(ASTROMETRY_MODE_FID) && object != null) {
            OTButtonGroup oTButtonGroup = (OTButtonGroup)this.getComponent(ASTROMETRY_MODE_FID);
            oTButtonGroup.setSelectedItem(AstrometryModeEnum.valueOf((String)object).getUILabel());
        }
    }

    private void setUserForceDGCSelection(boolean bl) {
        JComboBox jComboBox = (JComboBox)this.getComponent(FORCE_DGC);
        JComponent jComponent = this.getComponent(FORCE_DGC_LABEL);
        if (bl) {
            this.set2(jComboBox, (Object)CalibrationSetupParameters.FORCEDDGCSTRATEGY_NONE);
        }
        boolean bl2 = RoleDirectoryServiceHelper.isUserP2G() && !bl;
        jComponent.setEnabled(bl2);
        jComboBox.setEnabled(bl2);
    }

    @Override
    protected void addComponents(String string) {
        this.initCalibratorsPanel();
        this.initQueryColumn(this.calibratorTable, this.calibratorTable.getColumnModel().getColumn(6));
    }

    @Override
    protected void build() {
        super.build("CalibrationSetupParametersEditor");
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        JComponent jComponent = this.addNonCollapsingGroup(0, this, gridBagLayout, gridBagConstraints, this.calibratorsPanel, "Goal Calibrators");
        CSH.setHelpIDString((Component)jComponent, (String)"TOC-Phase 1 and Phase 2 Science Goals-Calibration Setup-Goal Calibrators");
        JComponent jComponent2 = this.addNonCollapsingGroup(0, this, gridBagLayout, gridBagConstraints, this.astrometryPanel, "Astrometry");
        CSH.setHelpIDString((Component)jComponent2, (String)"TOC-Phase 1 and Phase 2 Science Goals-Calibration Setup-Astrometry");
        gridBagConstraints.fill = 1;
        JPanel jPanel = this.addGroup(0, this, gridBagLayout, gridBagConstraints, this.overrideDGCPanel, "DGC Override (observatory-use only)", true);
        CSH.setHelpIDString((Component)jPanel, (String)"TOC-Phase 1 and Phase 2 Science Goals-Calibration Setup-DGC Override");
        this.calibratorTable.getSelectionModel().addListSelectionListener(this);
    }

    @Override
    public void modelChanged(Model model, FieldID fieldID, Object object) {
        if (CalibrationSetupParametersModel.CALIBRATOR_TABLE_ELEMENTS.equals(fieldID) && object != null) {
            if (object instanceof List) {
                List list = (List)object;
                this.calibrationSetupParametersTableModel.setCalibrators(list);
                this.setRemoveCalibratorButtonState();
                this.packRows(this.calibratorTable, 0);
                return;
            }
            throw new IllegalArgumentException("Non-List published for calibrator table elements");
        }
        if (SYSTEM_CALIBRATORS_STANDARD.equals(fieldID)) {
            this.systemCalibratorsStandardButton.setSelected(true);
            this.setQueryButtonsVisibility(false);
        } else if (SYSTEM_CALIBRATORS_AMPLITUDE.equals(fieldID)) {
            this.systemCalibratorsModifiedAmplitudeStrategyButton.setSelected(true);
            this.setQueryButtonsVisibility(false);
        } else if (MANUAL_CALIBRATORS.equals(fieldID)) {
            this.userCalibratorsButton.setSelected(true);
            this.setQueryButtonsVisibility(true);
        } else {
            if (ADD_FIXED_CALIBRATOR.equals(fieldID) || ADD_CALIBRATOR_QUERY.equals(fieldID)) {
                if (object != null) {
                    this.getController().widgetUpdated(this, EDIT_CALIBRATOR_QUERY, object);
                }
                return;
            }
            if (FORCE_DGC.equals(fieldID) && object instanceof String) {
                this.set2((JComboBox)this.getComponent(FORCE_DGC), (Object)((String)object));
            } else if (fieldID.equals(SingleFieldScienceGoalModel.EDITOR_SUBVIEW_FID)) {
                this.configureEditorForView((ScienceGoalEditorViewEnum)((Object)object));
            }
        }
        super.modelChanged(model, fieldID, object);
    }

    private void setQueryButtonsVisibility(boolean bl) {
        this.scrollPane.setVisible(bl);
        this.userHelpLabel.setVisible(bl);
        this.addDynamicCalibratorButton.setVisible(bl);
        this.addFixedCalibratorButton.setVisible(bl);
        this.deleteCalibratorButton.setVisible(bl);
        this.deleteAllCalibratorButton.setVisible(bl);
        this.spacer.setVisible(!bl);
    }

    @Override
    protected void configureEditorForView(ScienceGoalEditorViewEnum scienceGoalEditorViewEnum) {
        ObsProposal obsProposal;
        CalibrationSetupParameters calibrationSetupParameters = (CalibrationSetupParameters)((Object)this.getModel().getDocument());
        if (calibrationSetupParameters == null) {
            return;
        }
        ScienceGoal scienceGoal = (ScienceGoal)calibrationSetupParameters.getParent();
        if (scienceGoal == null) {
            return;
        }
        boolean bl = VLBIExpert.isPassivePhasingEnabled(scienceGoal);
        boolean bl2 = scienceGoalEditorViewEnum != ScienceGoalEditorViewEnum.VLBI || !bl;
        Streams.stream(this.calibrationTypeButtonGroup.getElements().asIterator()).forEach(abstractButton -> abstractButton.setEnabled(bl2));
        try {
            obsProposal = ObservingToolController.getOTGui().getPrimaryProject().getObsProposal();
        }
        catch (UnknownEntityException unknownEntityException) {
            Log.logger(CalibrationSetupParametersEditor.class).warning("Unable to locate obsproposal");
            return;
        }
        boolean bl3 = false;
        try {
            bl3 = scienceGoal.isSolarScienceGoal();
        }
        catch (UnknownEntityException unknownEntityException) {
            Log.logger(CalibrationSetupParametersEditor.class).warning("Unable to determine if SG is solar : " + unknownEntityException.getMessage());
        }
        boolean bl4 = !scienceGoalEditorViewEnum.equals((Object)ScienceGoalEditorViewEnum.VLBI) && !obsProposal.isLargeProgram() && !scienceGoal.isStandAloneACA() && !bl3;
        this.getComponent(ASTROMETRY_MODE_FID).setEnabled(bl4);
    }

    private void initCalibratorsPanel() {
        this.calibratorsPanel = new JPanel();
        JPanel jPanel = new JPanel();
        this.addDynamicCalibratorButton = this.makeButton(ADD_CALIBRATOR_QUERY, "Add Query", "Add search criteria for calibrator selection at execution time");
        this.addFixedCalibratorButton = this.makeButton(ADD_FIXED_CALIBRATOR, "Add Fixed Calibrator", "Choose a specific source to be used for calibration");
        this.deleteCalibratorButton = this.makeButton(DELETE_CALIBRATOR_QUERY, "Delete", "Delete the selected calibrator");
        this.deleteAllCalibratorButton = this.makeButton(DELETE_ALL_CALIBRATORS, "Delete All", "Delete all calibrators");
        JLabel jLabel = new JLabel();
        this.userHelpLabel = new JLabel();
        this.calibratorTable = new JTable();
        this.calibratorTable.getTableHeader().setReorderingAllowed(false);
        this.calibratorTable.setRowSelectionAllowed(true);
        this.calibrationTypeButtonGroup = new ButtonGroup();
        this.systemCalibratorsStandardButton = new JRadioButton();
        this.systemCalibratorsModifiedAmplitudeStrategyButton = new JRadioButton();
        this.userCalibratorsButton = new JRadioButton();
        this.scrollPane = new ScrollWhenFocusedPane();
        this.spacer = new JPanel();
        this.initEvents(this.systemCalibratorsStandardButton, SYSTEM_CALIBRATORS_STANDARD);
        this.initEvents(this.systemCalibratorsModifiedAmplitudeStrategyButton, SYSTEM_CALIBRATORS_AMPLITUDE);
        this.initEvents(this.userCalibratorsButton, MANUAL_CALIBRATORS);
        this.calibratorTable.setModel(this.calibrationSetupParametersTableModel);
        this.calibratorTable.setSelectionMode(2);
        this.scrollPane.setViewportView(this.calibratorTable);
        this.calibratorsPanel.setLayout(new GridBagLayout());
        jLabel.setFont(jLabel.getFont().deriveFont(jLabel.getFont().getStyle() & 0xFFFFFFFE));
        jLabel.setText("<html>By default, calibrators will be selected automatically at runtime and a single observation will be used to calibrate the bandpass and flux scale.</html>");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 12, 0, 12);
        this.calibratorsPanel.add((Component)jLabel, gridBagConstraints);
        this.calibrationTypeButtonGroup.add(this.systemCalibratorsStandardButton);
        this.systemCalibratorsStandardButton.setText("System-defined calibration (recommended)");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(8, 12, 0, 12);
        this.calibratorsPanel.add((Component)this.systemCalibratorsStandardButton, gridBagConstraints);
        this.calibrationTypeButtonGroup.add(this.systemCalibratorsModifiedAmplitudeStrategyButton);
        this.systemCalibratorsModifiedAmplitudeStrategyButton.setText("System-defined calibration (force separate amplitude calibration using solar-system object)");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(8, 12, 0, 12);
        this.calibratorsPanel.add((Component)this.systemCalibratorsModifiedAmplitudeStrategyButton, gridBagConstraints);
        this.calibrationTypeButtonGroup.add(this.userCalibratorsButton);
        this.userCalibratorsButton.setText("User-defined calibration");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(8, 12, 0, 12);
        this.calibratorsPanel.add((Component)this.userCalibratorsButton, gridBagConstraints);
        this.userHelpLabel.setFont(this.userHelpLabel.getFont().deriveFont(this.userHelpLabel.getFont().getStyle() & 0xFFFFFFFE));
        this.userHelpLabel.setText("<html><ul><li>When first selected, the table shows the default set of calibrators</li><li><i>Queries</i> select a source from the ALMA Calibrator Catalogue at SB execution time</li><li><i>Fixed Calibrators</i> are specific sources selected now</li></i></li></ul></html>");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 12, 0, 12);
        this.calibratorsPanel.add((Component)this.userHelpLabel, gridBagConstraints);
        GroupLayout groupLayout = new GroupLayout(jPanel);
        jPanel.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(this.addDynamicCalibratorButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.addFixedCalibratorButton).addGap(18, 18, 18).addComponent(this.deleteCalibratorButton).addGap(18, 18, 18).addComponent(this.deleteAllCalibratorButton)));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.addDynamicCalibratorButton).addComponent(this.addFixedCalibratorButton).addComponent(this.deleteCalibratorButton).addComponent(this.deleteAllCalibratorButton)));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.insets = new Insets(12, 12, 12, 12);
        this.calibratorsPanel.add((Component)jPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(12, 12, 12, 12);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.calibratorsPanel.add((Component)this.scrollPane, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.calibratorsPanel.add((Component)this.spacer, gridBagConstraints);
        this.addDynamicCalibratorButton.setName("CalibrationSetupParametersEditor.addDynamicCalibratorButton");
        this.addFixedCalibratorButton.setName("CalibrationSetupParametersEditor.addFixedCalibratorButton");
        jPanel.setName("CalibrationSetupParametersEditor.buttonPanel");
        this.calibratorsPanel.setName("CalibrationSetupParametersEditor.calibratorsPanel");
        jLabel.setName("CalibrationSetupParametersEditor.helpLabel");
        this.deleteCalibratorButton.setName("CalibrationSetupParametersEditor.removeCalibratorButton");
        this.scrollPane.setName("CalibrationSetupParametersEditor.scrollPane");
        this.spacer.setName("CalibrationSetupParametersEditor.spacer");
        this.systemCalibratorsStandardButton.setName("CalibrationSetupParametersEditor.systemCalibratorsButton");
        this.calibratorTable.setName("CalibrationSetupParametersEditor.table");
        this.userCalibratorsButton.setName("CalibrationSetupParametersEditor.userCalibratorsButton");
        this.userHelpLabel.setName("CalibrationSetupParametersEditor.userHelpLabel");
    }

    @Override
    public Object widgetUpdated(FieldID fieldID, Object object) {
        if (ADD_CALIBRATOR_QUERY.equals(fieldID) || ADD_FIXED_CALIBRATOR.equals(fieldID)) {
            NewCalibratorDialog newCalibratorDialog = new NewCalibratorDialog(null, this.getModel().getParentModel().getDocument());
            newCalibratorDialog.setVisible(true);
            return newCalibratorDialog.getCalibrationSelected();
        }
        if (DELETE_CALIBRATOR_QUERY.equals(fieldID)) {
            int[] nArray = this.calibratorTable.getSelectedRows();
            ArrayList<Object> arrayList = new ArrayList<Object>();
            for (int n : nArray) {
                arrayList.add(this.calibrationSetupParametersTableModel.getValueAt(n, 6));
            }
            return arrayList;
        }
        if (EDIT_CALIBRATOR_QUERY.equals(fieldID)) {
            if (object instanceof IQuerySource) {
                IQuerySource iQuerySource = (IQuerySource)object;
                IQuerySource iQuerySource2 = iQuerySource.deepCopy();
                CalibrationSetupParameters calibrationSetupParameters = (CalibrationSetupParameters)((Object)this.getModel().getDocument());
                if (calibrationSetupParameters == null) {
                    return object;
                }
                QuerySourceAdapter querySourceAdapter = new QuerySourceAdapter(iQuerySource);
                this.calibratorExpertModel.setDocument(querySourceAdapter);
                ScienceGoal scienceGoal = (ScienceGoal)calibrationSetupParameters.getParent();
                CalibrationSetupParametersQuerySourceEditorDialog calibrationSetupParametersQuerySourceEditorDialog = new CalibrationSetupParametersQuerySourceEditorDialog(this.calibratorExpertModel, null, true, VLBIExpert.isPassivePhasingEnabled(scienceGoal));
                String string = iQuerySource.getIntendedUse();
                calibrationSetupParametersQuerySourceEditorDialog.setTitle(string + " Calibrator Query Editor");
                CalibrationSetupParametersEditor.resizeDialog(calibrationSetupParametersQuerySourceEditorDialog);
                calibrationSetupParametersQuerySourceEditorDialog.setVisible(true);
                if (calibrationSetupParametersQuerySourceEditorDialog.isCancelled()) {
                    CalibrationSetupParametersEditor.copyIQuerySource(iQuerySource2, iQuerySource);
                    this.calibratorsSetupParametersModel.removeMostRecentlyAddedCalibrator();
                } else {
                    this.calibratorsSetupParametersModel.retainCalibratorSelection();
                }
                return iQuerySource;
            }
            if (object instanceof CalibrationTargetParameters) {
                CalibrationTargetParameters calibrationTargetParameters = (CalibrationTargetParameters)object;
                CalibrationTargetParametersDialog calibrationTargetParametersDialog = CalibrationTargetParametersDialog.getInstance();
                calibrationTargetParametersDialog.setDocument(calibrationTargetParameters);
                CalibrationSetupParameters calibrationSetupParameters = (CalibrationSetupParameters)((Object)this.getModel().getDocument());
                if (calibrationSetupParameters == null) {
                    return object;
                }
                ScienceGoal scienceGoal = (ScienceGoal)calibrationSetupParameters.getParent();
                calibrationTargetParameters.setScienceGoal(scienceGoal);
                String string = calibrationTargetParameters.getIntendedUse();
                calibrationTargetParametersDialog.setTitle(string + " Calibration Source Editor");
                CalibrationSetupParametersEditor.resizeDialog(calibrationTargetParametersDialog);
                calibrationTargetParametersDialog.setVisible(true);
                if (calibrationTargetParametersDialog.isCancelled()) {
                    this.calibratorsSetupParametersModel.removeMostRecentlyAddedCalibrator();
                } else {
                    this.calibratorsSetupParametersModel.retainCalibratorSelection();
                }
                return calibrationTargetParameters;
            }
            throw new IllegalArgumentException("Non-string published as edit intent");
        }
        return object;
    }

    private static void copyIQuerySource(IQuerySource iQuerySource, IQuerySource iQuerySource2) {
        if (iQuerySource == null) {
            return;
        }
        iQuerySource2.setIntendedUse(iQuerySource.getIntendedUse());
        iQuerySource2.setMaxFlux(iQuerySource.getMaxFlux().deepCopy());
        iQuerySource2.setMaxFrequency(iQuerySource.getMaxFrequency().deepCopy());
        iQuerySource2.setMaxSources(iQuerySource.getMaxSources());
        iQuerySource2.setMaxTimeSinceObserved(iQuerySource.getMaxTimeSinceObserved().deepCopy());
        iQuerySource2.setMinFlux(iQuerySource.getMinFlux().deepCopy());
        iQuerySource2.setMinFrequency(iQuerySource.getMinFrequency().deepCopy());
        iQuerySource2.setMinTimeSinceObserved(iQuerySource.getMinTimeSinceObserved().deepCopy());
        iQuerySource2.setQueryCenter(iQuerySource.getQueryCenter().deepCopy());
        iQuerySource2.setSearchRadius(iQuerySource.getSearchRadius().deepCopy());
        iQuerySource2.setUse(iQuerySource.getUse());
    }

    private int getPreferredRowHeight(@NonNull JTable jTable, int n, int n2) {
        if (jTable == null) {
            throw new NullPointerException("table is marked non-null but is null");
        }
        int n3 = jTable.getRowHeight();
        for (int i = 0; i < jTable.getColumnCount(); ++i) {
            TableCellRenderer tableCellRenderer = jTable.getCellRenderer(n, i);
            Component component = jTable.prepareRenderer(tableCellRenderer, n, i);
            int n4 = component.getPreferredSize().height + 2 * n2;
            n3 = Math.max(n3, n4);
        }
        return n3;
    }

    private void packRows(@NonNull JTable jTable, int n) {
        if (jTable == null) {
            throw new NullPointerException("table is marked non-null but is null");
        }
        this.packRows(jTable, jTable.getRowCount(), n);
    }

    private void packRows(@NonNull JTable jTable, int n, int n2) {
        if (jTable == null) {
            throw new NullPointerException("table is marked non-null but is null");
        }
        for (int i = 0; i < jTable.getRowCount(); ++i) {
            int n3 = this.getPreferredRowHeight(jTable, i, n2);
            if (jTable.getRowHeight(i) == n3) continue;
            jTable.setRowHeight(i, n3);
        }
    }

    private void resizeColumn(@NonNull JTable jTable, @NonNull TableColumn tableColumn, @NonNull TableCellRenderer tableCellRenderer, int n) {
        if (jTable == null) {
            throw new NullPointerException("table is marked non-null but is null");
        }
        if (tableColumn == null) {
            throw new NullPointerException("column is marked non-null but is null");
        }
        if (tableCellRenderer == null) {
            throw new NullPointerException("renderer is marked non-null but is null");
        }
        Component component = tableCellRenderer.getTableCellRendererComponent(jTable, tableColumn.getHeaderValue(), false, false, 0, n);
        int n2 = component.getPreferredSize().width;
        for (int i = 0; i < jTable.getRowCount(); ++i) {
            TableCellRenderer tableCellRenderer2 = jTable.getCellRenderer(i, n);
            component = tableCellRenderer2.getTableCellRendererComponent(jTable, jTable.getValueAt(i, n), false, false, i, n);
            n2 = Math.max(n2, component.getPreferredSize().width);
        }
        tableColumn.setPreferredWidth(n2);
    }

    private void initQueryColumn(@NonNull JTable jTable, @NonNull TableColumn tableColumn) {
        if (jTable == null) {
            throw new NullPointerException("table is marked non-null but is null");
        }
        if (tableColumn == null) {
            throw new NullPointerException("column is marked non-null but is null");
        }
        ButtonCellRenderer buttonCellRenderer = new ButtonCellRenderer();
        tableColumn.setCellRenderer(buttonCellRenderer);
        this.resizeColumn(jTable, tableColumn, buttonCellRenderer, 2);
        ButtonCellEditor buttonCellEditor = new ButtonCellEditor();
        tableColumn.setCellEditor(buttonCellEditor);
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.setRemoveCalibratorButtonState();
    }

    private void setRemoveCalibratorButtonState() {
        boolean bl = this.calibratorTable.getSelectedRows().length >= 1;
        this.deleteCalibratorButton.setEnabled(bl && this.calibratorTable.isEnabled());
    }

    public static void main(String[] stringArray) {
        InitServices.initModelSupportClasses();
        ScienceGoal scienceGoal = ScienceGoal.createScienceGoal();
        SingleFieldScienceGoalModel singleFieldScienceGoalModel = new SingleFieldScienceGoalModel(scienceGoal);
        EventQueue.invokeLater(() -> {
            try {
                UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException exception) {
                Logger.getLogger(ObservatoryGoalTargetsEditor.class.getName()).log(Level.SEVERE, null, exception);
            }
            CalibrationSetupParametersEditor calibrationSetupParametersEditor = new CalibrationSetupParametersEditor(singleFieldScienceGoalModel);
            singleFieldScienceGoalModel.setDocument(scienceGoal);
            JFrame jFrame = new JFrame("ObservatoryGoalTargetsEditor");
            jFrame.setDefaultCloseOperation(3);
            jFrame.getContentPane().add(calibrationSetupParametersEditor);
            jFrame.pack();
            jFrame.setVisible(true);
        });
    }

    class ButtonCellRenderer
    implements TableCellRenderer {
        private JButton editQueryButton = new JButton("Edit");
        private JButton editTargetButton = new JButton("Edit");

        public ButtonCellRenderer() {
            this.editQueryButton.setToolTipText("Edit the search criteria to be used at execution time for calibrator selection");
            this.editTargetButton.setToolTipText("Edit the parameters for your specified calibration source");
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            CalibratorTableElement calibratorTableElement = CalibrationSetupParametersEditor.this.calibrationSetupParametersTableModel.get(n);
            if (calibratorTableElement == null) {
                return this.editQueryButton;
            }
            if (calibratorTableElement.getQuerySource() != null) {
                return this.editQueryButton;
            }
            return this.editTargetButton;
        }
    }

    class ButtonCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private final JButton button = new JButton("Edit");

        ButtonCellEditor() {
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            CalibratorTableElement calibratorTableElement = CalibrationSetupParametersEditor.this.calibrationSetupParametersTableModel.get(n);
            if (calibratorTableElement.getQuerySource() != null) {
                CalibrationSetupParametersEditor.this.getController().widgetUpdated(CalibrationSetupParametersEditor.this, EDIT_CALIBRATOR_QUERY, calibratorTableElement.getQuerySource());
            } else {
                CalibrationSetupParametersEditor.this.getController().widgetUpdated(CalibrationSetupParametersEditor.this, EDIT_CALIBRATOR_QUERY, calibratorTableElement.getCalibrationTargetParameters());
            }
            SwingUtilities.invokeLater(() -> this.stopCellEditing());
            return this.button;
        }

        @Override
        public Object getCellEditorValue() {
            return this.button.getText();
        }
    }

    abstract class ComboBoxCellRenderer
    implements TableCellRenderer {
        protected final JComboBox comboBox = new JComboBox();

        ComboBoxCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.comboBox.setSelectedItem(object);
            return this.comboBox;
        }
    }
}

