/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.obsproject;

import alma.obsprep.bo.obsproject.QuerySource;
import alma.obsprep.bo.obsproject.QuerySourceAdapter;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.ot.editors.obsproject.CalibrationSetupParametersQuerySourceEditor;
import alma.obsprep.ot.editors.obsproject.ObservatoryGoalTargetsEditor;
import alma.obsprep.ot.gui.toplevel.Dialog;
import alma.obsprep.ot.gui.toplevel.InitServices;
import alma.obsprep.services.experts.calibrators.CalibratorExpertController;
import alma.obsprep.services.experts.calibrators.CalibratorExpertModel;
import alma.obsprep.util.UnitMapConfigurator;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFrame;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public class CalibrationSetupParametersQuerySourceEditorDialog
extends Dialog {
    private final CalibrationSetupParametersQuerySourceEditor editor;
    private boolean isCancelled = false;
    private boolean isPassivePhasing = false;

    public CalibrationSetupParametersQuerySourceEditorDialog(Model model, Frame frame, boolean bl, boolean bl2) {
        this.setModal(bl);
        this.editor = new CalibrationSetupParametersQuerySourceEditor(model, bl2);
        this.editor.getOkButton().addActionListener(actionEvent -> this.okButtonActionPerformed());
        this.editor.getCancelButton().addActionListener(actionEvent -> this.cancelButtonActionPerformed());
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                CalibrationSetupParametersQuerySourceEditorDialog.this.okButtonActionPerformed();
            }
        });
        this.initComponents();
    }

    @Override
    public void setVisible(boolean bl) {
        if (bl) {
            this.rescaleToMonitor(0.8);
        }
        super.setVisible(bl);
    }

    private void okButtonActionPerformed() {
        this.setVisible(false);
        this.dispose();
    }

    private void cancelButtonActionPerformed() {
        this.setVisible(false);
        this.dispose();
        this.isCancelled = true;
    }

    private void initComponents() {
        this.setDefaultCloseOperation(2);
        this.setTitle("Calibrator Query Editor");
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.editor, gridBagConstraints);
        this.pack();
        this.getRootPane().setDefaultButton(this.editor.getSubmitButton());
    }

    public static void main(String[] stringArray) {
        InitServices.initModelSupportClasses();
        UnitMapConfigurator.configureUnitMaps();
        QuerySource querySource = QuerySource.createQuerySource(QuerySource.INTENDEDUSE_AMPLITUDE);
        QuerySourceAdapter querySourceAdapter = new QuerySourceAdapter(querySource);
        CalibratorExpertModel calibratorExpertModel = new CalibratorExpertModel(querySourceAdapter);
        calibratorExpertModel.subscribe(new CalibratorExpertController());
        EventQueue.invokeLater(() -> {
            try {
                UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
            }
            catch (ClassNotFoundException classNotFoundException) {
                Logger.getLogger(ObservatoryGoalTargetsEditor.class.getName()).log(Level.SEVERE, null, classNotFoundException);
            }
            catch (InstantiationException instantiationException) {
                Logger.getLogger(ObservatoryGoalTargetsEditor.class.getName()).log(Level.SEVERE, null, instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                Logger.getLogger(ObservatoryGoalTargetsEditor.class.getName()).log(Level.SEVERE, null, illegalAccessException);
            }
            catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
                Logger.getLogger(ObservatoryGoalTargetsEditor.class.getName()).log(Level.SEVERE, null, unsupportedLookAndFeelException);
            }
            CalibrationSetupParametersQuerySourceEditorDialog calibrationSetupParametersQuerySourceEditorDialog = new CalibrationSetupParametersQuerySourceEditorDialog(calibratorExpertModel, new JFrame(), true, false);
            calibrationSetupParametersQuerySourceEditorDialog.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent windowEvent) {
                    System.exit(0);
                }
            });
            calibrationSetupParametersQuerySourceEditorDialog.setVisible(true);
        });
    }

    @Override
    public String toString() {
        return "CalibrationSetupParametersQuerySourceEditorDialog(editor=" + this.editor + ", isCancelled=" + this.isCancelled() + ", isPassivePhasing=" + this.isPassivePhasing + ")";
    }

    public boolean isCancelled() {
        return this.isCancelled;
    }
}

