/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.editors.sciencegoals;

import alma.entity.xmlbinding.obsproject.types.PerformanceParametersTTimingConstraintsTypeType;
import alma.hla.runtime.obsprep.bo.AbstractDoubleWithUnit;
import alma.hla.runtime.obsprep.util.Log;
import alma.hla.runtime.obsprep.util.UnknownEntityException;
import alma.obsprep.bo.enumerations.Array;
import alma.obsprep.bo.obsproject.FieldTypeInfo;
import alma.obsprep.bo.obsproject.MonitoringConstraint;
import alma.obsprep.bo.obsproject.PerformanceParameters;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproject.SpectralSetupParameters;
import alma.obsprep.bo.obsproject.TargetParameters;
import alma.obsprep.bo.obsproposal.ObsProposal;
import alma.obsprep.ot.editors.sciencegoals.EstimatedTimeInfoBuilder;
import alma.obsprep.ot.editors.sciencegoals.TimeEstimateInterface;
import alma.obsprep.ot.models.sciencegoals.AngularResolutionMode;
import alma.obsprep.ot.valdef.obsproject.PerformanceParametersValidator;
import alma.obsprep.services.calibration.CalObs;
import alma.obsprep.services.calibration.CalType;
import alma.obsprep.services.etc.ObservingTimeCalculator;
import alma.obsprep.services.etc.SchedBlockObservingTimeCalculator;
import alma.obsprep.services.etc.SourceClusterDetector;
import alma.obsprep.services.etc.SourceNeverVisibleException;
import alma.obsprep.services.etc.TimeSummary;
import alma.obsprep.services.etc.editor.WaterVaporColumns;
import alma.obsprep.services.experts.Configuration;
import alma.obsprep.services.experts.ConfigurationHelper;
import alma.obsprep.services.experts.ConfigurationSet;
import alma.obsprep.services.experts.InvalidConfigurationParametersException;
import alma.obsprep.services.experts.InvalidFrequencyException;
import alma.obsprep.services.experts.MatchedConfiguration;
import alma.obsprep.services.experts.ScienceGoalConfigurations;
import alma.obsprep.services.generator.InvalidObsProgramParametersException;
import alma.obsprep.services.generator.refactored.RequestedArray;
import alma.obsprep.util.TextUtils;
import alma.valuetypes.Angle;
import alma.valuetypes.Sensitivity;
import alma.valuetypes.Time;
import alma.valuetypes.UserFrequency;
import alma.valuetypes.UserSensitivity;
import java.awt.Dimension;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;

public class StandardTimeEstimate
implements TimeEstimateInterface {
    private static final String TOTAL_TP_TIME = "Total TP time";
    private static final String TP_ON_SOURCE_TIME = "TP on-source time";
    private static final String UNABLE_TO_GENERATE_TIME_ESTIMATE_MSG = "Unable to generate time estimate ";
    private static final String INPUT_PARAMETERS_LABEL = "<b>Input Parameters</b>";
    private final Log.Logger logger = Log.logger((Object)this);
    private Time timeForAllScienceGoals;

    @Override
    public EstimatedTimeInfoBuilder.TimeEstimateModel generateTimeEstimateModel(@NonNull ScienceGoal scienceGoal) throws TimeEstimateInterface.UnableToGenerateTimeEstimateException {
        SchedBlockObservingTimeCalculator schedBlockObservingTimeCalculator;
        Object object;
        Object object2;
        Object object3;
        Object exception;
        Collection<ScienceGoal> collection;
        if (scienceGoal == null) {
            throw new NullPointerException("sg is marked non-null but is null");
        }
        SpectralSetupParameters spectralSetupParameters = scienceGoal.getSpectralSetupParameters();
        SourceClusterDetector sourceClusterDetector = new SourceClusterDetector(scienceGoal);
        try {
            collection = sourceClusterDetector.splitScienceGoalIntoSourceClusters();
        }
        catch (InvalidObsProgramParametersException invalidObsProgramParametersException) {
            throw new TimeEstimateInterface.UnableToGenerateTimeEstimateException(invalidObsProgramParametersException.getMessage());
        }
        for (ScienceGoal object52 : collection) {
            boolean userSensitivity = false;
            try {
                exception = scienceGoal.getPerformanceParameters().getAngularResolutionMode();
                if (EnumSet.of(AngularResolutionMode.SACA, AngularResolutionMode.Any).contains(exception)) {
                    userSensitivity = true;
                } else if (((Enum)exception).equals(AngularResolutionMode.Range)) {
                    scienceGoalConfigurations = object52.getPerformanceParameters().getRepresentativeFrequencyWithSkyOffset().getContentInGHz();
                    object3 = Configuration.getBestConfiguration(scienceGoalConfigurations, RequestedArray.TWELVE_M, object52);
                    if (object3.equals(Configuration.ILLEGAL_CONFIG)) {
                        throw new TimeEstimateInterface.UnableToGenerateTimeEstimateException("Unable to determine any 12-m configurations within the range for cluster");
                    }
                    userSensitivity = true;
                } else {
                    scienceGoalConfigurations = object52.getPerformanceParameters().getRepresentativeFrequencyWithSkyOffset().getContentInGHz();
                    userSensitivity = PerformanceParametersValidator.isDesiredAngularResolutionAchievableWith12mConfigs(object52.getPerformanceParameters(), object52.getPerformanceParameters().getDesiredAngularResolution().getContentInUnits(Angle.UNIT_ARCSEC), scienceGoalConfigurations);
                }
            }
            catch (Configuration.UnableToDetermineConfigurationException | InvalidConfigurationParametersException | InvalidObsProgramParametersException exception2) {
                throw new TimeEstimateInterface.UnableToGenerateTimeEstimateException("<html> No array configuration can be determined for the observing parameters specified: <ul> <li> Check that the desired angular resolution is within the range allowed by the available arrays and configuration</li></ul</html>");
            }
            if (userSensitivity) continue;
            throw new TimeEstimateInterface.UnableToGenerateTimeEstimateException("<html> No array configuration can be determined for the observing parameters specified: <ul> <li> Check that the desired angular resolution is within the range allowed by the available arrays and configuration</li></ul</html>");
        }
        EstimatedTimeInfoBuilder.TimeEstimateModel timeEstimateModel = new EstimatedTimeInfoBuilder.TimeEstimateModel();
        timeEstimateModel.setDialogWindowDimensions(new Dimension(600, 950));
        timeEstimateModel.addToHeader("Note: The time in brackets is that required to reach the sensitivity. <P>Operational requirements often mean that the actual observed time <P>is longer, especially for mosaics. Please see the User Manual for more details.<P>", "");
        PerformanceParameters performanceParameters = scienceGoal.getPerformanceParameters();
        UserSensitivity userSensitivity = performanceParameters.getDesiredSensitivity().deepCopy();
        if (performanceParameters.isAngularResolutionModeRange()) {
            exception = null;
            try {
                ScienceGoalConfigurations<ConfigurationSet> scienceGoalConfigurations = Configuration.getConfigurationsToBeScheduled(scienceGoal);
                exception = ConfigurationHelper.getBestMatchedConfiguration(performanceParameters.getRepresentativeFrequency().getContentInGHz(), RequestedArray.TWELVE_M, scienceGoal, scienceGoalConfigurations, Configuration.DesiredAngularResolution.FINEST, false);
            }
            catch (InvalidConfigurationParametersException | InvalidObsProgramParametersException object22) {
                throw new TimeEstimateInterface.UnableToGenerateTimeEstimateException(object22);
            }
            assert (exception != null);
            userSensitivity.setBeamsize(((MatchedConfiguration)exception).getConfigurationAR());
        }
        exception = Sensitivity.createSensitivity();
        exception.setContentAndUnit(userSensitivity.getContentInDefaultUnits(), userSensitivity.defaultUnit());
        exception.convertToUnit(exception.getFriendlyUnit());
        if (exception.isZero(1.0E-9)) {
            throw new TimeEstimateInterface.UnableToGenerateTimeEstimateException("Unable to generate time estimate: the requested sensitivity " + (Sensitivity)((Object)exception) + " is invalid");
        }
        TargetParameters targetParameters = scienceGoal.getSoleTargetParameters();
        if (targetParameters.getType().equals(FieldTypeInfo.F_SingleRectangle.getValue()) && ((object2 = targetParameters.getFieldRectangle()[0]).getLong().isZero() || object2.getShort().isZero())) {
            throw new TimeEstimateInterface.UnableToGenerateTimeEstimateException("Rectangle definition incomplete - please define the rectangle in your field setup correctly");
        }
        if (spectralSetupParameters.getScienceSpectralWindowCount() == 0 && !spectralSetupParameters.isSpectralScan()) {
            throw new TimeEstimateInterface.UnableToGenerateTimeEstimateException("No Spectral Window/Element is set.");
        }
        if (PerformanceParameters.DESIREDSENSITIVITYFREQUENCYMEASURE_USER.equals(performanceParameters.getDesiredSensitivityFrequencyMeasure()) && performanceParameters.getDesiredSensitivityReferenceFrequencyWidth().getContent() <= 0.0) {
            throw new TimeEstimateInterface.UnableToGenerateTimeEstimateException("Positive \"Frequency Width\" value must be set in choosing \"User\" type as \"Bandwidth used for Sensitivity\".");
        }
        timeEstimateModel.addToHeader(INPUT_PARAMETERS_LABEL, "");
        timeEstimateModel.addToHeader("Requested sensitivity", String.format("%.4g %s", exception.getContentInUnits(exception.getFriendlyUnit()), exception.getFriendlyUnit()));
        object2 = performanceParameters.getSensitivityFrequencyWidth();
        object3 = TextUtils.format(object2, 3);
        if (performanceParameters.isUserSpecificFrequencyWidth() && object2 instanceof UserFrequency && !(object = (UserFrequency)object2).inModelUnit()) {
            object3 = String.format("%.3f %s", object.getUserContent(), object.getUserUnit());
        }
        object = spectralSetupParameters.isSpectralScan() ? scienceGoal.getRepresentativeFrequency() : scienceGoal.getRepresentativeFrequencyInSky();
        timeEstimateModel.addToHeader("Bandwidth used for sensitivity", (String)object3);
        timeEstimateModel.addToHeader("Representative frequency (sky, first source)", TextUtils.format(object, 3));
        SchedBlockObservingTimeCalculator.Builder builder = new SchedBlockObservingTimeCalculator.Builder();
        builder.scienceGoal(scienceGoal);
        try {
            schedBlockObservingTimeCalculator = new SchedBlockObservingTimeCalculator(builder);
        }
        catch (InvalidObsProgramParametersException n) {
            throw new TimeEstimateInterface.UnableToGenerateTimeEstimateException(n.getMessage());
        }
        this.timeForAllScienceGoals = Time.createTime();
        int n = 1;
        for (ScienceGoal scienceGoal2 : schedBlockObservingTimeCalculator.getScienceGoalsWithClusters()) {
            try {
                if (scienceGoal2.isStandAloneACA()) {
                    this.createStandaloneACATimeEstimate(schedBlockObservingTimeCalculator, scienceGoal2, timeEstimateModel, this.timeForAllScienceGoals, n);
                } else {
                    this.createStandard12mBasedTimeEstimate(schedBlockObservingTimeCalculator, scienceGoal2, timeEstimateModel, this.timeForAllScienceGoals, n);
                }
            }
            catch (InvalidObsProgramParametersException invalidObsProgramParametersException) {
                throw new TimeEstimateInterface.UnableToGenerateTimeEstimateException(invalidObsProgramParametersException);
            }
            ++n;
        }
        timeEstimateModel.addToHeader("<h3>Estimated Total time for Science Goal</h3>", "<h3>" + TextUtils.format(this.timeForAllScienceGoals.convertToFriendlyUnit(), 2) + "</h3>");
        return timeEstimateModel;
    }

    /*
     * WARNING - void declaration
     */
    private EstimatedTimeInfoBuilder.TimeEstimateModel createStandard12mBasedTimeEstimate(SchedBlockObservingTimeCalculator schedBlockObservingTimeCalculator, ScienceGoal scienceGoal, @NonNull EstimatedTimeInfoBuilder.TimeEstimateModel timeEstimateModel, Time time, int n) throws TimeEstimateInterface.UnableToGenerateTimeEstimateException, InvalidObsProgramParametersException {
        Object object;
        Time time2;
        void var16_25;
        void var27_42;
        void var13_16;
        if (timeEstimateModel == null) {
            throw new NullPointerException("timeEstimateModel is marked non-null but is null");
        }
        Array array = Array.ARRAY_12M;
        PerformanceParameters performanceParameters = scienceGoal.getPerformanceParameters();
        boolean bl = performanceParameters.getIsSimultaneous12and7();
        Integer n2 = 1;
        Integer n3 = 0;
        Time time3 = Time.createTimeSec(0.0);
        TargetParameters targetParameters = scienceGoal.getSoleTargetParameters();
        timeEstimateModel.setClusterSpecificScienceGoal(scienceGoal);
        if (performanceParameters.getIsTimeConstrained() && performanceParameters.getTimingConstraintsType() != null) {
            if (performanceParameters.getTimingConstraintsType().equals(PerformanceParametersTTimingConstraintsTypeType.MULTIPLEVISITS.toString())) {
                n2 = performanceParameters.getVisitConstraintCount();
            } else if (performanceParameters.getTimingConstraintsType().equals(PerformanceParametersTTimingConstraintsTypeType.CONTINUOUSMONITORING.toString())) {
                for (MonitoringConstraint monitoringConstraint : performanceParameters.getMonitoringConstraint()) {
                    time3.aggregate(schedBlockObservingTimeCalculator.adjustForFullPolarization(monitoringConstraint.getMonitoringLength()));
                }
                n3 = performanceParameters.getMonitoringConstraint().length;
            }
        }
        Object var13_14 = null;
        Time time4 = null;
        Time time5 = null;
        Object var16_23 = null;
        Time time6 = null;
        Time time7 = null;
        Time time8 = null;
        Time time9 = null;
        Time time10 = Time.createTime();
        Integer n4 = null;
        Integer n5 = 1;
        int n6 = 0;
        ScienceGoalConfigurations<ConfigurationSet> scienceGoalConfigurations = null;
        try {
            scienceGoalConfigurations = Configuration.getConfigurationsToBeScheduled(scienceGoal);
            timeEstimateModel.setScienceGoalConfigurations(scienceGoalConfigurations);
            time5 = schedBlockObservingTimeCalculator.singlePointOnSourceTime(scienceGoal, array, targetParameters, false).convertToFriendlyUnit();
            time6 = schedBlockObservingTimeCalculator.getTotalOnSourceTime(scienceGoal, array, false).convertToFriendlyUnit();
            time4 = schedBlockObservingTimeCalculator.singlePointOnSourceTimeFromSB(scienceGoal, targetParameters, array).convertToFriendlyUnit();
            Time time11 = schedBlockObservingTimeCalculator.getTotalArraySBScienceIntegrationTime(true, scienceGoal, array).convertToFriendlyUnit();
            time7 = schedBlockObservingTimeCalculator.getTotalRequestedTime(array, true, false, scienceGoal).convertToFriendlyUnit();
            n4 = schedBlockObservingTimeCalculator.getSBExecutionCount(scienceGoal, array);
            n5 = schedBlockObservingTimeCalculator.getNumberOfAntennaConfigurations(scienceGoal, RequestedArray.TWELVE_M);
            time8 = scienceGoal.getOverheadTimes(EnumSet.of(ObservingTimeCalculator.CalibrationOverheads.ONSOURCEOVERHEADS), array, scienceGoal.getSoleTargetParameters(), true).convertToFriendlyUnit();
            time9 = scienceGoal.getOverheadTimes(EnumSet.of(ObservingTimeCalculator.CalibrationOverheads.CALIBRATIONEXECTIMES, ObservingTimeCalculator.CalibrationOverheads.CALIBRATIONOVERHEADS, ObservingTimeCalculator.CalibrationOverheads.CALIBRATIONSLEWTIME), array, scienceGoal.getSoleTargetParameters(), false);
            assert (time9 != null);
            time10 = (Time)scienceGoal.getOverheadTimes(EnumSet.of(ObservingTimeCalculator.CalibrationOverheads.CALIBRATIONOVERHEADS, ObservingTimeCalculator.CalibrationOverheads.CALIBRATIONSLEWTIME), array, scienceGoal.getSoleTargetParameters(), true).divide(n4.intValue());
            assert (time10 != null);
            if (time11 != null) {
                this.logger.fine("Total 12m ext array on-source time from SB generator " + time11.convertToFriendlyUnit());
            }
            this.logger.fine("Total 12m ext array on-source time from SB OTC " + time11.convertToFriendlyUnit());
            n6 = schedBlockObservingTimeCalculator.getWaterVapourContentUsed(scienceGoal);
            timeEstimateModel.addClusterSpecificKeyValuePair(INPUT_PARAMETERS_LABEL, "");
            timeEstimateModel.addClusterSpecificKeyValuePair("Precipitable water vapour (all sources)", WaterVaporColumns.getWVIndexLabel(n6));
            timeEstimateModel.addClusterSpecificKeyValuePair("", "");
        }
        catch (UnknownEntityException | SourceNeverVisibleException | InvalidFrequencyException | InvalidObsProgramParametersException throwable) {
            String string = throwable.getMessage();
        }
        if (var13_16 != null) {
            this.throwUnableToGenerateTimeEstimateExcepion((String)var13_16);
        }
        int n7 = 0;
        for (TargetParameters targetParameters2 : scienceGoal.gettrueTargetParameters()) {
            n7 += targetParameters2.getNumberOfPointings(Array.ARRAY_12M);
        }
        Object var27_38 = null;
        if (scienceGoalConfigurations == null || scienceGoalConfigurations.getExtendedConfigurations().isEmpty()) {
            String string = "Unable to determine configuration";
        } else if (scienceGoal.getPerformanceParameters().isAngularResolutionModeRange()) {
            ScienceGoalConfigurations<ConfigurationSet> scienceGoalConfigurations2;
            try {
                scienceGoalConfigurations2 = Configuration.getConfigurationsToBeScheduled(scienceGoal);
            }
            catch (InvalidObsProgramParametersException invalidObsProgramParametersException) {
                throw new TimeEstimateInterface.UnableToGenerateTimeEstimateException(UNABLE_TO_GENERATE_TIME_ESTIMATE_MSG + invalidObsProgramParametersException.getMessage());
            }
            Comparator comparator = (configuration, configuration2) -> Double.compare(configuration.getMaxBaseline(), configuration2.getMaxBaseline());
            String string = ((Configuration)scienceGoalConfigurations2.getExtendedConfigurations().stream().max(comparator).get()).getCanonicalName();
        } else {
            String string = scienceGoalConfigurations.getExtendedConfigurations().get(0).getCanonicalName();
        }
        assert (var27_42 != null);
        timeEstimateModel.addClusterSpecificKeyValuePair(String.format("<b>Time required for 12m (1) [%s]</b>", var27_42), "");
        Object object2 = this.getFirstPointOnSourceData(scienceGoal, array, time4, time5);
        timeEstimateModel.addClusterSpecificKeyValuePair("Time on source per pointing (first source)", (String)object2);
        timeEstimateModel.addClusterSpecificKeyValuePair("Total number of pointings (all sources)", Integer.toString(n7));
        timeEstimateModel.addClusterSpecificKeyValuePair("Number of tunings", Integer.toString(schedBlockObservingTimeCalculator.getNumRetunings(scienceGoal)));
        object2 = TextUtils.format(var16_25.convertToFriendlyUnit(), 2) + " [" + StringUtils.trim((String)TextUtils.format(time6.convertToFriendlyUnit(), 2)) + "]";
        timeEstimateModel.addClusterSpecificKeyValuePair("Total time on source", (String)object2);
        object2 = TextUtils.format(time9.convertToFriendlyUnit(), 2);
        timeEstimateModel.addClusterSpecificKeyValuePair("Total calibration time", (String)object2);
        object2 = TextUtils.format(time8.convertToFriendlyUnit(), 2);
        timeEstimateModel.addClusterSpecificKeyValuePair("Other overheads", (String)object2);
        object2 = TextUtils.format(((Time)time7.divide(n4.intValue())).convertToFriendlyUnit(), 2);
        timeEstimateModel.addClusterSpecificKeyValuePair("Total time for 1 SB execution", (String)object2);
        object2 = n4.toString();
        timeEstimateModel.addClusterSpecificKeyValuePair("Number of SB executions", (String)object2);
        object2 = TextUtils.format(time7.convertToFriendlyUnit(), 2);
        timeEstimateModel.addClusterSpecificKeyValuePair("Total time to complete SB", (String)object2);
        if (performanceParameters.getNeedsMoreTime()) {
            Time time12 = performanceParameters.getDesiredTime().deepCopy();
            object2 = TextUtils.format(time12.convertToFriendlyUnit(), 2);
            timeEstimateModel.addClusterSpecificKeyValuePair("Time override", (String)object2);
        }
        timeEstimateModel.addClusterSpecificKeyValuePair("", "");
        this.createCalibrationBreakdownSummary(schedBlockObservingTimeCalculator, scienceGoal, timeEstimateModel, array, targetParameters, time10, n4);
        timeEstimateModel.addClusterSpecificKeyValuePair("", "");
        int n8 = 0;
        if (n5 > 1) {
            if (n8 == 0) {
                timeEstimateModel.addClusterSpecificKeyValuePair("<b>Additional Arrays</b>", "");
                n8 = 1;
            }
            Time time13 = time7.deepCopy();
            if (performanceParameters.getNeedsMoreTime()) {
                Time time14 = performanceParameters.getDesiredTime().deepCopy();
            }
            try {
                void var30_53;
                object2 = TextUtils.format(schedBlockObservingTimeCalculator.getTimeForSecond12mCompactArray(scienceGoal, (Time)var30_53, true, true).convertToFriendlyUnit(), 2);
            }
            catch (InvalidObsProgramParametersException invalidObsProgramParametersException) {
                String string = invalidObsProgramParametersException.getMessage();
            }
            timeEstimateModel.addClusterSpecificKeyValuePair("Time required for additional 12-m", (String)object2);
        }
        Boolean bl2 = performanceParameters.gettrueUseACA();
        Boolean bl3 = performanceParameters.gettrueUseTP();
        Time time15 = Time.createTime();
        Time time16 = Time.createTime();
        if (Boolean.TRUE.equals(bl2)) {
            Object object3;
            timeEstimateModel.setDialogWindowDimensions(new Dimension(600, 1000));
            if (n8 == 0) {
                timeEstimateModel.addClusterSpecificKeyValuePair("<b>Additional Arrays</b>", "");
                n8 = 1;
            }
            time2 = Time.createTime();
            try {
                time2 = schedBlockObservingTimeCalculator.getTotalArraySBScienceIntegrationTime(true, scienceGoal, Array.ARRAY_7M).convertToFriendlyUnit();
                object3 = bl ? "-" : TextUtils.format(time2, 2);
                timeEstimateModel.addClusterSpecificKeyValuePair("ACA 7-m on-source time", (String)object3);
            }
            catch (UnknownEntityException | InvalidObsProgramParametersException throwable) {
                timeEstimateModel.addClusterSpecificKeyValuePair("ACA 7-m on-source time", throwable.getMessage());
            }
            try {
                time15 = schedBlockObservingTimeCalculator.getTotalRequestedTime(bl ? Array.ARRAY_12M : Array.ARRAY_7M, true, false, scienceGoal).convertToFriendlyUnit();
                timeEstimateModel.addClusterSpecificKeyValuePair("Total 7-m time", TextUtils.format(bl ? time7 : time15, 2));
            }
            catch (InvalidObsProgramParametersException invalidObsProgramParametersException) {
                timeEstimateModel.addClusterSpecificKeyValuePair("Total 7-m time", invalidObsProgramParametersException.getMessage());
            }
            if (Boolean.TRUE.equals(bl3)) {
                object3 = Time.createTime();
                try {
                    object3 = schedBlockObservingTimeCalculator.getTotalArraySBScienceIntegrationTime(true, scienceGoal, Array.ARRAY_TP).convertToFriendlyUnit();
                    object = bl ? "-" : TextUtils.format(object3, 2);
                    timeEstimateModel.addClusterSpecificKeyValuePair(TP_ON_SOURCE_TIME, (String)object);
                }
                catch (UnknownEntityException | InvalidObsProgramParametersException throwable) {
                    timeEstimateModel.addClusterSpecificKeyValuePair(TP_ON_SOURCE_TIME, throwable.getMessage());
                }
                try {
                    time16 = schedBlockObservingTimeCalculator.getTotalRequestedTime(Array.ARRAY_TP, true, false, scienceGoal).convertToFriendlyUnit();
                    timeEstimateModel.addClusterSpecificKeyValuePair(TOTAL_TP_TIME, TextUtils.format(bl ? time7 : time16, 2));
                }
                catch (InvalidObsProgramParametersException invalidObsProgramParametersException) {
                    timeEstimateModel.addClusterSpecificKeyValuePair(TOTAL_TP_TIME, invalidObsProgramParametersException.getMessage());
                }
            }
            object3 = time15.isGreaterThan((AbstractDoubleWithUnit)time16) ? time15 : time16;
            object2 = TextUtils.format(bl ? time7 : object3, 2);
            timeEstimateModel.addClusterSpecificKeyValuePair("Total ACA time (max[t_7-m,t_TP])", (String)object2);
            timeEstimateModel.addClusterSpecificKeyValuePair("", "");
        }
        time2 = time7;
        boolean bl4 = false;
        try {
            bl4 = ObsProposal.isVLBIRelated();
        }
        catch (UnknownEntityException unknownEntityException) {
            Log.logger(StandardTimeEstimate.class).warning("Unable to determine if VLBI is enabled");
        }
        if (bl4 && performanceParameters.getNeedsMoreTime()) {
            time2 = performanceParameters.getDesiredTime().deepCopy().convertToFriendlyUnit();
        }
        time2 = schedBlockObservingTimeCalculator.adjustForFullPolarization(time2).convertToFriendlyUnit();
        try {
            boolean bl5;
            Object object4 = object = time15.isGreaterThan((AbstractDoubleWithUnit)time16) ? time15 : time16;
            if (bl) {
                object = time7;
            }
            time2 = (bl5 = performanceParameters.gettrueIsSimultaneous12and7()) ? ((Time)time2.plus((AbstractDoubleWithUnit)object)).convertToFriendlyUnit() : ((Time)((Time)time2.plus((AbstractDoubleWithUnit)schedBlockObservingTimeCalculator.getTimeForSecond12mCompactArray(scienceGoal, time2, true, true))).plus((AbstractDoubleWithUnit)object)).convertToFriendlyUnit();
        }
        catch (InvalidObsProgramParametersException invalidObsProgramParametersException) {
            Log.logger((Object)this).info("Unable to determine the total time for a science goal " + invalidObsProgramParametersException.getMessage());
        }
        if (n2 > 1) {
            timeEstimateModel.setDialogWindowDimensions(new Dimension(600, 1050));
            timeEstimateModel.addClusterSpecificKeyValuePair("Number of visits", n2.toString());
            object2 = "<h3>" + TextUtils.format(((Time)time2.multiply(n2.intValue())).convertToFriendlyUnit(), 2) + "</h3>";
            timeEstimateModel.addClusterSpecificKeyValuePair(String.format("<h3>Estimated total time for cluster %d</h3>", n), (String)object2);
        } else if (n3 > 0) {
            timeEstimateModel.addClusterSpecificKeyValuePair("No of continuous monitoring visits", n3.toString());
            object2 = "<h3>" + TextUtils.format(time3.convertToFriendlyUnit(), 2) + "</h3>";
            timeEstimateModel.addClusterSpecificKeyValuePair(String.format("<h3>Estimated total time for continuous monitoring time for cluster %d </h3>", n), (String)object2);
        } else {
            object2 = "<b>" + TextUtils.format(time2.convertToFriendlyUnit(), 2) + "</b>";
            timeEstimateModel.addClusterSpecificKeyValuePair(String.format("<h3>Estimated total time for cluster %d</h3>", n), (String)object2);
        }
        time.aggregate((Time)time2.multiply(n2.intValue()));
        timeEstimateModel.commitClusterSpecificData();
        return timeEstimateModel;
    }

    private void throwUnableToGenerateTimeEstimateExcepion(String string) throws TimeEstimateInterface.UnableToGenerateTimeEstimateException {
        if (string != null) {
            Matcher matcher = Pattern.compile("([\\$\\w\\.]*:[ ])*(.*)", 2).matcher(string);
            string = matcher.matches() ? matcher.group(matcher.groupCount()).trim() : string.trim();
            throw new TimeEstimateInterface.UnableToGenerateTimeEstimateException("Unable to generate time estimate : " + string);
        }
    }

    private void createCalibrationBreakdownSummary(@NonNull SchedBlockObservingTimeCalculator schedBlockObservingTimeCalculator, @NonNull ScienceGoal scienceGoal, @NonNull EstimatedTimeInfoBuilder.TimeEstimateModel timeEstimateModel, @NonNull Array array, @NonNull TargetParameters targetParameters, @NonNull Time time, @NonNull Integer n) throws TimeEstimateInterface.UnableToGenerateTimeEstimateException {
        String string;
        if (schedBlockObservingTimeCalculator == null) {
            throw new NullPointerException("timeCalculator is marked non-null but is null");
        }
        if (scienceGoal == null) {
            throw new NullPointerException("scienceGoal is marked non-null but is null");
        }
        if (timeEstimateModel == null) {
            throw new NullPointerException("timeEstimateModel is marked non-null but is null");
        }
        if (array == null) {
            throw new NullPointerException("arrayToBaseEstimateUpon is marked non-null but is null");
        }
        if (targetParameters == null) {
            throw new NullPointerException("targetParameters is marked non-null but is null");
        }
        if (time == null) {
            throw new NullPointerException("calibrationOverheadsPerSBExec is marked non-null but is null");
        }
        if (n == null) {
            throw new NullPointerException("numberOfSBExecutions is marked non-null but is null");
        }
        if (schedBlockObservingTimeCalculator.isSBToBeExecutedUsingSessions()) {
            timeEstimateModel.addClusterSpecificKeyValuePair("<b>Calibration Breakdown per SB execution<sup>*</sup></b>", "");
        } else {
            timeEstimateModel.addClusterSpecificKeyValuePair("<b>Calibration Breakdown per SB execution</b>", "");
        }
        Map<CalType, TimeSummary> map = schedBlockObservingTimeCalculator.getCalibrationTimeSummary(scienceGoal);
        if (map == null || map.isEmpty()) {
            try {
                schedBlockObservingTimeCalculator.getCalibrationExecutionTimeStats(scienceGoal, true, array, targetParameters, false);
                map = schedBlockObservingTimeCalculator.getCalibrationTimeSummary(scienceGoal);
            }
            catch (SourceNeverVisibleException | InvalidObsProgramParametersException exception) {
                throw new TimeEstimateInterface.UnableToGenerateTimeEstimateException(UNABLE_TO_GENERATE_TIME_ESTIMATE_MSG + exception.getMessage());
            }
        }
        for (CalObs.CalibratorSecondaryIntentEnum calibratorSecondaryIntentEnum : CalObs.CalibratorSecondaryIntentEnum.values()) {
            for (TimeSummary timeSummary : map.values()) {
                CalObs calObs = timeSummary.getCalibrationObservation();
                if (!calObs.isIncludedInTimeEstimateAccounting() || !calObs.getCalibratorSecondaryIntent().equals((Object)calibratorSecondaryIntentEnum)) continue;
                Time time2 = ((Time)timeSummary.getTotalCalibrationTime().divide(n.intValue())).convertToFriendlyUnit();
                long l = timeSummary.getNumberOfCalibrationExecutions() / (long)n.intValue();
                CalType calType = timeSummary.getType();
                String string2 = this.customiseCalibrationName(timeSummary, calType);
                String string3 = l + " x " + string2;
                string = TextUtils.format(time2.convertToFriendlyUnit(), 2);
                timeEstimateModel.addClusterSpecificKeyValuePair("&nbsp;" + string3, string);
            }
        }
        string = TextUtils.format(time.convertToFriendlyUnit(), 2);
        timeEstimateModel.addClusterSpecificKeyValuePair("Calibration overheads", string);
        if (schedBlockObservingTimeCalculator.isSBToBeExecutedUsingSessions()) {
            timeEstimateModel.addClusterSpecificKeyValuePair("<html><small><sup>*</sup>Sessions assumed: some calibrations are only observed <P>during the first SB execution</small></html>", "");
        }
    }

    private String customiseCalibrationName(TimeSummary timeSummary, CalType calType) {
        String string = calType.toString();
        if (calType.equals((Object)CalType.DGCBandpass)) {
            string = "DGC Bandpass";
        } else if (calType.equals((Object)CalType.DGCAmplitude) && timeSummary.isSSOCalibrationStrategyUsed()) {
            string = "DGC Amplitude";
        } else if (calType.equals((Object)CalType.Bandpass) && timeSummary.isStandardSystemCalibrationStrategyUsed()) {
            string = "Amplitude/bandpass";
        } else if (calType.equals((Object)CalType.DGCScience)) {
            string = "DGC";
        } else if (calType.toString().equals("Delay")) {
            string = "Phase reference check source";
        }
        return string;
    }

    private String getFirstPointOnSourceData(ScienceGoal scienceGoal, Array array, Time time, Time time2) {
        String string = null;
        double d = 1.0;
        double d2 = 0.0;
        try {
            d = Configuration.getShadowMultiplierForArray(array, scienceGoal);
            d2 = Configuration.getShadowingPercentage(array, scienceGoal);
        }
        catch (InvalidObsProgramParametersException invalidObsProgramParametersException) {
            // empty catch block
        }
        String string2 = "";
        if (d != 1.0) {
            string2 = String.format(", shadowing = %.2g%%", d2);
        }
        string = String.format("%s [%s%s] ", TextUtils.format(time.convertToFriendlyUnit(), 2), TextUtils.format(time2.convertToFriendlyUnit(), 2), string2);
        assert (string != null);
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private EstimatedTimeInfoBuilder.TimeEstimateModel createStandaloneACATimeEstimate(SchedBlockObservingTimeCalculator schedBlockObservingTimeCalculator, ScienceGoal scienceGoal, EstimatedTimeInfoBuilder.TimeEstimateModel timeEstimateModel, Time time, int n) throws TimeEstimateInterface.UnableToGenerateTimeEstimateException, InvalidObsProgramParametersException {
        void var30_69;
        Time time2;
        Map<CalType, TimeSummary> map;
        void var15_23;
        void var26_40;
        void var12_15;
        ScienceGoalConfigurations<ConfigurationSet> scienceGoalConfigurations;
        Array array = Array.ARRAY_7M;
        PerformanceParameters performanceParameters = scienceGoal.getPerformanceParameters();
        Integer n2 = 1;
        Integer n3 = 0;
        Time time22 = Time.createTimeSec(0.0);
        TargetParameters targetParameters = scienceGoal.getSoleTargetParameters();
        timeEstimateModel.setClusterSpecificScienceGoal(scienceGoal);
        if (performanceParameters.getIsTimeConstrained() && performanceParameters.getTimingConstraintsType() != null) {
            if (performanceParameters.getTimingConstraintsType().equals(PerformanceParametersTTimingConstraintsTypeType.MULTIPLEVISITS.toString())) {
                n2 = performanceParameters.getVisitConstraintCount();
            } else if (performanceParameters.getTimingConstraintsType().equals(PerformanceParametersTTimingConstraintsTypeType.CONTINUOUSMONITORING.toString())) {
                for (MonitoringConstraint monitoringConstraint : performanceParameters.getMonitoringConstraint()) {
                    time22.aggregate(schedBlockObservingTimeCalculator.adjustForFullPolarization(monitoringConstraint.getMonitoringLength()));
                }
                n3 = performanceParameters.getMonitoringConstraint().length;
            }
        }
        Object var12_13 = null;
        Time time3 = null;
        Time time4 = null;
        Object var15_21 = null;
        Time time5 = null;
        Time time6 = null;
        Time time7 = null;
        Time time8 = null;
        Time time9 = Time.createTime();
        Time time10 = Time.createTime();
        Integer n4 = null;
        int n5 = 0;
        try {
            scienceGoalConfigurations = Configuration.getConfigurationsToBeScheduled(scienceGoal, RequestedArray.SEVEN_M);
        }
        catch (InvalidObsProgramParametersException invalidObsProgramParametersException) {
            throw new TimeEstimateInterface.UnableToGenerateTimeEstimateException(invalidObsProgramParametersException.getMessage());
        }
        try {
            ConfigurationSet configurationSet;
            if (!(scienceGoalConfigurations.isEmpty() || (configurationSet = (ConfigurationSet)scienceGoalConfigurations.get(0)).isTPRequired() || this.isLASRecoverableWithoutTPWithSACA(scienceGoal))) {
                throw new InvalidObsProgramParametersException("Unable to calculate optimal array configuration - please check the LAS can be recovered by the ACA 7-m alone with the given band.");
            }
            timeEstimateModel.setScienceGoalConfigurations(scienceGoalConfigurations);
            time4 = schedBlockObservingTimeCalculator.singlePointOnSourceTime(scienceGoal, array, targetParameters, false).convertToFriendlyUnit();
            time5 = schedBlockObservingTimeCalculator.getTotalOnSourceTime(array, false).convertToFriendlyUnit();
            time3 = schedBlockObservingTimeCalculator.singlePointOnSourceTimeFromSB(scienceGoal, targetParameters, array).convertToFriendlyUnit();
            Time time11 = schedBlockObservingTimeCalculator.getTotalArraySBScienceIntegrationTime(true, scienceGoal, array).convertToFriendlyUnit();
            time6 = schedBlockObservingTimeCalculator.getTotalRequestedTime(array, true, false, scienceGoal).convertToFriendlyUnit();
            n4 = schedBlockObservingTimeCalculator.getSBExecutionCount(scienceGoal, Array.ARRAY_7M);
            time7 = scienceGoal.getOverheadTimes(EnumSet.of(ObservingTimeCalculator.CalibrationOverheads.ONSOURCEOVERHEADS), array, scienceGoal.getSoleTargetParameters(), true).convertToFriendlyUnit();
            time8 = scienceGoal.getOverheadTimes(EnumSet.of(ObservingTimeCalculator.CalibrationOverheads.CALIBRATIONEXECTIMES, ObservingTimeCalculator.CalibrationOverheads.CALIBRATIONOVERHEADS, ObservingTimeCalculator.CalibrationOverheads.CALIBRATIONSLEWTIME), array, scienceGoal.getSoleTargetParameters(), false);
            assert (time8 != null);
            time10 = (Time)scienceGoal.getOverheadTimes(EnumSet.of(ObservingTimeCalculator.CalibrationOverheads.CALIBRATIONOVERHEADS, ObservingTimeCalculator.CalibrationOverheads.CALIBRATIONSLEWTIME), array, scienceGoal.getSoleTargetParameters(), false).divide(n4.intValue());
            assert (time10 != null);
            if (time11 != null) {
                this.logger.fine("Total 7m ext array on-source time from SB generator " + time11.convertToFriendlyUnit());
            }
            this.logger.fine("Total 7m ext array on-source time from SB OTC " + time11.convertToFriendlyUnit());
            n5 = schedBlockObservingTimeCalculator.getWaterVapourContentUsed(scienceGoal);
            timeEstimateModel.addClusterSpecificKeyValuePair(INPUT_PARAMETERS_LABEL, "");
            timeEstimateModel.addClusterSpecificKeyValuePair("Precipitable water vapour (all sources)", WaterVaporColumns.getWVIndexLabel(n5));
            timeEstimateModel.addClusterSpecificKeyValuePair("", "");
        }
        catch (UnknownEntityException | SourceNeverVisibleException | InvalidFrequencyException | InvalidObsProgramParametersException throwable) {
            String string = throwable.getMessage();
        }
        if (var12_15 != null) {
            this.throwUnableToGenerateTimeEstimateExcepion((String)var12_15);
        }
        int n6 = 0;
        for (TargetParameters targetParameters2 : scienceGoal.gettrueTargetParameters()) {
            n6 += targetParameters2.getNumberOfPointings(Array.ARRAY_7M);
        }
        timeEstimateModel.addClusterSpecificKeyValuePair("<b>Time required for ACA 7-m array</b>", "");
        if (var12_15 != null) {
            void var26_38 = var12_15;
        } else {
            String string = this.getFirstPointOnSourceData(scienceGoal, array, time3, time4);
        }
        timeEstimateModel.addClusterSpecificKeyValuePair("Time on source per pointing (first source)", (String)var26_40);
        timeEstimateModel.addClusterSpecificKeyValuePair("Total number of pointings (all sources)", Integer.toString(n6));
        timeEstimateModel.addClusterSpecificKeyValuePair("Number of tunings", Integer.toString(schedBlockObservingTimeCalculator.getNumRetunings(scienceGoal)));
        void var26_41 = var12_15 != null ? var12_15 : TextUtils.format(var15_23.convertToFriendlyUnit(), 2) + " [" + StringUtils.trim((String)TextUtils.format(time5.convertToFriendlyUnit(), 2)) + "]";
        timeEstimateModel.addClusterSpecificKeyValuePair("Total time on source", (String)var26_41);
        void var26_42 = var12_15 != null ? var12_15 : TextUtils.format(time8.convertToFriendlyUnit(), 2);
        timeEstimateModel.addClusterSpecificKeyValuePair("Total calibration time", (String)var26_42);
        void var26_43 = var12_15 != null ? var12_15 : TextUtils.format(time7.convertToFriendlyUnit(), 2);
        timeEstimateModel.addClusterSpecificKeyValuePair("Other overheads", (String)var26_43);
        void var26_44 = var12_15 != null ? var12_15 : TextUtils.format(((Time)time6.divide(n4.intValue())).convertToFriendlyUnit(), 2);
        timeEstimateModel.addClusterSpecificKeyValuePair("Total time for 1 SB execution", (String)var26_44);
        String string = var12_15 != null ? var12_15 : n4.toString();
        timeEstimateModel.addClusterSpecificKeyValuePair("Number of SB executions", string);
        void var26_46 = var12_15 != null ? var12_15 : TextUtils.format(time6.convertToFriendlyUnit(), 2);
        timeEstimateModel.addClusterSpecificKeyValuePair("Total time to complete SB", (String)var26_46);
        Time time12 = null;
        if (performanceParameters.getNeedsMoreTime()) {
            time12 = performanceParameters.getDesiredTime().deepCopy();
            String string2 = TextUtils.format(time12.convertToFriendlyUnit(), 2);
            timeEstimateModel.addClusterSpecificKeyValuePair("Time override", string2);
        }
        timeEstimateModel.addClusterSpecificKeyValuePair("", "");
        if (var12_15 != null) {
            return timeEstimateModel;
        }
        timeEstimateModel.addClusterSpecificKeyValuePair("<b>Calibration Breakdown per SB execution</b>", "");
        try {
            schedBlockObservingTimeCalculator.getCalibrationExecutionTimeStats(scienceGoal, true, array, targetParameters, true);
            map = schedBlockObservingTimeCalculator.getCalibrationTimeSummary(scienceGoal);
        }
        catch (SourceNeverVisibleException | InvalidObsProgramParametersException exception) {
            throw new TimeEstimateInterface.UnableToGenerateTimeEstimateException(UNABLE_TO_GENERATE_TIME_ESTIMATE_MSG + exception.getMessage());
        }
        for (TimeSummary timeSummary : map.values()) {
            if (!timeSummary.getCalibrationObservation().isIncludedInTimeEstimateAccounting()) continue;
            time2 = timeSummary.getTotalCalibrationTime().convertToFriendlyUnit();
            Long l = timeSummary.getNumberOfCalibrationExecutions();
            CalType calType = timeSummary.getType();
            String string3 = calType.toString().equals("Delay") ? "Phase reference check source" : calType.toString();
            String string4 = l + " x " + string3;
            void var26_50 = var12_15 != null ? var12_15 : TextUtils.format(time2.convertToFriendlyUnit(), 2);
            timeEstimateModel.addClusterSpecificKeyValuePair("&nbsp;" + string4, (String)var26_50);
        }
        void var26_51 = var12_15 != null ? var12_15 : TextUtils.format(time10.convertToFriendlyUnit(), 2);
        timeEstimateModel.addClusterSpecificKeyValuePair("Calibration overheads", (String)var26_51);
        timeEstimateModel.addClusterSpecificKeyValuePair("", "");
        boolean bl = performanceParameters.gettrueUseTP();
        Time time13 = time6;
        if (bl) {
            void var30_68;
            timeEstimateModel.setDialogWindowDimensions(new Dimension(600, 1000));
            timeEstimateModel.addClusterSpecificKeyValuePair("<b>Additional Arrays</b>", "");
            if (time12 != null) {
                try {
                    time9 = (Time)time12.multiply(Configuration.getArrayTimeMultiplier(Configuration.MultiplierEnumType.ACATP, scienceGoal));
                    timeEstimateModel.addClusterSpecificKeyValuePair(String.format("ACA TP time (t_7m x %.3g)", Configuration.getArrayTimeMultiplier(Configuration.MultiplierEnumType.ACATP, scienceGoal)), TextUtils.format(time9, 2));
                }
                catch (InvalidObsProgramParametersException invalidObsProgramParametersException) {
                    Log.logger(StandardTimeEstimate.class).warning("Unable to determine multiplier for ACA TP");
                    timeEstimateModel.addClusterSpecificKeyValuePair("ACA TP time (t_7m x ?)", "ACA invalid with this configuration");
                }
            } else {
                time2 = Time.createTime();
                try {
                    time2 = schedBlockObservingTimeCalculator.getTotalArraySBScienceIntegrationTime(true, scienceGoal, Array.ARRAY_TP).convertToFriendlyUnit();
                    timeEstimateModel.addClusterSpecificKeyValuePair(TP_ON_SOURCE_TIME, TextUtils.format(time2, 2));
                }
                catch (UnknownEntityException | InvalidObsProgramParametersException throwable) {
                    timeEstimateModel.addClusterSpecificKeyValuePair(TP_ON_SOURCE_TIME, throwable.getMessage());
                }
                try {
                    time9 = schedBlockObservingTimeCalculator.getTotalRequestedTime(Array.ARRAY_TP, true, false, scienceGoal).convertToFriendlyUnit();
                    timeEstimateModel.addClusterSpecificKeyValuePair(TOTAL_TP_TIME, TextUtils.format(time9, 2));
                }
                catch (InvalidObsProgramParametersException invalidObsProgramParametersException) {
                    timeEstimateModel.addClusterSpecificKeyValuePair(TOTAL_TP_TIME, invalidObsProgramParametersException.getMessage());
                }
            }
            if (time12 != null) {
                Time time14 = time12.isGreaterThan((AbstractDoubleWithUnit)time9) ? time12 : time9;
            } else {
                Time time15 = time6.isGreaterThan((AbstractDoubleWithUnit)time9) ? time6 : time9;
            }
            String string5 = TextUtils.format(var30_68, 2);
            timeEstimateModel.addClusterSpecificKeyValuePair("Total ACA time (max[t_7-m,t_TP])", string5);
            timeEstimateModel.addClusterSpecificKeyValuePair("", "");
        }
        time2 = var30_69;
        if (time12 != null && bl) {
            time2 = (Time)time12.plus((AbstractDoubleWithUnit)var30_69);
        }
        if (n2 > 1) {
            timeEstimateModel.setDialogWindowDimensions(new Dimension(600, 1050));
            timeEstimateModel.addClusterSpecificKeyValuePair("Number of visits", n2.toString());
            String string6 = "<h3>" + TextUtils.format(((Time)time2.multiply(n2.intValue())).convertToFriendlyUnit(), 2) + "</h3>";
            timeEstimateModel.addClusterSpecificKeyValuePair(String.format("<h3>Estimated total time for cluster %d</h3>", n), string6);
        } else if (n3 > 0) {
            timeEstimateModel.addClusterSpecificKeyValuePair("No of continuous monitoring visits", n3.toString());
            String string7 = "<h3>" + TextUtils.format(time22.convertToFriendlyUnit(), 2) + "</h3>";
            timeEstimateModel.addClusterSpecificKeyValuePair(String.format("<h3>Estimated total time for continuous monitoring time for cluster %d </h3>", n), string7);
        } else {
            String string8 = "<b>" + TextUtils.format(time2.convertToFriendlyUnit(), 2) + "</b>";
            timeEstimateModel.addClusterSpecificKeyValuePair(String.format("<h3>Estimated total time for cluster %d</h3>", n), string8);
        }
        time.aggregate((Time)time2.multiply(n2.intValue()));
        timeEstimateModel.commitClusterSpecificData();
        return timeEstimateModel;
    }

    private boolean isLASRecoverableWithoutTPWithSACA(@NonNull ScienceGoal scienceGoal) throws TimeEstimateInterface.UnableToGenerateTimeEstimateException {
        if (scienceGoal == null) {
            throw new NullPointerException("scienceGoal is marked non-null but is null");
        }
        Configuration configuration = Configuration.getKnownConfigurations(RequestedArray.SEVEN_M).get(0);
        TargetParameters[] targetParametersArray = scienceGoal.getTargetParameters();
        PerformanceParameters performanceParameters = scienceGoal.getPerformanceParameters();
        try {
            return performanceParameters.getDesiredLargestScale().getContentInUnits(Angle.UNIT_ARCSEC) < configuration.getRecoverableScale(performanceParameters.getRepresentativeFrequency().getContentInGHz(), targetParametersArray, RequestedArray.SEVEN_M);
        }
        catch (InvalidConfigurationParametersException invalidConfigurationParametersException) {
            throw new TimeEstimateInterface.UnableToGenerateTimeEstimateException(invalidConfigurationParametersException.getMessage());
        }
    }

    public String toString() {
        return "StandardTimeEstimate(logger=" + this.logger + ", timeForAllScienceGoals=" + this.getTimeForAllScienceGoals() + ")";
    }

    public Time getTimeForAllScienceGoals() {
        return this.timeForAllScienceGoals;
    }
}

