/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.gui.preferences;

import alma.obsprep.obstooluserprefs.ObsToolUserPrefs;
import alma.obsprep.obstooluserprefs.types.DefaultEditorTypeType;
import alma.obsprep.obstooluserprefs.types.TabPlacementType;
import alma.obsprep.ot.gui.preferences.AbstractPanel;
import alma.obsprep.ot.gui.toplevel.ObservingToolGui;
import alma.obsprep.ot.gui.toplevel.PreferencesReadWrite;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import lombok.NonNull;

public class AppearancePanel
extends JPanel
implements PreferencesReadWrite {
    private final ObservingToolGui gui;
    JPanel pnlStripe1 = new JPanel();
    JPanel pnlStripe2 = new JPanel();
    JPanel pnlStripe3 = new JPanel();
    JPanel pnlStripe4 = new JPanel();
    JPanel pnlStripe5 = new JPanel();
    JPanel pnlStripe6 = new JPanel();
    JPanel pnlStripe8 = new JPanel();
    Border lineBorder = AbstractPanel.linedBorder;
    ButtonGroup buttonGroup1 = new ButtonGroup();
    JRadioButton btnTabPlacementTop = new JRadioButton();
    JRadioButton btnTabPlacementBottom = new JRadioButton();
    JList<String> lstPerspectives;
    JList<String> lstLookAndFeels;
    JComboBox<Integer> cmbFontsize = new JComboBox();
    JComboBox<Integer> cmbTooltipTime = new JComboBox();
    ButtonGroup grpScienceGoalSummary = new ButtonGroup();
    JRadioButton btnScienceGoalSummaryTable = new JRadioButton();
    JRadioButton btnScienceGoalSummaryPages = new JRadioButton();
    ButtonGroup grpFieldInsert = new ButtonGroup();
    JRadioButton btnFieldInsertOn = new JRadioButton();
    JRadioButton btnFieldInsertOff = new JRadioButton();
    JComboBox cmbEditorType = new JComboBox();

    public AppearancePanel(ObservingToolGui observingToolGui) {
        this.gui = observingToolGui;
        this.setName("AppearancePrefs");
        this.initialize();
    }

    /*
     * WARNING - void declaration
     */
    void initialize() {
        void var3_6;
        this.btnTabPlacementTop.setName("AppearancePrefs.btnTabPlacementTop");
        this.btnTabPlacementBottom.setName("AppearancePrefs.btnTabPlacementBottom");
        this.cmbFontsize.setName("AppearancePrefs.cmbFontsize");
        this.cmbTooltipTime.setName("AppearancePrefs.cmbTooltipTime");
        this.btnScienceGoalSummaryTable.setName("AppearancePrefs.btnScienceGoalSummaryTable");
        this.btnScienceGoalSummaryPages.setName("AppearancePrefs.btnScienceGoalSummaryPages");
        this.btnFieldInsertOn.setName("AppearancePrefs.btnFieldInsertOn");
        this.btnFieldInsertOff.setName("AppearancePrefs.btnFieldInsertOff");
        this.cmbEditorType.setName("AppearancePrefs.cmbEditorType");
        this.btnTabPlacementTop.setText("top");
        this.buttonGroup1.add(this.btnTabPlacementTop);
        this.btnTabPlacementBottom.setText("bottom");
        this.buttonGroup1.add(this.btnTabPlacementBottom);
        this.pnlStripe1.setBorder(new TitledBorder(this.lineBorder, "Tab Placement"));
        this.pnlStripe1.add(this.btnTabPlacementTop);
        this.pnlStripe1.add(this.btnTabPlacementBottom);
        Integer[] object = new Integer[]{8, 10, 12, 14, 16, 18, 20};
        int jScrollPane = object.length;
        boolean object2 = false;
        while (var3_6 < jScrollPane) {
            Integer n = object[var3_6];
            this.cmbFontsize.addItem(n);
            ++var3_6;
        }
        this.pnlStripe2.setBorder(new TitledBorder(this.lineBorder, "Font Size"));
        this.pnlStripe2.add(new JLabel("Font Size"));
        this.pnlStripe2.add(this.cmbFontsize);
        this.lstPerspectives = this.gui.getFactory().givePerspectivesList();
        this.lstPerspectives.setName("AppearancePrefs.lstPerspectives");
        this.pnlStripe3.setLayout(new BorderLayout());
        this.pnlStripe3.setBorder(new TitledBorder(this.lineBorder, "Perspective"));
        JScrollPane jScrollPane2 = new JScrollPane(this.lstPerspectives, 20, 31);
        this.pnlStripe3.add((Component)jScrollPane2, "Center");
        this.lstLookAndFeels = this.gui.getFactory().giveLookAndFeelList();
        this.lstLookAndFeels.setName("AppearancePrefs.lstLookAndFeels");
        this.pnlStripe4.setLayout(new BorderLayout());
        this.pnlStripe4.setBorder(new TitledBorder(this.lineBorder, "Look and Feel"));
        JScrollPane jScrollPane3 = new JScrollPane(this.lstLookAndFeels, 20, 31);
        this.pnlStripe4.add((Component)jScrollPane3, "Center");
        for (Integer n : new Integer[]{4, 8, 12, 20, 60}) {
            this.cmbTooltipTime.addItem(n);
        }
        this.pnlStripe5.setBorder(new TitledBorder(this.lineBorder, "Mouse-over Tooltips"));
        this.pnlStripe5.add(new JLabel("Show for"));
        this.pnlStripe5.add(this.cmbTooltipTime);
        this.pnlStripe5.add(new JLabel("secs."));
        this.pnlStripe6.setBorder(new TitledBorder(this.lineBorder, "Science Goal Summary View"));
        this.pnlStripe6.setLayout(new BoxLayout(this.pnlStripe6, 1));
        this.pnlStripe6.add(new JLabel("When looking at a Science Goal, show ..."));
        this.btnScienceGoalSummaryTable.setText("a summary table");
        this.btnScienceGoalSummaryPages.setText("all its page editors");
        this.grpScienceGoalSummary.add(this.btnScienceGoalSummaryTable);
        this.grpScienceGoalSummary.add(this.btnScienceGoalSummaryPages);
        this.pnlStripe6.add(this.btnScienceGoalSummaryTable);
        this.pnlStripe6.add(this.btnScienceGoalSummaryPages);
        this.pnlStripe8.setBorder(new TitledBorder(this.lineBorder, "Text Forms"));
        this.pnlStripe8.setLayout(new BoxLayout(this.pnlStripe8, 3));
        this.pnlStripe8.add(new JLabel("When putting the cursor into a form field, ..."));
        this.btnFieldInsertOff.setText("select it (for easy overwriting)");
        this.btnFieldInsertOn.setText("don't select it (for easy inserting)");
        this.grpFieldInsert.add(this.btnFieldInsertOff);
        this.grpFieldInsert.add(this.btnFieldInsertOn);
        this.pnlStripe8.add(this.btnFieldInsertOff);
        this.pnlStripe8.add(this.btnFieldInsertOn);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        this.add((Component)this.pnlStripe1, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        this.add((Component)this.pnlStripe2, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridx = 0;
        this.add((Component)this.pnlStripe5, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        this.add((Component)this.pnlStripe6, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridx = 0;
        this.add((Component)this.pnlStripe8, gridBagConstraints);
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        this.add((Component)this.pnlStripe3, gridBagConstraints);
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        this.add((Component)this.pnlStripe4, gridBagConstraints);
    }

    @Override
    public void readPreferences(@NonNull ObsToolUserPrefs obsToolUserPrefs) {
        if (obsToolUserPrefs == null) {
            throw new NullPointerException("model is marked non-null but is null");
        }
        this.btnTabPlacementTop.setSelected(obsToolUserPrefs.getTabPlacement().equals(TabPlacementType.TOP));
        this.btnTabPlacementBottom.setSelected(obsToolUserPrefs.getTabPlacement().equals(TabPlacementType.BOTTOM));
        this.lstPerspectives.setSelectedValue(obsToolUserPrefs.getPerspective(), true);
        this.lstLookAndFeels.setSelectedValue(obsToolUserPrefs.getLookAndFeel(), true);
        this.cmbFontsize.setSelectedItem((int)obsToolUserPrefs.getFontSize());
        this.cmbTooltipTime.setSelectedItem((int)obsToolUserPrefs.getTooltipDismissDelay());
        this.btnScienceGoalSummaryPages.setSelected(obsToolUserPrefs.getShowsAllWorkbookPagesAsSummary());
        this.btnScienceGoalSummaryTable.setSelected(!obsToolUserPrefs.getShowsAllWorkbookPagesAsSummary());
        this.cmbEditorType.setSelectedItem(obsToolUserPrefs.getDefaultEditorType());
        this.btnFieldInsertOn.setSelected(obsToolUserPrefs.getFieldInsert());
        this.btnFieldInsertOff.setSelected(!obsToolUserPrefs.getFieldInsert());
    }

    @Override
    public void writePreferences(@NonNull ObsToolUserPrefs obsToolUserPrefs) {
        if (obsToolUserPrefs == null) {
            throw new NullPointerException("model is marked non-null but is null");
        }
        obsToolUserPrefs.setTabPlacement(this.btnTabPlacementTop.isSelected() ? TabPlacementType.TOP : TabPlacementType.BOTTOM);
        obsToolUserPrefs.setPerspective(String.valueOf(this.lstPerspectives.getSelectedValue()));
        obsToolUserPrefs.setLookAndFeel(String.valueOf(this.lstLookAndFeels.getSelectedValue()));
        obsToolUserPrefs.setFontSize((long)((Integer)this.cmbFontsize.getSelectedItem()).intValue());
        obsToolUserPrefs.setTooltipDismissDelay((long)((Integer)this.cmbTooltipTime.getSelectedItem()).intValue());
        obsToolUserPrefs.setShowsAllWorkbookPagesAsSummary(this.btnScienceGoalSummaryPages.isSelected());
        obsToolUserPrefs.setFieldInsert(this.btnFieldInsertOn.isSelected());
        obsToolUserPrefs.setDefaultEditorType((DefaultEditorTypeType)this.cmbEditorType.getSelectedItem());
    }
}

