/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.models.obsproject;

import alma.hla.runtime.obsprep.bo.BusinessObject;
import alma.hla.runtime.obsprep.util.Log;
import alma.hla.runtime.obsprep.util.UnknownEntityException;
import alma.observatorycharacteristics.policies.AlmaPolicies;
import alma.obsprep.bo.EntityIdFactoryImpl;
import alma.obsprep.bo.obsattachment.DocumentLink;
import alma.obsprep.bo.obsattachment.ObsAttachment;
import alma.obsprep.bo.obsproject.AbstractScienceGoal;
import alma.obsprep.bo.obsproject.CalibrationSetupParameters;
import alma.obsprep.bo.obsproject.ObsProject;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproposal.Investigator;
import alma.obsprep.bo.obsproposal.ObsProposal;
import alma.obsprep.guiutil.mvc.Editor;
import alma.obsprep.guiutil.mvc.FieldID;
import alma.obsprep.guiutil.mvc.Model;
import alma.obsprep.guiutil.mvc.ModelChangeSubscriber;
import alma.obsprep.ot.boEditors.FieldIDs;
import alma.obsprep.ot.editors.investigator.TableInvestigator;
import alma.obsprep.ot.editors.obsproject.ObsProposalEditor;
import alma.obsprep.ot.models.obsproject.CalibrationSetupParametersModel;
import alma.obsprep.ot.models.obsproject.JointProposalModel;
import alma.obsprep.services.experts.VLBIExpert;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import javax.swing.JList;
import lombok.NonNull;

public class ObsProposalModel
extends Model
implements ModelChangeSubscriber {
    public static final String VLBI = "VLBI";
    private final AlmaPolicies almaPolicies = AlmaPolicies.getInstance();
    private int[] oldKeywords = new int[0];
    private int previousKeyword = -1;
    private int currentKeyword = -1;
    private JointProposalModel jointProposalModel;
    private boolean isMentorPhD = false;

    public ObsProposalModel(Object object) {
        super(object);
        if (object instanceof ObsProposal) {
            ObsProposal obsProposal = (ObsProposal)object;
            this.jointProposalModel = new JointProposalModel((Object)obsProposal.getJointProposal());
        } else {
            this.jointProposalModel = new JointProposalModel(null);
        }
        this.registerSubModel(this.jointProposalModel);
        this.subscribe(this.jointProposalModel);
        this.jointProposalModel.subscribe(this);
    }

    public boolean isLargeProgram() {
        ObsProposal obsProposal = this.getObsProposal();
        if (obsProposal == null) {
            Log.logger(ObsProposalModel.class).warning("");
            return false;
        }
        return obsProposal.getProposalTypeCode().equals("L");
    }

    public ObsProposal getObsProposal() {
        ObsProposal obsProposal = this.getTrueObsProposal();
        if (obsProposal == null) {
            obsProposal = ObsProposal.createObsProposal();
            this.setDocument(obsProposal);
        }
        return obsProposal;
    }

    public boolean isDDT() {
        ObsProject obsProject;
        ObsProposal obsProposal = this.getTrueObsProposal();
        if (obsProposal == null) {
            return false;
        }
        try {
            obsProject = obsProposal.getObsProject();
        }
        catch (UnknownEntityException unknownEntityException) {
            return false;
        }
        return obsProject != null ? obsProject.getIsDDT() : false;
    }

    private ObsProposal getTrueObsProposal() {
        return (ObsProposal)this.getDocument();
    }

    public ObsAttachment gettrueAttachments() throws UnknownEntityException {
        ObsAttachment obsAttachment = null;
        obsAttachment = this.getObsProposal().gettrueDocuments();
        return obsAttachment;
    }

    public ObsAttachment getAttachments() throws UnknownEntityException {
        ObsAttachment obsAttachment = this.gettrueAttachments();
        if (obsAttachment == null) {
            obsAttachment = ObsAttachment.createObsAttachment();
            this.getObsProposal().setDocuments(obsAttachment);
        }
        return obsAttachment;
    }

    @Override
    public void publish() {
        ObsProposal obsProposal = this.getObsProposal();
        if (obsProposal == null) {
            return;
        }
        this.publish(ObsProposalEditor.THIS_FID, obsProposal);
        this.publish(ObsProposalEditor.IS_SCHEDULING_FEASIBLE_FID, obsProposal.getSchedulingFeasibility() ? "Yes" : "No");
        this.publish(ObsProposalEditor.CATEGORY_FID, obsProposal.getScientificCategoryString());
        this.publish(ObsProposalEditor.KEYWORDS_FID, obsProposal.getKeyword());
        this.publish(ObsProposalEditor.ABSTRACT_FID, obsProposal.getAbstract());
        this.publish(ObsProposalEditor.PROPOSALTYPE_FID, obsProposal.getProposalTypeString());
        this.publish(ObsProposalEditor.ADVANCEDPROPOSALTYPE_FID, obsProposal.getProposalTypeString());
        this.publish(ObsProposalEditor.RELATEDPROPS_FID, obsProposal.getRelatedProposals());
        this.publish(ObsProposalEditor.DUPLICATE_OBSERVATION_FID, obsProposal.getDuplicateObservationsJustification());
        this.publish(ObsProposalEditor.PREVIOUSPROPS_FID, obsProposal.getPreviousProposals());
        this.publish(ObsProposalEditor.DATERECEIVED_FID, obsProposal.getDateReceived());
        this.publish(ObsProposalEditor.CYCLE_FID, obsProposal.getCycle());
        this.publish(ObsProposalEditor.STUDENT_FID, obsProposal.getStudentProject());
        if (obsProposal.gettrueReviewer() != null) {
            boolean bl = obsProposal.getReviewer().getHasPhD();
            this.publish(ObsProposalEditor.REVIEWERHASPHD_FID, bl ? "Yes" : "No");
            if (obsProposal.gettrueMentor() != null && !bl) {
                this.publish(ObsProposalEditor.MENTOR_HAS_PHD_FID, obsProposal.getMentor().getHasPhD() ? "Yes" : "No");
                this.publish(ObsProposalEditor.MENTOR_NAME_FID, obsProposal.getMentor().getFullName());
            } else {
                this.publish(ObsProposalEditor.MENTOR_NAME_FID, "");
            }
        } else {
            this.publish(ObsProposalEditor.REVIEWERHASPHD_FID, "No");
            this.publish(ObsProposalEditor.MENTOR_HAS_PHD_FID, "No");
        }
        this.publishDocumentFilename(DocumentLink.DOCUMENTCLASS_SCIENCE_CASE);
        this.publishDocumentFilename(DocumentLink.DOCUMENTCLASS_MANAGEMENT_PLAN);
        this.publishDocumentFilename(DocumentLink.DOCUMENTCLASS_FIGURES);
        this.publishDocumentFilename(DocumentLink.DOCUMENTCLASS_TECHNICAL_CASE);
        this.publishDocumentFilename(DocumentLink.DOCUMENTCLASS_TABLES);
        this.publish(FieldIDs.investigatorClearAllFID, null);
        this.publish(FieldIDs.investigatorSetPiFID, (Object)obsProposal.getPrincipalInvestigator());
        List<Investigator> list = Arrays.asList(obsProposal.getCoPrincipalInvestigator());
        this.publish(FieldIDs.investigatorAddCoPiFID, list);
        List<Investigator> list2 = Arrays.asList(obsProposal.getCoInvestigator());
        this.publish(FieldIDs.investigatorAddCoiFID, list2);
    }

    @Override
    public void setDocument(Object object) {
        ObsProject obsProject;
        ObsProposal obsProposal;
        super.setDocument(object);
        Model model = this.getParentModel();
        if (object instanceof ObsProposal) {
            obsProposal = (ObsProposal)object;
            this.jointProposalModel.setDocument((Object)obsProposal.getJointProposal());
        }
        if ((model != null || object instanceof ObsProposal) && (obsProject = (obsProposal = (BusinessObject)object).findProject()) != null) {
            if (!model.getDocument().equals(obsProject)) {
                model.setDocument(obsProject);
            }
            this.publish(FieldIDs.projectNameFID, obsProject.getProjectName());
            this.publish(ObsProposalEditor.THIS_FID, obsProject);
        }
    }

    public void publishProposalType() {
        ObsProposal obsProposal = this.getObsProposal();
        if (obsProposal == null) {
            return;
        }
        this.publish(ObsProposalEditor.PROPOSALTYPE_FID, obsProposal.getProposalTypeString());
    }

    private synchronized void checkKeywordsInRange(Editor editor, JList<String> jList) {
        int[] nArray = jList.getSelectedIndices();
        Arrays.sort(this.oldKeywords);
        for (int n : nArray) {
            if (Arrays.binarySearch(this.oldKeywords, n) >= 0) continue;
            this.currentKeyword = n;
            break;
        }
        if (this.currentKeyword == this.previousKeyword) {
            return;
        }
        if (nArray.length > 2) {
            editor.suspendEvents(jList);
            int[] nArray2 = new int[]{this.previousKeyword, this.currentKeyword};
            jList.setSelectedIndices(nArray2);
            this.oldKeywords = nArray2;
            editor.resumeEvents(jList);
        } else {
            this.oldKeywords = nArray;
        }
        this.previousKeyword = this.currentKeyword;
    }

    @Override
    public Object update(Editor editor, FieldID fieldID, Object object) {
        Object object2;
        Object object3;
        if (fieldID.equals(FieldIDs.investigatorSetPiFID)) {
            if (object instanceof Investigator) {
                Investigator investigator = (Investigator)((Object)object);
                this.setPrincipalInvestigator(investigator);
            }
            return object;
        }
        ObsProposal obsProposal = this.getObsProposal();
        if (fieldID.equals(FieldIDs.investigatorAddCoiFID)) {
            if (object instanceof List) {
                for (Investigator investigator : (List)object) {
                    this.addCoInvestigator(investigator);
                }
            }
            return object;
        }
        if (fieldID.equals(FieldIDs.investigatorRemoveCoiFID)) {
            if (object instanceof List) {
                for (TableInvestigator tableInvestigator : (List)object) {
                    this.deleteCoI(tableInvestigator.getInvestigator());
                }
            }
            return object;
        }
        if (fieldID.equals(FieldIDs.investigatorAddCoPiFID)) {
            if (object instanceof List) {
                for (Investigator investigator : (List)object) {
                    this.addCoPrincipalInvestigator(investigator);
                }
            }
            return object;
        }
        if (fieldID.equals(FieldIDs.investigatorRemoveCoPiFID)) {
            if (object instanceof List) {
                for (TableInvestigator tableInvestigator : (List)object) {
                    this.deleteCoPrincipalInvestigator(tableInvestigator.getInvestigator());
                }
            }
            return object;
        }
        if (fieldID == ObsProposalEditor.KEYWORDS_FID) {
            JList jList = (JList)editor.getComponent(ObsProposalEditor.KEYWORDS_FID);
            this.checkKeywordsInRange(editor, jList);
            Object[] objectArray = jList.getSelectedValues();
            String[] stringArray = new String[objectArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = objectArray[i].toString();
            }
            obsProposal.setKeyword(stringArray);
            String[] stringArray2 = new String[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray2[i] = this.almaPolicies.getScienceKeywordCode(stringArray[i]);
            }
            obsProposal.setKeywordCode(stringArray2);
            return stringArray;
        }
        if (fieldID == ObsProposalEditor.MENTOR_FID) {
            object3 = (Investigator)((Object)object);
            if (object3 != null) {
                this.getObsProposal().setMentor((Investigator)((Object)object3));
                object3.setHasPhD(this.isMentorPhD);
                this.publish(ObsProposalEditor.MENTOR_NAME_FID, object3.getFullName());
            }
        } else if (fieldID == ObsProposalEditor.MENTOR_HAS_PHD_FID) {
            object3 = (String)object;
            this.isMentorPhD = ((String)object3).equals("Yes");
            object2 = this.getObsProposal().getMentor();
            object2.setHasPhD(this.isMentorPhD);
        }
        object3 = object.toString();
        if (fieldID == ObsProposalEditor.CATEGORY_FID) {
            String string = this.almaPolicies.getScienceCodeForCategory((String)object3);
            obsProposal.setScientificCategoryCode(string);
            obsProposal.setScientificCategoryString((String)object3);
            String[] stringArray = this.almaPolicies.getScienceKeywords(string);
            JList jList = (JList)editor.getComponent(ObsProposalEditor.KEYWORDS_FID);
            jList.setListData(stringArray);
        } else if (fieldID == ObsProposalEditor.ABSTRACT_FID) {
            obsProposal.setAbstract((String)object3);
        } else if (fieldID == ObsProposalEditor.REVIEWERHASPHD_FID) {
            boolean bl = object.toString().equals("Yes");
            obsProposal.getReviewer().setHasPhD(bl);
            if (bl) {
                obsProposal.setMentor(null);
                this.isMentorPhD = false;
                this.publish(ObsProposalEditor.MENTOR_HAS_PHD_FID, "No");
                this.publish(ObsProposalEditor.MENTOR_NAME_FID, "");
            }
        } else if (fieldID == ObsProposalEditor.DUPLICATE_OBSERVATION_FID) {
            obsProposal.setDuplicateObservationsJustification((String)object3);
        } else if (fieldID == ObsProposalEditor.IS_SCHEDULING_FEASIBLE_FID && object instanceof String) {
            object2 = (String)object;
            boolean bl = ((String)object2).equals("Yes");
            obsProposal.setSchedulingFeasibility(bl);
        } else if (fieldID == ObsProposalEditor.PROPOSALTYPE_FID) {
            this.setProposalType(obsProposal, (String)object3);
        } else if (fieldID == ObsProposalEditor.ADVANCEDPROPOSALTYPE_FID) {
            String string = this.almaPolicies.getCodeForProposalType((String)object3);
            if (string.equals("?")) {
                string = this.almaPolicies.getCodeForObservatoryType((String)object3);
            }
            obsProposal.setProposalTypeCode(string);
            obsProposal.setProposalTypeString((String)object3);
        } else if (fieldID == ObsProposalEditor.RELATEDPROPS_FID) {
            obsProposal.setRelatedProposals((String)object3);
        } else if (fieldID == ObsProposalEditor.PREVIOUSPROPS_FID) {
            obsProposal.setPreviousProposals((String)object3);
        } else if (fieldID != ObsProposalEditor.DATERECEIVED_FID) {
            if (fieldID == ObsProposalEditor.CYCLE_FID) {
                obsProposal.setCycle((String)object3);
            } else if (fieldID == ObsProposalEditor.STUDENT_FID) {
                obsProposal.setStudentProject((Boolean)object);
            }
        }
        return object3;
    }

    private void setProposalType(@NonNull ObsProposal obsProposal, @NonNull String string) {
        boolean bl;
        if (obsProposal == null) {
            throw new NullPointerException("obsProposal is marked non-null but is null");
        }
        if (string == null) {
            throw new NullPointerException("proposalType is marked non-null but is null");
        }
        String string2 = this.almaPolicies.getCodeForProposalType(string);
        boolean bl2 = obsProposal.isVLBIorPhasedArray();
        obsProposal.setProposalTypeCode(string2);
        obsProposal.setProposalTypeString(string);
        boolean bl3 = ObsProposal.isProjectCodeVLBIRelated(string2);
        if (bl3 && !bl2) {
            try {
                VLBIExpert.setToVLBIDefaultSpectralConfiguration(obsProposal);
            }
            catch (VLBIExpert.InvalidVLBIModeException invalidVLBIModeException) {
                Log.logger(ObsProposalModel.class).warning("Invalid VLBI mode detected");
            }
        }
        if (obsProposal.isPhasedArray()) {
            this.configureForVLBIPulsarMode();
        } else if (!obsProposal.isVLBIorPhasedArray()) {
            ObsProposalModel.setVLBIPassivePhasing(obsProposal, false);
        }
        if (bl2 && !bl3) {
            obsProposal.resetTDMSpectralAveragingForProposal();
        }
        this.scheduleACAInAllScienceGoals();
        if (!this.isLargeProgram()) {
            try {
                this.detachDocument(DocumentLink.DOCUMENTCLASS_MANAGEMENT_PLAN);
            }
            catch (UnknownEntityException unknownEntityException) {
                // empty catch block
            }
        }
        if (bl = string2.equals("L")) {
            this.removeReviewerInformation(obsProposal);
        }
        if (bl || bl3) {
            Stream.of(obsProposal.getAbstractScienceGoalScienceGoal()).forEach(scienceGoal -> scienceGoal.getCalibrationSetupParameters().setPositionalAccuracy(CalibrationSetupParameters.POSITIONALACCURACY_STANDARD));
        }
    }

    private void removeReviewerInformation(@NonNull ObsProposal obsProposal) {
        if (obsProposal == null) {
            throw new NullPointerException("obsProposal is marked non-null but is null");
        }
        obsProposal.setReviewer(null);
        obsProposal.setMentor(null);
    }

    private void configureForVLBIPulsarMode() {
        ObsProposal obsProposal = this.getObsProposal();
        if (obsProposal != null) {
            ObsProposalModel.setVLBIPassivePhasing(obsProposal, true);
            this.setVLBIUserCalibrationMode(obsProposal);
        }
    }

    private void setVLBIUserCalibrationMode(@NonNull ObsProposal obsProposal) {
        if (obsProposal == null) {
            throw new NullPointerException("obsProposal is marked non-null but is null");
        }
        Stream.of(obsProposal.getAbstractScienceGoalScienceGoal()).forEach(scienceGoal -> {
            CalibrationSetupParameters calibrationSetupParameters = scienceGoal.getCalibrationSetupParameters();
            if (!calibrationSetupParameters.isUserDefinedCalibration()) {
                calibrationSetupParameters.setSelection(CalibrationSetupParameters.SELECTION_USER);
                new CalibrationSetupParametersModel(calibrationSetupParameters).setDefaultCalibratorIntents();
            }
        });
    }

    public static void setVLBIPassivePhasing(@NonNull ObsProposal obsProposal, boolean bl) {
        if (obsProposal == null) {
            throw new NullPointerException("obsProposal is marked non-null but is null");
        }
        List<ScienceGoal> list = Arrays.asList(obsProposal.getAbstractScienceGoalScienceGoal());
        list.stream().forEach(scienceGoal -> Arrays.asList(scienceGoal.getTargetParameters()).stream().forEach(targetParameters -> targetParameters.getExpectedProperties().setIsPassivePhasing(bl)));
    }

    private void scheduleACAInAllScienceGoals() {
        for (AbstractScienceGoal abstractScienceGoal : this.getObsProposal().getAbstractScienceGoal()) {
            if (!(abstractScienceGoal instanceof ScienceGoal)) continue;
            ScienceGoal scienceGoal = (ScienceGoal)((Object)abstractScienceGoal);
            ScienceGoal.determineACAScheduling(scienceGoal);
        }
    }

    public void resetProposalType() {
        ObsProposal obsProposal = this.getObsProposal();
        obsProposal.setProposalTypeCode(null);
        obsProposal.setProposalTypeString(null);
    }

    void publishDocumentFilename(String string) {
        ObsAttachment obsAttachment;
        try {
            obsAttachment = this.gettrueAttachments();
        }
        catch (UnknownEntityException unknownEntityException) {
            obsAttachment = null;
        }
        if (obsAttachment == null) {
            this.publish(ObsProposalEditor.SCIDOCUMENT_FID, null);
            this.publish(ObsProposalEditor.FIGURES_FID, null);
            this.publish(ObsProposalEditor.TECHDOCUMENT_FID, null);
            this.publish(ObsProposalEditor.TABLES_FID, null);
            this.publish(ObsProposalEditor.TEAM_EXPERTISE_DOCUMENT_FID, null);
            return;
        }
        if (string.equals(DocumentLink.DOCUMENTCLASS_SCIENCE_CASE)) {
            this.publish(ObsProposalEditor.SCIDOCUMENT_FID, (Object)obsAttachment.gettrueDocumentLink(string));
        } else if (string.equals(DocumentLink.DOCUMENTCLASS_TECHNICAL_CASE)) {
            this.publish(ObsProposalEditor.TECHDOCUMENT_FID, (Object)obsAttachment.gettrueDocumentLink(string));
        } else if (string.equals(DocumentLink.DOCUMENTCLASS_FIGURES)) {
            this.publish(ObsProposalEditor.FIGURES_FID, (Object)obsAttachment.gettrueDocumentLink(string));
        } else if (string.equals(DocumentLink.DOCUMENTCLASS_TABLES)) {
            this.publish(ObsProposalEditor.TABLES_FID, (Object)obsAttachment.gettrueDocumentLink(string));
        } else if (string.equals(DocumentLink.DOCUMENTCLASS_MANAGEMENT_PLAN)) {
            this.publish(ObsProposalEditor.TEAM_EXPERTISE_DOCUMENT_FID, (Object)obsAttachment.gettrueDocumentLink(string));
        }
    }

    public void attachDocument(File file, String string) throws UnknownEntityException {
        this.getAttachments().attachDocument(file, string);
        this.publishDocumentFilename(string);
    }

    public void detachDocument(String string) throws UnknownEntityException {
        this.getAttachments().detachDocument(string);
        this.publishDocumentFilename(string);
        if (this.getAttachments().getDocumentLinkCount() == 0) {
            this.getObsProposal().setDocuments(null);
        }
    }

    public Investigator getPrincipalInvestigator() {
        Investigator investigator = this.getTruePrincipalInvestigator();
        if (investigator == null) {
            investigator = Investigator.createInvestigator();
            this.getObsProposal().setPrincipalInvestigator(investigator);
        }
        return investigator;
    }

    private Investigator getTruePrincipalInvestigator() {
        ObsProposal obsProposal = this.getTrueObsProposal();
        if (obsProposal == null) {
            return null;
        }
        return obsProposal.getPrincipalInvestigator();
    }

    public void setPrincipalInvestigator(Investigator investigator) {
        if (investigator != null) {
            this.getObsProposal().setPrincipalInvestigator(investigator);
        }
    }

    public int addCoInvestigator(Investigator investigator) {
        if (!this.getCoInvestigators().contains((Object)investigator)) {
            this.getObsProposal().addCoInvestigator(investigator);
        }
        return this.getCoInvestigators().indexOf((Object)investigator);
    }

    public int addCoPrincipalInvestigator(Investigator investigator) {
        if (!this.getCoInvestigators().contains((Object)investigator)) {
            this.getObsProposal().addCoPrincipalInvestigator(investigator);
        }
        return this.getCoPrincipalInvestigators().indexOf((Object)investigator);
    }

    public void addCoInvestigators(Investigator[] investigatorArray) {
        if (investigatorArray != null) {
            for (Investigator investigator : investigatorArray) {
                this.addCoInvestigator(investigator);
            }
        }
    }

    public void deleteCoI(Investigator investigator) {
        this.getObsProposal().removeCoInvestigator(investigator);
    }

    public void deleteCoPrincipalInvestigator(Investigator investigator) {
        this.getObsProposal().removeCoPrincipalInvestigator(investigator);
    }

    public Investigator getCoInvestigator(int n) {
        Investigator[] investigatorArray = this.getObsProposal().getCoInvestigator();
        if (n > investigatorArray.length - 1) {
            return null;
        }
        return investigatorArray[n];
    }

    public Investigator getCoPrincipalInvestigator(int n) {
        Investigator[] investigatorArray = this.getObsProposal().getCoPrincipalInvestigator();
        if (n > investigatorArray.length - 1) {
            return null;
        }
        return investigatorArray[n];
    }

    public List<Investigator> getCoInvestigators() {
        List<Investigator> list = this.getTrueCoInvestigators();
        if (list == null) {
            list = new ArrayList<Investigator>();
            Investigator[] investigatorArray = list.toArray(new Investigator[list.size()]);
            this.getObsProposal().setCoInvestigator(investigatorArray);
        }
        return list;
    }

    public List<Investigator> getCoPrincipalInvestigators() {
        List<Investigator> list = this.getTrueCoPrincipalInvestigators();
        if (list == null) {
            list = new ArrayList<Investigator>();
            Investigator[] investigatorArray = list.toArray(new Investigator[list.size()]);
            this.getObsProposal().setCoPrincipalInvestigator(investigatorArray);
        }
        return list;
    }

    private List<Investigator> getTrueCoInvestigators() {
        ObsProposal obsProposal = this.getTrueObsProposal();
        if (obsProposal == null) {
            return null;
        }
        return Arrays.asList(obsProposal.getCoInvestigator());
    }

    private List<Investigator> getTrueCoPrincipalInvestigators() {
        ObsProposal obsProposal = this.getTrueObsProposal();
        if (obsProposal == null) {
            return null;
        }
        return Arrays.asList(obsProposal.getCoPrincipalInvestigator());
    }

    public void setCoInvestigator(Investigator investigator) {
        if (investigator != null) {
            List<Investigator> list = this.getCoInvestigators();
            int n = 0;
            for (Investigator investigator2 : list) {
                if (investigator2.getUserId().equals(investigator.getUserId())) {
                    list.set(n, investigator);
                    break;
                }
                ++n;
            }
            list.set(n, investigator);
            this.getObsProposal().setCoInvestigator(list.toArray(new Investigator[list.size()]));
        }
    }

    public void setCoPrincipalInvestigator(Investigator investigator) {
        if (investigator != null) {
            List<Investigator> list = this.getCoPrincipalInvestigators();
            int n = 0;
            for (Investigator investigator2 : list) {
                if (investigator2.getUserId().equals(investigator.getUserId())) {
                    list.set(n, investigator);
                    break;
                }
                ++n;
            }
            this.getObsProposal().setCoPrincipalInvestigator(list.toArray(new Investigator[list.size()]));
        }
    }

    public void setReviewer(@NonNull Optional<Investigator> optional) {
        if (optional == null) {
            throw new NullPointerException("investigator is marked non-null but is null");
        }
        ObsProposal obsProposal = this.getObsProposal();
        if (optional.isPresent()) {
            obsProposal.setReviewer(optional.get().deepCopy());
            obsProposal.getReviewer().setHasPhD(false);
        } else {
            obsProposal.setReviewer(null);
        }
        this.publish();
    }

    public boolean isMentorRequired() {
        ObsProposal obsProposal = this.getObsProposal();
        if (obsProposal == null) {
            return true;
        }
        Investigator investigator = obsProposal.gettrueReviewer();
        if (investigator == null) {
            return true;
        }
        if (!investigator.getUserId().equals(obsProposal.getPrincipalInvestigator().getUserId())) {
            return false;
        }
        return !investigator.getHasPhD();
    }

    public boolean isDPRRequired() {
        ObsProject obsProject;
        ObsProposal obsProposal = this.getObsProposal();
        if (obsProposal == null) {
            Log.logger(ObsProposalModel.class).warning("Unable to find obsproposal");
            return false;
        }
        try {
            obsProject = obsProposal.getObsProject();
        }
        catch (UnknownEntityException unknownEntityException) {
            Log.logger(ObsProposalModel.class).warning("Unable to find obsproject");
            return false;
        }
        if (obsProject == null) {
            return false;
        }
        return obsProject.isDPRRequired();
    }

    public boolean isResubmission(String string) {
        boolean bl = !EntityIdFactoryImpl.isOnTheFlyId(string);
        return bl;
    }

    @Override
    public void modelChanged(Model model, FieldID fieldID, Object object) {
        this.publish(fieldID, object);
    }

    public void setJointProposalEnabled(boolean bl) {
        this.getJointProposalModel().setJointProposalsEnabled(bl);
    }

    public JointProposalModel getJointProposalModel() {
        return this.jointProposalModel;
    }
}

