/*
 * Decompiled with CFR 0.152.
 */
package alma.obsprep.ot.project;

import alma.hla.runtime.obsprep.bo.BusinessObject;
import alma.obsprep.bo.FieldSourceCollection;
import alma.obsprep.bo.InstrumentSpecCollection;
import alma.obsprep.bo.ObservingParametersCollection;
import alma.obsprep.bo.TargetCollection;
import alma.obsprep.bo.annotations.BOWithOwnRenderer;
import alma.obsprep.bo.obsproject.Circle;
import alma.obsprep.bo.obsproject.Ellipse;
import alma.obsprep.bo.obsproject.ObsProgram;
import alma.obsprep.bo.obsproject.ObsProject;
import alma.obsprep.bo.obsproject.ObsUnitSet;
import alma.obsprep.bo.obsproject.ObservatoryGoal;
import alma.obsprep.bo.obsproject.OpticalPointingScienceGoal;
import alma.obsprep.bo.obsproject.Polygon;
import alma.obsprep.bo.obsproject.Rectangle;
import alma.obsprep.bo.obsproject.ScienceGoal;
import alma.obsprep.bo.obsproposal.ObsProposal;
import alma.obsprep.bo.schedblock.ObservingGroup;
import alma.obsprep.bo.schedblock.SchedBlock;
import alma.obsprep.bo.schedblock.Target;
import alma.obsprep.ot.gui.resources.ColorPalette;
import alma.obsprep.ot.gui.resources.Icons;
import alma.obsprep.ot.project.OTTree;
import alma.obsprep.ot.project.ProjectTreeNode;
import alma.obsprep.ot.project.ProjectTreeTransferHandler;
import alma.obsprep.util.MiscUtils;
import alma.obsprep.util.OverlayedIcon;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import lombok.NonNull;

public class ProjectTreeNodeRenderer
extends DefaultTreeCellRenderer {
    private final Color HIGHLIGHT_COLOR = Color.decode("#D2D1EB");

    @Override
    public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        int n2;
        BOWithOwnRenderer bOWithOwnRenderer;
        ProjectTreeNode projectTreeNode = (ProjectTreeNode)object;
        Object object2 = projectTreeNode.getUserObject();
        super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
        ColorPalette colorPalette = ((OTTree)jTree).getColorPalette();
        if (ProjectTreeTransferHandler.isClipboarded(projectTreeNode)) {
            this.setForeground(colorPalette.getClipboardColor());
        } else {
            this.setForeground(colorPalette.getForegroundColor());
        }
        if (projectTreeNode.isHighlighted()) {
            this.setBackgroundNonSelectionColor(this.HIGHLIGHT_COLOR);
        } else {
            this.setBackgroundNonSelectionColor(null);
        }
        Class<?> clazz = object2.getClass();
        if (object2 instanceof BOWithOwnRenderer) {
            bOWithOwnRenderer = (BOWithOwnRenderer)object2;
            bOWithOwnRenderer.getTreeCellRendererComponent(this, jTree, object, bl, bl2, bl3, n, bl4);
        } else if (clazz.equals(ObsProject.class)) {
            this.renderObsProject();
        } else if (clazz.equals(ObsProposal.class)) {
            this.renderObsProposal();
        } else if (clazz.equals(ObsProgram.class)) {
            this.renderObsProgram();
        } else if (clazz.equals(Circle.class)) {
            this.renderCircle();
        } else if (clazz.equals(Rectangle.class)) {
            this.renderRectangle();
        } else if (clazz.equals(Ellipse.class)) {
            this.renderEllipse();
        } else if (clazz.equals(Polygon.class)) {
            this.renderPolygon();
        } else if (clazz.equals(SchedBlock.class)) {
            this.renderSchedBlock((SchedBlock)object2);
        } else if (clazz.equals(ObservingGroup.class)) {
            this.renderObservingGroup();
        } else if (clazz.equals(Target.class)) {
            this.renderTarget();
        } else if (clazz.equals(ObsUnitSet.class)) {
            this.renderObsUnitSet((ObsUnitSet)object2);
        } else if (clazz.equals(OpticalPointingScienceGoal.class)) {
            this.renderOpticalPointingScienceGoal();
        } else if (clazz.equals(ScienceGoal.class)) {
            this.renderScienceGoal((ScienceGoal)object2);
        } else if (clazz.equals(ObservatoryGoal.class)) {
            this.renderObservatoryGoal();
        } else if (object2 instanceof TargetCollection) {
            this.renderTargetFolder();
        } else if (object2 instanceof FieldSourceCollection) {
            this.renderFieldSourceFolder();
        } else if (object2 instanceof InstrumentSpecCollection) {
            this.renderInstrumentSpecFolder();
        } else if (object2 instanceof ObservingParametersCollection) {
            this.renderIntentsFolder();
        } else {
            this.setIcon(Icons.foldedFolder);
            this.setNodeToolTip(null);
        }
        if (object2 instanceof BusinessObject) {
            bOWithOwnRenderer = (BusinessObject)object2;
            String string = "previous_text_" + jTree.hashCode();
            String string2 = (String)bOWithOwnRenderer.getNameValue(string);
            String string3 = this.getText();
            if (!string3.equals(string2)) {
                if (string2 != null) {
                    ((OTTree)jTree).sizesRecalculationNeeded();
                }
                bOWithOwnRenderer.setNameValue(string, string3);
            }
        }
        if (((n2 = projectTreeNode.getErrorStatus()) & 8) != 0) {
            this.setIcon(new OverlayedIcon(this.getIcon(), Icons.error_overlay));
        } else if ((n2 & 4) != 0) {
            this.setIcon(new OverlayedIcon(this.getIcon(), Icons.warning_overlay));
        }
        if ((n2 & 2) != 0) {
            this.setFont(MiscUtils.italicize(this.getFont()));
        } else {
            this.setFont(jTree.getFont());
        }
        return this;
    }

    private void setNodeToolTip(String string) {
        Object object = string != null ? (string.length() > 250 ? "<html><body width=350>" + string.subSequence(0, 250) + "...</body></html>" : (string.length() > 80 ? "<html><body width=350>" + string + "</body></html>" : string)) : string;
        this.setToolTipText((String)object);
    }

    private void renderObsProject() {
        this.setIcon(Icons.project);
        this.setNodeToolTip(null);
    }

    private void renderObsProposal() {
        this.setIcon(Icons.proposal);
        this.setNodeToolTip(null);
    }

    private void renderObsProgram() {
        this.setIcon(Icons.program);
        this.setNodeToolTip(null);
    }

    private void renderObservingGroup() {
        this.setIcon(Icons.observingGroup);
        this.setNodeToolTip(null);
    }

    private void renderTarget() {
        this.setIcon(Icons.target);
        this.setNodeToolTip(null);
    }

    private void renderTargetFolder() {
        this.setIcon(Icons.targetFolder);
        this.setNodeToolTip(null);
    }

    private void renderFieldSourceFolder() {
        this.setIcon(Icons.targetFolder);
        this.setNodeToolTip(null);
    }

    private void renderInstrumentSpecFolder() {
        this.setIcon(Icons.targetFolder);
        this.setNodeToolTip(null);
    }

    private void renderIntentsFolder() {
        this.setIcon(Icons.calibratorFolder);
        this.setNodeToolTip(null);
    }

    private void renderCircle() {
        this.setIcon(Icons.circle);
        this.setNodeToolTip(null);
    }

    private void renderRectangle() {
        this.setIcon(Icons.rectangle);
        this.setNodeToolTip(null);
    }

    private void renderEllipse() {
        this.setIcon(Icons.ellipse);
        this.setNodeToolTip(null);
    }

    private void renderPolygon() {
        this.setIcon(Icons.polygon);
        this.setNodeToolTip(null);
    }

    private void renderSchedBlock(@NonNull SchedBlock schedBlock) {
        if (schedBlock == null) {
            throw new NullPointerException("sb is marked non-null but is null");
        }
        this.setIcon(Icons.schedBlock);
        if (schedBlock.getNote().length() > 0) {
            this.setNodeToolTip(schedBlock.getNote());
        } else {
            this.setNodeToolTip(null);
        }
    }

    private void renderObsUnitSet(@NonNull ObsUnitSet obsUnitSet) {
        if (obsUnitSet == null) {
            throw new NullPointerException("ous is marked non-null but is null");
        }
        this.setIcon(Icons.obsUnitSet);
        if (obsUnitSet.getNote().length() > 0) {
            this.setNodeToolTip(obsUnitSet.getNote());
        } else {
            this.setNodeToolTip(null);
        }
    }

    private void renderOpticalPointingScienceGoal() {
        this.setIcon(Icons.optical);
        this.setNodeToolTip(null);
    }

    private void renderScienceGoal(@NonNull ScienceGoal scienceGoal) {
        if (scienceGoal == null) {
            throw new NullPointerException("sg is marked non-null but is null");
        }
        this.setIcon(Icons.scienceGoal);
        if (scienceGoal.getNote().length() > 0) {
            this.setNodeToolTip(scienceGoal.getNote());
        } else {
            this.setNodeToolTip(null);
        }
    }

    private void renderObservatoryGoal() {
        this.setIcon(Icons.optical);
        this.setNodeToolTip(null);
    }
}

